/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.annotations.PartitionerPlugin;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.trans.Partitioner;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PluginMainClassType(value=Partitioner.class)
@PluginAnnotationType(value=PartitionerPlugin.class)
public class PartitionerPluginType
extends BasePluginType
implements PluginTypeInterface {
    private static PartitionerPluginType pluginType;

    private PartitionerPluginType() {
        super(PartitionerPlugin.class, "PARTITIONER", "Partitioner");
        this.populateFolders("steps");
    }

    public static PartitionerPluginType getInstance() {
        if (pluginType == null) {
            pluginType = new PartitionerPluginType();
        }
        return pluginType;
    }

    protected void registerNatives() throws KettlePluginException {
        String kettlePartitionerXmlFile = "kettle-partition-plugins.xml";
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(kettlePartitionerXmlFile);
            if (inputStream == null) {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + kettlePartitionerXmlFile);
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find native partition plugins definition file: kettle-partition-plugins.xml");
            }
            Document document = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)true, (boolean)false);
            Node stepsNode = XMLHandler.getSubNode((Node)document, (String)"plugins");
            List stepNodes = XMLHandler.getNodes((Node)stepsNode, (String)"plugin-partitioner");
            for (Node stepNode : stepNodes) {
                this.registerPluginFromXmlResource(stepNode, null, ((Object)((Object)this)).getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle steps XML config file: " + kettlePartitionerXmlFile, (Throwable)e);
        }
    }

    protected void registerAnnotations() throws KettlePluginException {
    }

    protected void registerXmlPlugins() throws KettlePluginException {
        for (PluginFolderInterface folder : this.pluginFolders) {
            if (!folder.isPluginXmlFolder()) continue;
            List pluginXmlFiles = this.findPluginXmlFiles(folder.getFolder());
            for (FileObject file : pluginXmlFiles) {
                try {
                    Document document = XMLHandler.loadXMLFile((FileObject)file);
                    Node pluginNode = XMLHandler.getSubNode((Node)document, (String)"partitioner-plugin");
                    if (pluginNode == null) continue;
                    this.registerPluginFromXmlResource(pluginNode, KettleVFS.getFilename((FileObject)file.getParent()), ((Object)((Object)this)).getClass(), false, file.getParent().getURL());
                }
                catch (Exception e) {
                    this.log.logError("Error found while reading partitioning plugin.xml file: " + file.getName().toString(), (Throwable)e);
                }
            }
        }
    }

    protected String extractCategory(Annotation annotation) {
        return "";
    }

    protected String extractDesc(Annotation annotation) {
        return ((PartitionerPlugin)annotation).description();
    }

    protected String extractID(Annotation annotation) {
        return ((PartitionerPlugin)annotation).id();
    }

    protected String extractName(Annotation annotation) {
        return ((PartitionerPlugin)annotation).name();
    }

    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return false;
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return ((PartitionerPlugin)annotation).i18nPackageName();
    }

    protected void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
    }
}

