/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.plugins;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.annotations.RepositoryPlugin;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.plugins.BasePluginType;
import org.pentaho.di.core.plugins.PluginAnnotationType;
import org.pentaho.di.core.plugins.PluginExtraClassTypes;
import org.pentaho.di.core.plugins.PluginFolderInterface;
import org.pentaho.di.core.plugins.PluginMainClassType;
import org.pentaho.di.core.plugins.PluginTypeInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@PluginMainClassType(value=Repository.class)
@PluginExtraClassTypes(classTypes={RepositoryMeta.class}, xmlNodeNames={"meta-classname"})
@PluginAnnotationType(value=RepositoryPlugin.class)
public class RepositoryPluginType
extends BasePluginType
implements PluginTypeInterface {
    private static RepositoryPluginType pluginType;

    private RepositoryPluginType() {
        super(RepositoryPlugin.class, "REPOSITORY_TYPE", "Repository type");
        this.populateFolders("repositories");
    }

    public static RepositoryPluginType getInstance() {
        if (pluginType == null) {
            pluginType = new RepositoryPluginType();
        }
        return pluginType;
    }

    protected void registerNatives() throws KettlePluginException {
        String xmlFile = "kettle-repositories.xml";
        try {
            InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(xmlFile);
            if (inputStream == null) {
                inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/" + xmlFile);
            }
            if (inputStream == null) {
                throw new KettlePluginException("Unable to find native repository type definition file: " + xmlFile);
            }
            Document document = XMLHandler.loadXMLFile((InputStream)inputStream, null, (boolean)true, (boolean)false);
            Node repsNode = XMLHandler.getSubNode((Node)document, (String)"repositories");
            List repsNodes = XMLHandler.getNodes((Node)repsNode, (String)"repository");
            for (Node repNode : repsNodes) {
                this.registerPluginFromXmlResource(repNode, null, ((Object)((Object)this)).getClass(), true, null);
            }
        }
        catch (KettleXMLException e) {
            throw new KettlePluginException("Unable to read the kettle repositories XML config file: " + xmlFile, (Throwable)e);
        }
    }

    protected void registerXmlPlugins() throws KettlePluginException {
        for (PluginFolderInterface folder : this.pluginFolders) {
            if (!folder.isPluginXmlFolder()) continue;
            List pluginXmlFiles = this.findPluginXmlFiles(folder.getFolder());
            for (FileObject file : pluginXmlFiles) {
                try {
                    Document document = XMLHandler.loadXMLFile((FileObject)file);
                    Node pluginNode = XMLHandler.getSubNode((Node)document, (String)"plugin");
                    this.registerPluginFromXmlResource(pluginNode, KettleVFS.getFilename((FileObject)file.getParent()), ((Object)((Object)this)).getClass(), false, file.getParent().getURL());
                }
                catch (Exception e) {
                    this.log.logError("Error found while reading repository plugin.xml file: " + file.getName().toString(), (Throwable)e);
                }
            }
        }
    }

    protected String extractCategory(Annotation annotation) {
        return "";
    }

    protected String extractDesc(Annotation annotation) {
        return ((RepositoryPlugin)annotation).description();
    }

    protected String extractID(Annotation annotation) {
        return ((RepositoryPlugin)annotation).id();
    }

    protected String extractName(Annotation annotation) {
        return ((RepositoryPlugin)annotation).name();
    }

    protected String extractImageFile(Annotation annotation) {
        return null;
    }

    protected boolean extractSeparateClassLoader(Annotation annotation) {
        return false;
    }

    protected String extractI18nPackageName(Annotation annotation) {
        return ((RepositoryPlugin)annotation).i18nPackageName();
    }

    public void addExtraClasses(Map<Class<?>, String> classMap, Class<?> clazz, Annotation annotation) {
        RepositoryPlugin repositoryPlugin = (RepositoryPlugin)annotation;
        classMap.put(RepositoryMeta.class, repositoryPlugin.metaClass());
    }
}

