/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.List;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.GenericStepData;
import org.pentaho.di.core.util.KeyValueSet;
import org.pentaho.di.core.util.PluginPropertyFactory;
import org.pentaho.di.core.util.PluginPropertyHandler;
import org.pentaho.di.core.util.StringPluginProperty;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStepMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static final String CONNECTION_NAME = "connection";
    private final PluginPropertyFactory propertyFactory = new PluginPropertyFactory(new KeyValueSet());
    private DatabaseMeta dbMeta;
    private StringPluginProperty connectionName = this.propertyFactory.createString("connection");

    public PluginPropertyFactory getPropertyFactory() {
        return this.propertyFactory;
    }

    public KeyValueSet getProperties() {
        return this.propertyFactory.getProperties();
    }

    public void saveAsPreferences() throws BackingStoreException {
        Preferences node = Preferences.userNodeForPackage(this.getClass());
        this.getProperties().walk(new PluginPropertyHandler.SaveToPreferences(node));
        node.flush();
    }

    public void readFromPreferences() {
        Preferences node = Preferences.userNodeForPackage(this.getClass());
        this.getProperties().walk(new PluginPropertyHandler.ReadFromPreferences(node));
    }

    @Override
    public void loadXML(Node node, List<DatabaseMeta> databaseMeta, Map<String, Counter> counters) throws KettleXMLException {
        this.getProperties().walk(new PluginPropertyHandler.LoadXml(node));
        this.initDbMeta(databaseMeta);
    }

    private void initDbMeta(List<DatabaseMeta> databaseList) {
        if (!StringUtils.isEmpty((String)((String)this.connectionName.getValue()))) {
            this.dbMeta = DatabaseMeta.findDatabase(databaseList, (String)((String)this.connectionName.getValue()));
        }
    }

    @Override
    public String getXML() throws KettleException {
        return PluginPropertyHandler.toXml(this.getProperties());
    }

    @Override
    public void readRep(Repository repo, ObjectId stepId, List<DatabaseMeta> databaseList, Map<String, Counter> counters) throws KettleException {
        PluginPropertyHandler.walk(this.getProperties(), new PluginPropertyHandler.ReadFromRepository(repo, stepId));
        this.initDbMeta(databaseList);
    }

    @Override
    public void saveRep(Repository repo, ObjectId transformationId, ObjectId stepId) throws KettleException {
        PluginPropertyHandler.SaveToRepository handler = new PluginPropertyHandler.SaveToRepository(repo, transformationId, stepId);
        PluginPropertyHandler.walk(this.getProperties(), handler);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GenericStepData();
    }

    public StringPluginProperty getConnectionName() {
        return this.connectionName;
    }

    public void setConnectionName(StringPluginProperty connectionName) {
        this.connectionName = connectionName;
    }

    public DatabaseMeta getDbMeta() {
        return this.dbMeta;
    }

    public void setDbMeta(DatabaseMeta dbMeta) {
        this.dbMeta = dbMeta;
    }
}

