/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerializationHelper {
    private static final String INDENT_STRING = "    ";

    public static void read(Object object, Node node) {
        Field[] fields;
        for (Field field : fields = object.getClass().getFields()) {
            Class<Serializable> clazz;
            String fieldClassName;
            Node fieldNode;
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if (field.getType().isArray()) {
                try {
                    fieldNode = XMLHandler.getSubNode((Node)node, (String)field.getName());
                    if (fieldNode == null) continue;
                    fieldClassName = XMLHandler.getTagAttribute((Node)fieldNode, (String)"class");
                    clazz = null;
                    clazz = fieldClassName.equals("boolean") ? Boolean.TYPE : (fieldClassName.equals("int") ? Integer.TYPE : (fieldClassName.equals("float") ? Float.TYPE : (fieldClassName.equals("double") ? Double.TYPE : (fieldClassName.equals("long") ? Long.TYPE : Class.forName(fieldClassName)))));
                    NodeList childrenNodes = fieldNode.getChildNodes();
                    int arrayLength = 0;
                    for (int i = 0; i < childrenNodes.getLength(); ++i) {
                        Node child = childrenNodes.item(i);
                        if (child.getNodeType() == 3) continue;
                        ++arrayLength;
                    }
                    Object array = Array.newInstance(clazz, arrayLength);
                    field.set(object, array);
                    int arrayIndex = 0;
                    for (int i = 0; i < childrenNodes.getLength(); ++i) {
                        Comparable<Boolean> value;
                        Node child = childrenNodes.item(i);
                        if (child.getNodeType() == 3) continue;
                        if (String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz)) {
                            Constructor<Comparable<Boolean>> constructor = clazz.getConstructor(String.class);
                            Comparable<Boolean> instance = constructor.newInstance(XMLHandler.getTagAttribute((Node)child, (String)"value"));
                            Array.set(array, arrayIndex++, instance);
                            continue;
                        }
                        if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
                            value = Boolean.valueOf(XMLHandler.getTagAttribute((Node)child, (String)"value"));
                            Array.set(array, arrayIndex++, value);
                            continue;
                        }
                        if (Integer.class.isAssignableFrom(clazz) || Integer.TYPE.isAssignableFrom(clazz)) {
                            value = Integer.valueOf(XMLHandler.getTagAttribute((Node)child, (String)"value"));
                            Array.set(array, arrayIndex++, value);
                            continue;
                        }
                        if (Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz)) {
                            value = Float.valueOf(XMLHandler.getTagAttribute((Node)child, (String)"value"));
                            Array.set(array, arrayIndex++, value);
                            continue;
                        }
                        if (Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz)) {
                            value = Double.valueOf(XMLHandler.getTagAttribute((Node)child, (String)"value"));
                            Array.set(array, arrayIndex++, value);
                            continue;
                        }
                        if (Long.class.isAssignableFrom(clazz) || Long.TYPE.isAssignableFrom(clazz)) {
                            value = Long.valueOf(XMLHandler.getTagAttribute((Node)child, (String)"value"));
                            Array.set(array, arrayIndex++, value);
                            continue;
                        }
                        Comparable<Boolean> instance = clazz.newInstance();
                        Array.set(array, arrayIndex++, instance);
                        SerializationHelper.read(instance, child);
                    }
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
            }
            if (List.class.isAssignableFrom(field.getType())) {
                try {
                    fieldNode = XMLHandler.getSubNode((Node)node, (String)field.getName());
                    if (fieldNode == null) continue;
                    fieldClassName = XMLHandler.getTagAttribute((Node)fieldNode, (String)"class");
                    clazz = Class.forName(fieldClassName);
                    ArrayList<Comparable<Boolean>> list = new ArrayList<Comparable<Boolean>>();
                    field.set(object, list);
                    NodeList childrenNodes = fieldNode.getChildNodes();
                    for (int i = 0; i < childrenNodes.getLength(); ++i) {
                        Node child = childrenNodes.item(i);
                        if (child.getNodeType() == 3) continue;
                        if (String.class.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz)) {
                            Constructor<Comparable<Boolean>> constructor = clazz.getConstructor(String.class);
                            Comparable<Boolean> instance = constructor.newInstance(XMLHandler.getTagAttribute((Node)child, (String)"value"));
                            list.add(instance);
                            continue;
                        }
                        Comparable<Boolean> instance = clazz.newInstance();
                        list.add(instance);
                        SerializationHelper.read(instance, child);
                    }
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    continue;
                }
            }
            try {
                String value = XMLHandler.getTagValue((Node)node, (String)field.getName());
                if (value == null || field.getType().isPrimitive() && "".equals(value)) continue;
                if ("".equals(value)) {
                    field.set(object, value);
                    continue;
                }
                if (field.getType().isPrimitive()) {
                    if (Double.TYPE.isAssignableFrom(field.getType())) {
                        field.set(object, Double.parseDouble(value.toString()));
                        continue;
                    }
                    if (Float.TYPE.isAssignableFrom(field.getType())) {
                        field.set(object, Float.valueOf(Float.parseFloat(value.toString())));
                        continue;
                    }
                    if (Long.TYPE.isAssignableFrom(field.getType())) {
                        field.set(object, Long.parseLong(value.toString()));
                        continue;
                    }
                    if (Integer.TYPE.isAssignableFrom(field.getType())) {
                        field.set(object, Integer.parseInt(value.toString()));
                        continue;
                    }
                    if (Byte.TYPE.isAssignableFrom(field.getType())) {
                        field.set(object, value.toString().getBytes());
                        continue;
                    }
                    if (!Boolean.TYPE.isAssignableFrom(field.getType())) continue;
                    field.set(object, "true".equalsIgnoreCase(value.toString()));
                    continue;
                }
                if (String.class.isAssignableFrom(field.getType()) || Number.class.isAssignableFrom(field.getType())) {
                    Constructor<?> constructor = field.getType().getConstructor(String.class);
                    Object instance = constructor.newInstance(value);
                    field.set(object, instance);
                    continue;
                }
                Node fieldNode2 = XMLHandler.getSubNode((Node)node, (String)field.getName());
                if (fieldNode2 == null) continue;
                String fieldClassName2 = XMLHandler.getTagAttribute((Node)fieldNode2, (String)"class");
                Class<?> clazz2 = Class.forName(fieldClassName2);
                Object instance = clazz2.newInstance();
                field.set(object, instance);
                SerializationHelper.read(instance, fieldNode2);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void write(Object object, int indentLevel, StringBuffer buffer) {
        Field[] fields;
        if (object == null) {
            return;
        }
        for (Field field : fields = object.getClass().getFields()) {
            if (Modifier.isFinal(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                Object fieldValue = field.get(object);
                if (fieldValue == null || "".equals(fieldValue)) continue;
                if (field.getType().isPrimitive() || String.class.isAssignableFrom(field.getType()) || Number.class.isAssignableFrom(field.getType())) {
                    SerializationHelper.indent(buffer, indentLevel);
                    buffer.append(XMLHandler.addTagValue((String)field.getName(), (String)fieldValue.toString()));
                    continue;
                }
                if (field.getType().isArray()) {
                    int length = Array.getLength(fieldValue);
                    SerializationHelper.indent(buffer, indentLevel);
                    buffer.append("<" + field.getName() + " class=\"" + fieldValue.getClass().getComponentType().getName() + "\">").append(Const.CR);
                    for (int i = 0; i < length; ++i) {
                        Object childObject = Array.get(fieldValue, i);
                        if (String.class.isAssignableFrom(childObject.getClass()) || Number.class.isAssignableFrom(childObject.getClass())) {
                            SerializationHelper.indent(buffer, indentLevel + 1);
                            buffer.append("<").append(fieldValue.getClass().getComponentType().getSimpleName());
                            buffer.append(" value=\"" + childObject.toString() + "\"/>").append(Const.CR);
                            continue;
                        }
                        if (Boolean.class.isAssignableFrom(childObject.getClass()) || Boolean.TYPE.isAssignableFrom(childObject.getClass())) {
                            SerializationHelper.indent(buffer, indentLevel + 1);
                            buffer.append("<").append(fieldValue.getClass().getComponentType().getSimpleName());
                            buffer.append(" value=\"" + childObject.toString() + "\"/>").append(Const.CR);
                            continue;
                        }
                        SerializationHelper.indent(buffer, indentLevel + 1);
                        buffer.append("<" + fieldValue.getClass().getComponentType().getSimpleName() + ">").append(Const.CR);
                        SerializationHelper.write(childObject, indentLevel + 1, buffer);
                        SerializationHelper.indent(buffer, indentLevel + 1);
                        buffer.append("</" + fieldValue.getClass().getComponentType().getSimpleName() + ">").append(Const.CR);
                    }
                    buffer.append("    </" + field.getName() + ">").append(Const.CR);
                    continue;
                }
                if (List.class.isAssignableFrom(field.getType())) {
                    List list = (List)fieldValue;
                    if (list.size() == 0) continue;
                    Class<?> listClass = list.get(0).getClass();
                    SerializationHelper.indent(buffer, indentLevel);
                    buffer.append("<" + field.getName() + " class=\"" + listClass.getName() + "\">").append(Const.CR);
                    for (Object childObject : list) {
                        if (String.class.isAssignableFrom(childObject.getClass()) || Number.class.isAssignableFrom(childObject.getClass())) {
                            SerializationHelper.indent(buffer, indentLevel + 1);
                            buffer.append("<").append(listClass.getSimpleName());
                            buffer.append(" value=\"" + childObject.toString() + "\"/>").append(Const.CR);
                            continue;
                        }
                        if (Boolean.class.isAssignableFrom(childObject.getClass()) || Boolean.TYPE.isAssignableFrom(childObject.getClass())) {
                            SerializationHelper.indent(buffer, indentLevel + 1);
                            buffer.append("<").append(listClass.getSimpleName());
                            buffer.append(" value=\"" + childObject.toString() + "\"/>").append(Const.CR);
                            continue;
                        }
                        SerializationHelper.indent(buffer, indentLevel + 1);
                        buffer.append("<" + listClass.getSimpleName() + ">").append(Const.CR);
                        SerializationHelper.write(childObject, indentLevel + 1, buffer);
                        SerializationHelper.indent(buffer, indentLevel + 1);
                        buffer.append("</" + listClass.getSimpleName() + ">").append(Const.CR);
                    }
                    SerializationHelper.indent(buffer, indentLevel);
                    buffer.append("</" + field.getName() + ">").append(Const.CR);
                    continue;
                }
                SerializationHelper.indent(buffer, indentLevel);
                buffer.append("<" + field.getName() + " class=\"" + fieldValue.getClass().getName() + "\">").append(Const.CR);
                SerializationHelper.write(fieldValue, indentLevel + 1, buffer);
                SerializationHelper.indent(buffer, indentLevel);
                buffer.append("</" + field.getName() + ">").append(Const.CR);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void saveJobRep(Object object, Repository rep, ObjectId id_job, ObjectId id_job_entry) throws KettleException {
        StringBuffer sb = new StringBuffer(1024);
        SerializationHelper.write(object, 0, sb);
        rep.saveJobEntryAttribute(id_job, id_job_entry, "job-xml", sb.toString());
    }

    public static void readJobRep(Object object, Repository rep, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            String jobXML = rep.getJobEntryAttributeString(id_step, "job-xml");
            ByteArrayInputStream bais = new ByteArrayInputStream(jobXML.getBytes());
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
            SerializationHelper.read(object, doc.getDocumentElement());
        }
        catch (ParserConfigurationException ex) {
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
        catch (SAXException ex) {
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
    }

    public static void saveStepRep(Object object, Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        StringBuffer sb = new StringBuffer(1024);
        SerializationHelper.write(object, 0, sb);
        rep.saveStepAttribute(id_transformation, id_step, "step-xml", sb.toString());
    }

    public static void readStepRep(Object object, Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            String stepXML = rep.getStepAttributeString(id_step, "step-xml");
            ByteArrayInputStream bais = new ByteArrayInputStream(stepXML.getBytes());
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(bais);
            SerializationHelper.read(object, doc.getDocumentElement());
        }
        catch (ParserConfigurationException ex) {
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
        catch (SAXException ex) {
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
        catch (IOException ex) {
            throw new KettleException(ex.getMessage(), (Throwable)ex);
        }
    }

    private static void indent(StringBuffer sb, int indentLevel) {
        for (int i = 0; i < indentLevel; ++i) {
            sb.append(INDENT_STRING);
        }
    }
}

