/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.util;

import java.util.prefs.Preferences;
import org.apache.commons.lang.StringUtils;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.util.KeyValue;
import org.pentaho.di.core.util.PluginProperty;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringPluginProperty
extends KeyValue<String>
implements PluginProperty {
    private static final long serialVersionUID = -2990345692552430357L;

    public StringPluginProperty(String key) throws IllegalArgumentException {
        super(key, "");
    }

    @Override
    public boolean evaluate() {
        return StringUtils.isNotBlank((String)((String)this.getValue()));
    }

    @Override
    public void appendXml(StringBuilder builder) {
        builder.append(XMLHandler.addTagValue((String)this.getKey(), (String)((String)this.getValue())));
    }

    @Override
    public void loadXml(Node node) {
        String value = XMLHandler.getTagValue((Node)node, (String)this.getKey());
        this.setValue(value);
    }

    @Override
    public void readFromRepositoryStep(Repository repository, ObjectId stepId) throws KettleException {
        String value = repository.getStepAttributeString(stepId, this.getKey());
        this.setValue(value);
    }

    @Override
    public void saveToPreferences(Preferences node) {
        node.put(this.getKey(), (String)this.getValue());
    }

    @Override
    public void readFromPreferences(Preferences node) {
        this.setValue(node.get(this.getKey(), (String)this.getValue()));
    }

    @Override
    public void saveToRepositoryStep(Repository repository, ObjectId transformationId, ObjectId stepId) throws KettleException {
        repository.saveStepAttribute(transformationId, stepId, this.getKey(), (String)this.getValue());
    }
}

