/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.plugins.ImportRulePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.pentaho.di.imp.rule.ImportValidationFeedback;
import org.pentaho.di.imp.rules.BaseImportRule;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportRules
implements Cloneable {
    public static final String XML_TAG = "rules";
    protected List<ImportRuleInterface> rules = new ArrayList<ImportRuleInterface>();

    public ImportRules clone() {
        ImportRules importRules = new ImportRules();
        for (ImportRuleInterface rule : this.rules) {
            importRules.getRules().add(rule.clone());
        }
        return importRules;
    }

    public List<ImportValidationFeedback> verifyRules(Object subject) {
        ArrayList<ImportValidationFeedback> feedback = new ArrayList<ImportValidationFeedback>();
        for (ImportRuleInterface rule : this.rules) {
            feedback.addAll(rule.verifyRule(subject));
        }
        return feedback;
    }

    public void loadXML(Node rulesNode) throws KettleException {
        List ruleNodes = XMLHandler.getNodes((Node)rulesNode, (String)BaseImportRule.XML_TAG);
        for (Node ruleNode : ruleNodes) {
            String id = XMLHandler.getTagValue((Node)ruleNode, (String)"id");
            PluginRegistry registry = PluginRegistry.getInstance();
            PluginInterface plugin = registry.findPluginWithId(ImportRulePluginType.class, id);
            if (plugin == null) {
                throw new KettleException("The import rule of type '" + id + "' could not be found in the plugin registry.");
            }
            ImportRuleInterface rule = (ImportRuleInterface)registry.loadClass(plugin);
            rule.loadXML(ruleNode);
            this.getRules().add(rule);
        }
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder();
        xml.append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR).append(Const.CR);
        for (ImportRuleInterface rule : this.getRules()) {
            PluginInterface plugin = PluginRegistry.getInstance().getPlugin(ImportRulePluginType.class, rule.getId());
            xml.append("<!-- ").append(plugin.getName()).append(" : ").append(plugin.getDescription()).append(Const.CR).append(" -->").append(Const.CR);
            xml.append(rule.getXML());
            xml.append(Const.CR).append(Const.CR);
        }
        xml.append(XMLHandler.closeTag((String)XML_TAG));
        return xml.toString();
    }

    public List<ImportRuleInterface> getRules() {
        return this.rules;
    }

    public void setRules(List<ImportRuleInterface> rules) {
        this.rules = rules;
    }
}

