/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.imp.rule;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.imp.rule.ImportRuleInterface;
import org.pentaho.di.imp.rule.ImportValidationResultType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportValidationFeedback {
    private ImportRuleInterface importRule;
    private ImportValidationResultType resultType;
    private String comment;

    public ImportValidationFeedback(ImportRuleInterface importRule, ImportValidationResultType resultType, String comment) {
        this.importRule = importRule;
        this.resultType = resultType;
        this.comment = comment;
    }

    public static List<ImportValidationFeedback> getErrors(List<ImportValidationFeedback> feedback) {
        ArrayList<ImportValidationFeedback> errors = new ArrayList<ImportValidationFeedback>();
        for (ImportValidationFeedback error : feedback) {
            if (!error.isError()) continue;
            errors.add(error);
        }
        return errors;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append(this.resultType.name()).append(" : ");
        string.append(this.comment).append(" - ");
        string.append(this.importRule.toString());
        return string.toString();
    }

    public ImportValidationResultType getResultType() {
        return this.resultType;
    }

    public boolean isError() {
        return this.resultType == ImportValidationResultType.ERROR;
    }

    public boolean isApproval() {
        return this.resultType == ImportValidationResultType.APPROVAL;
    }

    public void setResultType(ImportValidationResultType resultType) {
        this.resultType = resultType;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public ImportRuleInterface getImportRule() {
        return this.importRule;
    }

    public void setImportRule(ImportRuleInterface importRule) {
        this.importRule = importRule;
    }
}

