/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job;

import java.util.Comparator;
import java.util.Date;
import org.pentaho.di.core.Result;
import org.pentaho.di.job.entry.JobEntryCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryResult
implements Cloneable,
Comparator<JobEntryResult>,
Comparable<JobEntryResult> {
    private Result result;
    private String jobEntryName;
    private int jobEntryNr;
    private String comment;
    private String reason;
    private Date logDate = new Date();
    private String jobEntryFilename;
    private String logChannelId;

    public JobEntryResult() {
    }

    public JobEntryResult(Result result, String logChannelId, String comment, String reason, String jobEntryName, int jobEntryNr, String jobEntryFilename) {
        this();
        if (result != null) {
            this.result = result.lightClone();
            this.result.setLogText(null);
        } else {
            this.result = null;
        }
        this.logChannelId = logChannelId;
        this.comment = comment;
        this.reason = reason;
        this.jobEntryName = jobEntryName;
        this.jobEntryNr = jobEntryNr;
        this.jobEntryFilename = jobEntryFilename;
    }

    @Deprecated
    public JobEntryResult(Result result, String comment, String reason, JobEntryCopy copy) {
        this(result, copy.getEntry().getLogChannel().getLogChannelId(), comment, reason, copy != null ? copy.getName() : null, copy != null ? copy.getNr() : 0, copy == null ? null : (copy.getEntry() != null ? copy.getEntry().getFilename() : null));
    }

    public Object clone() {
        try {
            JobEntryResult jobEntryResult = (JobEntryResult)super.clone();
            if (this.getResult() != null) {
                jobEntryResult.setResult(this.getResult().clone());
            }
            return jobEntryResult;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getReason() {
        return this.reason;
    }

    public void setReason(String reason) {
        this.reason = reason;
    }

    public Date getLogDate() {
        return this.logDate;
    }

    public void setLogDate(Date logDate) {
        this.logDate = logDate;
    }

    public String getJobEntryName() {
        return this.jobEntryName;
    }

    public void setJobEntryName(String jobEntryName) {
        this.jobEntryName = jobEntryName;
    }

    public String getJobEntryFilename() {
        return this.jobEntryFilename;
    }

    public void setJobEntryFilename(String jobEntryFilename) {
        this.jobEntryFilename = jobEntryFilename;
    }

    public int getJobEntryNr() {
        return this.jobEntryNr;
    }

    public void setJobEntryNr(int jobEntryNr) {
        this.jobEntryNr = jobEntryNr;
    }

    @Override
    public int compare(JobEntryResult one, JobEntryResult two) {
        if (one == null && two != null) {
            return -1;
        }
        if (one != null && two == null) {
            return 1;
        }
        if (one == null && two == null) {
            return 0;
        }
        if (one.getJobEntryName() == null && two.getJobEntryName() != null) {
            return -1;
        }
        if (one.getJobEntryName() != null && two.getJobEntryName() == null) {
            return 1;
        }
        if (one.getJobEntryName() == null && two.getJobEntryName() == null) {
            return 0;
        }
        int cmp = one.getJobEntryName().compareTo(two.getJobEntryName());
        if (cmp != 0) {
            return cmp;
        }
        return Integer.valueOf(one.getJobEntryNr()).compareTo(two.getJobEntryNr());
    }

    @Override
    public int compareTo(JobEntryResult two) {
        return this.compare(this, two);
    }

    public String getLogChannelId() {
        return this.logChannelId;
    }
}

