/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.copyfiles;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryCopyFiles
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryCopyFiles.class;
    public boolean copy_empty_folders = true;
    public boolean arg_from_previous = false;
    public boolean overwrite_files = false;
    public boolean include_subfolders = false;
    public boolean add_result_filesname = false;
    public boolean remove_source_files = false;
    public boolean destination_is_a_file = false;
    public boolean create_destination_folder = false;
    public String[] source_filefolder = null;
    public String[] destination_filefolder = null;
    public String[] wildcard = null;
    HashSet<String> list_files_remove = new HashSet();
    HashSet<String> list_add_result = new HashSet();
    int NbrFail = 0;

    public JobEntryCopyFiles(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryCopyFiles() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryCopyFiles je = (JobEntryCopyFiles)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"copy_empty_folders", (boolean)this.copy_empty_folders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.arg_from_previous));
        retval.append("      ").append(XMLHandler.addTagValue((String)"overwrite_files", (boolean)this.overwrite_files));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.include_subfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove_source_files", (boolean)this.remove_source_files));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_result_filesname", (boolean)this.add_result_filesname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination_is_a_file", (boolean)this.destination_is_a_file));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_destination_folder", (boolean)this.create_destination_folder));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.source_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"destination_filefolder", (String)this.destination_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.copy_empty_folders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"copy_empty_folders"));
            this.arg_from_previous = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.overwrite_files = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"overwrite_files"));
            this.include_subfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.remove_source_files = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove_source_files"));
            this.add_result_filesname = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_result_filesname"));
            this.destination_is_a_file = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"destination_is_a_file"));
            this.create_destination_folder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_destination_folder"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.source_filefolder = new String[nrFields];
            this.destination_filefolder = new String[nrFields];
            this.wildcard = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.destination_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"destination_filefolder");
                this.wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.copy_empty_folders = rep.getJobEntryAttributeBoolean(id_jobentry, "copy_empty_folders");
            this.arg_from_previous = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.overwrite_files = rep.getJobEntryAttributeBoolean(id_jobentry, "overwrite_files");
            this.include_subfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.remove_source_files = rep.getJobEntryAttributeBoolean(id_jobentry, "remove_source_files");
            this.add_result_filesname = rep.getJobEntryAttributeBoolean(id_jobentry, "add_result_filesname");
            this.destination_is_a_file = rep.getJobEntryAttributeBoolean(id_jobentry, "destination_is_a_file");
            this.create_destination_folder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_destination_folder");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.source_filefolder = new String[argnr];
            this.destination_filefolder = new String[argnr];
            this.wildcard = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.destination_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "destination_filefolder");
                this.wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.UnableLoadRep", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "copy_empty_folders", this.copy_empty_folders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.arg_from_previous);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "overwrite_files", this.overwrite_files);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.include_subfolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "remove_source_files", this.remove_source_files);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_result_filesname", this.add_result_filesname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destination_is_a_file", this.destination_is_a_file);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "create_destination_folder", this.create_destination_folder);
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "source_filefolder", this.source_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "destination_filefolder", this.destination_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "wildcard", this.wildcard[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.UnableSaveRep", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        Result result = previousResult;
        List rows = result.getRows();
        RowMetaAndData resultRow = null;
        int NbrFail = 0;
        NbrFail = 0;
        if (this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.Starting", (String[])new String[0]));
        }
        try {
            String[] vsourcefilefolder = this.source_filefolder;
            String[] vdestinationfilefolder = this.destination_filefolder;
            String[] vwildcard = this.wildcard;
            result.setResult(false);
            result.setNrErrors(1L);
            if (this.arg_from_previous && this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
            }
            if (this.arg_from_previous && rows != null) {
                for (int iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    String vsourcefilefolder_previous = resultRow.getString(0, null);
                    String vdestinationfilefolder_previous = resultRow.getString(1, null);
                    String vwildcard_previous = resultRow.getString(2, null);
                    if (!Const.isEmpty((String)vsourcefilefolder_previous) && !Const.isEmpty((String)vdestinationfilefolder_previous)) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder_previous, vdestinationfilefolder_previous, vwildcard_previous}));
                        }
                        if (this.ProcessFileFolder(vsourcefilefolder_previous, vdestinationfilefolder_previous, vwildcard_previous, this.parentJob, result)) continue;
                        ++NbrFail;
                        continue;
                    }
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.IgnoringRow", (String[])new String[]{vsourcefilefolder[iteration], vdestinationfilefolder[iteration], vwildcard[iteration]}));
                }
            } else if (vsourcefilefolder != null && vdestinationfilefolder != null) {
                for (int i = 0; i < vsourcefilefolder.length && !this.parentJob.isStopped(); ++i) {
                    if (!Const.isEmpty((String)vsourcefilefolder[i]) && !Const.isEmpty((String)vdestinationfilefolder[i])) {
                        if (this.isBasic()) {
                            this.logBasic(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i]}));
                        }
                        if (this.ProcessFileFolder(vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i], this.parentJob, result)) continue;
                        ++NbrFail;
                        continue;
                    }
                    if (!this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.IgnoringRow", (String[])new String[]{vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i]}));
                }
            }
            Object var15_15 = null;
            this.list_add_result = null;
            this.list_files_remove = null;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            this.list_add_result = null;
            this.list_files_remove = null;
            throw throwable;
        }
        if (NbrFail == 0) {
            result.setResult(true);
            result.setNrErrors(0L);
        } else {
            result.setNrErrors((long)NbrFail);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean ProcessFileFolder(String sourcefilefoldername, String destinationfilefoldername, String wildcard, Job parentJob, Result result) {
        boolean entrystatus;
        block47: {
            IOException ex2222;
            String realDestinationFilefoldername;
            String realSourceFilefoldername;
            FileObject destinationfilefolder;
            FileObject sourcefilefolder;
            block45: {
                block44: {
                    entrystatus = false;
                    sourcefilefolder = null;
                    destinationfilefolder = null;
                    this.list_files_remove.clear();
                    this.list_add_result.clear();
                    realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
                    realDestinationFilefoldername = this.environmentSubstitute(destinationfilefoldername);
                    String realWildcard = this.environmentSubstitute(wildcard);
                    sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername, (VariableSpace)this);
                    destinationfilefolder = KettleVFS.getFileObject((String)realDestinationFilefoldername, (VariableSpace)this);
                    if (sourcefilefolder.exists()) {
                        if (this.CreateDestinationFolder(destinationfilefolder)) {
                            if (sourcefilefolder.getType().equals(FileType.FOLDER) && this.destination_is_a_file) {
                                this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.CanNotCopyFolderToFile", (String[])new String[]{realSourceFilefoldername, realDestinationFilefoldername}));
                                ++this.NbrFail;
                            } else {
                                int trimPathLength;
                                if (destinationfilefolder.getType().equals(FileType.FOLDER) && sourcefilefolder.getType().equals(FileType.FILE)) {
                                    destinationfilefolder.copyFrom(sourcefilefolder.getParent(), (FileSelector)new TextOneFileSelector(sourcefilefolder.getParent().toString(), sourcefilefolder.getName().getBaseName(), destinationfilefolder.toString()));
                                    if (this.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.FileCopied", (String[])new String[]{sourcefilefolder.getName().toString(), destinationfilefolder.getName().toString()}));
                                    }
                                } else if (sourcefilefolder.getType().equals(FileType.FILE) && this.destination_is_a_file) {
                                    destinationfilefolder.copyFrom(sourcefilefolder, (FileSelector)new TextOneToOneFileSelector(destinationfilefolder));
                                } else {
                                    if (this.isDetailed()) {
                                        this.logDetailed("  ");
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.FetchFolder", (String[])new String[]{sourcefilefolder.toString()}));
                                    }
                                    TextFileSelector textFileSelector = new TextFileSelector(sourcefilefolder, destinationfilefolder, realWildcard, parentJob);
                                    try {
                                        destinationfilefolder.copyFrom(sourcefilefolder, (FileSelector)textFileSelector);
                                        Object var14_15 = null;
                                        textFileSelector.shutdown();
                                    }
                                    catch (Throwable throwable) {
                                        Object var14_16 = null;
                                        textFileSelector.shutdown();
                                        throw throwable;
                                    }
                                }
                                if (this.remove_source_files && !this.list_files_remove.isEmpty()) {
                                    String sourceFilefoldername = sourcefilefolder.toString();
                                    trimPathLength = sourceFilefoldername.length() + 1;
                                    Iterator<String> iter = this.list_files_remove.iterator();
                                    while (iter.hasNext() && !parentJob.isStopped()) {
                                        String fileremoventry = iter.next();
                                        FileObject removeFile = null;
                                        if (fileremoventry.startsWith(sourceFilefoldername) && trimPathLength < fileremoventry.length()) {
                                            removeFile = sourcefilefolder.getChild(fileremoventry.substring(trimPathLength));
                                        }
                                        if (removeFile == null) {
                                            removeFile = KettleVFS.getFileObject((String)fileremoventry, (VariableSpace)this);
                                        }
                                        if (removeFile.getType() != FileType.FILE) continue;
                                        boolean deletefile = removeFile.delete();
                                        this.logBasic(" ------ ");
                                        if (!deletefile) {
                                            this.logError("      " + BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.CanRemoveFileFolder", (String[])new String[]{fileremoventry}));
                                            continue;
                                        }
                                        if (!this.isDetailed()) continue;
                                        this.logDetailed("      " + BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.FileFolderRemoved", (String[])new String[]{fileremoventry}));
                                    }
                                }
                                if (this.add_result_filesname && !this.list_add_result.isEmpty()) {
                                    String destinationFilefoldername = destinationfilefolder.toString();
                                    trimPathLength = destinationFilefoldername.length() + 1;
                                    for (String fileaddentry : this.list_add_result) {
                                        FileObject addFile = null;
                                        if (fileaddentry.startsWith(destinationFilefoldername) && trimPathLength < fileaddentry.length()) {
                                            addFile = destinationfilefolder.getChild(fileaddentry.substring(trimPathLength));
                                        }
                                        if (addFile == null) {
                                            addFile = KettleVFS.getFileObject((String)fileaddentry, (VariableSpace)this);
                                        }
                                        if (addFile.getType() != FileType.FILE) continue;
                                        ResultFile resultFile = new ResultFile(0, addFile, parentJob.getJobname(), this.toString());
                                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                        if (!this.isDetailed()) continue;
                                        this.logDetailed(" ------ ");
                                        this.logDetailed("      " + BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.FileAddedToResultFilesName", (String[])new String[]{fileaddentry}));
                                    }
                                }
                            }
                            entrystatus = true;
                            break block44;
                        }
                        this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.DestinationFolderNotFound", (String[])new String[]{realDestinationFilefoldername}));
                        break block44;
                    }
                    this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
                }
                Object var19_24 = null;
                if (sourcefilefolder == null) break block45;
                try {
                    sourcefilefolder.close();
                    sourcefilefolder = null;
                }
                catch (IOException ex2222) {
                    // empty catch block
                }
            }
            if (destinationfilefolder != null) {
                try {
                    destinationfilefolder.close();
                    destinationfilefolder = null;
                }
                catch (IOException ex2222) {}
            }
            break block47;
            {
                catch (FileSystemException fse) {
                    IOException ex2222;
                    this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.CopyProcessFileSystemException", (String[])new String[]{fse.getMessage()}));
                    for (Throwable throwable = fse.getCause(); throwable != null; throwable = throwable.getCause()) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Log.CausedBy", (String[])new String[]{throwable.getMessage()}));
                    }
                    Object var19_25 = null;
                    if (sourcefilefolder != null) {
                        try {
                            sourcefilefolder.close();
                            sourcefilefolder = null;
                        }
                        catch (IOException ex2222) {
                            // empty catch block
                        }
                    }
                    if (destinationfilefolder != null) {
                        try {
                            destinationfilefolder.close();
                            destinationfilefolder = null;
                        }
                        catch (IOException ex2222) {}
                    }
                    break block47;
                }
                catch (Exception e) {
                    IOException ex2222;
                    this.logError(BaseMessages.getString(PKG, (String)"JobCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{realSourceFilefoldername, realDestinationFilefoldername, e.getMessage()}), e);
                    Object var19_26 = null;
                    if (sourcefilefolder != null) {
                        try {
                            sourcefilefolder.close();
                            sourcefilefolder = null;
                        }
                        catch (IOException ex2222) {
                            // empty catch block
                        }
                    }
                    if (destinationfilefolder != null) {
                        try {
                            destinationfilefolder.close();
                            destinationfilefolder = null;
                        }
                        catch (IOException ex2222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ex2222;
                Object var19_27 = null;
                if (sourcefilefolder != null) {
                    try {
                        sourcefilefolder.close();
                        sourcefilefolder = null;
                    }
                    catch (IOException ex2222) {
                        // empty catch block
                    }
                }
                if (destinationfilefolder != null) {
                    try {
                        destinationfilefolder.close();
                        destinationfilefolder = null;
                    }
                    catch (IOException ex2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return entrystatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean CreateDestinationFolder(FileObject filefolder) {
        FileObject folder;
        block13: {
            folder = null;
            folder = this.destination_is_a_file ? filefolder.getParent() : filefolder;
            if (folder.exists()) break block13;
            if (this.create_destination_folder) {
                if (this.isDetailed()) {
                    this.logDetailed("Folder  " + folder.getName() + " does not exist !");
                }
                folder.createFolder();
                if (this.isDetailed()) {
                    this.logDetailed("Folder parent was created.");
                }
                break block13;
            }
            this.logError("Folder  " + folder.getName() + " does not exist !");
            boolean bl = false;
            Object var5_6 = null;
            if (folder == null) return bl;
            try {
                folder.close();
                return bl;
            }
            catch (Exception ex) {
                // empty catch block
            }
            return bl;
        }
        boolean bl = true;
        Object var5_7 = null;
        if (folder == null) return bl;
        try {
            folder.close();
            return bl;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return bl;
        catch (Exception e) {
            try {
                this.logError("Couldn't created parent folder " + folder.getName(), e);
                Object var5_8 = null;
                if (folder == null) return false;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (folder == null) throw throwable;
                try {
                    folder.close();
                    folder = null;
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                folder.close();
                return false;
            }
            catch (Exception ex) {}
            return false;
        }
    }

    public void setCopyEmptyFolders(boolean copy_empty_foldersin) {
        this.copy_empty_folders = copy_empty_foldersin;
    }

    public void setoverwrite_files(boolean overwrite_filesin) {
        this.overwrite_files = overwrite_filesin;
    }

    public void setIncludeSubfolders(boolean include_subfoldersin) {
        this.include_subfolders = include_subfoldersin;
    }

    public void setAddresultfilesname(boolean add_result_filesnamein) {
        this.add_result_filesname = add_result_filesnamein;
    }

    public void setArgFromPrevious(boolean argfrompreviousin) {
        this.arg_from_previous = argfrompreviousin;
    }

    public void setRemoveSourceFiles(boolean remove_source_filesin) {
        this.remove_source_files = remove_source_filesin;
    }

    public void setDestinationIsAFile(boolean destination_is_a_file) {
        this.destination_is_a_file = destination_is_a_file;
    }

    public void setCreateDestinationFolder(boolean create_destination_folder) {
        this.create_destination_folder = create_destination_folder;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.source_filefolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    private class TextOneFileSelector
    implements FileSelector {
        String filename = null;
        String foldername = null;
        String destfolder = null;
        private int traverseCount;

        public TextOneFileSelector(String sourcefolderin, String sourcefilenamein, String destfolderin) {
            if (!Const.isEmpty((String)sourcefilenamein)) {
                this.filename = sourcefilenamein;
            }
            if (!Const.isEmpty((String)sourcefolderin)) {
                this.foldername = sourcefolderin;
            }
            if (!Const.isEmpty((String)destfolderin)) {
                this.destfolder = destfolderin;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean resultat = false;
            String fil_name = null;
            try {
                if (info.getFile().getType() == FileType.FILE) {
                    if (info.getFile().getName().getBaseName().equals(this.filename) && info.getFile().getParent().toString().equals(this.foldername)) {
                        fil_name = this.destfolder + Const.FILE_SEPARATOR + this.filename;
                        if (KettleVFS.getFileObject((String)fil_name, (VariableSpace)JobEntryCopyFiles.this).exists()) {
                            if (JobEntryCopyFiles.this.isDetailed()) {
                                JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{fil_name}));
                            }
                            if (JobEntryCopyFiles.this.overwrite_files) {
                                if (JobEntryCopyFiles.this.isDetailed()) {
                                    JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileOverwrite", (String[])new String[]{info.getFile().toString(), fil_name}));
                                }
                                resultat = true;
                            }
                        } else {
                            if (JobEntryCopyFiles.this.isDetailed()) {
                                JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileCopied", (String[])new String[]{info.getFile().toString(), fil_name}));
                            }
                            resultat = true;
                        }
                    }
                    if (resultat && JobEntryCopyFiles.this.remove_source_files) {
                        JobEntryCopyFiles.this.list_files_remove.add(info.getFile().toString());
                    }
                    if (resultat && JobEntryCopyFiles.this.add_result_filesname) {
                        JobEntryCopyFiles.this.list_add_result.add(KettleVFS.getFileObject(fil_name, (VariableSpace)JobEntryCopyFiles.this).toString());
                    }
                }
            }
            catch (Exception e) {
                JobEntryCopyFiles.this.logError(BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{info.getFile().toString(), fil_name, e.getMessage()}));
                resultat = false;
            }
            return resultat;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return this.traverseCount++ == 0 || JobEntryCopyFiles.this.include_subfolders;
        }
    }

    private class TextFileSelector
    implements FileSelector {
        String file_wildcard = null;
        String source_folder = null;
        String destination_folder = null;
        Job parentjob;
        Pattern pattern;
        private int traverseCount;
        FileObject destinationFolderObject = null;

        private boolean GetFileWildcard(String selectedfile) {
            boolean getIt = true;
            if (this.pattern != null) {
                Matcher matcher = this.pattern.matcher(selectedfile);
                getIt = matcher.matches();
            }
            return getIt;
        }

        public TextFileSelector(FileObject sourcefolderin, FileObject destinationfolderin, String filewildcard, Job parentJob) {
            if (sourcefolderin != null) {
                this.source_folder = sourcefolderin.toString();
            }
            if (destinationfolderin != null) {
                this.destinationFolderObject = destinationfolderin;
                this.destination_folder = this.destinationFolderObject.toString();
            }
            if (!Const.isEmpty((String)filewildcard)) {
                this.file_wildcard = filewildcard;
                this.pattern = Pattern.compile(this.file_wildcard);
            }
            this.parentjob = parentJob;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public boolean includeFile(FileSelectInfo info) {
            block48: {
                returncode = false;
                file_name = null;
                addFileNameString = null;
                try {
                    block47: {
                        if (info.getFile().toString().equals(this.source_folder) || this.parentjob.isStopped()) break block47;
                        short_filename = info.getFile().getName().getBaseName();
                        if (this.destinationFolderObject == null) {
                            this.destinationFolderObject = KettleVFS.getFileObject((String)this.destination_folder, (VariableSpace)JobEntryCopyFiles.this);
                        }
                        file_name = this.destinationFolderObject.getChild(short_filename);
                        if (!info.getFile().getParent().equals(info.getBaseFolder())) {
                            if (JobEntryCopyFiles.this.include_subfolders) {
                                if (info.getFile().getType() == FileType.FOLDER) {
                                    if (JobEntryCopyFiles.this.include_subfolders && JobEntryCopyFiles.this.copy_empty_folders && Const.isEmpty((String)this.file_wildcard)) {
                                        if (file_name == null || !file_name.exists()) {
                                            if (JobEntryCopyFiles.this.isDetailed()) {
                                                JobEntryCopyFiles.this.logDetailed(" ------ ");
                                                JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FolderCopied", (String[])new String[]{info.getFile().toString(), file_name != null ? file_name.toString() : ""}));
                                            }
                                            returncode = true;
                                        } else {
                                            if (JobEntryCopyFiles.this.isDetailed()) {
                                                JobEntryCopyFiles.this.logDetailed(" ------ ");
                                                JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FolderExists", (String[])new String[]{file_name.toString()}));
                                            }
                                            if (JobEntryCopyFiles.this.overwrite_files) {
                                                if (JobEntryCopyFiles.this.isDetailed()) {
                                                    JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FolderOverwrite", (String[])new String[]{info.getFile().toString(), file_name.toString()}));
                                                }
                                                returncode = true;
                                            }
                                        }
                                    }
                                } else if (this.GetFileWildcard(short_filename)) {
                                    if (file_name == null || !file_name.exists()) {
                                        if (JobEntryCopyFiles.this.isDetailed()) {
                                            JobEntryCopyFiles.this.logDetailed(" ------ ");
                                            JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FileCopied", (String[])new String[]{info.getFile().toString(), file_name != null ? file_name.toString() : ""}));
                                        }
                                        returncode = true;
                                    } else {
                                        if (JobEntryCopyFiles.this.isDetailed()) {
                                            JobEntryCopyFiles.this.logDetailed(" ------ ");
                                            JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{file_name.toString()}));
                                        }
                                        if (JobEntryCopyFiles.this.overwrite_files) {
                                            if (JobEntryCopyFiles.this.isDetailed()) {
                                                JobEntryCopyFiles.this.logDetailed("       " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{info.getFile().toString(), file_name.toString()}));
                                            }
                                            returncode = true;
                                            ** GOTO lbl77
                                        }
                                    }
                                }
                            }
                            break block47;
                        }
                        if (info.getFile().getType() == FileType.FOLDER) {
                            if (JobEntryCopyFiles.this.include_subfolders && JobEntryCopyFiles.this.copy_empty_folders && Const.isEmpty((String)this.file_wildcard)) {
                                if (file_name == null || !file_name.exists()) {
                                    if (JobEntryCopyFiles.this.isDetailed()) {
                                        JobEntryCopyFiles.this.logDetailed("", new Object[]{" ------ "});
                                        JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FolderCopied", (String[])new String[]{info.getFile().toString(), file_name != null ? file_name.toString() : ""}));
                                    }
                                    returncode = true;
                                } else {
                                    if (JobEntryCopyFiles.this.isDetailed()) {
                                        JobEntryCopyFiles.this.logDetailed(" ------ ");
                                        JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FolderExists", (String[])new String[]{file_name.toString()}));
                                    }
                                    if (JobEntryCopyFiles.this.overwrite_files) {
                                        if (JobEntryCopyFiles.this.isDetailed()) {
                                            JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FolderOverwrite", (String[])new String[]{info.getFile().toString(), file_name.toString()}));
                                        }
                                        returncode = true;
                                    }
                                }
                            }
                            break block47;
                        }
                        file_name = KettleVFS.getFileObject((String)(this.destination_folder + Const.FILE_SEPARATOR + short_filename));
                        if (!this.GetFileWildcard(short_filename)) break block47;
                        if (file_name == null || !file_name.exists()) {
                            if (JobEntryCopyFiles.this.isDetailed()) {
                                JobEntryCopyFiles.this.logDetailed(" ------ ");
                                JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FileCopied", (String[])new String[]{info.getFile().toString(), file_name != null ? file_name.toString() : ""}));
                            }
                            returncode = true;
                            break block47;
                        }
                        if (JobEntryCopyFiles.this.isDetailed()) {
                            JobEntryCopyFiles.this.logDetailed(" ------ ");
                            JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{file_name.toString()}));
                        }
                        if (!JobEntryCopyFiles.this.overwrite_files) break block47;
                        if (JobEntryCopyFiles.this.isDetailed()) {
                            JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FileExistsInfos", (String[])new String[0]), new Object[]{BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{info.getFile().toString(), file_name.toString()})});
                        }
                        returncode = true;
                    }
                    var7_7 = null;
                    ** if (file_name == null) goto lbl-1000
                }
                catch (Throwable var6_13) {
                    var7_9 = null;
                    if (file_name != null) {
                        try {
                            if (returncode && JobEntryCopyFiles.this.add_result_filesname) {
                                addFileNameString = file_name.toString();
                            }
                            file_name.close();
                            file_name = null;
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    throw var6_13;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        if (returncode && JobEntryCopyFiles.this.add_result_filesname) {
                            addFileNameString = file_name.toString();
                        }
                        file_name.close();
                        file_name = null;
                    }
                    catch (IOException ex) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block48;
                    catch (Exception e) {
                        JobEntryCopyFiles.this.logError(BaseMessages.getString((Class)JobEntryCopyFiles.access$000(), (String)"JobCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{info.getFile().toString(), file_name.toString(), e.getMessage()}));
                        returncode = false;
                        var7_8 = null;
                        if (file_name != null) {
                            try {
                                if (returncode && JobEntryCopyFiles.this.add_result_filesname) {
                                    addFileNameString = file_name.toString();
                                }
                                file_name.close();
                                file_name = null;
                            }
                            catch (IOException ex) {}
                        }
                    }
                }
            }
            if (returncode && JobEntryCopyFiles.this.remove_source_files) {
                JobEntryCopyFiles.this.list_files_remove.add(info.getFile().toString());
            }
            if (returncode && JobEntryCopyFiles.this.add_result_filesname) {
                JobEntryCopyFiles.this.list_add_result.add(addFileNameString);
            }
            return returncode;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return this.traverseCount++ == 0 || JobEntryCopyFiles.this.include_subfolders;
        }

        public void shutdown() {
            if (this.destinationFolderObject != null) {
                try {
                    this.destinationFolderObject.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    private class TextOneToOneFileSelector
    implements FileSelector {
        FileObject destfile = null;

        public TextOneToOneFileSelector(FileObject destinationfile) {
            if (destinationfile != null) {
                this.destfile = destinationfile;
            }
        }

        public boolean includeFile(FileSelectInfo info) {
            boolean resultat = false;
            Object fil_name = null;
            try {
                if (this.destfile.exists()) {
                    if (JobEntryCopyFiles.this.isDetailed()) {
                        JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileExists", (String[])new String[]{this.destfile.toString()}));
                    }
                    if (JobEntryCopyFiles.this.overwrite_files) {
                        if (JobEntryCopyFiles.this.isDetailed()) {
                            JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileOverwrite", (String[])new String[]{this.destfile.toString()}));
                        }
                        resultat = true;
                    }
                } else {
                    if (JobEntryCopyFiles.this.isDetailed()) {
                        JobEntryCopyFiles.this.logDetailed("      " + BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Log.FileCopied", (String[])new String[]{info.getFile().toString(), this.destfile.toString()}));
                    }
                    resultat = true;
                }
                if (resultat && JobEntryCopyFiles.this.remove_source_files) {
                    JobEntryCopyFiles.this.list_files_remove.add(info.getFile().toString());
                }
                if (resultat && JobEntryCopyFiles.this.add_result_filesname) {
                    JobEntryCopyFiles.this.list_add_result.add(this.destfile.toString());
                }
            }
            catch (Exception e) {
                JobEntryCopyFiles.this.logError(BaseMessages.getString((Class)PKG, (String)"JobCopyFiles.Error.Exception.CopyProcess", (String[])new String[]{info.getFile().toString(), fil_name, e.getMessage()}));
            }
            return resultat;
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return false;
        }
    }
}

