/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.delay;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryDelay
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryDelay.class;
    private static String DEFAULT_MAXIMUM_TIMEOUT = "0";
    private String maximumTimeout;
    public int scaleTime;

    public JobEntryDelay(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryDelay() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryDelay je = (JobEntryDelay)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"maximumTimeout", (String)this.maximumTimeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"scaletime", (int)this.scaleTime));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.maximumTimeout = XMLHandler.getTagValue((Node)entrynode, (String)"maximumTimeout");
            this.scaleTime = Integer.parseInt(XMLHandler.getTagValue((Node)entrynode, (String)"scaletime"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryDelay.UnableToLoadFromXml.Label", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.maximumTimeout = rep.getJobEntryAttributeString(id_jobentry, "maximumTimeout");
            this.scaleTime = (int)rep.getJobEntryAttributeInteger(id_jobentry, "scaletime");
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryDelay.UnableToLoadFromRepo.Label", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "maximumTimeout", this.maximumTimeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "scaletime", this.scaleTime);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryDelay.UnableToSaveToRepo.Label", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        String Waitscale;
        int Multiple;
        Result result = previousResult;
        result.setResult(false);
        switch (this.scaleTime) {
            case 0: {
                Multiple = 1000;
                Waitscale = BaseMessages.getString(PKG, (String)"JobEntryDelay.SScaleTime.Label", (String[])new String[0]);
                break;
            }
            case 1: {
                Multiple = 60000;
                Waitscale = BaseMessages.getString(PKG, (String)"JobEntryDelay.MnScaleTime.Label", (String[])new String[0]);
                break;
            }
            default: {
                Multiple = 3600000;
                Waitscale = BaseMessages.getString(PKG, (String)"JobEntryDelay.HrScaleTime.Label", (String[])new String[0]);
            }
        }
        try {
            long timeStart = System.currentTimeMillis() / (long)Multiple;
            long iMaximumTimeout = Const.toInt((String)this.getrealMaximumTimeout(), (int)Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0));
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDelay.LetsWaitFor.Label", (Object[])new Object[]{iMaximumTimeout, Waitscale}));
            }
            boolean continueLoop = true;
            if (iMaximumTimeout < 0L) {
                iMaximumTimeout = Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0);
                this.logBasic(BaseMessages.getString(PKG, (String)"JobEntryDelay.MaximumTimeReset.Label", (String[])new String[]{String.valueOf(iMaximumTimeout), String.valueOf(Waitscale)}));
            }
            while (continueLoop && !this.parentJob.isStopped()) {
                long now = System.currentTimeMillis() / (long)Multiple;
                if (iMaximumTimeout > 0L && now >= timeStart + iMaximumTimeout) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryDelay.WaitTimeIsElapsed.Label", (String[])new String[0]));
                    }
                    continueLoop = false;
                    result.setResult(true);
                    continue;
                }
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            result.setResult(false);
            this.logError("Error  : " + e.getMessage());
        }
        return result;
    }

    @Override
    public boolean resetErrorsBeforeExecution() {
        return false;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    public String getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public String getrealMaximumTimeout() {
        return this.environmentSubstitute(this.getMaximumTimeout());
    }

    public void setMaximumTimeout(String s) {
        this.maximumTimeout = s;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "maximumTimeout", remarks, AndValidator.putValidators(JobEntryValidatorUtils.longValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "scaleTime", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }

    public int getScaleTime() {
        return this.scaleTime;
    }

    public void setScaleTime(int scaleTime) {
        this.scaleTime = scaleTime;
    }
}

