/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.evalfilesmetrics;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.simpleeval.JobEntrySimpleEval;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryEvalFilesMetrics
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryEvalFilesMetrics.class;
    public static final BigDecimal ONE = new BigDecimal(1);
    public static final String[] IncludeSubFoldersDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] IncludeSubFoldersCodes = new String[]{"N", "Y"};
    private static final String YES = "Y";
    private static final String NO = "N";
    public static final String[] scaleDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Bytes.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.KBytes.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.MBytes.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.GBytes.Label", (String[])new String[0])};
    public static final String[] scaleCodes = new String[]{"bytes", "kbytes", "mbytes", "gbytes"};
    public static final int SCALE_BYTES = 0;
    public static final int SCALE_KBYTES = 1;
    public static final int SCALE_MBYTES = 2;
    public static final int SCALE_GBYTES = 3;
    public int scale = 0;
    public static final String[] SourceFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.SourceFiles.Files.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.SourceFiles.FilenamesResult.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.SourceFiles.PreviousResult.Label", (String[])new String[0])};
    public static final String[] SourceFilesCodes = new String[]{"files", "filenamesresult", "previousresult"};
    public static final int SOURCE_FILES_FILES = 0;
    public static final int SOURCE_FILES_FILENAMES_RESULT = 1;
    public static final int SOURCE_FILES_PREVIOUS_RESULT = 2;
    public int sourceFiles = 0;
    public static final String[] EvaluationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.EvaluationType.Size.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.EvaluationType.Count.Label", (String[])new String[0])};
    public static final String[] EvaluationTypeCodes = new String[]{"size", "count"};
    public static final int EVALUATE_TYPE_SIZE = 0;
    public static final int EVALUATE_TYPE_COUNT = 1;
    public int evaluationType = 0;
    private String comparevalue;
    private String minvalue;
    private String maxvalue;
    public int successnumbercondition = 4;
    private String resultFilenamesWildcard = null;
    public boolean arg_from_previous;
    public String[] source_filefolder = null;
    public String[] wildcard = null;
    public String[] includeSubFolders = null;
    private BigDecimal evaluationValue;
    private BigDecimal filesCount;
    private long nrErrors;
    private String ResultFieldFile = null;
    private String ResultFieldWildcard = null;
    private String ResultFieldIncludesubFolders = null;
    private BigDecimal compareValue;
    private BigDecimal minValue;
    private BigDecimal maxValue;

    public JobEntryEvalFilesMetrics(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryEvalFilesMetrics() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryEvalFilesMetrics je = (JobEntryEvalFilesMetrics)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"result_filenames_wildcard", (String)this.resultFilenamesWildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"Result_field_file", (String)this.ResultFieldFile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"Result_field_wildcard", (String)this.ResultFieldWildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"Result_field_includesubfolders", (String)this.ResultFieldIncludesubFolders));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.source_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"include_subFolders", (String)this.includeSubFolders[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"comparevalue", (String)this.comparevalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"minvalue", (String)this.minvalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"maxvalue", (String)this.maxvalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"successnumbercondition", (String)JobEntrySimpleEval.getSuccessNumberConditionCode(this.successnumbercondition)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"source_files", (String)JobEntryEvalFilesMetrics.getSourceFilesCode(this.sourceFiles)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"evaluation_type", (String)JobEntryEvalFilesMetrics.getEvaluationTypeCode(this.evaluationType)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"scale", (String)JobEntryEvalFilesMetrics.getScaleCode(this.scale)));
        return retval.toString();
    }

    public static String getIncludeSubFolders(String tt) {
        if (tt == null) {
            return IncludeSubFoldersCodes[0];
        }
        if (tt.equals(IncludeSubFoldersDesc[1])) {
            return IncludeSubFoldersCodes[1];
        }
        return IncludeSubFoldersCodes[0];
    }

    public static String getIncludeSubFoldersDesc(String tt) {
        if (tt == null) {
            return IncludeSubFoldersDesc[0];
        }
        if (tt.equals(IncludeSubFoldersCodes[1])) {
            return IncludeSubFoldersDesc[1];
        }
        return IncludeSubFoldersDesc[0];
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.source_filefolder = new String[nrFields];
            this.wildcard = new String[nrFields];
            this.includeSubFolders = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
                this.includeSubFolders[i] = XMLHandler.getTagValue((Node)fnode, (String)"include_subFolders");
            }
            this.resultFilenamesWildcard = XMLHandler.getTagValue((Node)entrynode, (String)"result_filenames_wildcard");
            this.ResultFieldFile = XMLHandler.getTagValue((Node)entrynode, (String)"result_field_file");
            this.ResultFieldWildcard = XMLHandler.getTagValue((Node)entrynode, (String)"result_field_wildcard");
            this.ResultFieldIncludesubFolders = XMLHandler.getTagValue((Node)entrynode, (String)"result_field_includesubfolders");
            this.comparevalue = XMLHandler.getTagValue((Node)entrynode, (String)"comparevalue");
            this.minvalue = XMLHandler.getTagValue((Node)entrynode, (String)"minvalue");
            this.maxvalue = XMLHandler.getTagValue((Node)entrynode, (String)"maxvalue");
            this.successnumbercondition = JobEntrySimpleEval.getSuccessNumberConditionByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"successnumbercondition"), (String)""));
            this.sourceFiles = JobEntryEvalFilesMetrics.getSourceFilesByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"source_files"), (String)""));
            this.evaluationType = JobEntryEvalFilesMetrics.getEvaluationTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"evaluation_type"), (String)""));
            this.scale = JobEntryEvalFilesMetrics.getScaleByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"scale"), (String)""));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.source_filefolder = new String[argnr];
            this.wildcard = new String[argnr];
            this.includeSubFolders = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
                this.includeSubFolders[a] = rep.getJobEntryAttributeString(id_jobentry, a, "include_subFolders");
            }
            this.resultFilenamesWildcard = rep.getJobEntryAttributeString(id_jobentry, "result_filenames_wildcard");
            this.ResultFieldFile = rep.getJobEntryAttributeString(id_jobentry, "result_field_file");
            this.ResultFieldWildcard = rep.getJobEntryAttributeString(id_jobentry, "result_field_wildcard");
            this.ResultFieldIncludesubFolders = rep.getJobEntryAttributeString(id_jobentry, "result_field_includesubfolders");
            this.comparevalue = rep.getJobEntryAttributeString(id_jobentry, "comparevalue");
            this.minvalue = rep.getJobEntryAttributeString(id_jobentry, "minvalue");
            this.maxvalue = rep.getJobEntryAttributeString(id_jobentry, "maxvalue");
            this.successnumbercondition = JobEntrySimpleEval.getSuccessNumberConditionByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "successnumbercondition"), (String)""));
            this.sourceFiles = JobEntryEvalFilesMetrics.getSourceFilesByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "source_files"), (String)""));
            this.evaluationType = JobEntryEvalFilesMetrics.getEvaluationTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "evaluation_type"), (String)""));
            this.scale = JobEntryEvalFilesMetrics.getScaleByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "scale"), (String)""));
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.Exception.UnableLoadRep", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "source_filefolder", this.source_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "wildcard", this.wildcard[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "include_subFolders", this.includeSubFolders[i]);
                }
            }
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "result_filenames_wildcard", this.resultFilenamesWildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "result_field_file", this.ResultFieldFile);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "result_field_wild", this.ResultFieldWildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "result_field_includesubfolders", this.ResultFieldIncludesubFolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "comparevalue", this.comparevalue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "minvalue", this.minvalue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "maxvalue", this.maxvalue);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "successnumbercondition", JobEntrySimpleEval.getSuccessNumberConditionCode(this.successnumbercondition));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "scale", JobEntryEvalFilesMetrics.getScaleCode(this.scale));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "source_files", JobEntryEvalFilesMetrics.getSourceFilesCode(this.sourceFiles));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "evaluation_type", JobEntryEvalFilesMetrics.getEvaluationTypeCode(this.evaluationType));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.Exception.UnableSaveRep", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        rows = result.getRows();
        resultRow = null;
        try {
            this.initMetrics();
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Error.Init", (String[])new String[]{e.toString()}));
            return result;
        }
        vsourcefilefolder = this.source_filefolder;
        vwildcard = this.wildcard;
        vincludeSubFolders = this.includeSubFolders;
        switch (this.getSourceFiles()) {
            case 2: {
                realResultFieldFile = this.environmentSubstitute(this.getResultFieldFile());
                realResultFieldWildcard = this.environmentSubstitute(this.getResultFieldWildcard());
                realResultFieldIncluseSubfolders = this.environmentSubstitute(this.getResultFieldIncludeSubfolders());
                indexOfResultFieldFile = -1;
                if (Const.isEmpty((String)realResultFieldFile)) {
                    this.logError(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Error.ResultFieldsFileMissing", (String[])new String[0]));
                    return result;
                }
                indexOfResultFieldWildcard = -1;
                indexOfResultFieldIncludeSubfolders = -1;
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
                }
                if (rows == null || rows.size() <= 0) break;
                firstRow = (RowMetaAndData)rows.get(0);
                indexOfResultFieldFile = firstRow.getRowMeta().indexOfValue(realResultFieldFile);
                if (indexOfResultFieldFile == -1) {
                    this.logError(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Error.CanNotFindField", (String[])new String[]{realResultFieldFile}));
                    return result;
                }
                if (!Const.isEmpty((String)realResultFieldWildcard) && (indexOfResultFieldWildcard = firstRow.getRowMeta().indexOfValue(realResultFieldWildcard)) == -1) {
                    this.logError(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Error.CanNotFindField", (String[])new String[]{realResultFieldWildcard}));
                    return result;
                }
                if (!Const.isEmpty((String)realResultFieldIncluseSubfolders) && (indexOfResultFieldIncludeSubfolders = firstRow.getRowMeta().indexOfValue(realResultFieldIncluseSubfolders)) == -1) {
                    this.logError(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Error.CanNotFindField", (String[])new String[]{realResultFieldIncluseSubfolders}));
                    return result;
                }
                for (iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                    resultRow = (RowMetaAndData)rows.get(iteration);
                    vsourcefilefolder_previous = resultRow.getString(indexOfResultFieldFile, null);
                    vwildcard_previous = null;
                    if (indexOfResultFieldWildcard > -1) {
                        vwildcard_previous = resultRow.getString(indexOfResultFieldWildcard, null);
                    }
                    vincludeSubFolders_previous = "N";
                    if (indexOfResultFieldIncludeSubfolders > -1) {
                        vincludeSubFolders_previous = resultRow.getString(indexOfResultFieldIncludeSubfolders, "N");
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder_previous, vwildcard_previous}));
                    }
                    this.ProcessFileFolder(vsourcefilefolder_previous, vwildcard_previous, vincludeSubFolders_previous, this.parentJob, result);
                }
                break;
            }
            case 1: {
                resultFiles = result.getResultFilesList();
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Log.ResultFilenames.Found", (String[])new String[]{(resultFiles != null ? resultFiles.size() : 0) + ""}));
                }
                if (resultFiles == null || resultFiles.size() <= 0) break;
                pattern = null;
                realPattern = this.environmentSubstitute(this.getResultFilenamesWildcard());
                if (!Const.isEmpty((String)realPattern)) {
                    pattern = Pattern.compile(realPattern);
                }
                it = resultFiles.iterator();
                while (it.hasNext() && !this.parentJob.isStopped()) {
                    resultFile = (ResultFile)it.next();
                    file = resultFile.getFile();
                    if (file == null || !file.exists()) ** GOTO lbl77
                    getIt = true;
                    if (pattern != null) {
                        matcher = pattern.matcher(file.getName().getBaseName());
                        getIt = matcher.matches();
                    }
                    if (!getIt) ** GOTO lbl77
                    this.getFileSize(file, result, this.parentJob);
lbl77:
                    // 3 sources

                    var24_31 = null;
                    if (file == null) continue;
                    try {
                        file.close();
                    }
                    catch (Exception e) {}
                    continue;
                    {
                        catch (Exception e) {
                            this.incrementErrors();
                            this.logError(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Error.GettingFileFromResultFilenames", (String[])new String[]{file.toString(), e.toString()}));
                            var24_31 = null;
                            if (file == null) continue;
                            try {
                                file.close();
                            }
                            catch (Exception e) {}
                            continue;
                        }
                    }
                    catch (Throwable var23_33) {
                        var24_31 = null;
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        throw var23_33;
                    }
                }
                break;
            }
            default: {
                if (vsourcefilefolder != null && vsourcefilefolder.length > 0) {
                    for (i = 0; i < vsourcefilefolder.length && !this.parentJob.isStopped(); ++i) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder[i], vwildcard[i]}));
                        }
                        this.ProcessFileFolder(vsourcefilefolder[i], vwildcard[i], vincludeSubFolders[i], this.parentJob, result);
                    }
                    break;
                }
                this.logError(BaseMessages.getString(JobEntryEvalFilesMetrics.PKG, (String)"JobEvalFilesMetrics.Error.FilesGridEmpty", (String[])new String[0]));
                return result;
            }
        }
        result.setResult(this.isSuccess());
        result.setNrErrors(this.getNrError());
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.Info.FilesCount", (String[])new String[]{String.valueOf(this.getFilesCount())}));
            if (this.evaluationType == 0) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.Info.FilesSize", (String[])new String[]{String.valueOf(this.getEvaluationValue())}));
            }
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.Info.NrErrors", (String[])new String[]{String.valueOf(this.getNrError())}));
            this.logDetailed("=======================================");
        }
    }

    private long getNrError() {
        return this.nrErrors;
    }

    private BigDecimal getEvaluationValue() {
        return this.evaluationValue;
    }

    private BigDecimal getFilesCount() {
        return this.filesCount;
    }

    private boolean isSuccess() {
        boolean retval = false;
        switch (this.successnumbercondition) {
            case 0: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) == 0;
                break;
            }
            case 1: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) != 0;
                break;
            }
            case 2: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) < 0;
                break;
            }
            case 3: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) <= 0;
                break;
            }
            case 4: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) > 0;
                break;
            }
            case 5: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValue", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.compareValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.compareValue) >= 0;
                break;
            }
            case 6: {
                if (this.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.CompareWithValues", (String[])new String[]{String.valueOf(this.evaluationValue), String.valueOf(this.minValue), String.valueOf(this.maxValue)}));
                }
                retval = this.getEvaluationValue().compareTo(this.minValue) >= 0 && this.getEvaluationValue().compareTo(this.maxValue) <= 0;
                break;
            }
        }
        return retval;
    }

    private void initMetrics() throws Exception {
        this.evaluationValue = new BigDecimal(0);
        this.filesCount = new BigDecimal(0);
        this.nrErrors = 0L;
        if (this.successnumbercondition == 6) {
            this.minValue = new BigDecimal(this.environmentSubstitute(this.getMinValue()));
            this.maxValue = new BigDecimal(this.environmentSubstitute(this.getMaxValue()));
        } else {
            this.compareValue = new BigDecimal(this.environmentSubstitute(this.getCompareValue()));
        }
        if (this.evaluationType == 0) {
            int multyply = 1;
            switch (this.getScale()) {
                case 1: {
                    multyply = 1024;
                    break;
                }
                case 2: {
                    multyply = 0x100000;
                    break;
                }
                case 3: {
                    multyply = 0x40000000;
                    break;
                }
            }
            if (this.successnumbercondition == 6) {
                this.minValue = this.minValue.multiply(BigDecimal.valueOf(multyply));
                this.maxValue = this.maxValue.multiply(BigDecimal.valueOf(multyply));
            } else {
                this.compareValue = this.compareValue.multiply(BigDecimal.valueOf(multyply));
            }
        }
        this.arg_from_previous = this.getSourceFiles() == 2;
    }

    private void incrementErrors() {
        ++this.nrErrors;
    }

    public int getSourceFiles() {
        return this.sourceFiles;
    }

    private void incrementFilesCount() {
        this.filesCount = this.filesCount.add(ONE);
    }

    public String getResultFieldFile() {
        return this.ResultFieldFile;
    }

    public void setResultFieldFile(String field) {
        this.ResultFieldFile = field;
    }

    public String getResultFieldWildcard() {
        return this.ResultFieldWildcard;
    }

    public void setResultFieldWildcard(String field) {
        this.ResultFieldWildcard = field;
    }

    public String getResultFieldIncludeSubfolders() {
        return this.ResultFieldIncludesubFolders;
    }

    public void setResultFieldIncludeSubfolders(String field) {
        this.ResultFieldIncludesubFolders = field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void ProcessFileFolder(String sourcefilefoldername, String wildcard, String includeSubfolders, Job parentJob, Result result) {
        block30: {
            IOException ex222;
            String realSourceFilefoldername;
            FileObject CurrentFile;
            FileObject sourcefilefolder;
            block28: {
                block27: {
                    sourcefilefolder = null;
                    CurrentFile = null;
                    realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
                    if (Const.isEmpty((String)realSourceFilefoldername)) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.log.FileFolderEmpty", (String[])new String[0]));
                        this.incrementErrors();
                        return;
                    }
                    String realWildcard = this.environmentSubstitute(wildcard);
                    final boolean include_subfolders = YES.equalsIgnoreCase(includeSubfolders);
                    sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername);
                    if (sourcefilefolder.exists()) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.FileExists", (String[])new String[]{sourcefilefolder.toString()}));
                        }
                        if (sourcefilefolder.getType() == FileType.FILE) {
                            this.getFileSize(sourcefilefolder, result, parentJob);
                        } else if (sourcefilefolder.getType() == FileType.FOLDER) {
                            FileObject[] fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                                public boolean traverseDescendents(FileSelectInfo info) {
                                    return info.getDepth() == 0 || include_subfolders;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Unable to fully structure code
                                 * Enabled aggressive block sorting
                                 * Enabled unnecessary exception pruning
                                 * Enabled aggressive exception aggregation
                                 */
                                public boolean includeFile(FileSelectInfo info) {
                                    block14: {
                                        block15: {
                                            block13: {
                                                fileObject = info.getFile();
                                                try {
                                                    try {
                                                        if (fileObject == null) {
                                                            var3_3 = false;
                                                            var6_6 = null;
                                                            if (fileObject == null) return var3_3;
                                                            break block13;
                                                        }
                                                        if (fileObject.getType() == FileType.FILE) break block14;
                                                        var3_4 = false;
                                                        break block15;
                                                    }
                                                    catch (Exception ex) {
                                                        var4_16 = false;
                                                        var6_9 = null;
                                                        if (fileObject == null) return var4_16;
                                                        try {
                                                            fileObject.close();
                                                            return var4_16;
                                                        }
                                                        catch (IOException ex) {
                                                            // empty catch block
                                                        }
                                                        return var4_16;
                                                    }
                                                }
                                                catch (Throwable var5_17) {
                                                    var6_10 = null;
                                                    if (fileObject == null) throw var5_17;
                                                    ** try [egrp 2[TRYBLOCK] [7 : 67->76)] { 
lbl30:
                                                    // 1 sources

                                                    fileObject.close();
                                                    throw var5_17;
lbl32:
                                                    // 1 sources

                                                    catch (IOException ex) {
                                                        // empty catch block
                                                    }
                                                    throw var5_17;
                                                }
                                            }
                                            ** try [egrp 2[TRYBLOCK] [7 : 67->76)] { 
lbl37:
                                            // 1 sources

                                            fileObject.close();
                                            return var3_3;
lbl39:
                                            // 1 sources

                                            catch (IOException ex) {
                                                // empty catch block
                                            }
                                            return var3_3;
                                        }
                                        var6_7 = null;
                                        if (fileObject == null) return var3_4;
                                        try {}
                                        catch (IOException ex) {
                                            // empty catch block
                                            return var3_4;
                                        }
                                        fileObject.close();
                                        return var3_4;
                                    }
                                    var6_8 = null;
                                    if (fileObject == null) return true;
                                    try {}
                                    catch (IOException ex) {}
                                    fileObject.close();
                                    return true;
                                    return true;
                                }
                            });
                            if (fileObjects != null) {
                                for (int j = 0; j < fileObjects.length && !parentJob.isStopped(); ++j) {
                                    CurrentFile = fileObjects[j];
                                    if (!CurrentFile.getParent().toString().equals(sourcefilefolder.toString())) {
                                        if (!include_subfolders || !this.GetFileWildcard(CurrentFile.getName().getBaseName(), realWildcard)) continue;
                                        this.getFileSize(CurrentFile, result, parentJob);
                                        continue;
                                    }
                                    if (!this.GetFileWildcard(CurrentFile.getName().getBaseName(), realWildcard)) continue;
                                    this.getFileSize(CurrentFile, result, parentJob);
                                }
                            }
                        } else {
                            this.incrementErrors();
                            this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.UnknowFileFormat", (String[])new String[]{sourcefilefolder.toString()}));
                        }
                        break block27;
                    }
                    this.incrementErrors();
                    this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
                }
                Object var14_14 = null;
                if (sourcefilefolder == null) break block28;
                try {
                    sourcefilefolder.close();
                }
                catch (IOException ex222) {
                    // empty catch block
                }
            }
            if (CurrentFile != null) {
                try {
                    CurrentFile.close();
                }
                catch (IOException ex222) {}
            }
            break block30;
            {
                catch (Exception e) {
                    IOException ex222;
                    this.incrementErrors();
                    this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.Exception.Processing", (String[])new String[]{realSourceFilefoldername.toString(), e.getMessage()}));
                    Object var14_15 = null;
                    if (sourcefilefolder != null) {
                        try {
                            sourcefilefolder.close();
                        }
                        catch (IOException ex222) {
                            // empty catch block
                        }
                    }
                    if (CurrentFile != null) {
                        try {
                            CurrentFile.close();
                        }
                        catch (IOException ex222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException ex222;
                Object var14_16 = null;
                if (sourcefilefolder != null) {
                    try {
                        sourcefilefolder.close();
                    }
                    catch (IOException ex222) {
                        // empty catch block
                    }
                }
                if (CurrentFile != null) {
                    try {
                        CurrentFile.close();
                    }
                    catch (IOException ex222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void getFileSize(FileObject file, Result result, Job parentJob) {
        try {
            this.incrementFilesCount();
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.GetFile", (String[])new String[]{file.toString(), String.valueOf(this.getFilesCount())}));
            }
            switch (this.evaluationType) {
                case 0: {
                    BigDecimal fileSize = BigDecimal.valueOf(file.getContent().getSize());
                    this.evaluationValue = this.evaluationValue.add(fileSize);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Log.AddedFileSize", (String[])new String[]{String.valueOf(fileSize), file.toString()}));
                    }
                    break;
                }
                default: {
                    this.evaluationValue = this.evaluationValue.add(ONE);
                    break;
                }
            }
        }
        catch (Exception e) {
            this.incrementErrors();
            this.logError(BaseMessages.getString(PKG, (String)"JobEvalFilesMetrics.Error.GettingFileSize", (String[])new String[]{file.toString(), e.toString()}));
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    public void setMinValue(String minvalue) {
        this.minvalue = minvalue;
    }

    public String getMinValue() {
        return this.minvalue;
    }

    public void setCompareValue(String comparevalue) {
        this.comparevalue = comparevalue;
    }

    public String getCompareValue() {
        return this.comparevalue;
    }

    public void setResultFilenamesWildcard(String resultwildcard) {
        this.resultFilenamesWildcard = resultwildcard;
    }

    public String getResultFilenamesWildcard() {
        return this.resultFilenamesWildcard;
    }

    public void setMaxValue(String maxvalue) {
        this.maxvalue = maxvalue;
    }

    public String getMaxValue() {
        return this.maxvalue;
    }

    public static int getScaleByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < scaleDesc.length; ++i) {
            if (!scaleDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryEvalFilesMetrics.getScaleByCode(tt);
    }

    public static int getSourceFilesByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < SourceFilesDesc.length; ++i) {
            if (!SourceFilesDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryEvalFilesMetrics.getSourceFilesByCode(tt);
    }

    public static int getEvaluationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < EvaluationTypeDesc.length; ++i) {
            if (!EvaluationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return JobEntryEvalFilesMetrics.getEvaluationTypeByCode(tt);
    }

    private static int getScaleByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < scaleCodes.length; ++i) {
            if (!scaleCodes[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSourceFilesByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < SourceFilesCodes.length; ++i) {
            if (!SourceFilesCodes[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getEvaluationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < EvaluationTypeCodes.length; ++i) {
            if (!EvaluationTypeCodes[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public static String getScaleDesc(int i) {
        if (i < 0 || i >= scaleDesc.length) {
            return scaleDesc[0];
        }
        return scaleDesc[i];
    }

    public static String getEvaluationTypeDesc(int i) {
        if (i < 0 || i >= EvaluationTypeDesc.length) {
            return EvaluationTypeDesc[0];
        }
        return EvaluationTypeDesc[i];
    }

    public static String getSourceFilesDesc(int i) {
        if (i < 0 || i >= SourceFilesDesc.length) {
            return SourceFilesDesc[0];
        }
        return SourceFilesDesc[i];
    }

    public static String getScaleCode(int i) {
        if (i < 0 || i >= scaleCodes.length) {
            return scaleCodes[0];
        }
        return scaleCodes[i];
    }

    public static String getSourceFilesCode(int i) {
        if (i < 0 || i >= SourceFilesCodes.length) {
            return SourceFilesCodes[0];
        }
        return SourceFilesCodes[i];
    }

    public static String getEvaluationTypeCode(int i) {
        if (i < 0 || i >= EvaluationTypeCodes.length) {
            return EvaluationTypeCodes[0];
        }
        return EvaluationTypeCodes[i];
    }

    public int getScale() {
        return this.scale;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.source_filefolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }
}

