/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.fileexists;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryFileExists
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryFileExists.class;
    private String filename = null;

    public JobEntryFileExists(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryFileExists() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFileExists je = (JobEntryFileExists)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobEntryFileExists.ERROR_0001_Cannot_Load_Job_Entry_From_Xml_Node", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryFileExists.ERROR_0002_Cannot_Load_Job_From_Repository", (Object[])new Object[]{id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "filename", this.filename);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryFileExists.ERROR_0003_Cannot_Save_Job_Entry", (Object[])new Object[]{id_job}), (Throwable)dbe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    @Override
    public Result execute(Result previousResult, int nr) {
        Result result;
        block5: {
            result = previousResult;
            result.setResult(false);
            if (this.filename != null) {
                String realFilename = this.getRealFilename();
                try {
                    FileObject file = KettleVFS.getFileObject((String)realFilename, (VariableSpace)this);
                    if (file.exists() && file.isReadable()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFileExists.File_Exists", (String[])new String[]{realFilename}));
                        result.setResult(true);
                        break block5;
                    }
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFileExists.File_Does_Not_Exist", (String[])new String[]{realFilename}));
                }
                catch (Exception e) {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"JobEntryFileExists.ERROR_0004_IO_Exception", (String[])new String[]{e.getMessage()}), e);
                }
            } else {
                result.setNrErrors(1L);
                this.logError(BaseMessages.getString(PKG, (String)"JobEntryFileExists.ERROR_0005_No_Filename_Defined", (String[])new String[0]));
            }
        }
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileObject fileObject;
            if (!Const.isEmpty((String)this.filename) && (fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.filename), (VariableSpace)space)).exists()) {
                this.filename = resourceNamingInterface.nameResource(fileObject, space, true);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

