/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.folderisempty;

import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryFolderIsEmpty
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryFolderIsEmpty.class;
    private String foldername = null;
    private int filescount;
    private int folderscount;
    private boolean includeSubfolders = false;
    private boolean specifywildcard = false;
    private String wildcard = null;
    private Pattern pattern;

    public JobEntryFolderIsEmpty(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryFolderIsEmpty() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFolderIsEmpty je = (JobEntryFolderIsEmpty)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"foldername", (String)this.foldername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"specify_wildcard", (boolean)this.specifywildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.foldername = XMLHandler.getTagValue((Node)entrynode, (String)"foldername");
            this.includeSubfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.specifywildcard = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"specify_wildcard"));
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'create folder' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.foldername = rep.getJobEntryAttributeString(id_jobentry, "foldername");
            this.includeSubfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.specifywildcard = rep.getJobEntryAttributeBoolean(id_jobentry, "specify_wildcard");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'create Folder' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "foldername", this.foldername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.includeSubfolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "specify_wildcard", this.specifywildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'create Folder' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setSpecifyWildcard(boolean specifywildcard) {
        this.specifywildcard = specifywildcard;
    }

    public boolean isSpecifyWildcard() {
        return this.specifywildcard;
    }

    public void setFoldername(String foldername) {
        this.foldername = foldername;
    }

    public String getFoldername() {
        return this.foldername;
    }

    public String getRealFoldername() {
        return this.environmentSubstitute(this.getFoldername());
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getRealWildcard() {
        return this.environmentSubstitute(this.getWildcard());
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public boolean isIncludeSubFolders() {
        return this.includeSubfolders;
    }

    public void setIncludeSubFolders(boolean includeSubfolders) {
        this.includeSubfolders = includeSubfolders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        result.setNrErrors(1L);
        this.filescount = 0;
        this.folderscount = 0;
        this.pattern = null;
        if (!Const.isEmpty((String)this.getWildcard())) {
            this.pattern = Pattern.compile(this.getRealWildcard());
        }
        if (this.foldername != null) {
            FileObject folderObject;
            String realFoldername;
            block15: {
                realFoldername = this.getRealFoldername();
                folderObject = null;
                folderObject = KettleVFS.getFileObject((String)realFoldername, (VariableSpace)this);
                if (folderObject.exists()) {
                    if (folderObject.getType() == FileType.FOLDER) {
                        folderObject.findFiles((FileSelector)new TextFileSelector(folderObject.toString()));
                        if (this.log.isBasic()) {
                            this.log.logBasic("Total files", new Object[]{"We found : " + this.filescount + " file(s)"});
                        }
                        if (this.filescount == 0) {
                            result.setResult(true);
                            result.setNrErrors(0L);
                        }
                    } else {
                        this.log.logError("[" + realFoldername + "] is not a folder, failing.");
                    }
                    break block15;
                }
                if (!this.log.isBasic()) break block15;
                this.logBasic("we can not find [" + realFoldername + "] !");
            }
            Object var8_6 = null;
            if (folderObject == null) return result;
            try {
                folderObject.close();
                folderObject = null;
                return result;
            }
            catch (IOException ex) {}
            return result;
            {
                catch (Exception e) {
                    this.logError("Error checking folder [" + realFoldername + "]", e);
                    result.setResult(false);
                    result.setNrErrors(1L);
                    Object var8_7 = null;
                    if (folderObject == null) return result;
                    try {
                        folderObject.close();
                        folderObject = null;
                        return result;
                    }
                    catch (IOException ex) {}
                    return result;
                }
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (folderObject == null) throw throwable;
                try {
                    folderObject.close();
                    folderObject = null;
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        this.logError("No Foldername is defined.");
        return result;
    }

    private boolean GetFileWildcard(String selectedfile) {
        boolean getIt = true;
        if (this.pattern != null) {
            Matcher matcher = this.pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }

    private class TextFileSelector
    implements FileSelector {
        String root_folder = null;

        public TextFileSelector(String rootfolder) {
            if (rootfolder != null) {
                this.root_folder = rootfolder;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean includeFile(FileSelectInfo info) {
            boolean returncode = false;
            Object file_name = null;
            if (!info.getFile().toString().equals(this.root_folder)) {
                if (info.getFile().getType() == FileType.FILE) {
                    if (info.getFile().getParent().equals(info.getBaseFolder())) {
                        if (JobEntryFolderIsEmpty.this.isSpecifyWildcard() && JobEntryFolderIsEmpty.this.GetFileWildcard(info.getFile().getName().getBaseName()) || !JobEntryFolderIsEmpty.this.isSpecifyWildcard()) {
                            if (JobEntryFolderIsEmpty.this.log.isDetailed()) {
                                JobEntryFolderIsEmpty.this.log.logDetailed("We found file : " + info.getFile().toString());
                            }
                            JobEntryFolderIsEmpty.this.filescount++;
                        }
                    } else if (JobEntryFolderIsEmpty.this.isIncludeSubFolders() && (JobEntryFolderIsEmpty.this.isSpecifyWildcard() && JobEntryFolderIsEmpty.this.GetFileWildcard(info.getFile().getName().getBaseName()) || !JobEntryFolderIsEmpty.this.isSpecifyWildcard())) {
                        if (JobEntryFolderIsEmpty.this.log.isDetailed()) {
                            JobEntryFolderIsEmpty.this.log.logDetailed("We found file : " + info.getFile().toString());
                        }
                        JobEntryFolderIsEmpty.this.filescount++;
                    }
                } else {
                    JobEntryFolderIsEmpty.this.folderscount++;
                }
            }
            boolean bl = true;
            Object var6_6 = null;
            if (file_name == null) return bl;
            try {
                file_name.close();
                return bl;
            }
            catch (IOException ex) {
                // empty catch block
            }
            return bl;
            catch (Exception e) {
                try {
                    JobEntryFolderIsEmpty.this.log.logError(BaseMessages.getString((Class)PKG, (String)"JobFolderIsEmpty.Error", (String[])new String[0]), new Object[]{BaseMessages.getString((Class)PKG, (String)"JobFolderIsEmpty.Error.Exception", (String[])new String[]{info.getFile().toString(), e.getMessage()})});
                    returncode = false;
                    Object var6_7 = null;
                    if (file_name == null) return returncode;
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (file_name == null) throw throwable;
                    try {
                        file_name.close();
                        file_name = null;
                        throw throwable;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    file_name.close();
                    file_name = null;
                    return returncode;
                }
                catch (IOException ex) {}
                return returncode;
            }
        }

        public boolean traverseDescendents(FileSelectInfo info) {
            return true;
        }
    }
}

