/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.getpop;

import com.sun.mail.imap.IMAPSSLStore;
import com.sun.mail.pop3.POP3SSLStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeUtility;
import javax.mail.search.AndTerm;
import javax.mail.search.BodyTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.RecipientStringTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.getpop.JobEntryGetPOP;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailConnection {
    private static Class<?> PKG = JobEntryGetPOP.class;
    private String server;
    private int port;
    private String username;
    private String password;
    private boolean usessl;
    private boolean write;
    private boolean useproxy;
    private String proxyusername;
    private int protocol;
    private Properties prop;
    private Session session = null;
    private Store store = null;
    private Folder folder = null;
    private Message[] messages;
    private Message message;
    private SearchTerm searchTerm = null;
    private int messagenr;
    private int nrSavedMessages;
    private int nrMovedMessages;
    private int nrDeletedMessages;
    private int nrSavedAttachedFiles;
    private Folder destinationIMAPFolder = null;
    private LogChannelInterface log;

    public MailConnection(LogChannelInterface log, int protocol, String server, int port, String username, String password, boolean usessl, boolean useproxy, String proxyusername) throws KettleException {
        this.log = log;
        try {
            this.prop = System.getProperties();
        }
        catch (SecurityException s) {
            this.prop = new Properties();
        }
        this.port = port;
        this.server = server;
        this.username = username;
        this.password = password;
        this.usessl = usessl;
        this.protocol = protocol;
        this.nrSavedMessages = 0;
        this.nrDeletedMessages = 0;
        this.nrMovedMessages = 0;
        this.nrSavedAttachedFiles = 0;
        this.messagenr = -1;
        this.useproxy = useproxy;
        this.proxyusername = proxyusername;
        try {
            String protocolString;
            if (useproxy) {
                this.prop.put("mail.imap.sasl.enable", "true");
                this.prop.put("mail.imap.sasl.authorizationid", proxyusername);
            }
            if (protocol == 0) {
                this.prop.setProperty("mail.pop3s.rsetbeforequit", "true");
                this.prop.setProperty("mail.pop3.rsetbeforequit", "true");
            }
            String string = protocolString = protocol == 0 ? "pop3" : "imap";
            if (usessl) {
                this.prop.setProperty("mail." + protocolString + ".socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                this.prop.setProperty("mail." + protocolString + ".socketFactory.fallback", "false");
                this.prop.setProperty("mail." + protocolString + ".port", "" + port);
                this.prop.setProperty("mail." + protocolString + ".socketFactory.port", "" + port);
                this.session = Session.getInstance((Properties)this.prop, null);
                this.session.setDebug(log.isDebug());
                if (this.port == -1) {
                    this.port = protocol == 0 ? 995 : 993;
                }
                URLName url = new URLName(protocolString, server, port, "", username, password);
                this.store = protocol == 0 ? new POP3SSLStore(this.session, url) : new IMAPSSLStore(this.session, url);
                url = null;
            } else {
                this.session = Session.getInstance((Properties)this.prop, null);
                this.session.setDebug(log.isDebug());
                this.store = this.session.getStore(protocolString);
            }
            if (log.isDetailed()) {
                log.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.NewConnectionDefined", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.NewConnection", (String[])new String[]{Const.NVL((String)this.server, (String)"")}), (Throwable)e);
        }
    }

    public boolean isConnected() {
        return this.store != null && this.store.isConnected();
    }

    public boolean isUseSSL() {
        return this.usessl;
    }

    public boolean isUseProxy() {
        return this.useproxy;
    }

    public String getProxyUsername() {
        return this.proxyusername;
    }

    public Store getStore() {
        return this.store;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public void connect() throws KettleException {
        if (this.log.isDetailed()) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Connecting", (String[])new String[]{this.server, this.username, "" + this.port}));
        }
        try {
            if (this.usessl) {
                this.store.connect();
            } else if (this.port > -1) {
                this.store.connect(this.server, this.port, this.username, this.password);
            } else {
                this.store.connect(this.server, this.username, this.password);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Connected", (String[])new String[]{this.server, this.username, "" + this.port}));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.Connecting", (String[])new String[]{this.server, this.username, Const.NVL((String)("" + this.port), (String)"")}), (Throwable)e);
        }
    }

    public void openFolder(boolean write) throws KettleException {
        this.openFolder(null, true, write);
    }

    public void openFolder(String foldername, boolean write) throws KettleException {
        this.openFolder(foldername, false, write);
    }

    public void openFolder(String foldername, boolean defaultFolder, boolean write) throws KettleException {
        this.write = write;
        try {
            if (this.getFolder() != null) {
                this.closeFolder(true);
            }
            if (defaultFolder) {
                this.folder = this.store.getDefaultFolder().getFolder("INBOX");
                if (this.folder == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.InvalidDefaultFolder.Label", (String[])new String[0]));
                }
                if ((this.folder.getType() & 1) == 0) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.DefaultFolderCanNotHoldMessage", (String[])new String[0]));
                }
            } else {
                if (this.protocol == 1) {
                    this.folder = this.store.getFolder(foldername);
                }
                if (this.folder == null || !this.folder.exists()) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.InvalidFolder.Label", (String[])new String[0]));
                }
            }
            if (this.write) {
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.OpeningFolderInWriteMode.Label", (String[])new String[]{this.getFolderName()}));
                }
                this.folder.open(2);
            } else {
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.OpeningFolderInReadMode.Label", (String[])new String[]{this.getFolderName()}));
                }
                this.folder.open(1);
            }
            if (this.log.isDetailed()) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderOpened.Label", (String[])new String[]{this.getFolderName()}));
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderOpened.Name", (String[])new String[]{this.getFolderName()}));
                this.log.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderOpened.FullName", (String[])new String[]{this.folder.getFullName()}));
                this.log.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderOpened.Url", (String[])new String[]{this.folder.getURLName().toString()}));
                this.log.logDebug(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.FolderOpened.Subscribed", (String[])new String[]{"" + this.folder.isSubscribed()}));
            }
        }
        catch (Exception e) {
            throw new KettleException(defaultFolder ? BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.OpeningDefaultFolder", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.OpeningFolder", (String[])new String[]{foldername}), (Throwable)e);
        }
    }

    public void clearFilters() {
        this.nrSavedMessages = 0;
        this.nrDeletedMessages = 0;
        this.nrMovedMessages = 0;
        this.nrSavedAttachedFiles = 0;
        if (this.searchTerm != null) {
            this.searchTerm = null;
        }
    }

    public void disconnect() throws KettleException {
        this.disconnect(true);
    }

    public void closeFolder(boolean expunge) throws KettleException {
        try {
            if (this.folder != null && this.folder.isOpen()) {
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.ClosingFolder", (String[])new String[]{this.getFolderName()}));
                }
                this.folder.close(expunge);
                this.folder = null;
                this.messages = null;
                this.message = null;
                this.messagenr = -1;
                if (this.log.isDebug()) {
                    this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.FolderClosed", (String[])new String[]{this.getFolderName()}));
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.ClosingFolder", (String[])new String[]{this.getFolderName()}), (Throwable)e);
        }
    }

    private void addSearchTerm(SearchTerm Term) {
        this.searchTerm = this.searchTerm != null ? new AndTerm(this.searchTerm, Term) : Term;
    }

    public void setSubjectTerm(String subject, boolean notTerm) {
        if (!Const.isEmpty((String)subject)) {
            if (notTerm) {
                this.addSearchTerm((SearchTerm)new NotTerm((SearchTerm)new SubjectTerm(subject)));
            } else {
                this.addSearchTerm((SearchTerm)new SubjectTerm(subject));
            }
        }
    }

    public void setBodyTerm(String bodyfilter, boolean notTerm) {
        if (!Const.isEmpty((String)bodyfilter)) {
            if (notTerm) {
                this.addSearchTerm((SearchTerm)new NotTerm((SearchTerm)new BodyTerm(bodyfilter)));
            } else {
                this.addSearchTerm((SearchTerm)new BodyTerm(bodyfilter));
            }
        }
    }

    public void setSenderTerm(String sender, boolean notTerm) {
        if (!Const.isEmpty((String)sender)) {
            if (notTerm) {
                this.addSearchTerm((SearchTerm)new NotTerm((SearchTerm)new FromStringTerm(sender)));
            } else {
                this.addSearchTerm((SearchTerm)new FromStringTerm(sender));
            }
        }
    }

    public void setReceipientTerm(String receipient) {
        if (!Const.isEmpty((String)receipient)) {
            this.addSearchTerm((SearchTerm)new RecipientStringTerm(Message.RecipientType.TO, receipient));
        }
    }

    public void setReceivedDateTermEQ(Date receiveddate) {
        if (this.protocol == 0) {
            this.log.logError(BaseMessages.getString(PKG, (String)"MailConnection.Error.ReceivedDatePOP3Unsupported", (String[])new String[0]));
        } else {
            this.addSearchTerm((SearchTerm)new ReceivedDateTerm(3, receiveddate));
        }
    }

    public void setReceivedDateTermLT(Date futureDate) {
        if (this.protocol == 0) {
            this.log.logError(BaseMessages.getString(PKG, (String)"MailConnection.Error.ReceivedDatePOP3Unsupported", (String[])new String[0]));
        } else {
            this.addSearchTerm((SearchTerm)new ReceivedDateTerm(2, futureDate));
        }
    }

    public void setReceivedDateTermGT(Date pastDate) {
        if (this.protocol == 0) {
            this.log.logError(BaseMessages.getString(PKG, (String)"MailConnection.Error.ReceivedDatePOP3Unsupported", (String[])new String[0]));
        } else {
            this.addSearchTerm((SearchTerm)new ReceivedDateTerm(5, pastDate));
        }
    }

    public void setReceivedDateTermBetween(Date beginDate, Date endDate) {
        if (this.protocol == 0) {
            this.log.logError(BaseMessages.getString(PKG, (String)"MailConnection.Error.ReceivedDatePOP3Unsupported", (String[])new String[0]));
        } else {
            this.addSearchTerm((SearchTerm)new AndTerm((SearchTerm)new ReceivedDateTerm(2, endDate), (SearchTerm)new ReceivedDateTerm(5, beginDate)));
        }
    }

    public void setFlagTermNew() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.RECENT), true));
    }

    public void setFlagTermOld() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.RECENT), false));
    }

    public void setFlagTermRead() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), true));
    }

    public void setFlagTermUnread() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), false));
    }

    public void setFlagTermFlagged() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.FLAGGED), true));
    }

    public void setFlagTermNotFlagged() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.FLAGGED), false));
    }

    public void setFlagTermDraft() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DRAFT), true));
    }

    public void setFlagTermNotDraft() {
        this.addSearchTerm((SearchTerm)new FlagTerm(new Flags(Flags.Flag.DRAFT), false));
    }

    public void retrieveMessages() throws KettleException {
        try {
            this.messages = this.searchTerm != null ? this.folder.search(this.searchTerm) : this.folder.getMessages();
        }
        catch (Exception e) {
            this.messages = null;
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.RetrieveMessages", (String[])new String[]{this.getFolderName()}), (Throwable)e);
        }
    }

    public void disconnect(boolean expunge) throws KettleException {
        if (this.log.isDebug()) {
            this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.ClosingConnection", (String[])new String[0]));
        }
        try {
            this.closeFolder(expunge);
            this.clearFilters();
            if (this.store != null) {
                this.store.close();
                this.store = null;
            }
            if (this.session != null) {
                this.session = null;
            }
            if (this.destinationIMAPFolder != null) {
                this.destinationIMAPFolder.close(expunge);
            }
            if (this.log.isDebug()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"MailConnection.ConnectionClosed", (String[])new String[0]));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.Error.ClosingConnection", (String[])new String[0]), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveMessageContentToFile(String filename, String foldername) throws KettleException {
        OutputStream os = null;
        try {
            try {
                os = KettleVFS.getOutputStream((String)(foldername + (foldername.endsWith("/") ? "" : "/") + filename), (boolean)false);
                this.getMessage().writeTo(os);
                this.updateSavedMessagesCounter();
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.SavingMessageContent", (String[])new String[]{"" + this.message.getMessageNumber(), filename, foldername}), (Throwable)e);
            }
            Object var6_4 = null;
            if (os == null) return;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (os == null) throw throwable;
            try {
                os.close();
                os = null;
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        os.close();
        return;
    }

    public void saveAttachedFiles(String foldername) throws KettleException {
        this.saveAttachedFiles(foldername, null);
    }

    public void saveAttachedFiles(String foldername, Pattern pattern) throws KettleException {
        Object content = null;
        try {
            block6: {
                try {
                    content = this.getMessage().getContent();
                    if (!(content instanceof Multipart)) break block6;
                    this.handleMultipart(foldername, (Multipart)content, pattern);
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.SavingAttachedFiles", (String[])new String[]{"" + this.message.getMessageNumber(), foldername}), (Throwable)e);
                }
            }
            Object var6_4 = null;
            if (content != null) {
                content = null;
            }
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (content != null) {
                content = null;
            }
            throw throwable;
        }
    }

    private void handleMultipart(String foldername, Multipart multipart, Pattern pattern) throws KettleException {
        try {
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                this.handlePart(foldername, (Part)multipart.getBodyPart(i), pattern);
            }
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    private void handlePart(String foldername, Part part, Pattern pattern) throws KettleException {
        block7: {
            try {
                String filename;
                String disposition = part.getDisposition();
                if (disposition == null || disposition.length() < 1) {
                    disposition = "attachment";
                }
                if (!disposition.equalsIgnoreCase("attachment") && !disposition.equalsIgnoreCase("inline")) break block7;
                String MimeText = null;
                try {
                    MimeText = MimeUtility.decodeText((String)part.getFileName());
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (MimeText != null && this.isWildcardMatch(filename = MimeUtility.decodeText((String)part.getFileName()), pattern)) {
                    MailConnection.saveFile(foldername, filename, part.getInputStream());
                    this.updateSavedAttachedFilesCounter();
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobGetMailsFromPOP.AttachedFileSaved", (String[])new String[]{filename, "" + this.getMessage().getMessageNumber(), foldername}));
                    }
                }
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void saveFile(String foldername, String filename, InputStream input) throws KettleException {
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        File file = null;
        BufferedInputStream bis = null;
        try {
            try {
                int aByte;
                if (filename == null) {
                    filename = File.createTempFile("xx", ".out").getName();
                }
                file = new File(foldername, filename);
                int i = 0;
                while (file.exists()) {
                    file = new File(foldername, filename + i);
                    ++i;
                }
                fos = new FileOutputStream(file);
                bos = new BufferedOutputStream(fos);
                bis = new BufferedInputStream(input);
                while ((aByte = bis.read()) != -1) {
                    bos.write(aByte);
                }
                Object var9_9 = null;
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (bos != null) {
                    bos.flush();
                    bos.close();
                }
                if (bis != null) {
                    bis.close();
                    bis = null;
                }
                file = null;
                throw throwable;
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception e) {}
        if (bos != null) {
            bos.flush();
            bos.close();
        }
        if (bis == null) return;
        bis.close();
        return;
    }

    private boolean isWildcardMatch(String filename, Pattern pattern) {
        boolean retval = true;
        if (pattern != null) {
            Matcher matcher = pattern.matcher(filename);
            retval = matcher.matches();
        }
        return retval;
    }

    public void deleteMessage() throws KettleException {
        try {
            this.message.setFlag(Flags.Flag.DELETED, true);
            this.updateDeletedMessagesCounter();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.DeletingMessage", (String[])new String[]{"" + this.getMessage().getMessageNumber()}), (Throwable)e);
        }
    }

    public void setDestinationFolder(String foldername, boolean createFolder) throws KettleException {
        block3: {
            try {
                this.destinationIMAPFolder = this.store.getFolder(foldername);
                if (this.destinationIMAPFolder.exists()) break block3;
                if (createFolder) {
                    this.destinationIMAPFolder.create(1);
                    break block3;
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.FolderNotFound", (String[])new String[]{foldername}));
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
        }
    }

    public void moveMessage() throws KettleException {
        try {
            this.folder.copyMessages(new Message[]{this.message}, this.destinationIMAPFolder);
            this.updatedMovedMessagesCounter();
            this.deleteMessage();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.MovingMessage", (String[])new String[]{"" + this.getMessage().getMessageNumber(), this.destinationIMAPFolder.getName()}), (Throwable)e);
        }
    }

    public String getFolderName() {
        if (this.folder == null) {
            return "";
        }
        return this.folder.getName();
    }

    public String getServer() {
        return this.server;
    }

    public int getProtocol() {
        return this.protocol;
    }

    public Message[] getMessages() {
        return this.messages;
    }

    private void updateMessageNr() {
        ++this.messagenr;
    }

    private int getMessageNr() {
        return this.messagenr;
    }

    public void fetchNext() throws KettleException {
        this.updateMessageNr();
        try {
            this.message = this.messages[this.getMessageNr()];
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.FetchingMessages", (String[])new String[0]), (Throwable)e);
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public int getMessagesCount() {
        return this.messages.length;
    }

    public void updateSavedMessagesCounter() {
        ++this.nrSavedMessages;
    }

    public int getSavedMessagesCounter() {
        return this.nrSavedMessages;
    }

    public int getSavedAttachedFilesCounter() {
        return this.nrSavedAttachedFiles;
    }

    public void updateSavedAttachedFilesCounter() {
        ++this.nrSavedAttachedFiles;
    }

    public int getDeletedMessagesCounter() {
        return this.nrDeletedMessages;
    }

    private void updateDeletedMessagesCounter() {
        ++this.nrDeletedMessages;
    }

    private void setDeletedMessagesCounter() {
        this.nrDeletedMessages = this.getMessagesCount();
    }

    public int getMovedMessagesCounter() {
        return this.nrMovedMessages;
    }

    private void updatedMovedMessagesCounter() {
        ++this.nrMovedMessages;
    }

    private void setMovedMessagesCounter() {
        this.nrMovedMessages = this.getMessagesCount();
    }

    public void deleteMessages(boolean setCounter) throws KettleException {
        try {
            this.folder.setFlags(this.messages, new Flags(Flags.Flag.DELETED), true);
            if (setCounter) {
                this.setDeletedMessagesCounter();
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.DeletingMessage", (String[])new String[0]), (Throwable)e);
        }
    }

    public void moveMessages() throws KettleException {
        try {
            this.folder.copyMessages(this.messages, this.destinationIMAPFolder);
            this.deleteMessages(false);
            this.setMovedMessagesCounter();
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.MovingMessages", (String[])new String[]{this.destinationIMAPFolder.getName()}), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean folderExists(String foldername) {
        boolean retval;
        block12: {
            Folder dfolder;
            block11: {
                retval = false;
                dfolder = null;
                dfolder = this.store.getFolder(foldername);
                if (!dfolder.exists()) break block11;
                retval = true;
            }
            Object var6_4 = null;
            try {
                if (dfolder != null) {
                    dfolder.close(false);
                }
                break block12;
            }
            catch (Exception e2) {}
            break block12;
            {
                catch (Exception e) {
                    Object var6_5 = null;
                    try {
                        if (dfolder != null) {
                            dfolder.close(false);
                        }
                        break block12;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (dfolder != null) {
                        dfolder.close(false);
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return retval;
    }

    private HashSet<String> returnSubfolders(Folder folder) throws KettleException {
        HashSet<String> list = new HashSet<String>();
        try {
            if ((folder.getType() & 2) != 0) {
                Folder[] f = folder.list();
                for (int i = 0; i < f.length; ++i) {
                    if ((f[i].getType() & 2) == 0) continue;
                    list.add(f[i].getFullName());
                    list.addAll(this.returnSubfolders(f[i]));
                }
            }
        }
        catch (MessagingException m) {
            throw new KettleException((Throwable)m);
        }
        return list;
    }

    public String[] returnAllFolders(Folder folder) throws KettleException {
        HashSet<Object> list = new HashSet();
        list = this.returnSubfolders(folder);
        return list.toArray(new String[list.size()]);
    }

    public String[] returnAllFolders() throws KettleException {
        return this.returnAllFolders(this.getFolder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String[] returnAllFolders(String folder) throws KettleException {
        String[] retval;
        block11: {
            Folder dfolder = null;
            retval = null;
            dfolder = Const.isEmpty((String)folder) ? this.getStore().getDefaultFolder() : this.getStore().getFolder(folder);
            retval = this.returnAllFolders(dfolder);
            Object var6_4 = null;
            try {
                if (dfolder != null) {
                    dfolder.close(false);
                }
                break block11;
            }
            catch (Exception e2) {}
            break block11;
            {
                catch (Exception e) {
                    Object var6_5 = null;
                    try {
                        if (dfolder != null) {
                            dfolder.close(false);
                        }
                        break block11;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    if (dfolder != null) {
                        dfolder.close(false);
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return retval;
    }

    public String getMessageBody() throws Exception {
        return this.getMessageBody((Part)this.getMessage());
    }

    private String getMessageBody(Part p) throws MessagingException, Exception {
        if (p.isMimeType("text/*")) {
            String s = (String)p.getContent();
            return s;
        }
        if (p.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)p.getContent();
            String text = null;
            for (int i = 0; i < mp.getCount(); ++i) {
                BodyPart bp = mp.getBodyPart(i);
                if (!bp.isMimeType("text/plain") || text != null) continue;
                text = this.getMessageBody((Part)bp);
            }
            return text;
        }
        if (p.isMimeType("multipart/*")) {
            Multipart mp = (Multipart)p.getContent();
            for (int i = 0; i < mp.getCount(); ++i) {
                String s = this.getMessageBody((Part)mp.getBodyPart(i));
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    public boolean isMessageNew() {
        try {
            return this.getMessage().isSet(Flags.Flag.RECENT);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageRead() {
        try {
            return this.getMessage().isSet(Flags.Flag.SEEN);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageFlagged() {
        try {
            return this.getMessage().isSet(Flags.Flag.FLAGGED);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageDeleted() {
        try {
            return this.getMessage().isSet(Flags.Flag.DELETED);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public boolean isMessageDraft() {
        try {
            return this.getMessage().isSet(Flags.Flag.DRAFT);
        }
        catch (MessagingException e) {
            return false;
        }
    }

    public String toString() {
        if (this.getServer() != null) {
            return this.getServer();
        }
        return "-";
    }

    public int getAttachedFilesCount(Pattern pattern) throws KettleException {
        Object content = null;
        int retval = 0;
        try {
            try {
                content = this.getMessage().getContent();
                if (content instanceof Multipart) {
                    Multipart multipart = (Multipart)content;
                    int n = multipart.getCount();
                    for (int i = 0; i < n; ++i) {
                        String filename;
                        BodyPart part = multipart.getBodyPart(i);
                        String disposition = part.getDisposition();
                        if (disposition == null || !disposition.equalsIgnoreCase("attachment") && !disposition.equalsIgnoreCase("inline")) continue;
                        String MimeText = null;
                        try {
                            MimeText = MimeUtility.decodeText((String)part.getFileName());
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        if (MimeText == null || !this.isWildcardMatch(filename = MimeUtility.decodeText((String)part.getFileName()), pattern)) continue;
                        ++retval;
                    }
                }
                Object var12_13 = null;
                if (content != null) {
                    content = null;
                }
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MailConnection.Error.CountingAttachedFiles", (String[])new String[]{"" + this.message.getMessageNumber()}), (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (content != null) {
                content = null;
            }
            throw throwable;
        }
        return retval;
    }
}

