/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.movefiles;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryMoveFiles
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryMoveFiles.class;
    public boolean move_empty_folders = true;
    public boolean arg_from_previous = false;
    public boolean include_subfolders = false;
    public boolean add_result_filesname = false;
    public boolean destination_is_a_file = false;
    public boolean create_destination_folder = false;
    public String[] source_filefolder = null;
    public String[] destination_filefolder = null;
    public String[] wildcard = null;
    private String nr_errors_less_than = "10";
    private String success_condition = this.SUCCESS_IF_NO_ERRORS;
    public String SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private boolean add_date = false;
    private boolean add_time = false;
    private boolean SpecifyFormat = false;
    private String date_time_format = null;
    private boolean AddDateBeforeExtension = false;
    private boolean DoNotKeepFolderStructure = false;
    private String iffileexists = "do_nothing";
    private String destinationFolder = null;
    private String ifmovedfileexists = "do_nothing";
    private String moved_date_time_format = null;
    private boolean AddMovedDateBeforeExtension = false;
    private boolean add_moved_date = false;
    private boolean add_moved_time = false;
    private boolean SpecifyMoveFormat = false;
    public boolean create_move_to_folder = false;
    public boolean simulate = false;
    int NrErrors = 0;
    int NrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFiles = 0;

    public JobEntryMoveFiles(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryMoveFiles() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryMoveFiles je = (JobEntryMoveFiles)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"move_empty_folders", (boolean)this.move_empty_folders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"arg_from_previous", (boolean)this.arg_from_previous));
        retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.include_subfolders));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_result_filesname", (boolean)this.add_result_filesname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destination_is_a_file", (boolean)this.destination_is_a_file));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_destination_folder", (boolean)this.create_destination_folder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_date", (boolean)this.add_date));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_time", (boolean)this.add_time));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_errors_less_than", (String)this.nr_errors_less_than));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.AddDateBeforeExtension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"DoNotKeepFolderStructure", (boolean)this.DoNotKeepFolderStructure));
        retval.append("      ").append(XMLHandler.addTagValue((String)"iffileexists", (String)this.iffileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationFolder", (String)this.destinationFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ifmovedfileexists", (String)this.ifmovedfileexists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"moved_date_time_format", (String)this.moved_date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_move_to_folder", (boolean)this.create_move_to_folder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_moved_date", (boolean)this.add_moved_date));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_moved_time", (boolean)this.add_moved_time));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyMoveFormat", (boolean)this.SpecifyMoveFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddMovedDateBeforeExtension", (boolean)this.AddMovedDateBeforeExtension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"simulate", (boolean)this.simulate));
        retval.append("      <fields>").append(Const.CR);
        if (this.source_filefolder != null) {
            for (int i = 0; i < this.source_filefolder.length; ++i) {
                retval.append("        <field>").append(Const.CR);
                retval.append("          ").append(XMLHandler.addTagValue((String)"source_filefolder", (String)this.source_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"destination_filefolder", (String)this.destination_filefolder[i]));
                retval.append("          ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard[i]));
                retval.append("        </field>").append(Const.CR);
            }
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.move_empty_folders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"move_empty_folders"));
            this.arg_from_previous = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"arg_from_previous"));
            this.include_subfolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"include_subfolders"));
            this.add_result_filesname = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_result_filesname"));
            this.destination_is_a_file = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"destination_is_a_file"));
            this.create_destination_folder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_destination_folder"));
            this.add_date = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_date"));
            this.add_time = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_time"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.AddDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddDateBeforeExtension"));
            this.DoNotKeepFolderStructure = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"DoNotKeepFolderStructure"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.nr_errors_less_than = XMLHandler.getTagValue((Node)entrynode, (String)"nr_errors_less_than");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            this.iffileexists = XMLHandler.getTagValue((Node)entrynode, (String)"iffileexists");
            this.destinationFolder = XMLHandler.getTagValue((Node)entrynode, (String)"destinationFolder");
            this.ifmovedfileexists = XMLHandler.getTagValue((Node)entrynode, (String)"ifmovedfileexists");
            this.moved_date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"moved_date_time_format");
            this.AddMovedDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddMovedDateBeforeExtension"));
            this.create_move_to_folder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_move_to_folder"));
            this.add_moved_date = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_moved_date"));
            this.add_moved_time = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_moved_time"));
            this.SpecifyMoveFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyMoveFormat"));
            this.simulate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"simulate"));
            Node fields = XMLHandler.getSubNode((Node)entrynode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.source_filefolder = new String[nrFields];
            this.destination_filefolder = new String[nrFields];
            this.wildcard = new String[nrFields];
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.source_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"source_filefolder");
                this.destination_filefolder[i] = XMLHandler.getTagValue((Node)fnode, (String)"destination_filefolder");
                this.wildcard[i] = XMLHandler.getTagValue((Node)fnode, (String)"wildcard");
            }
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobMoveFiles.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.move_empty_folders = rep.getJobEntryAttributeBoolean(id_jobentry, "move_empty_folders");
            this.arg_from_previous = rep.getJobEntryAttributeBoolean(id_jobentry, "arg_from_previous");
            this.include_subfolders = rep.getJobEntryAttributeBoolean(id_jobentry, "include_subfolders");
            this.add_result_filesname = rep.getJobEntryAttributeBoolean(id_jobentry, "add_result_filesname");
            this.destination_is_a_file = rep.getJobEntryAttributeBoolean(id_jobentry, "destination_is_a_file");
            this.create_destination_folder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_destination_folder");
            this.nr_errors_less_than = rep.getJobEntryAttributeString(id_jobentry, "nr_errors_less_than");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            this.add_date = rep.getJobEntryAttributeBoolean(id_jobentry, "add_date");
            this.add_time = rep.getJobEntryAttributeBoolean(id_jobentry, "add_time");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.AddDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddDateBeforeExtension");
            this.DoNotKeepFolderStructure = rep.getJobEntryAttributeBoolean(id_jobentry, "DoNotKeepFolderStructure");
            this.iffileexists = rep.getJobEntryAttributeString(id_jobentry, "iffileexists");
            this.destinationFolder = rep.getJobEntryAttributeString(id_jobentry, "destinationFolder");
            this.ifmovedfileexists = rep.getJobEntryAttributeString(id_jobentry, "ifmovedfileexists");
            this.moved_date_time_format = rep.getJobEntryAttributeString(id_jobentry, "moved_date_time_format");
            this.AddMovedDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddMovedDateBeforeExtension");
            this.create_move_to_folder = rep.getJobEntryAttributeBoolean(id_jobentry, "create_move_to_folder");
            this.add_moved_date = rep.getJobEntryAttributeBoolean(id_jobentry, "add_moved_date");
            this.add_moved_time = rep.getJobEntryAttributeBoolean(id_jobentry, "add_moved_time");
            this.SpecifyMoveFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyMoveFormat");
            this.simulate = rep.getJobEntryAttributeBoolean(id_jobentry, "simulate");
            int argnr = rep.countNrJobEntryAttributes(id_jobentry, "source_filefolder");
            this.source_filefolder = new String[argnr];
            this.destination_filefolder = new String[argnr];
            this.wildcard = new String[argnr];
            for (int a = 0; a < argnr; ++a) {
                this.source_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "source_filefolder");
                this.destination_filefolder[a] = rep.getJobEntryAttributeString(id_jobentry, a, "destination_filefolder");
                this.wildcard[a] = rep.getJobEntryAttributeString(id_jobentry, a, "wildcard");
            }
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobMoveFiles.Error.Exception.UnableLoadRep", (String[])new String[0]) + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "move_empty_folders", this.move_empty_folders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "arg_from_previous", this.arg_from_previous);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "include_subfolders", this.include_subfolders);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_result_filesname", this.add_result_filesname);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destination_is_a_file", this.destination_is_a_file);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "create_destination_folder", this.create_destination_folder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nr_errors_less_than", this.nr_errors_less_than);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_date", this.add_date);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_time", this.add_time);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "AddDateBeforeExtension", this.AddDateBeforeExtension);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "DoNotKeepFolderStructure", this.DoNotKeepFolderStructure);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "iffileexists", this.iffileexists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destinationFolder", this.destinationFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ifmovedfileexists", this.ifmovedfileexists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "moved_date_time_format", this.moved_date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_moved_date", this.add_moved_date);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "add_moved_time", this.add_moved_time);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyMoveFormat", this.SpecifyMoveFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "create_move_to_folder", this.create_move_to_folder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "AddMovedDateBeforeExtension", this.AddMovedDateBeforeExtension);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "simulate", this.simulate);
            if (this.source_filefolder != null) {
                for (int i = 0; i < this.source_filefolder.length; ++i) {
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "source_filefolder", this.source_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "destination_filefolder", this.destination_filefolder[i]);
                    rep.saveJobEntryAttribute(id_job, this.getObjectId(), i, "wildcard", this.wildcard[i]);
                }
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobMoveFiles.Error.Exception.UnableSaveRep", (String[])new String[0]) + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        result = previousResult;
        rows = result.getRows();
        resultRow = null;
        result.setNrErrors(1L);
        result.setResult(false);
        this.NrErrors = 0;
        this.NrSuccess = 0;
        this.successConditionBroken = false;
        this.successConditionBrokenExit = false;
        this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getNrErrorsLessThan()), (int)10);
        if (this.log.isDetailed()) {
            if (this.simulate) {
                this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.SimulationOn", (String[])new String[0]));
            }
            if (this.include_subfolders) {
                this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.IncludeSubFoldersOn", (String[])new String[0]));
            }
        }
        MoveToFolder = this.environmentSubstitute(this.destinationFolder);
        vsourcefilefolder = this.source_filefolder;
        vdestinationfilefolder = this.destination_filefolder;
        vwildcard = this.wildcard;
        if (this.iffileexists.equals("move_file")) {
            block36: {
                block37: {
                    block35: {
                        if (Const.isEmpty((String)MoveToFolder)) {
                            this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.Error.MoveToFolderMissing", (String[])new String[0]));
                            return result;
                        }
                        folder = null;
                        try {
                            try {
                                folder = KettleVFS.getFileObject((String)MoveToFolder, (VariableSpace)this);
                                if (!folder.exists()) {
                                    if (this.log.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.Error.FolderMissing", (String[])new String[]{MoveToFolder}));
                                    }
                                    if (!this.create_move_to_folder) {
                                        this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.Error.FolderMissing", (String[])new String[]{MoveToFolder}));
                                        var11_13 = result;
                                        var14_17 = null;
                                        if (folder == null) return var11_13;
                                        break block35;
                                    }
                                    folder.createFolder();
                                }
                                if (folder.getType().equals(FileType.FOLDER)) break block36;
                                this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.Error.NotFolder", (String[])new String[]{MoveToFolder}));
                                var11_14 = result;
                                break block37;
                            }
                            catch (Exception e) {
                                this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.Error.GettingMoveToFolder", (String[])new String[]{MoveToFolder, e.getMessage()}));
                                var12_27 = result;
                                var14_20 = null;
                                if (folder == null) return var12_27;
                                try {
                                    folder.close();
                                    return var12_27;
                                }
                                catch (IOException ex) {
                                    // empty catch block
                                }
                                return var12_27;
                            }
                        }
                        catch (Throwable var13_29) {
                            var14_21 = null;
                            if (folder == null) throw var13_29;
                            ** try [egrp 2[TRYBLOCK] [7 : 390->400)] { 
lbl61:
                            // 1 sources

                            folder.close();
                            throw var13_29;
lbl63:
                            // 1 sources

                            catch (IOException ex) {
                                // empty catch block
                            }
                            throw var13_29;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [7 : 390->400)] { 
lbl68:
                    // 1 sources

                    folder.close();
                    return var11_13;
lbl70:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                    return var11_13;
                }
                var14_18 = null;
                if (folder == null) return var11_14;
                try {}
                catch (IOException ex) {
                    // empty catch block
                    return var11_14;
                }
                folder.close();
                return var11_14;
            }
            var14_19 = null;
            if (folder != null) {
                try {}
                catch (IOException ex) {}
                folder.close();
            }
        }
        if (this.arg_from_previous && this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
        }
        if (this.arg_from_previous && rows != null) {
            for (iteration = 0; iteration < rows.size() && !this.parentJob.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setNrErrors((long)this.NrErrors);
                    this.displayResults();
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                vsourcefilefolder_previous = resultRow.getString(0, null);
                vdestinationfilefolder_previous = resultRow.getString(1, null);
                vwildcard_previous = resultRow.getString(2, null);
                if (!Const.isEmpty((String)vsourcefilefolder_previous) && !Const.isEmpty((String)vdestinationfilefolder_previous)) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder_previous, vdestinationfilefolder_previous, vwildcard_previous}));
                    }
                    if (this.ProcessFileFolder(vsourcefilefolder_previous, vdestinationfilefolder_previous, vwildcard_previous, this.parentJob, result, MoveToFolder)) continue;
                    this.updateErrors();
                    continue;
                }
                if (!this.log.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.IgnoringRow", (String[])new String[]{vsourcefilefolder[iteration], vdestinationfilefolder[iteration], vwildcard[iteration]}));
            }
        } else if (vsourcefilefolder != null && vdestinationfilefolder != null) {
            for (i = 0; i < vsourcefilefolder.length && !this.parentJob.isStopped(); ++i) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setNrErrors((long)this.NrErrors);
                    this.displayResults();
                    return result;
                }
                if (!Const.isEmpty((String)vsourcefilefolder[i]) && !Const.isEmpty((String)vdestinationfilefolder[i])) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.ProcessingRow", (String[])new String[]{vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i]}));
                    }
                    if (this.ProcessFileFolder(vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i], this.parentJob, result, MoveToFolder)) continue;
                    this.updateErrors();
                    continue;
                }
                if (!this.log.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.IgnoringRow", (String[])new String[]{vsourcefilefolder[i], vdestinationfilefolder[i], vwildcard[i]}));
            }
        }
        result.setNrErrors((long)this.NrErrors);
        result.setNrLinesWritten((long)this.NrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.log.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobMoveFiles.Log.Info.FilesInError", (String[])new String[]{"" + this.NrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobMoveFiles.Log.Info.FilesInSuccess", (String[])new String[]{"" + this.NrSuccess}));
            this.logDetailed("=======================================");
        }
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrSuccess >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED) || this.NrErrors <= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean ProcessFileFolder(String sourcefilefoldername, String destinationfilefoldername, String wildcard, Job parentJob, Result result, String MoveToFolder) {
        entrystatus = false;
        sourcefilefolder = null;
        destinationfilefolder = null;
        movetofolderfolder = null;
        Currentfile = null;
        realSourceFilefoldername = this.environmentSubstitute(sourcefilefoldername);
        realDestinationFilefoldername = this.environmentSubstitute(destinationfilefoldername);
        realWildcard = this.environmentSubstitute(wildcard);
        try {
            block80: {
                block79: {
                    block78: {
                        block77: {
                            try {
                                sourcefilefolder = KettleVFS.getFileObject((String)realSourceFilefoldername, (VariableSpace)this);
                                destinationfilefolder = KettleVFS.getFileObject((String)realDestinationFilefoldername, (VariableSpace)this);
                                if (!Const.isEmpty((String)MoveToFolder)) {
                                    movetofolderfolder = KettleVFS.getFileObject((String)MoveToFolder, (VariableSpace)this);
                                }
                                if (sourcefilefolder.exists()) {
                                    if (this.CreateDestinationFolder(destinationfilefolder)) {
                                        if (sourcefilefolder.getType().equals(FileType.FOLDER) && this.destination_is_a_file) {
                                            this.log.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.Forbidden", (String[])new String[0]), new Object[]{BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.CanNotMoveFolderToFile", (String[])new String[]{realSourceFilefoldername, realDestinationFilefoldername})});
                                            this.updateErrors();
                                        } else if (destinationfilefolder.getType().equals(FileType.FOLDER) && sourcefilefolder.getType().equals(FileType.FILE)) {
                                            shortfilename = sourcefilefolder.getName().getBaseName();
                                            try {
                                                shortfilename = this.getDestinationFilename(shortfilename);
                                            }
                                            catch (Exception e) {
                                                this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.GettingFilename", (String[])new String[]{sourcefilefolder.getName().getBaseName(), e.toString()}), (String[])new String[0]));
                                                var17_23 = entrystatus;
                                                var20_28 = null;
                                                if (sourcefilefolder != null) {
                                                    try {
                                                        sourcefilefolder.close();
                                                    }
                                                    catch (IOException ex) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (destinationfilefolder != null) {
                                                    try {
                                                        destinationfilefolder.close();
                                                    }
                                                    catch (IOException ex) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (Currentfile != null) {
                                                    try {
                                                        Currentfile.close();
                                                    }
                                                    catch (IOException ex) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (movetofolderfolder == null) return var17_23;
                                                try {
                                                    movetofolderfolder.close();
                                                    return var17_23;
                                                }
                                                catch (IOException ex) {
                                                    // empty catch block
                                                }
                                                return var17_23;
                                            }
                                            destinationfilenamefull = KettleVFS.getFilename((FileObject)destinationfilefolder) + Const.FILE_SEPARATOR + shortfilename;
                                            destinationfile = KettleVFS.getFileObject((String)destinationfilenamefull, (VariableSpace)this);
                                            entrystatus = this.MoveFile(shortfilename, sourcefilefolder, destinationfile, movetofolderfolder, parentJob, result);
                                        } else if (sourcefilefolder.getType().equals(FileType.FILE) && this.destination_is_a_file) {
                                            destinationfile = KettleVFS.getFileObject((String)realDestinationFilefoldername, (VariableSpace)this);
                                            shortfilename = destinationfile.getName().getBaseName();
                                            try {
                                                shortfilename = this.getDestinationFilename(shortfilename);
                                            }
                                            catch (Exception e) {
                                                block73: {
                                                    block72: {
                                                        block71: {
                                                            this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.GettingFilename", (String[])new String[]{sourcefilefolder.getName().getBaseName(), e.toString()}), (String[])new String[0]));
                                                            var18_40 = entrystatus;
                                                            var20_29 = null;
                                                            if (sourcefilefolder != null) {
                                                                ** try [egrp 4[TRYBLOCK] [12 : 841->851)] { 
lbl76:
                                                                // 1 sources

                                                                sourcefilefolder.close();
                                                                break block71;
lbl78:
                                                                // 1 sources

                                                                catch (IOException ex) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (destinationfilefolder != null) {
                                                            ** try [egrp 5[TRYBLOCK] [13 : 858->868)] { 
lbl83:
                                                            // 1 sources

                                                            destinationfilefolder.close();
                                                            break block72;
lbl85:
                                                            // 1 sources

                                                            catch (IOException ex) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    if (Currentfile != null) {
                                                        ** try [egrp 6[TRYBLOCK] [14 : 875->885)] { 
lbl90:
                                                        // 1 sources

                                                        Currentfile.close();
                                                        break block73;
lbl92:
                                                        // 1 sources

                                                        catch (IOException ex) {
                                                            // empty catch block
                                                        }
                                                    }
                                                }
                                                if (movetofolderfolder == null) return var18_40;
                                                ** try [egrp 7[TRYBLOCK] [15 : 892->902)] { 
lbl97:
                                                // 1 sources

                                                movetofolderfolder.close();
                                                return var18_40;
lbl99:
                                                // 1 sources

                                                catch (IOException ex) {
                                                    // empty catch block
                                                }
                                                return var18_40;
                                            }
                                            destinationfilenamefull = KettleVFS.getFilename((FileObject)destinationfile.getParent()) + Const.FILE_SEPARATOR + shortfilename;
                                            destinationfile = KettleVFS.getFileObject((String)destinationfilenamefull, (VariableSpace)this);
                                            entrystatus = this.MoveFile(shortfilename, sourcefilefolder, destinationfile, movetofolderfolder, parentJob, result);
                                        } else {
                                            if (this.log.isDetailed()) {
                                                this.logDetailed("  ");
                                                this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.FetchFolder", (String[])new String[]{sourcefilefolder.toString()}));
                                            }
                                            if ((fileObjects = sourcefilefolder.findFiles((FileSelector)new AllFileSelector(){

                                                public boolean traverseDescendents(FileSelectInfo info) {
                                                    return true;
                                                }

                                                /*
                                                 * WARNING - Removed try catching itself - possible behaviour change.
                                                 * Unable to fully structure code
                                                 * Enabled aggressive block sorting
                                                 * Enabled unnecessary exception pruning
                                                 * Enabled aggressive exception aggregation
                                                 */
                                                public boolean includeFile(FileSelectInfo info) {
                                                    block11: {
                                                        fileObject = info.getFile();
                                                        try {
                                                            try {
                                                                if (fileObject != null) break block11;
                                                                var3_3 = false;
                                                                var6_5 = null;
                                                                if (fileObject == null) return var3_3;
                                                            }
                                                            catch (Exception ex) {
                                                                var4_13 = false;
                                                                var6_7 = null;
                                                                if (fileObject == null) return var4_13;
                                                                try {
                                                                    fileObject.close();
                                                                    return var4_13;
                                                                }
                                                                catch (IOException ex) {
                                                                    // empty catch block
                                                                }
                                                                return var4_13;
                                                            }
                                                        }
                                                        catch (Throwable var5_14) {
                                                            var6_8 = null;
                                                            if (fileObject == null) throw var5_14;
                                                            ** try [egrp 2[TRYBLOCK] [5 : 48->57)] { 
lbl26:
                                                            // 1 sources

                                                            fileObject.close();
                                                            throw var5_14;
lbl28:
                                                            // 1 sources

                                                            catch (IOException ex) {
                                                                // empty catch block
                                                            }
                                                            throw var5_14;
                                                        }
                                                        try {}
                                                        catch (IOException ex) {
                                                            // empty catch block
                                                            return var3_3;
                                                        }
                                                        fileObject.close();
                                                        return var3_3;
                                                    }
                                                    var6_6 = null;
                                                    if (fileObject == null) return true;
                                                    try {}
                                                    catch (IOException ex) {}
                                                    fileObject.close();
                                                    return true;
                                                    return true;
                                                }
                                            })) != null) {
                                                for (j = 0; j < fileObjects.length && !parentJob.isStopped(); ++j) {
                                                    if (this.successConditionBroken) {
                                                        block76: {
                                                            block75: {
                                                                block74: {
                                                                    if (!this.successConditionBrokenExit) {
                                                                        this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.SuccessConditionbroken", (String[])new String[]{"" + this.NrErrors}));
                                                                        this.successConditionBrokenExit = true;
                                                                    }
                                                                    var17_27 = false;
                                                                    var20_30 = null;
                                                                    if (sourcefilefolder != null) {
                                                                        ** try [egrp 4[TRYBLOCK] [12 : 841->851)] { 
lbl120:
                                                                        // 1 sources

                                                                        sourcefilefolder.close();
                                                                        break block74;
lbl122:
                                                                        // 1 sources

                                                                        catch (IOException ex) {
                                                                            // empty catch block
                                                                        }
                                                                    }
                                                                }
                                                                if (destinationfilefolder != null) {
                                                                    ** try [egrp 5[TRYBLOCK] [13 : 858->868)] { 
lbl127:
                                                                    // 1 sources

                                                                    destinationfilefolder.close();
                                                                    break block75;
lbl129:
                                                                    // 1 sources

                                                                    catch (IOException ex) {
                                                                        // empty catch block
                                                                    }
                                                                }
                                                            }
                                                            if (Currentfile != null) {
                                                                ** try [egrp 6[TRYBLOCK] [14 : 875->885)] { 
lbl134:
                                                                // 1 sources

                                                                Currentfile.close();
                                                                break block76;
lbl136:
                                                                // 1 sources

                                                                catch (IOException ex) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (movetofolderfolder == null) return var17_27;
                                                        ** try [egrp 7[TRYBLOCK] [15 : 892->902)] { 
lbl141:
                                                        // 1 sources

                                                        movetofolderfolder.close();
                                                        return var17_27;
lbl143:
                                                        // 1 sources

                                                        catch (IOException ex) {
                                                            // empty catch block
                                                        }
                                                        return var17_27;
                                                    }
                                                    Currentfile = fileObjects[j];
                                                    if (this.MoveOneFile(Currentfile, sourcefilefolder, realDestinationFilefoldername, realWildcard, parentJob, result, movetofolderfolder)) continue;
                                                    this.updateErrors();
                                                }
                                            }
                                        }
                                        entrystatus = true;
                                        break block77;
                                    }
                                    this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.DestinationFolderNotFound", (String[])new String[]{realDestinationFilefoldername}));
                                    break block77;
                                }
                                this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.SourceFileNotExists", (String[])new String[]{realSourceFilefoldername}));
                            }
                            catch (Exception e) {
                                block83: {
                                    block82: {
                                        block81: {
                                            this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.Exception.MoveProcess", (String[])new String[]{realSourceFilefoldername.toString(), destinationfilefolder.toString(), e.getMessage()}));
                                            this.updateErrors();
                                            var20_32 = null;
                                            if (sourcefilefolder != null) {
                                                ** try [egrp 4[TRYBLOCK] [12 : 841->851)] { 
lbl162:
                                                // 1 sources

                                                sourcefilefolder.close();
                                                break block81;
lbl164:
                                                // 1 sources

                                                catch (IOException ex) {
                                                    // empty catch block
                                                }
                                            }
                                        }
                                        if (destinationfilefolder != null) {
                                            ** try [egrp 5[TRYBLOCK] [13 : 858->868)] { 
lbl169:
                                            // 1 sources

                                            destinationfilefolder.close();
                                            break block82;
lbl171:
                                            // 1 sources

                                            catch (IOException ex) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (Currentfile != null) {
                                        ** try [egrp 6[TRYBLOCK] [14 : 875->885)] { 
lbl176:
                                        // 1 sources

                                        Currentfile.close();
                                        break block83;
lbl178:
                                        // 1 sources

                                        catch (IOException ex) {
                                            // empty catch block
                                        }
                                    }
                                }
                                if (movetofolderfolder == null) return entrystatus;
                                try {}
                                catch (IOException ex) {
                                    return entrystatus;
                                }
                                movetofolderfolder.close();
                                return entrystatus;
                            }
                        }
                        var20_31 = null;
                        if (sourcefilefolder != null) {
                            ** try [egrp 4[TRYBLOCK] [12 : 841->851)] { 
lbl191:
                            // 1 sources

                            sourcefilefolder.close();
                            break block78;
lbl193:
                            // 1 sources

                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                    }
                    if (destinationfilefolder != null) {
                        ** try [egrp 5[TRYBLOCK] [13 : 858->868)] { 
lbl198:
                        // 1 sources

                        destinationfilefolder.close();
                        break block79;
lbl200:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
                if (Currentfile != null) {
                    ** try [egrp 6[TRYBLOCK] [14 : 875->885)] { 
lbl205:
                    // 1 sources

                    Currentfile.close();
                    break block80;
lbl207:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (movetofolderfolder == null) return entrystatus;
            try {}
            catch (IOException ex) {
                return entrystatus;
            }
            movetofolderfolder.close();
            return entrystatus;
        }
        catch (Throwable var19_41) {
            block86: {
                block85: {
                    block84: {
                        var20_33 = null;
                        if (sourcefilefolder != null) {
                            ** try [egrp 4[TRYBLOCK] [12 : 841->851)] { 
lbl221:
                            // 1 sources

                            sourcefilefolder.close();
                            break block84;
lbl223:
                            // 1 sources

                            catch (IOException ex) {
                                // empty catch block
                            }
                        }
                    }
                    if (destinationfilefolder != null) {
                        ** try [egrp 5[TRYBLOCK] [13 : 858->868)] { 
lbl228:
                        // 1 sources

                        destinationfilefolder.close();
                        break block85;
lbl230:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
                if (Currentfile != null) {
                    ** try [egrp 6[TRYBLOCK] [14 : 875->885)] { 
lbl235:
                    // 1 sources

                    Currentfile.close();
                    break block86;
lbl237:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (movetofolderfolder == null) throw var19_41;
            ** try [egrp 7[TRYBLOCK] [15 : 892->902)] { 
lbl242:
            // 1 sources

            movetofolderfolder.close();
            throw var19_41;
lbl244:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            throw var19_41;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean MoveFile(String shortfilename, FileObject sourcefilename, FileObject destinationfilename, FileObject movetofolderfolder, Job parentJob, Result result) {
        block55: {
            block52: {
                destinationfile = null;
                retval = false;
                if (!destinationfilename.exists()) {
                    if (!this.simulate) {
                        sourcefilename.moveTo(destinationfilename);
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.FileMoved", (String[])new String[]{sourcefilename.getName().toString(), destinationfilename.getName().toString()}));
                    }
                    if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                        this.addFileToResultFilenames(destinationfilename.toString(), result, parentJob);
                    }
                    this.updateSuccess();
                    break block52;
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.FileExists", (String[])new String[]{destinationfilename.toString()}));
                }
                if (this.iffileexists.equals("overwrite_file")) {
                    if (!this.simulate) {
                        sourcefilename.moveTo(destinationfilename);
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.FileOverwrite", (String[])new String[]{destinationfilename.getName().toString()}));
                    }
                    if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                        this.addFileToResultFilenames(destinationfilename.toString(), result, parentJob);
                    }
                    this.updateSuccess();
                    break block52;
                }
                if (!this.iffileexists.equals("unique_name")) ** GOTO lbl53
                short_filename = shortfilename;
                try {
                    short_filename = this.getMoveDestinationFilename(short_filename, "ddMMyyyy_HHmmssSSS");
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.GettingFilename", (String[])new String[]{short_filename}), (String[])new String[0]), e);
                    var11_15 = retval;
                    var16_18 = null;
                    if (destinationfile != null) {
                        try {
                            destinationfile.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return var11_15;
                }
                movetofilenamefull = destinationfilename.getParent().toString() + Const.FILE_SEPARATOR + short_filename;
                destinationfile = KettleVFS.getFileObject((String)movetofilenamefull, (VariableSpace)this);
                if (!this.simulate) {
                    sourcefilename.moveTo(destinationfile);
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.FileMoved", (String[])new String[]{sourcefilename.getName().toString(), destinationfile.getName().toString()}));
                }
                if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                    this.addFileToResultFilenames(destinationfile.toString(), result, parentJob);
                }
                this.updateSuccess();
                break block52;
lbl53:
                // 1 sources

                if (this.iffileexists.equals("delete_file")) {
                    if (!this.simulate) {
                        destinationfilename.delete();
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.FileDeleted", (String[])new String[]{destinationfilename.getName().toString()}));
                    }
                    break block52;
                }
                if (!this.iffileexists.equals("move_file")) ** GOTO lbl118
                short_filename = shortfilename;
                try {
                    short_filename = this.getMoveDestinationFilename(short_filename, null);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.GettingFilename", (String[])new String[]{short_filename}), (String[])new String[0]), e);
                    var11_16 = retval;
                    var16_19 = null;
                    if (destinationfile != null) {
                        try {
                            destinationfile.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    return var11_16;
                }
                try {
                    movetofilenamefull = movetofolderfolder.toString() + Const.FILE_SEPARATOR + short_filename;
                    destinationfile = KettleVFS.getFileObject((String)movetofilenamefull, (VariableSpace)this);
                    if (!destinationfile.exists()) {
                        if (!this.simulate) {
                            sourcefilename.moveTo(destinationfile);
                        }
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.FileMoved", (String[])new String[]{sourcefilename.getName().toString(), destinationfile.getName().toString()}));
                        }
                        if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                            this.addFileToResultFilenames(destinationfile.toString(), result, parentJob);
                        }
                    } else if (this.ifmovedfileexists.equals("overwrite_file")) {
                        if (!this.simulate) {
                            sourcefilename.moveTo(destinationfile);
                        }
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.FileOverwrite", (String[])new String[]{destinationfile.getName().toString()}));
                        }
                        if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                            this.addFileToResultFilenames(destinationfile.toString(), result, parentJob);
                        }
                        this.updateSuccess();
                    } else if (this.ifmovedfileexists.equals("unique_name")) {
                        daf = new SimpleDateFormat();
                        now = new Date();
                        daf.applyPattern("ddMMyyyy_HHmmssSSS");
                        dt = daf.format(now);
                        short_filename = short_filename + "_" + dt;
                        destinationfilenamefull = movetofolderfolder.toString() + Const.FILE_SEPARATOR + short_filename;
                        destinationfile = KettleVFS.getFileObject((String)destinationfilenamefull, (VariableSpace)this);
                        if (!this.simulate) {
                            sourcefilename.moveTo(destinationfile);
                        }
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.FileMoved", (String[])new String[]{destinationfile.getName().toString()}));
                        }
                        if (this.add_result_filesname && !this.iffileexists.equals("fail") && !this.iffileexists.equals("do_nothing")) {
                            this.addFileToResultFilenames(destinationfile.toString(), result, parentJob);
                        }
                        this.updateSuccess();
                    } else if (this.ifmovedfileexists.equals("fail")) {
                        this.updateErrors();
                    }
                    break block52;
lbl118:
                    // 1 sources

                    if (!this.iffileexists.equals("fail")) break block52;
                    this.updateErrors();
                }
                catch (Throwable var15_31) {
                    var16_22 = null;
                    if (destinationfile != null) {
                        try {
                            destinationfile.close();
                        }
                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                    throw var15_31;
                }
            }
            var16_20 = null;
            if (destinationfile != null) {
                try {
                    destinationfile.close();
                }
                catch (IOException ex) {}
            }
            break block55;
            {
                catch (Exception e) {
                    this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.Exception.MoveProcessError", (String[])new String[]{sourcefilename.toString(), destinationfilename.toString(), e.getMessage()}));
                    var16_21 = null;
                    if (destinationfile != null) {
                        try {
                            destinationfile.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean MoveOneFile(FileObject Currentfile, FileObject sourcefilefolder, String realDestinationFilefoldername, String realWildcard, Job parentJob, Result result, FileObject movetofolderfolder) {
        block29: {
            entrystatus = false;
            file_name = null;
            if (Currentfile.toString().equals(sourcefilefolder.toString())) ** GOTO lbl45
            shortfilename = sourceshortfilename = Currentfile.getName().getBaseName();
            try {
                shortfilename = this.getDestinationFilename(sourceshortfilename);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Error.GettingFilename", (String[])new String[]{Currentfile.getName().getBaseName(), e.toString()}), (String[])new String[0]));
                var13_15 = entrystatus;
                var15_17 = null;
                if (file_name != null) {
                    try {
                        file_name.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                return var13_15;
            }
            try {
                lenCurrent = sourceshortfilename.length();
                short_filename_from_basefolder = shortfilename;
                if (!this.isDoNotKeepFolderStructure()) {
                    short_filename_from_basefolder = Currentfile.toString().substring(sourcefilefolder.toString().length(), Currentfile.toString().length());
                }
                short_filename_from_basefolder = short_filename_from_basefolder.substring(0, short_filename_from_basefolder.length() - lenCurrent) + shortfilename;
                file_name = KettleVFS.getFileObject((String)(realDestinationFilefoldername + Const.FILE_SEPARATOR + short_filename_from_basefolder), (VariableSpace)this);
                if (!Currentfile.getParent().toString().equals(sourcefilefolder.toString())) {
                    if (this.include_subfolders) {
                        if (Currentfile.getType() == FileType.FOLDER) {
                            if (this.include_subfolders && this.move_empty_folders && Const.isEmpty((String[])this.wildcard)) {
                                entrystatus = this.MoveFile(shortfilename, Currentfile, file_name, movetofolderfolder, parentJob, result);
                            }
                        } else if (this.GetFileWildcard(sourceshortfilename, realWildcard)) {
                            entrystatus = this.MoveFile(shortfilename, Currentfile, file_name, movetofolderfolder, parentJob, result);
                        }
                    }
                } else if (Currentfile.getType() == FileType.FOLDER) {
                    if (this.include_subfolders && this.move_empty_folders && Const.isEmpty((String[])this.wildcard)) {
                        entrystatus = this.MoveFile(shortfilename, Currentfile, file_name, movetofolderfolder, parentJob, result);
                    }
                } else if (this.GetFileWildcard(sourceshortfilename, realWildcard)) {
                    entrystatus = this.MoveFile(shortfilename, Currentfile, file_name, movetofolderfolder, parentJob, result);
                }
lbl45:
                // 7 sources

                entrystatus = true;
                var15_18 = null;
                ** if (file_name == null) goto lbl-1000
            }
            catch (Throwable var14_25) {
                var15_20 = null;
                if (file_name != null) {
                    try {
                        file_name.close();
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                throw var14_25;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    file_name.close();
                }
                catch (IOException ex) {}
            }
lbl-1000:
            // 2 sources

            {
                break block29;
                catch (Exception e) {
                    this.logError(BaseMessages.getString(JobEntryMoveFiles.PKG, (String)"JobMoveFiles.Log.Error", (String[])new String[]{e.toString()}));
                    var15_19 = null;
                    if (file_name != null) {
                        try {
                            file_name.close();
                        }
                        catch (IOException ex) {}
                    }
                }
            }
        }
        return entrystatus;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateSuccess() {
        ++this.NrSuccess;
    }

    private void addFileToResultFilenames(String fileaddentry, Result result, Job parentJob) {
        try {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)fileaddentry, (VariableSpace)this), parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (this.log.isDebug()) {
                this.logDebug(" ------ ");
                this.logDebug(BaseMessages.getString(PKG, (String)"JobMoveFiles.Log.FileAddedToResultFilesName", (String[])new String[]{fileaddentry}));
            }
        }
        catch (Exception e) {
            this.log.logError(BaseMessages.getString(PKG, (String)"JobMoveFiles.Error.AddingToFilenameResult", (String[])new String[0]), new Object[]{fileaddentry + "" + e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean CreateDestinationFolder(FileObject filefolder) {
        FileObject folder;
        block13: {
            folder = null;
            folder = this.destination_is_a_file ? filefolder.getParent() : filefolder;
            if (folder.exists()) break block13;
            if (this.create_destination_folder) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobMoveFiles.Log.FolderNotExist", (String[])new String[]{folder.getName().toString()}));
                }
                folder.createFolder();
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobMoveFiles.Log.FolderWasCreated", (String[])new String[]{folder.getName().toString()}));
                }
                break block13;
            }
            this.logError(BaseMessages.getString(PKG, (String)"JobMoveFiles.Log.FolderNotExist", (String[])new String[]{folder.getName().toString()}));
            boolean bl = false;
            Object var5_6 = null;
            if (folder == null) return bl;
            try {
                folder.close();
                return bl;
            }
            catch (Exception ex) {
                // empty catch block
            }
            return bl;
        }
        boolean bl = true;
        Object var5_7 = null;
        if (folder == null) return bl;
        try {
            folder.close();
            return bl;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return bl;
        catch (Exception e) {
            try {
                this.logError(BaseMessages.getString(PKG, (String)"JobMoveFiles.Log.CanNotCreateParentFolder", (String[])new String[]{folder.getName().toString()}), e);
                Object var5_8 = null;
                if (folder == null) return false;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (folder == null) throw throwable;
                try {
                    folder.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                folder.close();
                return false;
            }
            catch (Exception ex) {}
            return false;
        }
    }

    private boolean GetFileWildcard(String selectedfile, String wildcard) {
        Pattern pattern = null;
        boolean getIt = true;
        if (!Const.isEmpty((String)wildcard) && (pattern = Pattern.compile(wildcard)) != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    private String getDestinationFilename(String shortsourcefilename) throws Exception {
        String shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = shortfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = shortfilename.substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.isSpecifyFormat() && !Const.isEmpty((String)this.getDateTimeFormat())) {
            daf.applyPattern(this.getDateTimeFormat());
            String dt = daf.format(now);
            shortfilename = shortfilename + dt;
        } else {
            if (this.isAddDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                shortfilename = shortfilename + "_" + d;
            }
            if (this.isAddTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                shortfilename = shortfilename + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            shortfilename = shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    private String getMoveDestinationFilename(String shortsourcefilename, String DateFormat2) throws Exception {
        String shortfilename = shortsourcefilename;
        int lenstring = shortsourcefilename.length();
        int lastindexOfDot = shortfilename.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddMovedDateBeforeExtension()) {
            shortfilename = shortfilename.substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (DateFormat2 != null) {
            daf.applyPattern(DateFormat2);
            String dt = daf.format(now);
            shortfilename = shortfilename + dt;
        } else if (this.isSpecifyMoveFormat() && !Const.isEmpty((String)this.getMovedDateTimeFormat())) {
            daf.applyPattern(this.getMovedDateTimeFormat());
            String dt = daf.format(now);
            shortfilename = shortfilename + dt;
        } else {
            if (this.isAddMovedDate()) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                shortfilename = shortfilename + "_" + d;
            }
            if (this.isAddMovedTime()) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                shortfilename = shortfilename + "_" + t;
            }
        }
        if (this.isAddMovedDateBeforeExtension()) {
            shortfilename = shortfilename + shortsourcefilename.substring(lastindexOfDot, lenstring);
        }
        return shortfilename;
    }

    public void setAddDate(boolean adddate) {
        this.add_date = adddate;
    }

    public boolean isAddDate() {
        return this.add_date;
    }

    public boolean isAddMovedDate() {
        return this.add_moved_date;
    }

    public void setAddMovedDate(boolean add_moved_date) {
        this.add_moved_date = add_moved_date;
    }

    public boolean isAddMovedTime() {
        return this.add_moved_time;
    }

    public void setAddMovedTime(boolean add_moved_time) {
        this.add_moved_time = add_moved_time;
    }

    public void setIfFileExists(String iffileexists) {
        this.iffileexists = iffileexists;
    }

    public String getIfFileExists() {
        return this.iffileexists;
    }

    public void setIfMovedFileExists(String ifmovedfileexists) {
        this.ifmovedfileexists = ifmovedfileexists;
    }

    public String getIfMovedFileExists() {
        return this.ifmovedfileexists;
    }

    public void setAddTime(boolean addtime) {
        this.add_time = addtime;
    }

    public boolean isAddTime() {
        return this.add_time;
    }

    public void setAddDateBeforeExtension(boolean AddDateBeforeExtension) {
        this.AddDateBeforeExtension = AddDateBeforeExtension;
    }

    public void setAddMovedDateBeforeExtension(boolean AddMovedDateBeforeExtension) {
        this.AddMovedDateBeforeExtension = AddMovedDateBeforeExtension;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public void setSpecifyMoveFormat(boolean SpecifyMoveFormat) {
        this.SpecifyMoveFormat = SpecifyMoveFormat;
    }

    public boolean isSpecifyMoveFormat() {
        return this.SpecifyMoveFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public String getMovedDateTimeFormat() {
        return this.moved_date_time_format;
    }

    public void setMovedDateTimeFormat(String moved_date_time_format) {
        this.moved_date_time_format = moved_date_time_format;
    }

    public boolean isAddDateBeforeExtension() {
        return this.AddDateBeforeExtension;
    }

    public boolean isAddMovedDateBeforeExtension() {
        return this.AddMovedDateBeforeExtension;
    }

    public boolean isDoNotKeepFolderStructure() {
        return this.DoNotKeepFolderStructure;
    }

    public void setDestinationFolder(String destinationFolder) {
        this.destinationFolder = destinationFolder;
    }

    public String getDestinationFolder() {
        return this.destinationFolder;
    }

    public void setDoNotKeepFolderStructure(boolean DoNotKeepFolderStructure) {
        this.DoNotKeepFolderStructure = DoNotKeepFolderStructure;
    }

    public void setMoveEmptyFolders(boolean move_empty_foldersin) {
        this.move_empty_folders = move_empty_foldersin;
    }

    public void setIncludeSubfolders(boolean include_subfoldersin) {
        this.include_subfolders = include_subfoldersin;
    }

    public void setAddresultfilesname(boolean add_result_filesnamein) {
        this.add_result_filesname = add_result_filesnamein;
    }

    public void setArgFromPrevious(boolean argfrompreviousin) {
        this.arg_from_previous = argfrompreviousin;
    }

    public void setDestinationIsAFile(boolean destination_is_a_file) {
        this.destination_is_a_file = destination_is_a_file;
    }

    public void setCreateDestinationFolder(boolean create_destination_folder) {
        this.create_destination_folder = create_destination_folder;
    }

    public void setCreateMoveToFolder(boolean create_move_to_folder) {
        this.create_move_to_folder = create_move_to_folder;
    }

    public void setNrErrorsLessThan(String nr_errors_less_than) {
        this.nr_errors_less_than = nr_errors_less_than;
    }

    public String getNrErrorsLessThan() {
        return this.nr_errors_less_than;
    }

    public void setSimulate(boolean simulate) {
        this.simulate = simulate;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        boolean res = JobEntryValidatorUtils.andValidator().validate(this, "arguments", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        if (!res) {
            return;
        }
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notNullValidator(), JobEntryValidatorUtils.fileExistsValidator());
        for (int i = 0; i < this.source_filefolder.length; ++i) {
            JobEntryValidatorUtils.andValidator().validate(this, "arguments[" + i + "]", remarks, ctx);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }
}

