/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ssh2put;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import com.trilead.ssh2.ServerHostKeyVerifier;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ssh2get.FTPUtils;
import org.pentaho.di.job.entries.ssh2put.SimpleVerifier;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntrySSH2PUT
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntrySSH2PUT.class;
    private String serverName = null;
    private String userName;
    private String password;
    private String serverPort = "22";
    private String ftpDirectory;
    private String localDirectory;
    private String wildcard;
    private boolean onlyGettingNewFiles;
    private boolean usehttpproxy = false;
    private String httpproxyhost = null;
    private String httpproxyport = null;
    private String httpproxyusername = null;
    private String httpProxyPassword = null;
    private boolean publicpublickey = false;
    private String keyFilename = null;
    private String keyFilePass = null;
    private boolean useBasicAuthentication = false;
    private boolean createRemoteFolder = false;
    private String afterFtpPut = "do_nothing";
    private String destinationfolder = null;
    private boolean createDestinationFolder = false;
    private boolean cachehostkey = false;
    private int timeout = 0;
    static KnownHosts database = new KnownHosts();

    public JobEntrySSH2PUT(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntrySSH2PUT() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntrySSH2PUT je = (JobEntrySSH2PUT)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ftpdirectory", (String)this.ftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"localdirectory", (String)this.localDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_new", (boolean)this.onlyGettingNewFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usehttpproxy", (boolean)this.usehttpproxy));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxyhost", (String)this.httpproxyhost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxyport", (String)this.httpproxyport));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxyusername", (String)this.httpproxyusername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxypassword", (String)this.httpProxyPassword));
        retval.append("      ").append(XMLHandler.addTagValue((String)"publicpublickey", (boolean)this.publicpublickey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilename", (String)this.keyFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilepass", (String)this.keyFilePass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usebasicauthentication", (boolean)this.useBasicAuthentication));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createremotefolder", (boolean)this.createRemoteFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"afterftpput", (String)this.afterFtpPut));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationfolder", (String)this.destinationfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createdestinationfolder", (boolean)this.createDestinationFolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cachehostkey", (boolean)this.cachehostkey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.serverPort = XMLHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.ftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"ftpdirectory");
            this.localDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"localdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.onlyGettingNewFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_new"));
            this.usehttpproxy = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usehttpproxy"));
            this.httpproxyhost = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxyhost");
            this.httpproxyport = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxyport");
            this.httpproxyusername = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxyusername");
            this.httpProxyPassword = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxypassword");
            this.publicpublickey = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"publicpublickey"));
            this.keyFilename = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilename");
            this.keyFilePass = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilepass");
            this.useBasicAuthentication = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usebasicauthentication"));
            this.createRemoteFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createremotefolder"));
            this.afterFtpPut = XMLHandler.getTagValue((Node)entrynode, (String)"afterftpput");
            this.destinationfolder = XMLHandler.getTagValue((Node)entrynode, (String)"destinationfolder");
            this.createDestinationFolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createdestinationfolder"));
            this.cachehostkey = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"cachehostkey"));
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)0);
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.UnableLoadXML", (String[])new String[]{xe.getMessage()}));
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.serverPort = rep.getJobEntryAttributeString(id_jobentry, "serverport");
            this.ftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "ftpdirectory");
            this.localDirectory = rep.getJobEntryAttributeString(id_jobentry, "localdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.onlyGettingNewFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "only_new");
            this.usehttpproxy = rep.getJobEntryAttributeBoolean(id_jobentry, "usehttpproxy");
            this.httpproxyhost = rep.getJobEntryAttributeString(id_jobentry, "httpproxyhost");
            this.httpproxyusername = rep.getJobEntryAttributeString(id_jobentry, "httpproxyusername");
            this.httpProxyPassword = rep.getJobEntryAttributeString(id_jobentry, "httpproxypassword");
            this.publicpublickey = rep.getJobEntryAttributeBoolean(id_jobentry, "publicpublickey");
            this.keyFilename = rep.getJobEntryAttributeString(id_jobentry, "keyfilename");
            this.keyFilePass = rep.getJobEntryAttributeString(id_jobentry, "keyfilepass");
            this.useBasicAuthentication = rep.getJobEntryAttributeBoolean(id_jobentry, "usebasicauthentication");
            this.createRemoteFolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createremotefolder");
            this.afterFtpPut = rep.getJobEntryAttributeString(id_jobentry, "afterftpput");
            this.destinationfolder = rep.getJobEntryAttributeString(id_jobentry, "destinationfolder");
            this.createDestinationFolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createdestinationfolder");
            this.cachehostkey = rep.getJobEntryAttributeBoolean(id_jobentry, "cachehostkey");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.UnableLoadRep", (String[])new String[]{"" + id_jobentry, dbe.getMessage()}));
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "serverport", this.serverPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ftpdirectory", this.ftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "localdirectory", this.localDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "only_new", this.onlyGettingNewFiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "usehttpproxy", this.usehttpproxy);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "httpproxyhost", this.httpproxyhost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "httpproxyport", this.httpproxyport);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "httpproxyusername", this.httpproxyusername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "httpproxypassword", this.httpProxyPassword);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "publicpublickey", this.publicpublickey);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keyfilename", this.keyFilename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "keyfilepass", this.keyFilePass);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "usebasicauthentication", this.useBasicAuthentication);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createremotefolder", this.createRemoteFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "afterftpput", this.afterFtpPut);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "destinationfolder", this.destinationfolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createdestinationfolder", this.createDestinationFolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "cachehostkey", this.cachehostkey);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "timeout", this.timeout);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.UnableSaveRep", (String[])new String[]{"" + id_job, dbe.getMessage()}));
        }
    }

    public String getFtpDirectory() {
        return this.ftpDirectory;
    }

    public void setFtpDirectory(String directory) {
        this.ftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAfterFTPPut() {
        return this.afterFtpPut;
    }

    public void setAfterFTPPut(String afterFtpPut) {
        this.afterFtpPut = afterFtpPut;
    }

    public void setHTTPProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public String getHTTPProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setKeyFilepass(String keyFilePass) {
        this.keyFilePass = keyFilePass;
    }

    public String getKeyFilepass() {
        return this.keyFilePass;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setHTTPProxyHost(String proxyhost) {
        this.httpproxyhost = proxyhost;
    }

    public String getHTTPProxyHost() {
        return this.httpproxyhost;
    }

    public void setKeyFilename(String keyFilename) {
        this.keyFilename = keyFilename;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setHTTPProxyUsername(String proxyusername) {
        this.httpproxyusername = proxyusername;
    }

    public String getHTTPProxyUsername() {
        return this.httpproxyusername;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getlocalDirectory() {
        return this.localDirectory;
    }

    public void setlocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public boolean isOnlyGettingNewFiles() {
        return this.onlyGettingNewFiles;
    }

    public void setOnlyGettingNewFiles(boolean onlyGettingNewFiles) {
        this.onlyGettingNewFiles = onlyGettingNewFiles;
    }

    public void setCacheHostKey(boolean cachehostkeyin) {
        this.cachehostkey = cachehostkeyin;
    }

    public boolean isCacheHostKey() {
        return this.cachehostkey;
    }

    public void setUseHTTPProxy(boolean httpproxy) {
        this.usehttpproxy = httpproxy;
    }

    public boolean isUseHTTPProxy() {
        return this.usehttpproxy;
    }

    public boolean isUseBasicAuthentication() {
        return this.useBasicAuthentication;
    }

    public void setUseBasicAuthentication(boolean useBasicAuthenticationin) {
        this.useBasicAuthentication = useBasicAuthenticationin;
    }

    public void setCreateRemoteFolder(boolean createRemoteFolder) {
        this.createRemoteFolder = createRemoteFolder;
    }

    public boolean isCreateRemoteFolder() {
        return this.createRemoteFolder;
    }

    public void setCreateDestinationFolder(boolean createDestinationFolder) {
        this.createDestinationFolder = createDestinationFolder;
    }

    public boolean isCreateDestinationFolder() {
        return this.createDestinationFolder;
    }

    public void setUsePublicKey(boolean publickey) {
        this.publicpublickey = publickey;
    }

    public boolean isUsePublicKey() {
        return this.publicpublickey;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void setHTTPProxyPort(String proxyport) {
        this.httpproxyport = proxyport;
    }

    public String getHTTPProxyPort() {
        return this.httpproxyport;
    }

    public void setDestinationFolder(String destinationfolderin) {
        this.destinationfolder = destinationfolderin;
    }

    public String getDestinationFolder() {
        return this.destinationfolder;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        try {
            SFTPv3Client client;
            block58: {
                boolean mandatoryok;
                String realDestinationFolder;
                String realftpDirectory;
                String realwildcard;
                String realLocalDirectory;
                String relKeyFilepass;
                String realKeyFilename;
                String realProxyPassword;
                String realproxyUserName;
                int realProxyPort;
                String realProxyHost;
                String realServerPassword;
                String realUserName;
                int realServerPort;
                String realServerName;
                block55: {
                    realServerName = this.environmentSubstitute(this.serverName);
                    realServerPort = Const.toInt((String)this.environmentSubstitute(this.serverPort), (int)22);
                    realUserName = this.environmentSubstitute(this.userName);
                    realServerPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password));
                    realProxyHost = this.environmentSubstitute(this.httpproxyhost);
                    realProxyPort = Const.toInt((String)this.environmentSubstitute(this.httpproxyport), (int)22);
                    realproxyUserName = this.environmentSubstitute(this.httpproxyusername);
                    realProxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.httpProxyPassword));
                    realKeyFilename = this.environmentSubstitute(this.keyFilename);
                    relKeyFilepass = this.environmentSubstitute(this.keyFilePass);
                    realLocalDirectory = this.environmentSubstitute(this.localDirectory);
                    realwildcard = this.environmentSubstitute(this.wildcard);
                    realftpDirectory = this.environmentSubstitute(this.ftpDirectory);
                    realDestinationFolder = this.environmentSubstitute(this.destinationfolder);
                    try {
                        realftpDirectory = FTPUtils.normalizePath(realftpDirectory);
                        realDestinationFolder = FTPUtils.normalizePath(realDestinationFolder);
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.CanNotNormalizePath", (String[])new String[]{e.getMessage()}));
                        result.setNrErrors(1L);
                        return result;
                    }
                    mandatoryok = true;
                    if (Const.isEmpty((String)realServerName)) {
                        mandatoryok = false;
                        this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.ServernameMissing", (String[])new String[0]));
                    }
                    if (this.usehttpproxy && Const.isEmpty((String)realProxyHost)) {
                        mandatoryok = false;
                        this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.HttpProxyhostMissing", (String[])new String[0]));
                    }
                    if (this.publicpublickey) {
                        if (Const.isEmpty((String)realKeyFilename)) {
                            mandatoryok = false;
                            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.KeyFileMissing", (String[])new String[0]));
                        } else if (!KettleVFS.fileExists((String)realKeyFilename, (VariableSpace)this)) {
                            mandatoryok = false;
                            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.KeyFileNotExist", (String[])new String[0]));
                        }
                    }
                    if (Const.isEmpty((String)realLocalDirectory)) {
                        mandatoryok = false;
                        this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.LocalFolderMissing", (String[])new String[0]));
                    }
                    if (this.afterFtpPut.equals("move_file")) {
                        if (Const.isEmpty((String)realDestinationFolder)) {
                            mandatoryok = false;
                            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.DestinatFolderMissing", (String[])new String[0]));
                        } else {
                            FileObject folder = null;
                            try {
                                block54: {
                                    try {
                                        folder = KettleVFS.getFileObject((String)realDestinationFolder, (VariableSpace)this);
                                        if (folder.exists()) break block54;
                                        if (this.createDestinationFolder) {
                                            folder.createFolder();
                                        } else {
                                            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.DestinatFolderNotExist", (String[])new String[]{realDestinationFolder}));
                                        }
                                    }
                                    catch (Exception e) {
                                        throw new KettleException((Throwable)e);
                                    }
                                }
                                Object var22_22 = null;
                                if (folder == null) break block55;
                            }
                            catch (Throwable throwable) {
                                Object var22_23 = null;
                                if (folder == null) throw throwable;
                                try {
                                    folder.close();
                                    folder = null;
                                    throw throwable;
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                            try {}
                            catch (Exception e) {}
                            folder.close();
                            folder = null;
                        }
                    }
                }
                if (!mandatoryok) return result;
                Connection conn = null;
                client = null;
                boolean good = true;
                int nbfilestoput = 0;
                int nbput = 0;
                int nbrerror = 0;
                try {
                    block57: {
                        try {
                            block60: {
                                block61: {
                                    conn = this.getConnection(realServerName, realServerPort, realProxyHost, realProxyPort, realproxyUserName, realProxyPassword);
                                    if (this.timeout > 0) {
                                        if (this.cachehostkey) {
                                            conn.connect((ServerHostKeyVerifier)new SimpleVerifier(database), 0, this.timeout * 1000);
                                        } else {
                                            conn.connect(null, 0, this.timeout * 1000);
                                        }
                                    } else if (this.cachehostkey) {
                                        conn.connect((ServerHostKeyVerifier)new SimpleVerifier(database));
                                    } else {
                                        conn.connect();
                                    }
                                    boolean isAuthenticated = false;
                                    if (this.publicpublickey) {
                                        String keyContent = KettleVFS.getTextFileContent((String)realKeyFilename, (VariableSpace)this, (String)"UTF-8");
                                        isAuthenticated = conn.authenticateWithPublicKey(realUserName, keyContent.toCharArray(), relKeyFilepass);
                                    } else {
                                        isAuthenticated = conn.authenticateWithPassword(realUserName, realServerPassword);
                                    }
                                    if (!isAuthenticated) {
                                        this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.AuthenticationFailed", (String[])new String[0]));
                                        break block57;
                                    }
                                    if (this.log.isBasic()) {
                                        this.logBasic(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.Connected", (String[])new String[]{this.serverName, this.userName}));
                                    }
                                    client = new SFTPv3Client(conn);
                                    if (this.log.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.ProtocolVersion", (String[])new String[]{"" + client.getProtocolVersion()}));
                                    }
                                    if (Const.isEmpty((String)realftpDirectory)) break block60;
                                    if (this.sshDirectoryExists(client, realftpDirectory)) break block61;
                                    good = false;
                                    if (this.createRemoteFolder) {
                                        good = this.CreateRemoteFolder(client, realftpDirectory);
                                        if (good) {
                                            this.logBasic(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.RemoteDirectoryCreated", (String[])new String[0]));
                                        }
                                        break block60;
                                    } else {
                                        this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.RemoteDirectoryNotExist", (String[])new String[]{realftpDirectory}));
                                    }
                                    break block60;
                                }
                                if (this.log.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.RemoteDirectoryExist", (String[])new String[]{realftpDirectory}));
                                }
                            }
                            if (!good) break block57;
                            List<FileObject> myFileList = this.getFiles(realLocalDirectory);
                            Pattern pattern = null;
                            if (!Const.isEmpty((String)realwildcard)) {
                                pattern = Pattern.compile(realwildcard);
                            }
                            for (int i = 0; i < myFileList.size() && !this.parentJob.isStopped(); ++i) {
                                FileObject myFile = myFileList.get(i);
                                String localFilename = myFile.toString();
                                String remoteFilename = myFile.getName().getBaseName();
                                boolean getIt = true;
                                if (pattern != null) {
                                    Matcher matcher = pattern.matcher(remoteFilename);
                                    getIt = matcher.matches();
                                }
                                if (!Const.isEmpty((String)realftpDirectory)) {
                                    remoteFilename = realftpDirectory + FTPUtils.FILE_SEPARATOR + remoteFilename;
                                }
                                if (this.onlyGettingNewFiles) {
                                    boolean bl = getIt = !this.sshFileExists(client, remoteFilename);
                                }
                                if (!getIt) continue;
                                ++nbfilestoput;
                                boolean putok = this.putFile(myFile, remoteFilename, client);
                                if (!putok) {
                                    ++nbrerror;
                                    this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.Error.CanNotPutFile", (String[])new String[]{localFilename}));
                                } else {
                                    ++nbput;
                                }
                                if (!putok || this.afterFtpPut.equals("do_nothing")) continue;
                                this.deleteOrMoveFiles(myFile, realDestinationFolder);
                            }
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.Result.JobEntryEnd1", (String[])new String[0]));
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.Result.TotalFiles", (String[])new String[]{"" + nbfilestoput}));
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.Result.TotalFilesPut", (String[])new String[]{"" + nbput}));
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.Result.TotalFilesError", (String[])new String[]{"" + nbrerror}));
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.Result.JobEntryEnd2", (String[])new String[0]));
                            }
                            if (nbrerror == 0) {
                                result.setResult(true);
                            }
                        }
                        catch (Exception e) {
                            result.setNrErrors((long)nbrerror);
                            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.Error.ErrorFTP", (String[])new String[]{e.getMessage()}));
                            Object var35_45 = null;
                            if (conn != null) {
                                conn.close();
                            }
                            if (client == null) return result;
                            client.close();
                            return result;
                        }
                    }
                    Object var35_44 = null;
                    if (conn == null) break block58;
                }
                catch (Throwable throwable) {
                    Object var35_46 = null;
                    if (conn != null) {
                        conn.close();
                    }
                    if (client == null) throw throwable;
                    client.close();
                    throw throwable;
                }
                conn.close();
            }
            if (client == null) return result;
            client.close();
            return result;
        }
        catch (Exception e) {
            result.setResult(false);
            result.setNrErrors(1L);
            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.Error.UnexpectedError", (String[])new String[0]), e);
        }
        return result;
    }

    private Connection getConnection(String servername, int serverport, String proxyhost, int proxyport, String proxyusername, String proxypassword) {
        Connection connect = new Connection(servername, serverport);
        if (this.usehttpproxy) {
            connect.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport));
            if (this.useBasicAuthentication) {
                connect.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport, proxyusername, proxypassword));
            }
        }
        return connect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean putFile(FileObject localFile, String remotefilename, SFTPv3Client sftpClient) {
        boolean retval;
        block31: {
            Exception ex222222;
            SFTPv3FileHandle sftpFileHandle;
            BufferedInputStream inBuf;
            InputStream in;
            block27: {
                int len;
                long filesize = -1L;
                in = null;
                inBuf = null;
                sftpFileHandle = null;
                retval = false;
                sftpFileHandle = sftpClient.createFileTruncate(remotefilename);
                in = KettleVFS.getInputStream((FileObject)localFile);
                inBuf = new BufferedInputStream(in);
                byte[] buf = new byte[2048];
                long offset = 0L;
                long length = localFile.getContent().getSize();
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.SendingFile", (String[])new String[]{localFile.toString(), "" + length, remotefilename}));
                }
                while ((len = in.read(buf, 0, buf.length)) > 0) {
                    sftpClient.write(sftpFileHandle, offset, buf, 0, len);
                    offset += (long)len;
                }
                filesize = this.getFileSize(sftpClient, remotefilename);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.FileOnRemoteHost", (String[])new String[]{remotefilename, "" + filesize}));
                }
                retval = true;
                Object var17_14 = null;
                if (in == null) break block27;
                try {
                    in.close();
                    in = null;
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (inBuf != null) {
                try {
                    inBuf.close();
                    inBuf = null;
                }
                catch (Exception ex222222) {
                    // empty catch block
                }
            }
            if (sftpFileHandle != null) {
                try {
                    sftpClient.closeFile(sftpFileHandle);
                    sftpFileHandle = null;
                }
                catch (Exception ex222222) {}
            }
            break block31;
            {
                catch (Exception e) {
                    Exception ex222222;
                    this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.ErrorCopyingFile", (String[])new String[]{localFile.toString()}) + ":" + e.getMessage());
                    Object var17_15 = null;
                    if (in != null) {
                        try {
                            in.close();
                            in = null;
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (inBuf != null) {
                        try {
                            inBuf.close();
                            inBuf = null;
                        }
                        catch (Exception ex222222) {
                            // empty catch block
                        }
                    }
                    if (sftpFileHandle != null) {
                        try {
                            sftpClient.closeFile(sftpFileHandle);
                            sftpFileHandle = null;
                        }
                        catch (Exception ex222222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                Exception ex222222;
                Object var17_16 = null;
                if (in != null) {
                    try {
                        in.close();
                        in = null;
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (inBuf != null) {
                    try {
                        inBuf.close();
                        inBuf = null;
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                if (sftpFileHandle != null) {
                    try {
                        sftpClient.closeFile(sftpFileHandle);
                        sftpFileHandle = null;
                    }
                    catch (Exception ex222222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return retval;
    }

    public boolean sshFileExists(SFTPv3Client sftpClient, String filename) {
        try {
            SFTPv3FileAttributes attributes = sftpClient.stat(filename);
            if (attributes != null) {
                return attributes.isRegularFile();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean sshDirectoryExists(SFTPv3Client sftpClient, String directory) {
        try {
            SFTPv3FileAttributes attributes = sftpClient.stat(directory);
            if (attributes != null) {
                return attributes.isDirectory();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean CreateRemoteFolder(SFTPv3Client sftpClient, String foldername) {
        boolean retval = false;
        if (!this.sshDirectoryExists(sftpClient, foldername)) {
            try {
                sftpClient.mkdir(foldername, 448);
                retval = true;
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.Error.CreatingRemoteFolder", (String[])new String[]{foldername}), e);
            }
        }
        return retval;
    }

    public long getFileSize(SFTPv3Client sftpClient, String filename) throws Exception {
        return sftpClient.stat((String)filename).size;
    }

    private List<FileObject> getFiles(String localfolder) throws KettleFileException {
        try {
            ArrayList<FileObject> myFileList = new ArrayList<FileObject>();
            FileObject localFiles = KettleVFS.getFileObject((String)localfolder, (VariableSpace)this);
            FileObject[] children = localFiles.getChildren();
            if (children != null) {
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].getType().equals(FileType.FILE)) continue;
                    myFileList.add(children[i]);
                }
            }
            return myFileList;
        }
        catch (IOException e) {
            throw new KettleFileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean deleteOrMoveFiles(FileObject file, String destinationFolder) throws KettleException {
        try {
            boolean retval;
            block24: {
                block25: {
                    Exception ex222;
                    Object source;
                    FileObject destination;
                    block21: {
                        block23: {
                            retval = false;
                            if (!this.afterFtpPut.equals("delete_file")) break block23;
                            file.delete();
                            retval = true;
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.DeletedFile", (String[])new String[]{file.toString()}));
                            }
                            break block24;
                        }
                        if (!this.afterFtpPut.equals("move_file")) break block24;
                        destination = null;
                        source = null;
                        destination = KettleVFS.getFileObject((String)(destinationFolder + Const.FILE_SEPARATOR + file.getName().getBaseName()), (VariableSpace)this);
                        file.moveTo(destination);
                        retval = true;
                        Object var8_7 = null;
                        if (destination == null) break block21;
                        try {
                            destination.close();
                        }
                        catch (Exception ex222) {
                            // empty catch block
                        }
                    }
                    if (source != null) {
                        try {
                            source.close();
                        }
                        catch (Exception ex222) {}
                    }
                    break block25;
                    {
                        catch (Exception e) {
                            Exception ex222;
                            this.logError(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Cant_Move_File.Label", (String[])new String[]{file.toString(), destinationFolder, e.getMessage()}));
                            Object var8_8 = null;
                            if (destination != null) {
                                try {
                                    destination.close();
                                }
                                catch (Exception ex222) {
                                    // empty catch block
                                }
                            }
                            if (source != null) {
                                try {
                                    source.close();
                                }
                                catch (Exception ex222) {}
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Exception ex222;
                        Object var8_9 = null;
                        if (destination != null) {
                            try {
                                destination.close();
                            }
                            catch (Exception ex222) {
                                // empty catch block
                            }
                        }
                        if (source != null) {
                            try {
                                source.close();
                            }
                            catch (Exception ex222) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobSSH2PUT.Log.MovedFile", (String[])new String[]{file.toString(), this.ftpDirectory}));
                }
            }
            return retval;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "localDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

