/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.tableexists;

import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryTableExists
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryTableExists.class;
    private String tablename = null;
    private String schemaname = null;
    private DatabaseMeta connection = null;

    public JobEntryTableExists(String n) {
        super(n, "");
        this.setID(-1L);
    }

    public JobEntryTableExists() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryTableExists je = (JobEntryTableExists)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.tablename = XMLHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.schemaname = XMLHandler.getTagValue((Node)entrynode, (String)"schemaname");
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
        }
        catch (KettleException e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"TableExists.Meta.UnableLoadXml", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.tablename = rep.getJobEntryAttributeString(id_jobentry, "tablename");
            this.schemaname = rep.getJobEntryAttributeString(id_jobentry, "schemaname");
            this.connection = rep.loadDatabaseMetaFromJobEntryAttribute(id_jobentry, "connection", "id_database", databases);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TableExists.Meta.UnableLoadRep", (String[])new String[]{"" + id_jobentry}), (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "tablename", this.tablename);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "schemaname", this.schemaname);
            rep.saveDatabaseMetaJobEntryAttribute(id_job, this.getObjectId(), "connection", "id_database", this.connection);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"TableExists.Meta.UnableSaveRep", (String[])new String[]{"" + id_job}), (Throwable)dbe);
        }
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getTablename() {
        return this.tablename;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        if (this.connection != null) {
            Database db;
            block14: {
                db = new Database((LoggingObjectInterface)this, this.connection);
                db.shareVariablesWith((VariableSpace)this);
                db.connect();
                String realTablename = this.environmentSubstitute(this.tablename);
                String realSchemaname = this.environmentSubstitute(this.schemaname);
                if (!Const.isEmpty((String)realSchemaname)) {
                    realTablename = db.getDatabaseMeta().getQuotedSchemaTableCombination(realSchemaname, realTablename);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TableExists.Log.SchemaTable", (String[])new String[]{realTablename}));
                    }
                } else {
                    realTablename = db.getDatabaseMeta().quoteField(realTablename);
                }
                if (db.checkTableExists(realTablename)) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"TableExists.Log.TableExists", (String[])new String[]{realTablename}));
                    }
                    result.setResult(true);
                    break block14;
                }
                if (!this.log.isDetailed()) break block14;
                this.logDetailed(BaseMessages.getString(PKG, (String)"TableExists.Log.TableNotExists", (String[])new String[]{realTablename}));
            }
            Object var8_8 = null;
            if (db == null) return result;
            try {
                db.disconnect();
                return result;
            }
            catch (Exception e) {}
            return result;
            {
                catch (KettleDatabaseException dbe) {
                    result.setNrErrors(1L);
                    this.logError(BaseMessages.getString(PKG, (String)"TableExists.Error.RunningJobEntry", (String[])new String[]{dbe.getMessage()}));
                    Object var8_9 = null;
                    if (db == null) return result;
                    try {
                        db.disconnect();
                        return result;
                    }
                    catch (Exception e) {}
                    return result;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (db == null) throw throwable;
                try {
                    db.disconnect();
                    throw throwable;
                }
                catch (Exception e) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        result.setNrErrors(1L);
        this.logError(BaseMessages.getString(PKG, (String)"TableExists.Error.NoConnectionDefined", (String[])new String[0]));
        return result;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (this.connection != null) {
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "tablename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

