/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceHolderInterface;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryBase
implements Cloneable,
VariableSpace,
CheckResultSourceInterface,
ResourceHolderInterface,
LoggingObjectInterface {
    private String name;
    private String description;
    private String configId;
    private boolean changed;
    private ObjectId id;
    protected VariableSpace variables = new Variables();
    protected Repository rep;
    protected Job parentJob;
    protected LogChannelInterface log;
    private LogLevel logLevel = DefaultLogLevel.getLogLevel();
    private String containerObjectId;

    public JobEntryBase() {
        this.name = null;
        this.description = null;
        this.log = new LogChannel((Object)this);
    }

    public JobEntryBase(String name, String description) {
        this.setName(name);
        this.setDescription(description);
        this.setObjectId(null);
        this.log = new LogChannel((Object)this);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JobEntryBase)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        return this.name.equalsIgnoreCase(((JobEntryBase)obj).getName());
    }

    public void clear() {
        this.name = null;
        this.description = null;
        this.changed = false;
    }

    public void setObjectId(ObjectId id) {
        this.id = id;
    }

    public void setID(long id) {
        this.id = new LongObjectId(id);
    }

    @Override
    public ObjectId getObjectId() {
        return this.id;
    }

    public String getTypeDesc() {
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, this.configId);
        return plugin.getDescription();
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setDescription(String Description) {
        this.description = Description;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setChanged() {
        this.setChanged(true);
    }

    public void setChanged(boolean ch) {
        this.changed = ch;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    public boolean isStart() {
        return false;
    }

    public boolean isDummy() {
        return false;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isJob() {
        return "JOB".equals(this.configId);
    }

    public boolean isMail() {
        return "MAIL".equals(this.configId);
    }

    public boolean isShell() {
        return "SHELL".equals(this.configId);
    }

    public boolean isSpecial() {
        return "SPECIAL".equals(this.configId);
    }

    public boolean isTransformation() {
        return "TRANS".equals(this.configId);
    }

    public boolean isFTP() {
        return "FTP".equals(this.configId);
    }

    public boolean isSFTP() {
        return "SFTP".equals(this.configId);
    }

    public boolean isHTTP() {
        return "HTTP".equals(this.configId);
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("      ").append(XMLHandler.addTagValue((String)"name", (String)this.getName()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"description", (String)this.getDescription()));
        retval.append("      ").append(XMLHandler.addTagValue((String)"type", (String)this.configId));
        return retval.toString();
    }

    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleXMLException {
        try {
            this.setName(XMLHandler.getTagValue((Node)entrynode, (String)"name"));
            this.setDescription(XMLHandler.getTagValue((Node)entrynode, (String)"description"));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load base info for job entry", (Throwable)e);
        }
    }

    public void parseRepositoryObjects(Repository rep) throws KettleException {
    }

    public void loadRep(Repository rep, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
    }

    public void saveRep(Repository rep, ObjectId id_job) throws KettleException {
    }

    public Object clone() {
        JobEntryBase je;
        try {
            je = (JobEntryBase)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
        return je;
    }

    public String toString() {
        return this.name;
    }

    public boolean resetErrorsBeforeExecution() {
        return true;
    }

    public boolean evaluates() {
        return false;
    }

    public boolean isUnconditional() {
        return true;
    }

    public List<SQLStatement> getSQLStatements(Repository repository) throws KettleException {
        return this.getSQLStatements(repository, null);
    }

    public List<SQLStatement> getSQLStatements(Repository repository, VariableSpace space) throws KettleException {
        return new ArrayList<SQLStatement>();
    }

    public String getFilename() {
        return null;
    }

    public String getRealFilename() {
        return null;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[0];
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
    }

    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        return new ArrayList<ResourceReference>(5);
    }

    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface namingInterface, Repository repository) throws KettleException {
        return null;
    }

    public String getPluginId() {
        return this.configId;
    }

    public void setPluginId(String configId) {
        this.configId = configId;
    }

    @Override
    public String getTypeId() {
        return this.getPluginId();
    }

    public void setTypeId(String typeId) {
        this.setPluginId(typeId);
    }

    public String getDialogClassName() {
        String className = this.getClass().getCanonicalName();
        className = className.replaceFirst("\\.di\\.", ".di.ui.");
        className = className + "Dialog";
        return className;
    }

    @Override
    public String getHolderType() {
        return "JOBENTRY";
    }

    protected VariableSpace getVariables() {
        return this.variables;
    }

    public void setRepository(Repository repository) {
        this.rep = repository;
    }

    public Repository getRepository() {
        return this.rep;
    }

    public void setParentJob(Job parentJob) {
        this.parentJob = parentJob;
        this.logLevel = parentJob.getLogLevel();
        this.log = new LogChannel((Object)this, (LoggingObjectInterface)parentJob);
        this.containerObjectId = parentJob.getContainerObjectId();
    }

    public Job getParentJob() {
        return this.parentJob;
    }

    public boolean isBasic() {
        return this.log.isBasic();
    }

    public boolean isDetailed() {
        return this.log.isDetailed();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public boolean isRowlevel() {
        return this.log.isRowLevel();
    }

    public void logMinimal(String message) {
        this.log.logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.log.logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.log.logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.log.logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.log.logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.log.logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.log.logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.log.logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.log.logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.log.logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.log.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.log.logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.log.logError(message, arguments);
    }

    public LogChannelInterface getLogChannel() {
        return this.log;
    }

    public String getLogChannelId() {
        return this.log.getLogChannelId();
    }

    public String getObjectName() {
        return this.getName();
    }

    public String getObjectCopy() {
        return null;
    }

    public ObjectRevision getObjectRevision() {
        return null;
    }

    public LoggingObjectType getObjectType() {
        return LoggingObjectType.JOBENTRY;
    }

    public LoggingObjectInterface getParent() {
        return this.parentJob;
    }

    public RepositoryDirectory getRepositoryDirectory() {
        return null;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        this.log.setLogLevel(logLevel);
    }

    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    public void setContainerObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    public Date getRegistrationDate() {
        return null;
    }

    public boolean hasRepositoryReferences() {
        return false;
    }

    public void lookupRepositoryReferences(Repository repository) throws KettleException {
    }
}

