/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry.validator;

import java.io.IOException;
import java.util.List;
import org.apache.commons.validator.util.ValidatorUtils;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileDoesNotExistValidator
extends AbstractFileValidator {
    private static final String KEY_FAIL_IF_EXISTS = "org.pentaho.di.job.entries.createfile.failIfExists";
    public static final FileDoesNotExistValidator INSTANCE = new FileDoesNotExistValidator();
    static final String VALIDATOR_NAME = "fileDoesNotExist";

    @Override
    public boolean validate(CheckResultSourceInterface source, String propertyName, List<CheckResultInterface> remarks, ValidatorContext context) {
        String filename = ValidatorUtils.getValueAsString((Object)source, (String)propertyName);
        VariableSpace variableSpace = this.getVariableSpace(source, propertyName, remarks, context);
        boolean failIfExists = this.getFailIfExists(source, propertyName, remarks, context);
        if (null == variableSpace) {
            return false;
        }
        String realFileName = variableSpace.environmentSubstitute(filename);
        FileObject fileObject = null;
        try {
            fileObject = KettleVFS.getFileObject((String)realFileName, (VariableSpace)variableSpace);
            if (fileObject.exists() && failIfExists) {
                JobEntryValidatorUtils.addFailureRemark(source, propertyName, VALIDATOR_NAME, remarks, JobEntryValidatorUtils.getLevelOnFail(context, VALIDATOR_NAME));
                return false;
            }
            try {
                fileObject.close();
            }
            catch (IOException ignored) {}
        }
        catch (Exception e) {
            JobEntryValidatorUtils.addExceptionRemark(source, propertyName, VALIDATOR_NAME, remarks, e);
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return VALIDATOR_NAME;
    }

    public static ValidatorContext putFailIfExists(boolean failIfExists) {
        ValidatorContext context = new ValidatorContext();
        context.put(KEY_FAIL_IF_EXISTS, failIfExists);
        return context;
    }

    protected boolean getFailIfExists(CheckResultSourceInterface source, String propertyName, List<CheckResultInterface> remarks, ValidatorContext context) {
        Object obj = context.get(KEY_FAIL_IF_EXISTS);
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        return false;
    }

    public static void putFailIfExists(ValidatorContext context, boolean failIfExists) {
        context.put(KEY_FAIL_IF_EXISTS, failIfExists);
    }
}

