/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entry.validator;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.job.entry.validator.JobEntryValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotNullValidator
implements JobEntryValidator {
    public static final NotNullValidator INSTANCE = new NotNullValidator();
    private static final String VALIDATOR_NAME = "notNull";

    @Override
    public boolean validate(CheckResultSourceInterface source, String propertyName, List<CheckResultInterface> remarks, ValidatorContext context) {
        Object value = null;
        try {
            value = PropertyUtils.getProperty((Object)source, (String)propertyName);
            if (null == value) {
                JobEntryValidatorUtils.addFailureRemark(source, propertyName, VALIDATOR_NAME, remarks, JobEntryValidatorUtils.getLevelOnFail(context, VALIDATOR_NAME));
                return false;
            }
            return true;
        }
        catch (IllegalAccessException e) {
            JobEntryValidatorUtils.addExceptionRemark(source, propertyName, VALIDATOR_NAME, remarks, e);
        }
        catch (InvocationTargetException e) {
            JobEntryValidatorUtils.addExceptionRemark(source, propertyName, VALIDATOR_NAME, remarks, e);
        }
        catch (NoSuchMethodException e) {
            JobEntryValidatorUtils.addExceptionRemark(source, propertyName, VALIDATOR_NAME, remarks, e);
        }
        return false;
    }

    @Override
    public String getName() {
        return VALIDATOR_NAME;
    }
}

