/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.lineage;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.lineage.ValueLineage;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransDataLineage {
    private TransMeta transMeta;
    private List<ValueLineage> valueLineages;
    private Map<ValueMetaInterface, List<StepMeta>> fieldStepsMap;

    public TransDataLineage(TransMeta transMeta) {
        this.transMeta = transMeta;
        this.valueLineages = new ArrayList<ValueLineage>();
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public List<ValueLineage> getValueLineages() {
        return this.valueLineages;
    }

    public void setValueLineages(List<ValueLineage> valueLineages) {
        this.valueLineages = valueLineages;
    }

    public void calculateLineage() throws KettleStepException {
        final Map<StepMeta, Map<StepMeta, Boolean>> stepMap = this.transMeta.sortStepsNatural();
        HashMap previousStepListMap = new HashMap();
        for (StepMeta stepMeta : stepMap.keySet()) {
            ArrayList<StepMeta> previousSteps = new ArrayList<StepMeta>();
            previousStepListMap.put(stepMeta, previousSteps);
            previousSteps.addAll(stepMap.get(stepMeta).keySet());
            Collections.sort(previousSteps, new Comparator<StepMeta>(){

                @Override
                public int compare(StepMeta o1, StepMeta o2) {
                    Map beforeMap = (Map)stepMap.get(o1);
                    if (beforeMap != null) {
                        if (beforeMap.get(o2) == null) {
                            return -1;
                        }
                        return 1;
                    }
                    return o1.getName().compareToIgnoreCase(o2.getName());
                }
            });
            System.out.println("Step considered: " + stepMeta.getName());
            for (StepMeta prev : previousSteps) {
                System.out.println("      --> previous step: " + prev.getName());
            }
        }
        this.fieldStepsMap = new HashMap<ValueMetaInterface, List<StepMeta>>();
        List<StepMeta> usedSteps = this.transMeta.getUsedSteps();
        for (StepMeta stepMeta : usedSteps) {
            this.calculateLineage(stepMeta);
        }
    }

    private void calculateLineage(StepMeta stepMeta) throws KettleStepException {
        RowMetaInterface outputMeta = this.transMeta.getStepFields(stepMeta);
        for (ValueMetaInterface valueMeta : outputMeta.getValueMetaList()) {
            StepMeta originStepMeta = this.transMeta.findStep(valueMeta.getOrigin(), stepMeta);
            if (originStepMeta == null) continue;
            this.fieldStepsMap.get(originStepMeta);
        }
    }
}

