/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleDependencyException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryOperation;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KettleDatabaseRepositoryDatabaseDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    private static Class<?> PKG = DatabaseMeta.class;

    public KettleDatabaseRepositoryDatabaseDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public synchronized ObjectId getDatabaseID(String name) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_DATABASE"), this.quote("ID_DATABASE"), this.quote("NAME"), name);
    }

    public synchronized String getDatabaseTypeCode(ObjectId id_database_type) throws KettleException {
        return this.repository.connectionDelegate.getStringWithID(this.quoteTable("R_DATABASE_TYPE"), this.quote("ID_DATABASE_TYPE"), id_database_type, this.quote("CODE"));
    }

    public synchronized String getDatabaseConTypeCode(ObjectId id_database_contype) throws KettleException {
        return this.repository.connectionDelegate.getStringWithID(this.quoteTable("R_DATABASE_CONTYPE"), this.quote("ID_DATABASE_CONTYPE"), id_database_contype, this.quote("CODE"));
    }

    public RowMetaAndData getDatabase(ObjectId id_database) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_DATABASE"), this.quote("ID_DATABASE"), id_database);
    }

    public RowMetaAndData getDatabaseAttribute(ObjectId id_database_attribute) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_DATABASE_ATTRIBUTE"), this.quote("ID_DATABASE_ATTRIBUTE"), id_database_attribute);
    }

    public Collection<RowMetaAndData> getDatabaseAttributes() throws KettleDatabaseException, KettleValueException {
        ArrayList<RowMetaAndData> attrs = new ArrayList<RowMetaAndData>();
        List<Object[]> rows = this.repository.connectionDelegate.getRows("SELECT * FROM " + this.quoteTable("R_DATABASE_ATTRIBUTE"), 0);
        for (Object[] row : rows) {
            RowMetaAndData rowWithMeta = new RowMetaAndData(this.repository.connectionDelegate.getReturnRowMeta(), row);
            long id = rowWithMeta.getInteger(this.quote("ID_DATABASE_ATTRIBUTE"), 0L);
            if (id <= 0L) continue;
            attrs.add(rowWithMeta);
        }
        return attrs;
    }

    public DatabaseMeta loadDatabaseMeta(ObjectId id_database) throws KettleException {
        DatabaseMeta databaseMeta = new DatabaseMeta();
        try {
            RowMetaAndData r = this.getDatabase(id_database);
            if (r != null) {
                LongObjectId id_database_type = new LongObjectId(r.getInteger("ID_DATABASE_TYPE", 0L));
                String dbTypeDesc = this.getDatabaseTypeCode((ObjectId)id_database_type);
                if (dbTypeDesc != null) {
                    databaseMeta.setDatabaseInterface(DatabaseMeta.getDatabaseInterface((String)dbTypeDesc));
                    databaseMeta.setAttributes(new Properties());
                }
                databaseMeta.setObjectId(id_database);
                databaseMeta.setName(r.getString("NAME", ""));
                LongObjectId id_database_contype = new LongObjectId(r.getInteger("ID_DATABASE_CONTYPE", 0L));
                databaseMeta.setAccessType(DatabaseMeta.getAccessType((String)this.getDatabaseConTypeCode((ObjectId)id_database_contype)));
                databaseMeta.setHostname(r.getString("HOST_NAME", ""));
                databaseMeta.setDBName(r.getString("DATABASE_NAME", ""));
                databaseMeta.setDBPort(r.getString("PORT", ""));
                databaseMeta.setUsername(r.getString("USERNAME", ""));
                databaseMeta.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)r.getString("PASSWORD", "")));
                databaseMeta.setServername(r.getString("SERVERNAME", ""));
                databaseMeta.setDataTablespace(r.getString("DATA_TBS", ""));
                databaseMeta.setIndexTablespace(r.getString("INDEX_TBS", ""));
                Collection<RowMetaAndData> attrs = this.repository.connectionDelegate.getDatabaseAttributes(id_database);
                for (RowMetaAndData row : attrs) {
                    String code = row.getString("CODE", "");
                    String attribute = row.getString("VALUE_STR", "");
                    databaseMeta.getAttributes().put(code, Const.NVL((String)attribute, (String)""));
                }
            }
            return databaseMeta;
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Error loading database connection from repository (id_database=" + id_database + ")", (Throwable)dbe);
        }
    }

    public void saveDatabaseMeta(DatabaseMeta databaseMeta) throws KettleException {
        try {
            if (databaseMeta.getObjectId() == null) {
                databaseMeta.setObjectId(this.getDatabaseID(databaseMeta.getName()));
            }
            if (databaseMeta.getObjectId() == null) {
                databaseMeta.setObjectId(this.insertDatabase(databaseMeta.getName(), databaseMeta.getPluginId(), DatabaseMeta.getAccessTypeDesc((int)databaseMeta.getAccessType()), databaseMeta.getHostname(), databaseMeta.getDatabaseName(), databaseMeta.getDatabasePortNumberString(), databaseMeta.getUsername(), databaseMeta.getPassword(), databaseMeta.getServername(), databaseMeta.getDataTablespace(), databaseMeta.getIndexTablespace()));
            } else {
                this.updateDatabase(databaseMeta.getObjectId(), databaseMeta.getName(), databaseMeta.getPluginId(), DatabaseMeta.getAccessTypeDesc((int)databaseMeta.getAccessType()), databaseMeta.getHostname(), databaseMeta.getDatabaseName(), databaseMeta.getDatabasePortNumberString(), databaseMeta.getUsername(), databaseMeta.getPassword(), databaseMeta.getServername(), databaseMeta.getDataTablespace(), databaseMeta.getIndexTablespace());
            }
            this.delDatabaseAttributes(databaseMeta.getObjectId());
            Properties attributes = databaseMeta.getAttributes();
            Enumeration<Object> keys = databaseMeta.getAttributes().keys();
            while (keys.hasMoreElements()) {
                String code = (String)keys.nextElement();
                String attribute = (String)attributes.get(code);
                this.insertDatabaseAttribute(databaseMeta.getObjectId(), code, attribute);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Error saving database connection or one of its attributes to the repository.", (Throwable)dbe);
        }
    }

    public synchronized ObjectId insertDatabase(String name, String type, String access, String host, String dbname, String port, String user, String pass, String servername, String data_tablespace, String index_tablespace) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextDatabaseID();
        ObjectId id_database_type = this.getDatabaseTypeID(type);
        if (id_database_type == null) {
            id_database_type = this.repository.connectionDelegate.getNextDatabaseTypeID();
            String tablename = "R_DATABASE_TYPE";
            RowMeta tableMeta = new RowMeta();
            tableMeta.addValueMeta((ValueMetaInterface)new ValueMeta("ID_DATABASE_TYPE", 5, 5, 0));
            tableMeta.addValueMeta((ValueMetaInterface)new ValueMeta("CODE", 2, 255, 0));
            tableMeta.addValueMeta((ValueMetaInterface)new ValueMeta("DESCRIPTION", 2, 2000000, 0));
            this.repository.connectionDelegate.getDatabase().prepareInsert((RowMetaInterface)tableMeta, tablename);
            Object[] tableData = new Object[3];
            int tableIndex = 0;
            tableData[tableIndex++] = new LongObjectId(id_database_type).longValue();
            tableData[tableIndex++] = type;
            tableData[tableIndex++] = type;
            this.repository.connectionDelegate.getDatabase().setValuesInsert((RowMetaInterface)tableMeta, tableData);
            this.repository.connectionDelegate.getDatabase().insertRow();
            this.repository.connectionDelegate.getDatabase().closeInsert();
        }
        ObjectId id_database_contype = this.getDatabaseConTypeID(access);
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_DATABASE", 5), (Object)id);
        table.addValue(new ValueMeta("NAME", 2), (Object)name);
        table.addValue(new ValueMeta("ID_DATABASE_TYPE", 5), (Object)id_database_type);
        table.addValue(new ValueMeta("ID_DATABASE_CONTYPE", 5), (Object)id_database_contype);
        table.addValue(new ValueMeta("HOST_NAME", 2), (Object)host);
        table.addValue(new ValueMeta("DATABASE_NAME", 2), (Object)dbname);
        table.addValue(new ValueMeta("PORT", 5), (Object)new Long(Const.toInt((String)port, (int)-1)));
        table.addValue(new ValueMeta("USERNAME", 2), (Object)user);
        table.addValue(new ValueMeta("PASSWORD", 2), (Object)Encr.encryptPasswordIfNotUsingVariables((String)pass));
        table.addValue(new ValueMeta("SERVERNAME", 2), (Object)servername);
        table.addValue(new ValueMeta("DATA_TBS", 2), (Object)data_tablespace);
        table.addValue(new ValueMeta("INDEX_TBS", 2), (Object)index_tablespace);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_DATABASE");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public synchronized void updateDatabase(ObjectId id_database, String name, String type, String access, String host, String dbname, String port, String user, String pass, String servername, String data_tablespace, String index_tablespace) throws KettleException {
        ObjectId id_database_type = this.getDatabaseTypeID(type);
        ObjectId id_database_contype = this.getDatabaseConTypeID(access);
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)name);
        table.addValue(new ValueMeta("ID_DATABASE_TYPE", 5), (Object)id_database_type);
        table.addValue(new ValueMeta("ID_DATABASE_CONTYPE", 5), (Object)id_database_contype);
        table.addValue(new ValueMeta("HOST_NAME", 2), (Object)host);
        table.addValue(new ValueMeta("DATABASE_NAME", 2), (Object)dbname);
        table.addValue(new ValueMeta("PORT", 5), (Object)new Long(Const.toInt((String)port, (int)-1)));
        table.addValue(new ValueMeta("USERNAME", 2), (Object)user);
        table.addValue(new ValueMeta("PASSWORD", 2), (Object)Encr.encryptPasswordIfNotUsingVariables((String)pass));
        table.addValue(new ValueMeta("SERVERNAME", 2), (Object)servername);
        table.addValue(new ValueMeta("DATA_TBS", 2), (Object)data_tablespace);
        table.addValue(new ValueMeta("INDEX_TBS", 2), (Object)index_tablespace);
        this.repository.connectionDelegate.updateTableRow("R_DATABASE", "ID_DATABASE", table, id_database);
    }

    public synchronized ObjectId getDatabaseTypeID(String code) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_DATABASE_TYPE"), this.quote("ID_DATABASE_TYPE"), this.quote("CODE"), code);
    }

    public synchronized ObjectId getDatabaseConTypeID(String code) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_DATABASE_CONTYPE"), this.quote("ID_DATABASE_CONTYPE"), this.quote("CODE"), code);
    }

    public void deleteDatabaseMeta(String databaseName) throws KettleException {
        this.repository.getSecurityProvider().validateAction(RepositoryOperation.DELETE_DATABASE);
        try {
            ObjectId id_database = this.getDatabaseID(databaseName);
            this.delDatabase(id_database);
        }
        catch (KettleException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"KettleDatabaseRepository.Exception.ErrorDeletingConnection.Message", (String[])new String[]{databaseName}), (Throwable)dbe);
        }
    }

    public synchronized void delDatabase(ObjectId id_database) throws KettleException {
        this.repository.getSecurityProvider().validateAction(RepositoryOperation.DELETE_DATABASE);
        String[] transList = this.repository.getTransformationsUsingDatabase(id_database);
        String[] jobList = this.repository.getJobsUsingDatabase(id_database);
        if (jobList.length != 0 || transList.length != 0) {
            int i;
            String message = " Database used by the following " + Const.CR;
            if (jobList.length > 0) {
                message = "jobs :" + Const.CR;
                for (i = 0; i < jobList.length; ++i) {
                    message = message + "\t " + jobList[i] + Const.CR;
                }
            }
            message = message + "transformations:" + Const.CR;
            for (i = 0; i < transList.length; ++i) {
                message = message + "\t" + transList[i] + Const.CR;
            }
            KettleDependencyException e = new KettleDependencyException(message);
            throw new KettleDependencyException("This database is still in use by " + jobList.length + " jobs and " + transList.length + " transformations references", (Throwable)e);
        }
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_DATABASE") + " WHERE " + this.quote("ID_DATABASE") + " = ? ", id_database);
    }

    public synchronized void delDatabaseAttributes(ObjectId id_database) throws KettleException {
        this.repository.connectionDelegate.performDelete("DELETE FROM " + this.quoteTable("R_DATABASE_ATTRIBUTE") + " WHERE " + this.quote("ID_DATABASE") + " = ? ", id_database);
    }

    public synchronized int getNrDatabases() throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_DATABASE");
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrDatabases(ObjectId id_transformation) throws KettleException {
        int retval = 0;
        RowMetaAndData transIdRow = this.repository.connectionDelegate.getParameterMetaData(id_transformation);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_STEP_DATABASE") + " WHERE " + this.quote("ID_TRANSFORMATION") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, transIdRow.getRowMeta(), transIdRow.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrDatabaseAttributes(ObjectId id_database) throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_DATABASE_ATTRIBUTE") + " WHERE " + this.quote("ID_DATABASE") + " = " + id_database;
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    private synchronized ObjectId insertDatabaseAttribute(ObjectId id_database, String code, String value_str) throws KettleException {
        LongObjectId id = this.repository.connectionDelegate.getNextDatabaseAttributeID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_DATABASE_ATTRIBUTE", 5), (Object)id);
        table.addValue(new ValueMeta("ID_DATABASE", 5), (Object)id_database);
        table.addValue(new ValueMeta("CODE", 2), (Object)code);
        table.addValue(new ValueMeta("VALUE_STR", 2), (Object)value_str);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_DATABASE_ATTRIBUTE");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        if (this.log.isDebug()) {
            this.log.logDebug("saved database attribute [" + code + "]");
        }
        return id;
    }
}

