/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobHopMeta;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.LongObjectId;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.RepositoryAttributeInterface;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryJobAttribute;
import org.pentaho.di.shared.SharedObjects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KettleDatabaseRepositoryJobDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    private static Class<?> PKG = JobMeta.class;

    public KettleDatabaseRepositoryJobDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getJob(ObjectId id_job) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_JOB"), this.quote("ID_JOB"), id_job);
    }

    public RowMetaAndData getJobHop(ObjectId id_job_hop) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_JOB_HOP"), this.quote("ID_JOB_HOP"), id_job_hop);
    }

    public synchronized ObjectId getJobHopID(ObjectId id_job, ObjectId id_jobentry_copy_from, ObjectId id_jobentry_copy_to) throws KettleException {
        String[] lookupkey = new String[]{this.quote("ID_JOB"), this.quote("ID_JOBENTRY_COPY_FROM"), this.quote("ID_JOBENTRY_COPY_TO")};
        ObjectId[] key = new ObjectId[]{id_job, id_jobentry_copy_from, id_jobentry_copy_to};
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_JOB_HOP"), this.quote("ID_JOB_HOP"), lookupkey, key);
    }

    public void saveJob(JobMeta jobMeta, String versionComment, ProgressMonitorListener monitor, boolean overwrite) throws KettleException {
        try {
            block27: {
                try {
                    int i;
                    int nrWorks = 2 + jobMeta.nrDatabases() + jobMeta.nrNotes() + jobMeta.nrJobEntries() + jobMeta.nrJobHops();
                    if (monitor != null) {
                        monitor.beginTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.SavingTransformation", (String[])new String[0]) + jobMeta.getRepositoryDirectory() + Const.FILE_SEPARATOR + jobMeta.getName(), nrWorks);
                    }
                    this.repository.lockRepository();
                    this.repository.insertLogEntry("save job '" + jobMeta.getName() + "'");
                    if (monitor != null) {
                        monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.HandlingPreviousVersionOfJob", (String[])new String[0]));
                    }
                    jobMeta.setObjectId(this.getJobID(jobMeta.getName(), jobMeta.getRepositoryDirectory().getObjectId()));
                    if (jobMeta.getObjectId() == null) {
                        jobMeta.setObjectId(this.repository.connectionDelegate.getNextJobID());
                    } else {
                        this.repository.deleteJob(jobMeta.getObjectId());
                    }
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    if (this.log.isDebug()) {
                        this.log.logDebug(BaseMessages.getString(PKG, (String)"JobMeta.Log.SavingDatabaseConnections", (String[])new String[0]));
                    }
                    for (i = 0; i < jobMeta.nrDatabases(); ++i) {
                        if (monitor != null) {
                            monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.SavingDatabaseTask.Title", (String[])new String[0]) + (i + 1) + "/" + jobMeta.nrDatabases());
                        }
                        DatabaseMeta databaseMeta = jobMeta.getDatabase(i);
                        if (overwrite || databaseMeta.hasChanged() || databaseMeta.getObjectId() == null) {
                            this.repository.save((RepositoryElementInterface)databaseMeta, versionComment, monitor, overwrite);
                        }
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                    if (monitor != null) {
                        monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.SavingJobDetails", (String[])new String[0]));
                    }
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Saving job info to repository...");
                    }
                    this.insertJob(jobMeta);
                    if (monitor != null) {
                        monitor.worked(1);
                    }
                    for (i = 0; i < jobMeta.getSlaveServers().size(); ++i) {
                        SlaveServer slaveServer = jobMeta.getSlaveServers().get(i);
                        this.repository.save(slaveServer, versionComment, null, jobMeta.getObjectId(), false, overwrite);
                    }
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Saving notes to repository...");
                    }
                    for (i = 0; i < jobMeta.nrNotes(); ++i) {
                        if (monitor != null) {
                            monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.SavingNoteNr", (String[])new String[0]) + (i + 1) + "/" + jobMeta.nrNotes());
                        }
                        NotePadMeta ni = jobMeta.getNote(i);
                        this.repository.saveNotePadMeta(ni, jobMeta.getObjectId());
                        if (ni.getObjectId() != null) {
                            this.repository.insertJobNote(jobMeta.getObjectId(), ni.getObjectId());
                        }
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Saving " + jobMeta.nrJobEntries() + " Job enty copies to repository...");
                    }
                    this.repository.updateJobEntryTypes();
                    for (i = 0; i < jobMeta.nrJobEntries(); ++i) {
                        if (monitor != null) {
                            monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.SavingJobEntryNr", (String[])new String[0]) + (i + 1) + "/" + jobMeta.nrJobEntries());
                        }
                        JobEntryCopy cge = jobMeta.getJobEntry(i);
                        this.repository.jobEntryDelegate.saveJobEntryCopy(cge, jobMeta.getObjectId());
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                    if (this.log.isDetailed()) {
                        this.log.logDetailed("Saving job hops to repository...");
                    }
                    for (i = 0; i < jobMeta.nrJobHops(); ++i) {
                        if (monitor != null) {
                            monitor.subTask("Saving job hop #" + (i + 1) + "/" + jobMeta.nrJobHops());
                        }
                        JobHopMeta hi = jobMeta.getJobHop(i);
                        this.saveJobHopMeta(hi, jobMeta.getObjectId());
                        if (monitor == null) continue;
                        monitor.worked(1);
                    }
                    this.saveJobParameters(jobMeta);
                    this.repository.commit();
                    jobMeta.clearChanged();
                    if (monitor == null) break block27;
                    monitor.done();
                }
                catch (KettleDatabaseException dbe) {
                    this.repository.rollback();
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobMeta.Exception.UnableToSaveJobInRepositoryRollbackPerformed", (String[])new String[0]), (Throwable)dbe);
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.repository.unlockRepository();
            throw throwable;
        }
        this.repository.unlockRepository();
    }

    private void saveJobParameters(JobMeta jobMeta) throws KettleException {
        String[] paramKeys = jobMeta.listParameters();
        for (int idx = 0; idx < paramKeys.length; ++idx) {
            String desc = jobMeta.getParameterDescription(paramKeys[idx]);
            String defValue = jobMeta.getParameterDefault(paramKeys[idx]);
            this.insertJobParameter(jobMeta.getObjectId(), idx, paramKeys[idx], defValue, desc);
        }
    }

    public boolean existsJobMeta(String name, RepositoryDirectoryInterface repositoryDirectory, RepositoryObjectType objectType) throws KettleException {
        try {
            return this.getJobID(name, repositoryDirectory.getObjectId()) != null;
        }
        catch (KettleException e) {
            throw new KettleException("Unable to verify if the job with name [" + name + "] in directory [" + repositoryDirectory + "] exists", (Throwable)e);
        }
    }

    public JobMeta loadJobMeta(String jobname, RepositoryDirectoryInterface repdir) throws KettleException {
        return this.loadJobMeta(jobname, repdir, null);
    }

    public JobMeta loadJobMeta(String jobname, RepositoryDirectoryInterface repdir, ProgressMonitorListener monitor) throws KettleException {
        JobMeta jobMeta = new JobMeta();
        KettleDatabaseRepository kettleDatabaseRepository = this.repository;
        synchronized (kettleDatabaseRepository) {
            block33: {
                int i;
                jobMeta.clear();
                jobMeta.setRepositoryDirectory(repdir);
                jobMeta.setObjectId(this.getJobID(jobname, repdir.getObjectId()));
                if (jobMeta.getObjectId() == null) break block33;
                ObjectId[] noteids = this.repository.getJobNoteIDs(jobMeta.getObjectId());
                ObjectId[] jecids = this.repository.getJobEntryCopyIDs(jobMeta.getObjectId());
                ObjectId[] hopid = this.repository.getJobHopIDs(jobMeta.getObjectId());
                int nrWork = 2 + noteids.length + jecids.length + hopid.length;
                if (monitor != null) {
                    monitor.beginTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.LoadingJob", (String[])new String[0]) + repdir + Const.FILE_SEPARATOR + jobname, nrWork);
                }
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.ReadingJobInformation", (String[])new String[0]));
                }
                RowMetaAndData jobRow = this.getJob(jobMeta.getObjectId());
                jobMeta.setName(jobRow.getString("NAME", null));
                jobMeta.setDescription(jobRow.getString("DESCRIPTION", null));
                jobMeta.setExtendedDescription(jobRow.getString("EXTENDED_DESCRIPTION", null));
                jobMeta.setJobversion(jobRow.getString("JOB_VERSION", null));
                jobMeta.setJobstatus(Const.toInt((String)jobRow.getString("JOB_STATUS", null), (int)-1));
                jobMeta.setCreatedUser(jobRow.getString("CREATED_USER", null));
                jobMeta.setCreatedDate(jobRow.getDate("CREATED_DATE", new Date()));
                jobMeta.setModifiedUser(jobRow.getString("MODIFIED_USER", null));
                jobMeta.setModifiedDate(jobRow.getDate("MODIFIED_DATE", new Date()));
                long id_logdb = jobRow.getInteger("ID_DATABASE_LOG", 0L);
                if (id_logdb > 0L) {
                    DatabaseMeta logDb = this.repository.loadDatabaseMeta((ObjectId)new LongObjectId(id_logdb), null);
                    jobMeta.getJobLogTable().setConnectionName(logDb.getName());
                }
                jobMeta.getJobLogTable().setTableName(jobRow.getString("TABLE_NAME_LOG", null));
                jobMeta.getJobLogTable().setBatchIdUsed(jobRow.getBoolean("USE_BATCH_ID", false));
                jobMeta.getJobLogTable().setLogFieldUsed(jobRow.getBoolean("USE_LOGFIELD", false));
                jobMeta.getJobLogTable().setLogSizeLimit(this.getJobAttributeString(jobMeta.getObjectId(), 0, "LOG_SIZE_LIMIT"));
                jobMeta.setBatchIdPassed(jobRow.getBoolean("PASS_BATCH_ID", false));
                KettleDatabaseRepositoryJobAttribute attributeInterface = new KettleDatabaseRepositoryJobAttribute(this.repository.connectionDelegate, jobMeta.getObjectId());
                for (LogTableInterface logTable : jobMeta.getLogTables()) {
                    logTable.loadFromRepository((RepositoryAttributeInterface)attributeInterface);
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.ReadingAvailableDatabasesFromRepository", (String[])new String[0]));
                }
                try {
                    jobMeta.setSharedObjectsFile(jobRow.getString("SHARED_FILE", null));
                    jobMeta.setSharedObjects(this.repository != null ? this.repository.readJobMetaSharedObjects(jobMeta) : jobMeta.readSharedObjects());
                }
                catch (Exception e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"JobMeta.ErrorReadingSharedObjects.Message", (String[])new String[]{e.toString()}));
                    this.log.logError(Const.getStackTracker((Throwable)e));
                }
                if (monitor != null) {
                    monitor.worked(1);
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Loading " + noteids.length + " notes");
                }
                for (int i2 = 0; i2 < noteids.length; ++i2) {
                    NotePadMeta ni;
                    if (monitor != null) {
                        monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.ReadingNoteNr", (String[])new String[0]) + (i2 + 1) + "/" + noteids.length);
                    }
                    if (jobMeta.indexOfNote(ni = this.repository.notePadDelegate.loadNotePadMeta(noteids[i2])) < 0) {
                        jobMeta.addNote(ni);
                    }
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                ArrayList<JobEntryInterface> jobentries = new ArrayList<JobEntryInterface>();
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Loading " + jecids.length + " job entries");
                }
                for (i = 0; i < jecids.length; ++i) {
                    if (monitor != null) {
                        monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.ReadingJobEntryNr", (String[])new String[0]) + (i + 1) + "/" + jecids.length);
                    }
                    JobEntryCopy jec = this.repository.jobEntryDelegate.loadJobEntryCopy(jobMeta.getObjectId(), jecids[i], jobentries, jobMeta.getDatabases(), jobMeta.getSlaveServers());
                    int copyNr = 0;
                    for (JobEntryCopy copy : jobMeta.getJobCopies()) {
                        if (jec.getEntry() != copy.getEntry()) continue;
                        ++copyNr;
                    }
                    jec.setNr(copyNr);
                    int idx = jobMeta.indexOfJobEntry(jec);
                    if (idx < 0) {
                        if (jec.getName() != null && jec.getName().length() > 0) {
                            jobMeta.addJobEntry(jec);
                        }
                    } else {
                        jobMeta.setJobEntry(idx, jec);
                    }
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Loading " + hopid.length + " job hops");
                }
                for (i = 0; i < hopid.length; ++i) {
                    if (monitor != null) {
                        monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.ReadingJobHopNr", (String[])new String[0]) + (i + 1) + "/" + jecids.length);
                    }
                    JobHopMeta hi = this.loadJobHopMeta(hopid[i], jobMeta.getJobCopies());
                    jobMeta.getJobhops().add(hi);
                    if (monitor == null) continue;
                    monitor.worked(1);
                }
                this.loadRepParameters(jobMeta);
                jobMeta.clearChanged();
                if (monitor != null) {
                    monitor.subTask(BaseMessages.getString(PKG, (String)"JobMeta.Monitor.FinishedLoadOfJob", (String[])new String[0]));
                }
                if (monitor != null) {
                    monitor.done();
                }
                JobMeta jobMeta2 = jobMeta;
                {
                    Object var21_26 = null;
                    jobMeta.initializeVariablesFrom(jobMeta.getParentVariableSpace());
                    jobMeta.setInternalKettleVariables();
                }
                return jobMeta2;
            }
            try {
                try {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobMeta.Exception.CanNotFindJob", (String[])new String[0]) + jobname);
                }
                catch (KettleException dbe) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"JobMeta.Exception.AnErrorOccuredReadingJob", (String[])new String[]{jobname}), (Throwable)dbe);
                }
            }
            catch (Throwable throwable) {
                Object var21_27 = null;
                jobMeta.initializeVariablesFrom(jobMeta.getParentVariableSpace());
                jobMeta.setInternalKettleVariables();
                throw throwable;
            }
        }
    }

    private void loadRepParameters(JobMeta jobMeta) throws KettleException {
        jobMeta.eraseParameters();
        int count = this.countJobParameter(jobMeta.getObjectId());
        for (int idx = 0; idx < count; ++idx) {
            String key = this.getJobParameterKey(jobMeta.getObjectId(), idx);
            String defValue = this.getJobParameterDefault(jobMeta.getObjectId(), idx);
            String desc = this.getJobParameterDescription(jobMeta.getObjectId(), idx);
            jobMeta.addParameterDefinition(key, defValue, desc);
        }
    }

    public String getJobParameterKey(ObjectId id_job, int nr) throws KettleException {
        return this.repository.connectionDelegate.getJobAttributeString(id_job, nr, "PARAM_KEY");
    }

    public String getJobParameterDefault(ObjectId id_job, int nr) throws KettleException {
        return this.repository.connectionDelegate.getJobAttributeString(id_job, nr, "PARAM_DEFAULT");
    }

    public String getJobParameterDescription(ObjectId id_job, int nr) throws KettleException {
        return this.repository.connectionDelegate.getJobAttributeString(id_job, nr, "PARAM_DESC");
    }

    public void insertJobParameter(ObjectId id_job, long nr, String key, String defValue, String description) throws KettleException {
        this.repository.connectionDelegate.insertJobAttribute(id_job, nr, "PARAM_KEY", 0L, key != null ? key : "");
        this.repository.connectionDelegate.insertJobAttribute(id_job, nr, "PARAM_DEFAULT", 0L, defValue != null ? defValue : "");
        this.repository.connectionDelegate.insertJobAttribute(id_job, nr, "PARAM_DESC", 0L, description != null ? description : "");
    }

    public int countJobParameter(ObjectId id_job) throws KettleException {
        return this.repository.connectionDelegate.countNrJobAttributes(id_job, "PARAM_KEY");
    }

    public JobHopMeta loadJobHopMeta(ObjectId id_job_hop, List<JobEntryCopy> jobcopies) throws KettleException {
        JobHopMeta jobHopMeta = new JobHopMeta();
        try {
            RowMetaAndData r = this.getJobHop(id_job_hop);
            if (r != null) {
                long id_jobentry_copy_from = r.getInteger("ID_JOBENTRY_COPY_FROM", -1L);
                long id_jobentry_copy_to = r.getInteger("ID_JOBENTRY_COPY_TO", -1L);
                jobHopMeta.setEnabled(r.getBoolean("ENABLED", true));
                jobHopMeta.setEvaluation(r.getBoolean("EVALUATION", true));
                jobHopMeta.setConditional();
                if (r.getBoolean("UNCONDITIONAL", !jobHopMeta.getEvaluation())) {
                    jobHopMeta.setUnconditional();
                }
                jobHopMeta.setFromEntry(JobMeta.findJobEntryCopy(jobcopies, (ObjectId)new LongObjectId(id_jobentry_copy_from)));
                jobHopMeta.setToEntry(JobMeta.findJobEntryCopy(jobcopies, (ObjectId)new LongObjectId(id_jobentry_copy_to)));
                return jobHopMeta;
            }
            throw new KettleException("Unable to find job hop with ID : " + id_job_hop);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobHopMeta.Exception.UnableToLoadHopInfoRep", (String[])new String[]{"" + id_job_hop}), (Throwable)dbe);
        }
    }

    public void saveJobHopMeta(JobHopMeta hop, ObjectId id_job) throws KettleException {
        try {
            ObjectId id_jobentry_from = null;
            ObjectId id_jobentry_to = null;
            id_jobentry_from = hop.getFromEntry() == null ? null : hop.getFromEntry().getObjectId();
            id_jobentry_to = hop.getToEntry() == null ? null : hop.getToEntry().getObjectId();
            hop.setObjectId(this.insertJobHop(id_job, id_jobentry_from, id_jobentry_to, hop.isEnabled(), hop.getEvaluation(), hop.isUnconditional()));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobHopMeta.Exception.UnableToSaveHopInfoRep", (String[])new String[]{"" + id_job}), (Throwable)dbe);
        }
    }

    public void readDatabases(JobMeta jobMeta) throws KettleException {
        this.readDatabases(jobMeta, true);
    }

    public void readDatabases(JobMeta jobMeta, boolean overWriteShared) throws KettleException {
        try {
            ObjectId[] dbids = this.repository.getDatabaseIDs(false);
            for (int i = 0; i < dbids.length; ++i) {
                DatabaseMeta databaseMeta = this.repository.loadDatabaseMeta(dbids[i], null);
                databaseMeta.shareVariablesWith((VariableSpace)jobMeta);
                DatabaseMeta check = jobMeta.findDatabase(databaseMeta.getName());
                if (check != null && !overWriteShared || databaseMeta.getName() == null) continue;
                jobMeta.addOrReplaceDatabase(databaseMeta);
                if (overWriteShared) continue;
                databaseMeta.setChanged(false);
            }
            jobMeta.setChanged(false);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobMeta.Log.UnableToReadDatabaseIDSFromRepository", (String[])new String[0]), (Throwable)dbe);
        }
        catch (KettleException ke) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobMeta.Log.UnableToReadDatabasesFromRepository", (String[])new String[0]), (Throwable)ke);
        }
    }

    public void readSlaves(JobMeta jobMeta, boolean overWriteShared) throws KettleException {
        try {
            ObjectId[] dbids = this.repository.getSlaveIDs(false);
            for (int i = 0; i < dbids.length; ++i) {
                SlaveServer slaveServer = this.repository.loadSlaveServer(dbids[i], null);
                slaveServer.shareVariablesWith(jobMeta);
                SlaveServer check = jobMeta.findSlaveServer(slaveServer.getName());
                if (check != null && !overWriteShared || Const.isEmpty((String)slaveServer.getName())) continue;
                jobMeta.addOrReplaceSlaveServer(slaveServer);
                if (overWriteShared) continue;
                slaveServer.setChanged(false);
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"JobMeta.Log.UnableToReadSlaveServersFromRepository", (String[])new String[0]), (Throwable)dbe);
        }
    }

    public SharedObjects readSharedObjects(JobMeta jobMeta) throws KettleException {
        jobMeta.setSharedObjects(jobMeta.readSharedObjects());
        this.readDatabases(jobMeta, true);
        this.readSlaves(jobMeta, true);
        return jobMeta.getSharedObjects();
    }

    public synchronized ObjectId getJobID(String name, ObjectId id_directory) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_JOB"), this.quote("ID_JOB"), this.quote("NAME"), name, this.quote("ID_DIRECTORY"), id_directory);
    }

    public synchronized int getNrJobs() throws KettleException {
        int retval = 0;
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_JOB");
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql);
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrJobs(ObjectId id_directory) throws KettleException {
        int retval = 0;
        RowMetaAndData par = this.repository.connectionDelegate.getParameterMetaData(id_directory);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_JOB") + " WHERE " + this.quote("ID_DIRECTORY") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, par.getRowMeta(), par.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public synchronized int getNrJobHops(ObjectId id_job) throws KettleException {
        int retval = 0;
        RowMetaAndData par = this.repository.connectionDelegate.getParameterMetaData(id_job);
        String sql = "SELECT COUNT(*) FROM " + this.quoteTable("R_JOB_HOP") + " WHERE " + this.quote("ID_JOB") + " = ? ";
        RowMetaAndData r = this.repository.connectionDelegate.getOneRow(sql, par.getRowMeta(), par.getData());
        if (r != null) {
            retval = (int)r.getInteger(0, 0L);
        }
        return retval;
    }

    public String[] getJobsWithIDList(List<Object[]> list, RowMetaInterface rowMeta) throws KettleException {
        String[] jobList = new String[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            RowMetaAndData jobRow;
            long id_job = rowMeta.getInteger(list.get(i), this.quote("ID_JOB"), Long.valueOf(-1L));
            if (id_job <= 0L || (jobRow = this.getJob((ObjectId)new LongObjectId(id_job))) == null) continue;
            String jobName = jobRow.getString("NAME", "<name not found>");
            long id_directory = jobRow.getInteger("ID_DIRECTORY", -1L);
            RepositoryDirectoryInterface dir = this.repository.loadRepositoryDirectoryTree().findDirectory((ObjectId)new LongObjectId(id_directory));
            jobList[i] = dir.getPathObjectCombination(jobName);
        }
        return jobList;
    }

    public String[] getJobsWithIDList(ObjectId[] ids) throws KettleException {
        String[] jobsList = new String[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            RowMetaAndData transRow;
            ObjectId id_job = ids[i];
            if (id_job == null || (transRow = this.getJob(id_job)) == null) continue;
            String jobName = transRow.getString("NAME", "<name not found>");
            long id_directory = transRow.getInteger("ID_DIRECTORY", -1L);
            RepositoryDirectoryInterface dir = this.repository.loadRepositoryDirectoryTree().findDirectory((ObjectId)new LongObjectId(id_directory));
            jobsList[i] = dir.getPathObjectCombination(jobName);
        }
        return jobsList;
    }

    private synchronized void insertJob(JobMeta jobMeta) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)jobMeta.getObjectId());
        table.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)jobMeta.getRepositoryDirectory().getObjectId());
        table.addValue(new ValueMeta("NAME", 2), (Object)jobMeta.getName());
        table.addValue(new ValueMeta("DESCRIPTION", 2), (Object)jobMeta.getDescription());
        table.addValue(new ValueMeta("EXTENDED_DESCRIPTION", 2), (Object)jobMeta.getExtendedDescription());
        table.addValue(new ValueMeta("JOB_VERSION", 2), (Object)jobMeta.getJobversion());
        table.addValue(new ValueMeta("JOB_STATUS", 5), (Object)new Long(jobMeta.getJobstatus() < 0 ? -1L : (long)jobMeta.getJobstatus()));
        table.addValue(new ValueMeta("ID_DATABASE_LOG", 5), jobMeta.getJobLogTable().getDatabaseMeta() != null ? jobMeta.getJobLogTable().getDatabaseMeta().getObjectId() : Long.valueOf(-1L));
        table.addValue(new ValueMeta("TABLE_NAME_LOG", 2), (Object)jobMeta.getJobLogTable().getTableName());
        table.addValue(new ValueMeta("USE_BATCH_ID", 4), (Object)jobMeta.getJobLogTable().isBatchIdUsed());
        table.addValue(new ValueMeta("USE_LOGFIELD", 4), (Object)jobMeta.getJobLogTable().isLogFieldUsed());
        this.repository.connectionDelegate.insertJobAttribute(jobMeta.getObjectId(), 0L, "LOG_SIZE_LIMIT", 0L, jobMeta.getJobLogTable().getLogSizeLimit());
        table.addValue(new ValueMeta("CREATED_USER", 2), (Object)jobMeta.getCreatedUser());
        table.addValue(new ValueMeta("CREATED_DATE", 3), (Object)jobMeta.getCreatedDate());
        table.addValue(new ValueMeta("MODIFIED_USER", 2), (Object)jobMeta.getModifiedUser());
        table.addValue(new ValueMeta("MODIFIED_DATE", 3), (Object)jobMeta.getModifiedDate());
        table.addValue(new ValueMeta("PASS_BATCH_ID", 4), (Object)jobMeta.isBatchIdPassed());
        table.addValue(new ValueMeta("SHARED_FILE", 2), (Object)jobMeta.getSharedObjectsFile());
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_JOB");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        if (this.log.isDebug()) {
            this.log.logDebug("Inserted new record into table " + this.quoteTable("R_JOB") + " with data : " + table);
        }
        this.repository.connectionDelegate.getDatabase().closeInsert();
        if (jobMeta.getJobLogTable().getDatabaseMeta() != null) {
            this.repository.insertJobEntryDatabase(jobMeta.getObjectId(), null, jobMeta.getJobLogTable().getDatabaseMeta().getObjectId());
        }
        KettleDatabaseRepositoryJobAttribute attributeInterface = new KettleDatabaseRepositoryJobAttribute(this.repository.connectionDelegate, jobMeta.getObjectId());
        for (LogTableInterface logTable : jobMeta.getLogTables()) {
            logTable.saveToRepository((RepositoryAttributeInterface)attributeInterface);
        }
    }

    public synchronized ObjectId insertJobHop(ObjectId id_job, ObjectId id_jobentry_copy_from, ObjectId id_jobentry_copy_to, boolean enabled, boolean evaluation, boolean unconditional) throws KettleException {
        ObjectId id = this.repository.connectionDelegate.getNextJobHopID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_JOB_HOP", 5), (Object)id);
        table.addValue(new ValueMeta("ID_JOB", 5), (Object)id_job);
        table.addValue(new ValueMeta("ID_JOBENTRY_COPY_FROM", 5), (Object)id_jobentry_copy_from);
        table.addValue(new ValueMeta("ID_JOBENTRY_COPY_TO", 5), (Object)id_jobentry_copy_to);
        table.addValue(new ValueMeta("ENABLED", 4), (Object)enabled);
        table.addValue(new ValueMeta("EVALUATION", 4), (Object)evaluation);
        table.addValue(new ValueMeta("UNCONDITIONAL", 4), (Object)unconditional);
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_JOB_HOP");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public String getJobAttributeString(ObjectId id_job, int nr, String code) throws KettleException {
        return this.repository.connectionDelegate.getJobAttributeString(id_job, nr, code);
    }

    public long getJobAttributeInteger(ObjectId id_job, int nr, String code) throws KettleException {
        return this.repository.connectionDelegate.getJobAttributeInteger(id_job, nr, code);
    }

    public boolean getJobAttributeBoolean(ObjectId id_job, int nr, String code) throws KettleException {
        return this.repository.connectionDelegate.getJobAttributeBoolean(id_job, nr, code);
    }

    public synchronized void moveJob(String jobname, ObjectId id_directory_from, ObjectId id_directory_to) throws KettleException {
        String sql = "UPDATE " + this.quoteTable("R_JOB") + " SET " + this.quote("ID_DIRECTORY") + " = ? WHERE " + this.quote("NAME") + " = ? AND " + this.quote("ID_DIRECTORY") + " = ?";
        RowMetaAndData par = new RowMetaAndData();
        par.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)id_directory_to);
        par.addValue(new ValueMeta("NAME", 2), (Object)jobname);
        par.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)id_directory_from);
        this.repository.connectionDelegate.getDatabase().execStatement(sql, par.getRowMeta(), par.getData());
    }

    public synchronized void renameJob(ObjectId id_job, RepositoryDirectoryInterface newParentDir, String newname) throws KettleException {
        if (newParentDir != null || newname != null) {
            RowMetaAndData table = new RowMetaAndData();
            String sql = "UPDATE " + this.quoteTable("R_JOB") + " SET ";
            boolean additionalParameter = false;
            if (newname != null) {
                additionalParameter = true;
                sql = sql + this.quote("NAME") + " = ? ";
                table.addValue(new ValueMeta("NAME", 2), (Object)newname);
            }
            if (newParentDir != null) {
                if (additionalParameter) {
                    sql = sql + ", ";
                }
                sql = sql + this.quote("ID_DIRECTORY") + " = ? ";
                table.addValue(new ValueMeta("ID_DIRECTORY", 5), (Object)newParentDir.getObjectId());
            }
            sql = sql + "WHERE " + this.quote("ID_JOB") + " = ?";
            table.addValue(new ValueMeta("ID_JOB", 5), (Object)id_job);
            this.log.logBasic("sql = [" + sql + "]");
            this.log.logBasic("row = [" + table + "]");
            this.repository.connectionDelegate.getDatabase().execStatement(sql, table.getRowMeta(), table.getData());
        }
    }
}

