/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.repository.kdr.delegates;

import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleObjectExistsException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.kdr.KettleDatabaseRepository;
import org.pentaho.di.repository.kdr.delegates.KettleDatabaseRepositoryBaseDelegate;

public class KettleDatabaseRepositorySlaveServerDelegate
extends KettleDatabaseRepositoryBaseDelegate {
    private static Class<?> PKG = SlaveServer.class;

    public KettleDatabaseRepositorySlaveServerDelegate(KettleDatabaseRepository repository) {
        super(repository);
    }

    public RowMetaAndData getSlaveServer(ObjectId id_slave) throws KettleException {
        return this.repository.connectionDelegate.getOneRow(this.quoteTable("R_SLAVE"), this.quote("ID_SLAVE"), id_slave);
    }

    public synchronized ObjectId getSlaveID(String name) throws KettleException {
        return this.repository.connectionDelegate.getIDWithValue(this.quoteTable("R_SLAVE"), this.quote("ID_SLAVE"), this.quote("NAME"), name);
    }

    public void saveSlaveServer(SlaveServer slaveServer) throws KettleException {
        this.saveSlaveServer(slaveServer, null, false);
    }

    public void saveSlaveServer(SlaveServer slaveServer, ObjectId id_transformation, boolean isUsedByTransformation) throws KettleException {
        try {
            this.saveSlaveServer(slaveServer, id_transformation, isUsedByTransformation, false);
        }
        catch (KettleObjectExistsException e) {
            this.log.logBasic(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveSlaveServer(SlaveServer slaveServer, ObjectId id_transformation, boolean isUsedByTransformation, boolean overwrite) throws KettleException {
        if (slaveServer.getObjectId() == null) {
            slaveServer.setObjectId(this.getSlaveID(slaveServer.getName()));
        }
        if (slaveServer.getObjectId() == null) {
            slaveServer.setObjectId(this.insertSlave(slaveServer));
        } else {
            ObjectId existingSlaveId = slaveServer.getObjectId();
            if (existingSlaveId != null && slaveServer.getObjectId() != null && !slaveServer.getObjectId().equals(existingSlaveId)) {
                if (!overwrite) throw new KettleObjectExistsException("Failed to save object to repository. Object [" + slaveServer.getName() + "] already exists.");
                this.repository.deleteSlave(existingSlaveId);
                this.updateSlave(slaveServer);
            } else {
                this.updateSlave(slaveServer);
            }
        }
        if (id_transformation == null || !isUsedByTransformation) return;
        this.repository.insertTransformationSlave(id_transformation, slaveServer.getObjectId());
    }

    public SlaveServer loadSlaveServer(ObjectId id_slave_server) throws KettleException {
        SlaveServer slaveServer = new SlaveServer();
        slaveServer.setObjectId(id_slave_server);
        RowMetaAndData row = this.getSlaveServer(id_slave_server);
        if (row == null) {
            throw new KettleDatabaseException(BaseMessages.getString(PKG, (String)"SlaveServer.SlaveCouldNotBeFound", (String[])new String[]{id_slave_server.toString()}));
        }
        slaveServer.setName(row.getString("NAME", null));
        slaveServer.setHostname(row.getString("HOST_NAME", null));
        slaveServer.setPort(row.getString("PORT", null));
        slaveServer.setWebAppName(row.getString("WEB_APP_NAME", null));
        slaveServer.setUsername(row.getString("USERNAME", null));
        slaveServer.setPassword(Encr.decryptPasswordOptionallyEncrypted((String)row.getString("PASSWORD", null)));
        slaveServer.setProxyHostname(row.getString("PROXY_HOST_NAME", null));
        slaveServer.setProxyPort(row.getString("PROXY_PORT", null));
        slaveServer.setNonProxyHosts(row.getString("NON_PROXY_HOSTS", null));
        slaveServer.setMaster(row.getBoolean("MASTER", false));
        return slaveServer;
    }

    public synchronized ObjectId insertSlave(SlaveServer slaveServer) throws KettleException {
        if (this.getSlaveID(slaveServer.getName()) != null) {
            throw new KettleObjectExistsException("Failed to create object in repository. Object [" + slaveServer.getName() + "] already exists.");
        }
        ObjectId id = this.repository.connectionDelegate.getNextSlaveServerID();
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("ID_SLAVE", 5), (Object)id);
        table.addValue(new ValueMeta("NAME", 2), (Object)slaveServer.getName());
        table.addValue(new ValueMeta("HOST_NAME", 2), (Object)slaveServer.getHostname());
        table.addValue(new ValueMeta("PORT", 2), (Object)slaveServer.getPort());
        table.addValue(new ValueMeta("WEB_APP_NAME", 2), (Object)slaveServer.getWebAppName());
        table.addValue(new ValueMeta("USERNAME", 2), (Object)slaveServer.getUsername());
        table.addValue(new ValueMeta("PASSWORD", 2), (Object)Encr.encryptPasswordIfNotUsingVariables((String)slaveServer.getPassword()));
        table.addValue(new ValueMeta("PROXY_HOST_NAME", 2), (Object)slaveServer.getProxyHostname());
        table.addValue(new ValueMeta("PROXY_PORT", 2), (Object)slaveServer.getProxyPort());
        table.addValue(new ValueMeta("NON_PROXY_HOSTS", 2), (Object)slaveServer.getNonProxyHosts());
        table.addValue(new ValueMeta("MASTER", 4), (Object)slaveServer.isMaster());
        this.repository.connectionDelegate.getDatabase().prepareInsert(table.getRowMeta(), "R_SLAVE");
        this.repository.connectionDelegate.getDatabase().setValuesInsert(table);
        this.repository.connectionDelegate.getDatabase().insertRow();
        this.repository.connectionDelegate.getDatabase().closeInsert();
        return id;
    }

    public synchronized void updateSlave(SlaveServer slaveServer) throws KettleException {
        RowMetaAndData table = new RowMetaAndData();
        table.addValue(new ValueMeta("NAME", 2), (Object)slaveServer.getName());
        table.addValue(new ValueMeta("HOST_NAME", 2), (Object)slaveServer.getHostname());
        table.addValue(new ValueMeta("PORT", 2), (Object)slaveServer.getPort());
        table.addValue(new ValueMeta("WEB_APP_NAME", 2), (Object)slaveServer.getWebAppName());
        table.addValue(new ValueMeta("USERNAME", 2), (Object)slaveServer.getUsername());
        table.addValue(new ValueMeta("PASSWORD", 2), (Object)Encr.encryptPasswordIfNotUsingVariables((String)slaveServer.getPassword()));
        table.addValue(new ValueMeta("PROXY_HOST_NAME", 2), (Object)slaveServer.getProxyHostname());
        table.addValue(new ValueMeta("PROXY_PORT", 2), (Object)slaveServer.getProxyPort());
        table.addValue(new ValueMeta("NON_PROXY_HOSTS", 2), (Object)slaveServer.getNonProxyHosts());
        table.addValue(new ValueMeta("MASTER", 4), (Object)slaveServer.isMaster());
        this.repository.connectionDelegate.updateTableRow("R_SLAVE", "ID_SLAVE", table, slaveServer.getObjectId());
    }
}

