/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.BasePartitioner;
import org.pentaho.di.trans.Partitioner;
import org.w3c.dom.Node;

public class ModPartitioner
extends BasePartitioner {
    private String fieldName;
    protected int partitionColumnIndex = -1;

    public Partitioner getInstance() {
        ModPartitioner partitioner = new ModPartitioner();
        partitioner.setId(this.getId());
        partitioner.setDescription(this.getDescription());
        return partitioner;
    }

    public ModPartitioner clone() {
        ModPartitioner modPartitioner = (ModPartitioner)super.clone();
        modPartitioner.fieldName = this.fieldName;
        return modPartitioner;
    }

    public String getDialogClassName() {
        return "org.pentaho.di.ui.trans.dialog.ModPartitionerDialog";
    }

    public int getPartition(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        long value;
        this.init(rowMeta);
        if (this.partitionColumnIndex < 0) {
            this.partitionColumnIndex = rowMeta.indexOfValue(this.fieldName);
            if (this.partitionColumnIndex < 0) {
                throw new KettleStepException("Unable to find partitioning field name [" + this.fieldName + "] in the output row..." + rowMeta);
            }
        }
        ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.partitionColumnIndex);
        Object valueData = row[this.partitionColumnIndex];
        switch (valueMeta.getType()) {
            case 5: {
                Long longValue = rowMeta.getInteger(row, this.partitionColumnIndex);
                value = longValue == null ? (long)valueMeta.hashCode(valueData) : longValue;
            }
        }
        value = valueMeta.hashCode(valueData);
        int targetLocation = (int)(Math.abs(value) % (long)this.nrPartitions);
        return targetLocation;
    }

    public String getDescription() {
        String description = "Mod partitioner";
        if (!Const.isEmpty((String)this.fieldName)) {
            description = description + "(" + this.fieldName + ")";
        }
        return description;
    }

    public String getXML() {
        StringBuilder xml = new StringBuilder(150);
        xml.append("           ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldName));
        return xml.toString();
    }

    public void loadXML(Node partitioningMethodNode) throws KettleXMLException {
        this.fieldName = XMLHandler.getTagValue((Node)partitioningMethodNode, (String)"field_name");
    }

    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        rep.saveStepAttribute(id_transformation, id_step, "PARTITIONING_FIELDNAME", this.fieldName);
    }

    public void loadRep(Repository rep, ObjectId id_step) throws KettleException {
        this.fieldName = rep.getStepAttributeString(id_step, "PARTITIONING_FIELDNAME");
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }
}

