/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans;

import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.groupby.GroupByMeta;
import org.pentaho.di.trans.steps.tableinput.TableInputMeta;

public class TransProfileFactory {
    public static final String RESULT_STEP_NAME = "calc stats";
    private DatabaseMeta databaseMeta;
    private String schemaTable;
    private RowMetaInterface tableLayout;

    public TransProfileFactory(DatabaseMeta databaseMeta, String schemaTable) {
        this.databaseMeta = databaseMeta;
        this.schemaTable = schemaTable;
    }

    public TransMeta generateTransformation(LoggingObjectInterface parentLoggingInterface) throws KettleException {
        PluginRegistry registry = PluginRegistry.getInstance();
        this.tableLayout = this.getTableFields(parentLoggingInterface);
        TransMeta transMeta = new TransMeta((VariableSpace)this.databaseMeta);
        transMeta.addDatabase(this.databaseMeta);
        TableInputMeta readMeta = new TableInputMeta();
        readMeta.setSQL("SELECT * FROM " + this.schemaTable);
        readMeta.setDatabaseMeta(this.databaseMeta);
        StepMeta read = new StepMeta(registry.getPluginId(StepPluginType.class, (Object)readMeta), "Read data", readMeta);
        read.setLocation(50, 50);
        read.setDraw(true);
        transMeta.addStep(read);
        int[] numericCalculations = new int[]{3, 4, 1, 5, 2, 13};
        int[] stringCalculations = new int[]{3, 4, 5};
        int[] dateCalculations = new int[]{3, 4, 5};
        int[] booleanCalculations = new int[]{3, 4, 5};
        GroupByMeta statsMeta = new GroupByMeta();
        int nrNumeric = 0;
        int nrDates = 0;
        int nrStrings = 0;
        int nrBooleans = 0;
        for (ValueMetaInterface valueMeta : this.tableLayout.getValueMetaList()) {
            if (valueMeta.isNumeric()) {
                ++nrNumeric;
            }
            if (valueMeta.isDate()) {
                ++nrDates;
            }
            if (valueMeta.isString()) {
                ++nrStrings;
            }
            if (!valueMeta.isBoolean()) continue;
            ++nrBooleans;
        }
        int nrCalculations = nrNumeric * numericCalculations.length + nrDates * dateCalculations.length + nrStrings * stringCalculations.length + nrBooleans * booleanCalculations.length;
        statsMeta.allocate(0, nrCalculations);
        int calcIndex = 0;
        for (int i = 0; i < this.tableLayout.size(); ++i) {
            int c;
            ValueMetaInterface valueMeta = this.tableLayout.getValueMeta(i);
            if (valueMeta.isNumeric()) {
                for (c = 0; c < numericCalculations.length; ++c) {
                    statsMeta.getAggregateField()[calcIndex] = valueMeta.getName() + "(" + GroupByMeta.getTypeDesc(numericCalculations[c]) + ")";
                    statsMeta.getSubjectField()[calcIndex] = valueMeta.getName();
                    statsMeta.getAggregateType()[calcIndex] = numericCalculations[c];
                    ++calcIndex;
                }
            }
            if (valueMeta.isString()) {
                for (c = 0; c < stringCalculations.length; ++c) {
                    statsMeta.getAggregateField()[calcIndex] = valueMeta.getName() + "(" + GroupByMeta.getTypeDesc(stringCalculations[c]) + ")";
                    statsMeta.getSubjectField()[calcIndex] = valueMeta.getName();
                    statsMeta.getAggregateType()[calcIndex] = stringCalculations[c];
                    ++calcIndex;
                }
            }
            if (valueMeta.isDate()) {
                for (c = 0; c < dateCalculations.length; ++c) {
                    statsMeta.getAggregateField()[calcIndex] = valueMeta.getName() + "(" + GroupByMeta.getTypeDesc(dateCalculations[c]) + ")";
                    statsMeta.getSubjectField()[calcIndex] = valueMeta.getName();
                    statsMeta.getAggregateType()[calcIndex] = dateCalculations[c];
                    ++calcIndex;
                }
            }
            if (!valueMeta.isBoolean()) continue;
            for (c = 0; c < booleanCalculations.length; ++c) {
                statsMeta.getAggregateField()[calcIndex] = valueMeta.getName() + "(" + GroupByMeta.getTypeDesc(booleanCalculations[c]) + ")";
                statsMeta.getSubjectField()[calcIndex] = valueMeta.getName();
                statsMeta.getAggregateType()[calcIndex] = booleanCalculations[c];
                ++calcIndex;
            }
        }
        StepMeta calc = new StepMeta(registry.getPluginId(StepPluginType.class, (Object)statsMeta), "Calc", statsMeta);
        calc.setLocation(250, 50);
        calc.setDraw(true);
        transMeta.addStep(calc);
        TransHopMeta hop = new TransHopMeta(read, calc);
        transMeta.addTransHop(hop);
        DummyTransMeta dummyMeta = new DummyTransMeta();
        StepMeta result = new StepMeta(registry.getPluginId(StepPluginType.class, (Object)dummyMeta), RESULT_STEP_NAME, dummyMeta);
        result.setLocation(450, 50);
        result.setDraw(true);
        transMeta.addStep(result);
        TransHopMeta hop2 = new TransHopMeta(calc, result);
        transMeta.addTransHop(hop2);
        return transMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowMetaInterface getTableFields(LoggingObjectInterface parentLoggingObject) throws KettleDatabaseException {
        RowMetaInterface rowMetaInterface;
        Database database = new Database(parentLoggingObject, this.databaseMeta);
        try {
            database.connect();
            rowMetaInterface = database.getTableFields(this.schemaTable);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            database.disconnect();
            throw throwable;
        }
        database.disconnect();
        return rowMetaInterface;
    }

    public RowMetaInterface getTableLayout() {
        return this.tableLayout;
    }
}

