/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.debug;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.debug.BreakPointListener;
import org.pentaho.di.trans.debug.StepDebugMeta;
import org.pentaho.di.trans.step.RowAdapter;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransDebugMeta {
    public static final String XML_TAG = "trans-debug-meta";
    public static final String XML_TAG_STEP_DEBUG_METAS = "step-debug-metas";
    private TransMeta transMeta;
    private Map<StepMeta, StepDebugMeta> stepDebugMetaMap;

    public TransDebugMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
        this.stepDebugMetaMap = new HashMap<StepMeta, StepDebugMeta>();
    }

    public TransMeta getTransMeta() {
        return this.transMeta;
    }

    public void setTransMeta(TransMeta transMeta) {
        this.transMeta = transMeta;
    }

    public Map<StepMeta, StepDebugMeta> getStepDebugMetaMap() {
        return this.stepDebugMetaMap;
    }

    public void setStepDebugMetaMap(Map<StepMeta, StepDebugMeta> stepDebugMeta) {
        this.stepDebugMetaMap = stepDebugMeta;
    }

    public synchronized void addRowListenersToTransformation(final Trans trans) {
        final TransDebugMeta self = this;
        for (StepMeta stepMeta : this.stepDebugMetaMap.keySet()) {
            final StepDebugMeta stepDebugMeta = this.stepDebugMetaMap.get(stepMeta);
            for (StepInterface baseStep : trans.findBaseSteps(stepMeta.getName())) {
                baseStep.addRowListener(new RowAdapter(){

                    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
                        try {
                            int rowCount = stepDebugMeta.getRowCount();
                            if (stepDebugMeta.isReadingFirstRows() && rowCount > 0) {
                                int bufferSize = stepDebugMeta.getRowBuffer().size();
                                if (bufferSize < rowCount) {
                                    stepDebugMeta.setRowBufferMeta(rowMeta);
                                    stepDebugMeta.getRowBuffer().add(rowMeta.cloneRow(row));
                                } else {
                                    trans.pauseRunning();
                                    stepDebugMeta.fireBreakPointListeners(self);
                                }
                            } else if (stepDebugMeta.isPausingOnBreakPoint() && stepDebugMeta.getCondition() != null) {
                                if (rowCount > 0) {
                                    stepDebugMeta.setRowBufferMeta(rowMeta);
                                    stepDebugMeta.getRowBuffer().add(0, rowMeta.cloneRow(row));
                                    int bufferSize = stepDebugMeta.getRowBuffer().size();
                                    if (bufferSize > rowCount) {
                                        stepDebugMeta.getRowBuffer().remove(bufferSize - 1);
                                    }
                                } else if (stepDebugMeta.getRowBuffer().isEmpty()) {
                                    stepDebugMeta.getRowBuffer().add(rowMeta.cloneRow(row));
                                } else {
                                    stepDebugMeta.getRowBuffer().set(0, rowMeta.cloneRow(row));
                                }
                                if (stepDebugMeta.getCondition().evaluate(rowMeta, row)) {
                                    trans.pauseRunning();
                                    stepDebugMeta.fireBreakPointListeners(self);
                                }
                            }
                        }
                        catch (KettleException e) {
                            throw new KettleStepException((Throwable)e);
                        }
                    }
                });
            }
        }
    }

    public void addBreakPointListers(BreakPointListener breakPointListener) {
        for (StepDebugMeta stepDebugMeta : this.stepDebugMetaMap.values()) {
            stepDebugMeta.addBreakPointListener(breakPointListener);
        }
    }

    public int getTotalNumberOfHits() {
        int total = 0;
        for (StepDebugMeta stepDebugMeta : this.stepDebugMetaMap.values()) {
            total += stepDebugMeta.getNumberOfHits();
        }
        return total;
    }

    public int getNrOfUsedSteps() {
        int nr = 0;
        for (StepDebugMeta stepDebugMeta : this.stepDebugMetaMap.values()) {
            if (stepDebugMeta.isReadingFirstRows() && stepDebugMeta.getRowCount() > 0) {
                ++nr;
                continue;
            }
            if (!stepDebugMeta.isPausingOnBreakPoint() || stepDebugMeta.getCondition() == null || stepDebugMeta.getCondition().isEmpty()) continue;
            ++nr;
        }
        return nr;
    }
}

