/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.core.xml.XMLInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepErrorMeta
extends ChangedFlag
implements XMLInterface,
Cloneable {
    public static final String XML_TAG = "error";
    private StepMeta sourceStep;
    private StepMeta targetStep;
    private boolean enabled;
    private String nrErrorsValuename;
    private String errorDescriptionsValuename;
    private String errorFieldsValuename;
    private String errorCodesValuename;
    private String maxErrors = "";
    private String maxPercentErrors = "";
    private String minPercentRows = "";
    private VariableSpace variables;

    public StepErrorMeta(VariableSpace space, StepMeta sourceStep) {
        this.sourceStep = sourceStep;
        this.enabled = false;
        this.variables = space;
    }

    public StepErrorMeta(VariableSpace space, StepMeta sourceStep, StepMeta targetStep) {
        this.sourceStep = sourceStep;
        this.targetStep = targetStep;
        this.enabled = false;
        this.variables = space;
    }

    public StepErrorMeta(VariableSpace space, StepMeta sourceStep, StepMeta targetStep, String nrErrorsValuename, String errorDescriptionsValuename, String errorFieldsValuename, String errorCodesValuename) {
        this.sourceStep = sourceStep;
        this.targetStep = targetStep;
        this.enabled = false;
        this.nrErrorsValuename = nrErrorsValuename;
        this.errorDescriptionsValuename = errorDescriptionsValuename;
        this.errorFieldsValuename = errorFieldsValuename;
        this.errorCodesValuename = errorCodesValuename;
        this.variables = space;
    }

    public StepErrorMeta clone() {
        try {
            return (StepErrorMeta)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public String getXML() {
        StringBuffer xml = new StringBuffer(300);
        xml.append("      ").append(XMLHandler.openTag((String)XML_TAG)).append(Const.CR);
        xml.append("        ").append(XMLHandler.addTagValue((String)"source_step", (String)(this.sourceStep != null ? this.sourceStep.getName() : "")));
        xml.append("        ").append(XMLHandler.addTagValue((String)"target_step", (String)(this.targetStep != null ? this.targetStep.getName() : "")));
        xml.append("        ").append(XMLHandler.addTagValue((String)"is_enabled", (boolean)this.enabled));
        xml.append("        ").append(XMLHandler.addTagValue((String)"nr_valuename", (String)this.nrErrorsValuename));
        xml.append("        ").append(XMLHandler.addTagValue((String)"descriptions_valuename", (String)this.errorDescriptionsValuename));
        xml.append("        ").append(XMLHandler.addTagValue((String)"fields_valuename", (String)this.errorFieldsValuename));
        xml.append("        ").append(XMLHandler.addTagValue((String)"codes_valuename", (String)this.errorCodesValuename));
        xml.append("        ").append(XMLHandler.addTagValue((String)"max_errors", (String)this.maxErrors));
        xml.append("        ").append(XMLHandler.addTagValue((String)"max_pct_errors", (String)this.maxPercentErrors));
        xml.append("        ").append(XMLHandler.addTagValue((String)"min_pct_rows", (String)this.minPercentRows));
        xml.append("      ").append(XMLHandler.closeTag((String)XML_TAG)).append(Const.CR);
        return xml.toString();
    }

    public StepErrorMeta(VariableSpace variables, Node node, List<StepMeta> steps) {
        this.variables = variables;
        this.sourceStep = StepMeta.findStep(steps, XMLHandler.getTagValue((Node)node, (String)"source_step"));
        this.targetStep = StepMeta.findStep(steps, XMLHandler.getTagValue((Node)node, (String)"target_step"));
        this.enabled = "Y".equals(XMLHandler.getTagValue((Node)node, (String)"is_enabled"));
        this.nrErrorsValuename = XMLHandler.getTagValue((Node)node, (String)"nr_valuename");
        this.errorDescriptionsValuename = XMLHandler.getTagValue((Node)node, (String)"descriptions_valuename");
        this.errorFieldsValuename = XMLHandler.getTagValue((Node)node, (String)"fields_valuename");
        this.errorCodesValuename = XMLHandler.getTagValue((Node)node, (String)"codes_valuename");
        this.maxErrors = XMLHandler.getTagValue((Node)node, (String)"max_errors");
        this.maxPercentErrors = XMLHandler.getTagValue((Node)node, (String)"max_pct_errors");
        this.minPercentRows = XMLHandler.getTagValue((Node)node, (String)"min_pct_rows");
    }

    public String getErrorCodesValuename() {
        return this.errorCodesValuename;
    }

    public void setErrorCodesValuename(String errorCodesValuename) {
        this.errorCodesValuename = errorCodesValuename;
    }

    public String getErrorDescriptionsValuename() {
        return this.errorDescriptionsValuename;
    }

    public void setErrorDescriptionsValuename(String errorDescriptionsValuename) {
        this.errorDescriptionsValuename = errorDescriptionsValuename;
    }

    public String getErrorFieldsValuename() {
        return this.errorFieldsValuename;
    }

    public void setErrorFieldsValuename(String errorFieldsValuename) {
        this.errorFieldsValuename = errorFieldsValuename;
    }

    public String getNrErrorsValuename() {
        return this.nrErrorsValuename;
    }

    public void setNrErrorsValuename(String nrErrorsValuename) {
        this.nrErrorsValuename = nrErrorsValuename;
    }

    public StepMeta getTargetStep() {
        return this.targetStep;
    }

    public void setTargetStep(StepMeta targetStep) {
        this.targetStep = targetStep;
    }

    public StepMeta getSourceStep() {
        return this.sourceStep;
    }

    public void setSourceStep(StepMeta sourceStep) {
        this.sourceStep = sourceStep;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public RowMetaInterface getErrorFields() {
        return this.getErrorRowMeta(0L, null, null, null);
    }

    public RowMetaInterface getErrorRowMeta(long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) {
        String errCodes;
        String errFields;
        String errDesc;
        RowMeta row = new RowMeta();
        String nrErr = this.variables.environmentSubstitute(this.getNrErrorsValuename());
        if (!Const.isEmpty((String)nrErr)) {
            ValueMeta v = new ValueMeta(nrErr, 5);
            v.setLength(3);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)(errDesc = this.variables.environmentSubstitute(this.getErrorDescriptionsValuename())))) {
            ValueMeta v = new ValueMeta(errDesc, 2);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)(errFields = this.variables.environmentSubstitute(this.getErrorFieldsValuename())))) {
            ValueMeta v = new ValueMeta(errFields, 2);
            row.addValueMeta((ValueMetaInterface)v);
        }
        if (!Const.isEmpty((String)(errCodes = this.variables.environmentSubstitute(this.getErrorCodesValuename())))) {
            ValueMeta v = new ValueMeta(errCodes, 2);
            row.addValueMeta((ValueMetaInterface)v);
        }
        return row;
    }

    public void addErrorRowData(Object[] row, int startIndex, long nrErrors, String errorDescriptions, String fieldNames, String errorCodes) {
        String errCodes;
        String errFields;
        String errDesc;
        int index = startIndex;
        String nrErr = this.variables.environmentSubstitute(this.getNrErrorsValuename());
        if (!Const.isEmpty((String)nrErr)) {
            row[index] = new Long(nrErrors);
            ++index;
        }
        if (!Const.isEmpty((String)(errDesc = this.variables.environmentSubstitute(this.getErrorDescriptionsValuename())))) {
            row[index] = errorDescriptions;
            ++index;
        }
        if (!Const.isEmpty((String)(errFields = this.variables.environmentSubstitute(this.getErrorFieldsValuename())))) {
            row[index] = fieldNames;
            ++index;
        }
        if (!Const.isEmpty((String)(errCodes = this.variables.environmentSubstitute(this.getErrorCodesValuename())))) {
            row[index] = errorCodes;
            ++index;
        }
    }

    public String getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(String maxErrors) {
        this.maxErrors = maxErrors;
    }

    public String getMaxPercentErrors() {
        return this.maxPercentErrors;
    }

    public void setMaxPercentErrors(String maxPercentErrors) {
        this.maxPercentErrors = maxPercentErrors;
    }

    public String getMinPercentRows() {
        return this.minPercentRows;
    }

    public void setMinPercentRows(String minRowsForPercent) {
        this.minPercentRows = minRowsForPercent;
    }
}

