/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.changefileencoding;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.changefileencoding.ChangeFileEncoding;
import org.pentaho.di.trans.steps.changefileencoding.ChangeFileEncodingData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeFileEncodingMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ChangeFileEncoding.class;
    private boolean addsourceresultfilenames;
    private boolean addtargetresultfilenames;
    private String filenamefield;
    private String targetfilenamefield;
    private String targetencoding;
    private String sourceencoding;
    private boolean createparentfolder;

    public String getDynamicFilenameField() {
        return this.filenamefield;
    }

    public void setDynamicFilenameField(String filenamefield) {
        this.filenamefield = filenamefield;
    }

    public String getTargetFilenameField() {
        return this.targetfilenamefield;
    }

    public void setTargetFilenameField(String targetfilenamefield) {
        this.targetfilenamefield = targetfilenamefield;
    }

    public String getSourceEncoding() {
        return this.sourceencoding;
    }

    public void setSourceEncoding(String encoding) {
        this.sourceencoding = encoding;
    }

    public String getTargetEncoding() {
        return this.targetencoding;
    }

    public void setTargetEncoding(String encoding) {
        this.targetencoding = encoding;
    }

    public boolean addSourceResultFilenames() {
        return this.addsourceresultfilenames;
    }

    public void setaddSourceResultFilenames(boolean addresultfilenames) {
        this.addsourceresultfilenames = addresultfilenames;
    }

    public boolean addTargetResultFilenames() {
        return this.addtargetresultfilenames;
    }

    public void setaddTargetResultFilenames(boolean addresultfilenames) {
        this.addtargetresultfilenames = addresultfilenames;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public Object clone() {
        ChangeFileEncodingMeta retval = (ChangeFileEncodingMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.addsourceresultfilenames = false;
        this.addtargetresultfilenames = false;
        this.targetfilenamefield = null;
        this.sourceencoding = System.getProperty("file.encoding");
        this.targetencoding = null;
        this.createparentfolder = false;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"filenamefield", (String)this.filenamefield));
        retval.append("    " + XMLHandler.addTagValue((String)"targetfilenamefield", (String)this.targetfilenamefield));
        retval.append("    " + XMLHandler.addTagValue((String)"sourceencoding", (String)this.sourceencoding));
        retval.append("    " + XMLHandler.addTagValue((String)"targetencoding", (String)this.targetencoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"addsourceresultfilenames", (boolean)this.addsourceresultfilenames));
        retval.append("    ").append(XMLHandler.addTagValue((String)"addtargetresultfilenames", (boolean)this.addtargetresultfilenames));
        retval.append("    ").append(XMLHandler.addTagValue((String)"createparentfolder", (boolean)this.createparentfolder));
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.filenamefield = XMLHandler.getTagValue((Node)stepnode, (String)"filenamefield");
            this.targetfilenamefield = XMLHandler.getTagValue((Node)stepnode, (String)"targetfilenamefield");
            this.sourceencoding = XMLHandler.getTagValue((Node)stepnode, (String)"sourceencoding");
            this.targetencoding = XMLHandler.getTagValue((Node)stepnode, (String)"targetencoding");
            this.addsourceresultfilenames = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addsourceresultfilenames"));
            this.addtargetresultfilenames = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addtargetresultfilenames"));
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"createparentfolder"));
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.Exception.UnableToReadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.filenamefield = rep.getStepAttributeString(id_step, "filenamefield");
            this.targetfilenamefield = rep.getStepAttributeString(id_step, "targetfilenamefield");
            this.sourceencoding = rep.getStepAttributeString(id_step, "sourceencoding");
            this.targetencoding = rep.getStepAttributeString(id_step, "targetencoding");
            this.addsourceresultfilenames = rep.getStepAttributeBoolean(id_step, "addsourceresultfilenames");
            this.addtargetresultfilenames = rep.getStepAttributeBoolean(id_step, "addtargetresultfilenames");
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, "createparentfolder");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.Exception.UnexpectedErrorReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "filenamefield", this.filenamefield);
            rep.saveStepAttribute(id_transformation, id_step, "targetfilenamefield", this.targetfilenamefield);
            rep.saveStepAttribute(id_transformation, id_step, "sourceencoding", this.sourceencoding);
            rep.saveStepAttribute(id_transformation, id_step, "targetencoding", this.targetencoding);
            rep.saveStepAttribute(id_transformation, id_step, "addsourceresultfilenames", this.addsourceresultfilenames);
            rep.saveStepAttribute(id_transformation, id_step, "addtargetresultfilenames", this.addtargetresultfilenames);
            rep.saveStepAttribute(id_transformation, id_step, "createparentfolder", this.createparentfolder);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.filenamefield)) {
            error_message = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.FileFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.FileFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (Const.isEmpty((String)this.targetfilenamefield)) {
            error_message = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.TargetFileFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.TargetFileFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        String realSourceEncoding = transMeta.environmentSubstitute(this.getSourceEncoding());
        if (Const.isEmpty((String)realSourceEncoding)) {
            error_message = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.SourceEncodingMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.SourceEncodingOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        String realTargetEncoding = transMeta.environmentSubstitute(this.getTargetEncoding());
        if (Const.isEmpty((String)realTargetEncoding)) {
            error_message = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.TargetEncodingMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.TargetEncodingOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.ReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ChangeFileEncodingMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new ChangeFileEncoding(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ChangeFileEncodingData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

