/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.checksum;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.checksum.CheckSum;
import org.pentaho.di.trans.steps.checksum.CheckSumData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckSumMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = CheckSumMeta.class;
    private String[] fieldName;
    private String resultfieldName;
    public static final String TYPE_CRC32 = "CRC32";
    public static final String TYPE_ADLER32 = "ADLER32";
    public static final String TYPE_MD5 = "MD5";
    public static final String TYPE_SHA1 = "SHA-1";
    public static String[] checksumtypeCodes = new String[]{"CRC32", "ADLER32", "MD5", "SHA-1"};
    private String checksumtype;
    private boolean compatibilityMode;
    private int resultType;
    public static final String[] resultTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"CheckSumDialog.ResultType.String", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckSumDialog.ResultType.Hexadecimal", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckSumDialog.ResultType.Binary", (String[])new String[0])};
    public static final String[] resultTypeCode = new String[]{"string", "hexadecimal", "binay"};
    public static final int result_TYPE_STRING = 0;
    public static final int result_TYPE_HEXADECIMAL = 1;
    public static final int result_TYPE_BINARY = 2;

    public void setCheckSumType(int i) {
        this.checksumtype = checksumtypeCodes[i];
    }

    public int getTypeByDesc() {
        if (this.checksumtype == null) {
            return 0;
        }
        int retval = this.checksumtype.equals(checksumtypeCodes[1]) ? 1 : (this.checksumtype.equals(checksumtypeCodes[2]) ? 2 : (this.checksumtype.equals(checksumtypeCodes[3]) ? 3 : 0));
        return retval;
    }

    public String getCheckSumType() {
        return this.checksumtype;
    }

    public int getResultType() {
        return this.resultType;
    }

    public static String getResultTypeDesc(int i) {
        if (i < 0 || i >= resultTypeDesc.length) {
            return resultTypeDesc[0];
        }
        return resultTypeDesc[i];
    }

    public static int getResultTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < resultTypeDesc.length; ++i) {
            if (!resultTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return CheckSumMeta.getResultTypeByCode(tt);
    }

    private static int getResultTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < resultTypeCode.length; ++i) {
            if (!resultTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void setResultType(int resultType) {
        this.resultType = resultType;
    }

    public String getResultFieldName() {
        return this.resultfieldName;
    }

    public void setResultFieldName(String resultfieldName) {
        this.resultfieldName = resultfieldName;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        CheckSumMeta retval = (CheckSumMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
        }
        return retval;
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.checksumtype = XMLHandler.getTagValue((Node)stepnode, (String)"checksumtype");
            this.resultfieldName = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldName");
            this.resultType = CheckSumMeta.getResultTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"resultType"), (String)""));
            this.compatibilityMode = this.parseCompatibilityMode(XMLHandler.getTagValue((Node)stepnode, (String)"compatibilityMode"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    private boolean parseCompatibilityMode(String compatibilityMode) {
        if (compatibilityMode == null) {
            return true;
        }
        return Boolean.parseBoolean(compatibilityMode) || "Y".equalsIgnoreCase(compatibilityMode);
    }

    private static String getResultTypeCode(int i) {
        if (i < 0 || i >= resultTypeCode.length) {
            return resultTypeCode[0];
        }
        return resultTypeCode[i];
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append("      ").append(XMLHandler.addTagValue((String)"checksumtype", (String)this.checksumtype));
        retval.append("      ").append(XMLHandler.addTagValue((String)"resultfieldName", (String)this.resultfieldName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"resultType", (String)CheckSumMeta.getResultTypeCode(this.resultType)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"compatibilityMode", (boolean)this.compatibilityMode));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void setDefault() {
        this.resultfieldName = null;
        this.checksumtype = checksumtypeCodes[0];
        this.resultType = 1;
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
        }
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.checksumtype = rep.getStepAttributeString(id_step, "checksumtype");
            this.resultfieldName = rep.getStepAttributeString(id_step, "resultfieldName");
            this.resultType = CheckSumMeta.getResultTypeByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "resultType"), (String)""));
            this.compatibilityMode = this.parseCompatibilityMode(rep.getStepAttributeString(id_step, "compatibilityMode"));
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "checksumtype", this.checksumtype);
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldName", this.resultfieldName);
            rep.saveStepAttribute(id_transformation, id_step, "resultType", CheckSumMeta.getResultTypeCode(this.resultType));
            rep.saveStepAttribute(id_transformation, id_step, "compatibilityMode", this.compatibilityMode);
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (!Const.isEmpty((String)this.resultfieldName)) {
            ValueMeta v = null;
            if (this.checksumtype.equals(TYPE_CRC32) || this.checksumtype.equals(TYPE_ADLER32)) {
                v = new ValueMeta(space.environmentSubstitute(this.resultfieldName), 5);
            } else {
                switch (this.resultType) {
                    case 2: {
                        v = new ValueMeta(space.environmentSubstitute(this.resultfieldName), 8);
                        break;
                    }
                    default: {
                        v = new ValueMeta(space.environmentSubstitute(this.resultfieldName), 2);
                    }
                }
            }
            v.setOrigin(name);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        String error_message = "";
        if (Const.isEmpty((String)this.resultfieldName)) {
            error_message = BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, error_message, (CheckResultSourceInterface)stepMeta);
        }
        remarks.add((CheckResultInterface)cr);
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.StepRecevingData", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            boolean error_found = false;
            error_message = "";
            for (int i = 0; i < this.fieldName.length; ++i) {
                int idx = prev.indexOfValue(this.fieldName[i]);
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.fieldName[i] + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.FieldsFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else if (this.fieldName.length > 0) {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.NoFieldsEntered", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.StepRecevingData2", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CheckSumMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new CheckSum(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new CheckSumData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    public boolean isCompatibilityMode() {
        return this.compatibilityMode;
    }

    public void setCompatibilityMode(boolean compatibilityMode) {
        this.compatibilityMode = compatibilityMode;
    }
}

