/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.constant;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.constant.Constant;
import org.pentaho.di.trans.steps.constant.ConstantData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = ConstantMeta.class;
    private String[] currency;
    private String[] decimal;
    private String[] group;
    private String[] value;
    private String[] fieldName;
    private String[] fieldType;
    private String[] fieldFormat;
    private int[] fieldLength;
    private int[] fieldPrecision;

    public String[] getCurrency() {
        return this.currency;
    }

    public void setCurrency(String[] currency) {
        this.currency = currency;
    }

    public String[] getDecimal() {
        return this.decimal;
    }

    public void setDecimal(String[] decimal) {
        this.decimal = decimal;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(String[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getGroup() {
        return this.group;
    }

    public void setGroup(String[] group) {
        this.group = group;
    }

    public String[] getValue() {
        return this.value;
    }

    public void setValue(String[] value) {
        this.value = value;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldType = new String[nrfields];
        this.fieldFormat = new String[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
        this.currency = new String[nrfields];
        this.decimal = new String[nrfields];
        this.group = new String[nrfields];
        this.value = new String[nrfields];
    }

    @Override
    public Object clone() {
        ConstantMeta retval = (ConstantMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldType[i] = this.fieldType[i];
            retval.fieldFormat[i] = this.fieldFormat[i];
            retval.currency[i] = this.currency[i];
            retval.decimal[i] = this.decimal[i];
            retval.group[i] = this.group[i];
            retval.value[i] = this.value[i];
            this.fieldLength[i] = this.fieldLength[i];
            this.fieldPrecision[i] = this.fieldPrecision[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldType[i] = XMLHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldFormat[i] = XMLHandler.getTagValue((Node)fnode, (String)"format");
                this.currency[i] = XMLHandler.getTagValue((Node)fnode, (String)"currency");
                this.decimal[i] = XMLHandler.getTagValue((Node)fnode, (String)"decimal");
                this.group[i] = XMLHandler.getTagValue((Node)fnode, (String)"group");
                this.value[i] = XMLHandler.getTagValue((Node)fnode, (String)"nullif");
                String slength = XMLHandler.getTagValue((Node)fnode, (String)"length");
                String sprecision = XMLHandler.getTagValue((Node)fnode, (String)"precision");
                this.fieldLength[i] = Const.toInt((String)slength, (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)sprecision, (int)-1);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        int nrfields = 0;
        this.allocate(nrfields);
        DecimalFormat decimalFormat = new DecimalFormat();
        for (int i = 0; i < nrfields; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = "Number";
            this.fieldFormat[i] = "\u00a40,000,000.00;\u00a4-0,000,000.00";
            this.fieldLength[i] = 9;
            this.fieldPrecision[i] = 2;
            this.currency[i] = decimalFormat.getDecimalFormatSymbols().getCurrencySymbol();
            this.decimal[i] = new String(new char[]{decimalFormat.getDecimalFormatSymbols().getDecimalSeparator()});
            this.group[i] = new String(new char[]{decimalFormat.getDecimalFormatSymbols().getGroupingSeparator()});
            this.value[i] = "-";
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            int type = ValueMeta.getType((String)this.fieldType[i]);
            if (type == 0) {
                type = 2;
            }
            ValueMeta v = new ValueMeta(this.fieldName[i], type);
            v.setLength(this.fieldLength[i]);
            v.setPrecision(this.fieldPrecision[i]);
            v.setOrigin(name);
            rowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)this.fieldType[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.fieldFormat[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)this.currency[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.decimal[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.group[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullif", (String)this.value[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.fieldLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.fieldPrecision[i]));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = rep.getStepAttributeString(id_step, i, "field_type");
                this.fieldFormat[i] = rep.getStepAttributeString(id_step, i, "field_format");
                this.currency[i] = rep.getStepAttributeString(id_step, i, "field_currency");
                this.decimal[i] = rep.getStepAttributeString(id_step, i, "field_decimal");
                this.group[i] = rep.getStepAttributeString(id_step, i, "field_group");
                this.value[i] = rep.getStepAttributeString(id_step, i, "field_nullif");
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", this.fieldType[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", this.fieldFormat[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", this.currency[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", this.decimal[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", this.group[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", this.value[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.fieldPrecision[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        if (prev != null && prev.size() > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ConstantMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ConstantMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        ConstantData data = new ConstantData();
        ConstantMeta meta = (ConstantMeta)stepMeta.getStepMetaInterface();
        Constant.buildRow(meta, data, remarks);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new Constant(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new ConstantData();
    }
}

