/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.fileexists;

import org.apache.commons.vfs.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fileexists.FileExistsData;
import org.pentaho.di.trans.steps.fileexists.FileExistsMeta;

public class FileExists
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = FileExistsMeta.class;
    private FileExistsMeta meta;
    private FileExistsData data;

    public FileExists(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block15: {
            this.meta = (FileExistsMeta)smi;
            this.data = (FileExistsData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean fileexists = false;
            String filetype = null;
            try {
                if (this.first) {
                    this.first = false;
                    this.data.previousRowMeta = this.getInputRowMeta().clone();
                    this.data.NrPrevFields = this.data.previousRowMeta.size();
                    this.data.outputRowMeta = this.data.previousRowMeta;
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    if (Const.isEmpty((String)this.meta.getDynamicFilenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"FileExists.Error.FilenameFieldMissing", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"FileExists.Error.FilenameFieldMissing", (String[])new String[0]));
                    }
                    if (this.data.indexOfFileename < 0) {
                        this.data.indexOfFileename = this.data.previousRowMeta.indexOfValue(this.meta.getDynamicFilenameField());
                        if (this.data.indexOfFileename < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"FileExists.Exception.CouldnotFindField", (String[])new String[0]) + "[" + this.meta.getDynamicFilenameField() + "]");
                            throw new KettleException(BaseMessages.getString(PKG, (String)"FileExists.Exception.CouldnotFindField", (String[])new String[]{this.meta.getDynamicFilenameField()}));
                        }
                    }
                }
                Object[] outputRow = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
                for (int i = 0; i < this.data.NrPrevFields; ++i) {
                    outputRow[i] = r[i];
                }
                String filename = this.data.previousRowMeta.getString(r, this.data.indexOfFileename);
                if (!Const.isEmpty((String)filename)) {
                    this.data.file = KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta());
                    fileexists = this.data.file.exists();
                    if (this.meta.includeFileType() && fileexists && !Const.isEmpty((String)this.meta.getFileTypeFieldName())) {
                        filetype = this.data.file.getType().toString();
                    }
                    if (this.meta.addResultFilenames() && fileexists && this.data.file.getType() == FileType.FILE) {
                        ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"FileExists.Log.FileAddedResult", (String[])new String[0]));
                        this.addResultFile(resultFile);
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"FileExists.Log.FilenameAddResult", (String[])new String[]{this.data.file.toString()}));
                        }
                    }
                }
                outputRow[this.data.NrPrevFields] = fileexists;
                int rowIndex = this.data.NrPrevFields;
                ++rowIndex;
                if (this.meta.includeFileType() && !Const.isEmpty((String)this.meta.getFileTypeFieldName())) {
                    outputRow[rowIndex] = filetype;
                }
                this.putRow(this.data.outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"FileExists.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"FileExists.ErrorInStepRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block15;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, this.meta.getResultFieldName(), "FileExistsO01");
            }
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FileExistsMeta)smi;
        this.data = (FileExistsData)sdi;
        if (super.init(smi, sdi)) {
            if (Const.isEmpty((String)this.meta.getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"FileExists.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FileExistsMeta)smi;
        this.data = (FileExistsData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
                this.data.file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }
}

