/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.filterrows;

import java.util.List;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.filterrows.FilterRowsData;
import org.pentaho.di.trans.steps.filterrows.FilterRowsMeta;

public class FilterRows
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = FilterRowsMeta.class;
    private FilterRowsMeta meta;
    private FilterRowsData data;

    public FilterRows(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private synchronized boolean keepRow(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        try {
            return this.meta.getCondition().evaluate(rowMeta, row);
        }
        catch (Exception e) {
            String message = BaseMessages.getString(PKG, (String)"FilterRows.Exception.UnexpectedErrorFoundInEvaluationFuction", (String[])new String[0]);
            this.logError(message);
            this.logError(BaseMessages.getString(PKG, (String)"FilterRows.Log.ErrorOccurredForRow", (String[])new String[0]) + rowMeta.getString(row));
            this.logError(Const.getStackTracker((Throwable)e));
            throw new KettleException(message, (Throwable)e);
        }
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (FilterRowsMeta)smi;
        this.data = (FilterRowsData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.getInputRowMeta(), this.getStepname(), null, null, this);
            if (this.data.chosesTargetSteps) {
                List<StreamInterface> targetStreams = this.meta.getStepIOMeta().getTargetStreams();
                this.data.trueRowSet = this.findOutputRowSet(this.getStepname(), this.getCopy(), targetStreams.get(0).getStepname(), 0);
                if (this.data.trueRowSet == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"FilterRows.Log.TargetStepInvalid", (String[])new String[]{targetStreams.get(0).getStepname()}));
                }
                this.data.falseRowSet = this.findOutputRowSet(this.getStepname(), this.getCopy(), targetStreams.get(1).getStepname(), 0);
                if (this.data.falseRowSet == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"FilterRows.Log.TargetStepInvalid", (String[])new String[]{targetStreams.get(1).getStepname()}));
                }
            }
        }
        boolean keep = this.keepRow(this.getInputRowMeta(), r);
        if (!this.data.chosesTargetSteps) {
            if (keep) {
                this.putRow(this.data.outputRowMeta, r);
            }
        } else if (keep) {
            if (this.log.isRowLevel()) {
                this.logRowlevel("Sending row to true  :" + this.data.trueStepname + " : " + this.getInputRowMeta().getString(r));
            }
            this.putRowTo(this.data.outputRowMeta, r, this.data.trueRowSet);
        } else {
            if (this.log.isRowLevel()) {
                this.logRowlevel("Sending row to false :" + this.data.falseStepname + " : " + this.getInputRowMeta().getString(r));
            }
            this.putRowTo(this.data.outputRowMeta, r, this.data.falseRowSet);
        }
        if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"FilterRows.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FilterRowsMeta)smi;
        this.data = (FilterRowsData)sdi;
        if (super.init(smi, sdi)) {
            this.meta.getCondition().clearFieldPositions();
            List<StreamInterface> targetStreams = this.meta.getStepIOMeta().getTargetStreams();
            this.data.trueStepname = targetStreams.get(0).getStepname();
            this.data.falseStepname = targetStreams.get(1).getStepname();
            if (targetStreams.get(0).getStepMeta() != null ^ targetStreams.get(1).getStepMeta() != null) {
                this.logError(BaseMessages.getString(PKG, (String)"FilterRows.Log.BothTrueAndFalseNeeded", (String[])new String[0]));
            } else {
                this.data.chosesTargetSteps = targetStreams.get(0).getStepMeta() != null && targetStreams.get(1).getStepMeta() != null;
                return true;
            }
        }
        return false;
    }
}

