/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.flattener;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.flattener.FlattenerData;
import org.pentaho.di.trans.steps.flattener.FlattenerMeta;

public class Flattener
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = FlattenerMeta.class;
    private FlattenerMeta meta = (FlattenerMeta)this.getStepMeta().getStepMetaInterface();
    private FlattenerData data;

    public Flattener(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
        this.data = (FlattenerData)stepDataInterface;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] r = this.getRow();
        if (r == null) {
            if (this.data.processed > 0) {
                Object[] outputRowData = this.createOutputRow(this.data.previousRow);
                this.putRow(this.data.outputRowMeta, outputRowData);
            }
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.data.inputRowMeta = this.getInputRowMeta();
            this.data.outputRowMeta = this.data.inputRowMeta.clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.fieldNr = this.data.inputRowMeta.indexOfValue(this.meta.getFieldName());
            if (this.data.fieldNr < 0) {
                this.logError(BaseMessages.getString(PKG, (String)"Flattener.Log.FieldCouldNotFound", (String[])new String[]{this.meta.getFieldName()}));
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            this.data.targetResult = new Object[this.meta.getTargetField().length];
            this.first = false;
        }
        this.data.targetResult[this.data.processed++] = r[this.data.fieldNr];
        if (this.data.processed >= this.meta.getTargetField().length) {
            Object[] outputRowData = this.createOutputRow(r);
            this.putRow(this.data.outputRowMeta, outputRowData);
            this.data.targetResult = new Object[this.meta.getTargetField().length];
            this.data.processed = 0;
        }
        this.data.previousRow = r;
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"Flattener.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    private Object[] createOutputRow(Object[] rowData) {
        int i;
        Object[] outputRowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        int outputIndex = 0;
        for (i = 0; i < this.data.inputRowMeta.size(); ++i) {
            if (i == this.data.fieldNr) continue;
            outputRowData[outputIndex++] = rowData[i];
        }
        for (i = 0; i < this.data.targetResult.length; ++i) {
            outputRowData[outputIndex++] = this.data.targetResult[i];
        }
        return outputRowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (FlattenerMeta)smi;
        this.data = (FlattenerData)sdi;
        return super.init(smi, sdi);
    }
}

