/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getfilesrowscount;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getfilesrowscount.GetFilesRowsCountData;
import org.pentaho.di.trans.steps.getfilesrowscount.GetFilesRowsCountMeta;

public class GetFilesRowsCount
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GetFilesRowsCountMeta.class;
    private GetFilesRowsCountMeta meta;
    private GetFilesRowsCountData data;

    public GetFilesRowsCount(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    private Object[] getOneRow() throws KettleException {
        Object[] r;
        if (!this.openNextFile()) {
            return null;
        }
        try {
            if (this.meta.isFileField()) {
                r = (Object[])this.data.readrow.clone();
                r = RowDataUtil.resizeArray((Object[])r, (int)this.data.outputRowMeta.size());
            } else {
                r = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
            }
            r[this.data.totalpreviousfields] = this.data.rownr;
            if (this.meta.includeCountFiles()) {
                r[this.data.totalpreviousfields + 1] = this.data.filenr;
            }
            this.incrementLinesInput();
        }
        catch (Exception e) {
            throw new KettleException("Unable to read row from file", (Throwable)e);
        }
        return r;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        try {
            Object[] outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
            if (!this.meta.isFileField() && this.data.last_file || this.meta.isFileField()) {
                this.putRow(this.data.outputRowMeta, outputRowData);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.TotalRowsFiles", (String[])new String[0]), this.data.rownr, this.data.filenr);
                }
            }
        }
        catch (KettleException e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.ErrorInStepRunning", (String[])new String[]{e.getMessage()}));
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getRowNumber() throws KettleException {
        try {
            block7: {
                try {
                    if (this.data.file.getType() == FileType.FILE) {
                        int n;
                        this.data.fr = KettleVFS.getInputStream((FileObject)this.data.file);
                        byte[] buf = new byte[8192];
                        while ((n = this.data.fr.read(buf)) != -1) {
                            for (int i = 0; i < n; ++i) {
                                if (buf[i] != this.data.separator) continue;
                                ++this.data.rownr;
                            }
                        }
                    }
                    if (!this.log.isDetailed()) break block7;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.RowsInFile", (String[])new String[]{this.data.file.toString(), "" + this.data.rownr}));
                }
                catch (Exception e) {
                    throw new KettleException((Throwable)e);
                }
            }
            Object var5_5 = null;
            if (this.data.fr == null) return;
            BaseStep.closeQuietly(this.data.fr);
            this.data.fr = null;
            return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (this.data.fr == null) throw throwable;
            BaseStep.closeQuietly(this.data.fr);
            this.data.fr = null;
            throw throwable;
        }
    }

    private boolean openNextFile() {
        if (this.data.last_file) {
            return false;
        }
        try {
            if (!this.meta.isFileField()) {
                if (this.data.filenr >= (long)this.data.files.nrOfFiles()) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                this.data.last_file = this.data.filenr == (long)(this.data.files.nrOfFiles() - 1);
                this.data.file = this.data.files.getFile((int)this.data.filenr);
            } else {
                this.data.readrow = this.getRow();
                if (this.data.readrow == null) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
                if (this.first) {
                    this.first = false;
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    if (Const.isEmpty((String)this.meta.setOutputFilenameField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.NoField", (String[])new String[0]));
                        throw new KettleException(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.NoField", (String[])new String[0]));
                    }
                    if (this.data.indexOfFilenameField < 0) {
                        this.data.indexOfFilenameField = this.getInputRowMeta().indexOfValue(this.meta.setOutputFilenameField());
                        if (this.data.indexOfFilenameField < 0) {
                            this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.ErrorFindingField", (String[])new String[]{this.meta.setOutputFilenameField()}));
                            throw new KettleException(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Exception.CouldnotFindField", (String[])new String[]{this.meta.setOutputFilenameField()}));
                        }
                    }
                }
                String filename = this.getInputRowMeta().getString(this.data.readrow, this.data.indexOfFilenameField);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FilenameInStream", (String[])new String[]{this.meta.setOutputFilenameField(), filename}));
                }
                this.data.file = KettleVFS.getFileObject((String)filename, (VariableSpace)this.getTransMeta());
                if (this.meta.isFileField()) {
                    this.data.rownr = 0L;
                }
            }
            ++this.data.filenr;
            if (this.meta.isAddResultFile()) {
                ResultFile resultFile = new ResultFile(0, this.data.file, this.getTransMeta().getName(), this.getStepname());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FileAddedResult", (String[])new String[0]));
                this.addResultFile(resultFile);
            }
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.OpeningFile", (String[])new String[]{this.data.file.toString()}));
            }
            this.getRowNumber();
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.FileOpened", (String[])new String[]{this.data.file.toString()}));
            }
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.UnableToOpenFile", (String[])new String[]{"" + this.data.filenr, this.data.file.toString(), e.toString()}));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetFilesRowsCountMeta)smi;
        this.data = (GetFilesRowsCountData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.getRowSeparatorFormat().equals("CUSTOM") && Const.isEmpty((String)this.meta.getRowSeparator())) {
                this.log.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Error.NoSeparator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Error.NoSeparator.Msg", (String[])new String[0])});
                this.setErrors(1L);
                this.stopAll();
            } else if (this.meta.getRowSeparatorFormat().equals("CARRIAGERETURN") || this.meta.getRowSeparatorFormat().equals("LF")) {
                this.data.separator = (char)13;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separatoris.Infos", (String[])new String[0]) + " \\n"});
                }
            } else if (this.meta.getRowSeparatorFormat().equals("LINEFEED") || this.meta.getRowSeparatorFormat().equals("CR")) {
                this.data.separator = (char)10;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separatoris.Infos", (String[])new String[0]) + " \\r"});
                }
            } else if (this.meta.getRowSeparatorFormat().equals("TAB")) {
                this.data.separator = (char)9;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separatoris.Infos", (String[])new String[0]) + " \\t"});
                }
            } else {
                this.data.separator = this.environmentSubstitute(this.meta.getRowSeparator()).charAt(0);
                if (this.log.isDetailed()) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separator.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.Separatoris.Infos", (String[])new String[0]) + " " + this.data.separator});
                }
            }
            if (!this.meta.isFileField()) {
                this.data.files = this.meta.getFiles(this);
                if (this.data.files == null || this.data.files.nrOfFiles() == 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"GetFilesRowsCount.Log.NoFiles", (String[])new String[0]));
                    return false;
                }
                try {
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                }
                catch (Exception e) {
                    this.logError("Error initializing step: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            this.data.rownr = 0L;
            this.data.filenr = 0L;
            this.data.totalpreviousfields = 0;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GetFilesRowsCountMeta)smi;
        this.data = (GetFilesRowsCountData)sdi;
        if (this.data.file != null) {
            try {
                this.data.file.close();
                this.data.file = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.data.fr != null) {
            BaseStep.closeQuietly(this.data.fr);
            this.data.fr = null;
        }
        if (this.data.lineStringBuffer != null) {
            this.data.lineStringBuffer = null;
        }
        super.dispose(smi, sdi);
    }
}

