/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getrepositorynames;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.getrepositorynames.GetRepositoryNames;
import org.pentaho.di.trans.steps.getrepositorynames.GetRepositoryNamesData;
import org.pentaho.di.trans.steps.getrepositorynames.ObjectTypeSelection;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRepositoryNamesMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = GetRepositoryNamesMeta.class;
    private String[] directory;
    private String[] nameMask;
    private String[] excludeNameMask;
    private boolean[] includeSubFolders;
    private ObjectTypeSelection objectTypeSelection = ObjectTypeSelection.All;
    private boolean includeRowNumber;
    private String rowNumberField;

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    @Override
    public Object clone() {
        GetRepositoryNamesMeta retval = (GetRepositoryNamesMeta)super.clone();
        int nrfiles = this.directory.length;
        retval.allocate(nrfiles);
        for (int i = 0; i < nrfiles; ++i) {
            retval.directory[i] = this.directory[i];
            retval.nameMask[i] = this.nameMask[i];
            retval.excludeNameMask[i] = this.excludeNameMask[i];
            retval.includeSubFolders[i] = this.includeSubFolders[i];
        }
        return retval;
    }

    public void allocate(int nrfiles) {
        this.directory = new String[nrfiles];
        this.nameMask = new String[nrfiles];
        this.excludeNameMask = new String[nrfiles];
        this.includeSubFolders = new boolean[nrfiles];
    }

    @Override
    public void setDefault() {
        this.objectTypeSelection = ObjectTypeSelection.All;
        this.includeRowNumber = true;
        this.rowNumberField = "rownr";
        int nrfiles = 1;
        this.allocate(nrfiles);
        for (int i = 0; i < nrfiles; ++i) {
            this.directory[i] = "/";
            this.nameMask[i] = ".*";
            this.excludeNameMask[i] = "";
            this.includeSubFolders[i] = true;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta object = new ValueMeta("object", 2);
        object.setLength(500);
        object.setPrecision(-1);
        object.setOrigin(origin);
        row.addValueMeta((ValueMetaInterface)object);
        ValueMeta directory = new ValueMeta("directory", 2);
        directory.setLength(500);
        directory.setPrecision(-1);
        directory.setOrigin(origin);
        row.addValueMeta((ValueMetaInterface)directory);
        ValueMeta name = new ValueMeta("name", 2);
        name.setLength(500);
        name.setPrecision(-1);
        name.setOrigin(origin);
        row.addValueMeta((ValueMetaInterface)name);
        ValueMeta objectType = new ValueMeta("object_type", 2);
        objectType.setLength(500);
        objectType.setPrecision(-1);
        objectType.setOrigin(origin);
        row.addValueMeta((ValueMetaInterface)objectType);
        ValueMeta objectId = new ValueMeta("object_id", 2);
        object.setLength(500);
        object.setPrecision(-1);
        objectId.setOrigin(origin);
        row.addValueMeta((ValueMetaInterface)objectId);
        ValueMeta modifiedBy = new ValueMeta("modified_by", 2);
        object.setLength(500);
        object.setPrecision(-1);
        modifiedBy.setOrigin(origin);
        row.addValueMeta((ValueMetaInterface)modifiedBy);
        ValueMeta modifiedDate = new ValueMeta("modified_date", 3);
        modifiedDate.setOrigin(origin);
        row.addValueMeta((ValueMetaInterface)modifiedDate);
        ValueMeta description = new ValueMeta("description", 2);
        description.setLength(500);
        description.setPrecision(-1);
        description.setOrigin(origin);
        row.addValueMeta((ValueMetaInterface)description);
        if (this.includeRowNumber) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(origin);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"object_type", (String)this.objectTypeSelection.toString()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    <file>").append(Const.CR);
        for (int i = 0; i < this.directory.length; ++i) {
            retval.append("      ").append(XMLHandler.addTagValue((String)"directory", (String)this.directory[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"name_mask", (String)this.nameMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_name_mask", (String)this.excludeNameMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"include_subfolders", (boolean)this.includeSubFolders[i]));
        }
        retval.append("    </file>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        try {
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            int nrfiles = XMLHandler.countNodes((Node)filenode, (String)"directory");
            this.allocate(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"directory", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name_mask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_name_mask", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.directory[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.nameMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeNameMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.includeSubFolders[i] = "Y".equalsIgnoreCase(XMLHandler.getNodeValue((Node)includeSubFoldersnode));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int nrfiles = rep.countNrStepAttributes(id_step, "directory");
            String objectTypeString = rep.getStepAttributeString(id_step, "object_type");
            if (this.objectTypeSelection != null) {
                this.objectTypeSelection = ObjectTypeSelection.valueOf(objectTypeString);
            }
            if (this.objectTypeSelection == null) {
                this.objectTypeSelection = ObjectTypeSelection.All;
            }
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.allocate(nrfiles);
            for (int i = 0; i < nrfiles; ++i) {
                this.directory[i] = rep.getStepAttributeString(id_step, i, "directory");
                this.nameMask[i] = rep.getStepAttributeString(id_step, i, "name_mask");
                this.excludeNameMask[i] = rep.getStepAttributeString(id_step, i, "exclude_name_mask");
                this.includeSubFolders[i] = rep.getStepAttributeBoolean(id_step, i, "include_subfolders");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "object_type", this.objectTypeSelection.toString());
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            for (int i = 0; i < this.directory.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "directory", this.directory[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "name_mask", this.nameMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "exclude_name_mask", this.excludeNameMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.includeSubFolders[i]);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public boolean[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"GetRepositoryNamesMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"GetRepositoryNamesMeta.CheckResult.NoInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new GetRepositoryNames(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new GetRepositoryNamesData();
    }

    public boolean isIncludeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public void setIncludeSubFolders(boolean[] includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public ObjectTypeSelection getObjectTypeSelection() {
        return this.objectTypeSelection;
    }

    public void setObjectTypeSelection(ObjectTypeSelection objectTypeSelection) {
        this.objectTypeSelection = objectTypeSelection;
    }

    public String[] getDirectory() {
        return this.directory;
    }

    public void setDirectory(String[] directory) {
        this.directory = directory;
    }

    public String[] getNameMask() {
        return this.nameMask;
    }

    public void setNameMask(String[] nameMask) {
        this.nameMask = nameMask;
    }

    public String[] getExcludeNameMask() {
        return this.excludeNameMask;
    }

    public void setExcludeNameMask(String[] excludeNameMask) {
        this.excludeNameMask = excludeNameMask;
    }
}

