/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.gpbulkloader;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.gpbulkloader.GPBulkDataOutput;
import org.pentaho.di.trans.steps.gpbulkloader.GPBulkLoaderData;
import org.pentaho.di.trans.steps.gpbulkloader.GPBulkLoaderMeta;

public class GPBulkLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = GPBulkLoaderMeta.class;
    Process psqlProcess = null;
    private GPBulkLoaderMeta meta;
    protected GPBulkLoaderData data;
    private GPBulkDataOutput output = null;
    private boolean preview = false;

    public GPBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public String getControlFileContents(GPBulkLoaderMeta meta, RowMetaInterface rm, Object[] r) throws KettleException {
        DatabaseMeta dm = meta.getDatabaseMeta();
        String inputName = "'" + this.environmentSubstitute(meta.getDataFile()) + "'";
        String loadAction = meta.getLoadAction();
        StringBuffer contents = new StringBuffer(500);
        String tableName = dm.getQuotedSchemaTableCombination(this.environmentSubstitute(meta.getSchemaName()), this.environmentSubstitute(meta.getTableName()));
        if (loadAction.equalsIgnoreCase("truncate")) {
            contents.append(loadAction + " ");
            contents.append(tableName + ";");
            contents.append(Const.CR);
        }
        contents.append("\\COPY ");
        contents.append(tableName);
        contents.append(" ( ");
        String[] streamFields = meta.getFieldStream();
        String[] tableFields = meta.getFieldTable();
        if (streamFields == null || streamFields.length == 0) {
            throw new KettleException("No fields defined to load to database");
        }
        for (int i = 0; i < streamFields.length; ++i) {
            if (i != 0) {
                contents.append(", ");
            }
            contents.append(dm.quoteField(tableFields[i]));
        }
        contents.append(" ) ");
        contents.append(" FROM ");
        contents.append(inputName);
        contents.append(" WITH CSV ");
        contents.append("LOG ERRORS INTO ");
        contents.append(tableName + "_errors ");
        contents.append(" SEGMENT REJECT LIMIT ");
        contents.append(meta.getMaxErrors());
        return contents.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createControlFile(String filename, Object[] row, GPBulkLoaderMeta meta) throws KettleException {
        File controlFile = new File(filename);
        FileWriter fw = null;
        try {
            try {
                controlFile.createNewFile();
                fw = new FileWriter(controlFile);
                fw.write(this.getControlFileContents(meta, this.getInputRowMeta(), row));
            }
            catch (IOException ex) {
                throw new KettleException(ex.getMessage(), (Throwable)ex);
            }
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                if (fw == null) throw throwable;
                fw.close();
                throw throwable;
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ex) {}
        if (fw == null) return;
        fw.close();
        return;
    }

    public String createCommandLine(GPBulkLoaderMeta meta, boolean password) throws KettleException {
        DatabaseMeta dm;
        FileObject fileObject;
        StringBuffer sb = new StringBuffer(300);
        if (meta.getPsqlpath() != null) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getPsqlpath()), (VariableSpace)this.getTransMeta());
                String psqlexec = KettleVFS.getFilename((FileObject)fileObject);
                sb.append('\'').append(psqlexec).append('\'');
            }
            catch (Exception ex) {
                throw new KettleException("Error retrieving sqlldr string", (Throwable)ex);
            }
        } else {
            throw new KettleException("No psql application specified");
        }
        if (meta.getControlFile() != null) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getControlFile()), (VariableSpace)this.getTransMeta());
                sb.append(" -n -f ");
                sb.append('\'').append(KettleVFS.getFilename((FileObject)fileObject)).append('\'');
            }
            catch (Exception ex) {
                throw new KettleException("Error retrieving controlfile string", (Throwable)ex);
            }
        } else {
            throw new KettleException("No control file specified");
        }
        if (meta.getLogFile() != null) {
            try {
                fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(meta.getLogFile()), (VariableSpace)this.getTransMeta());
                sb.append(" -o ");
                sb.append('\'').append(KettleVFS.getFilename((FileObject)fileObject)).append('\'');
            }
            catch (Exception ex) {
                throw new KettleException("Error retrieving logfile string", (Throwable)ex);
            }
        }
        if ((dm = meta.getDatabaseMeta()) != null) {
            String user = Const.NVL((String)dm.getUsername(), (String)"");
            String pass = Const.NVL((String)dm.getPassword(), (String)"");
            if (password && !pass.equalsIgnoreCase("")) {
                throw new KettleException("Passwords are not supported directly, try configuring your connection for trusted access using pg_hba.conf");
            }
            sb.append(" -U ").append(this.environmentSubstitute(user));
            String hostname = Const.NVL((String)dm.getHostname(), (String)"");
            String portnum = Const.NVL((String)dm.getDatabasePortNumberString(), (String)"");
            sb.append(" -h ");
            sb.append(hostname);
            sb.append(" -p ");
            sb.append(portnum);
            String dns = Const.NVL((String)dm.getDatabaseName(), (String)"");
            sb.append(" -d ");
            String overrideName = meta.getDbNameOverride();
            if (Const.isEmpty((String)Const.rtrim((String)overrideName))) {
                sb.append(this.environmentSubstitute(dns));
            } else {
                sb.append(this.environmentSubstitute(overrideName));
            }
        } else {
            throw new KettleException("No connection specified");
        }
        return sb.toString();
    }

    public boolean execute(GPBulkLoaderMeta meta, boolean wait) throws KettleException {
        Runtime rt = Runtime.getRuntime();
        try {
            this.psqlProcess = rt.exec(this.createCommandLine(meta, true));
            StreamLogger errorLogger = new StreamLogger(this.psqlProcess.getErrorStream(), "ERROR");
            StreamLogger outputLogger = new StreamLogger(this.psqlProcess.getInputStream(), "OUTPUT");
            errorLogger.start();
            outputLogger.start();
            if (wait) {
                int exitVal = this.psqlProcess.waitFor();
                this.logBasic(BaseMessages.getString(PKG, (String)"GPBulkLoader.Log.ExitValuePsqlPath", (String[])new String[]{"" + exitVal}));
            }
        }
        catch (Exception ex) {
            throw new KettleException("Error while executing psql '" + this.createCommandLine(meta, false) + "'");
        }
        return true;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (GPBulkLoaderMeta)smi;
        this.data = (GPBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                if (!this.preview) {
                    String loadMethod;
                    if (this.output != null) {
                        try {
                            this.output.close();
                        }
                        catch (IOException e) {
                            throw new KettleException("Error while closing output", (Throwable)e);
                        }
                        this.output = null;
                    }
                    if ("AUTO_END".equals(loadMethod = this.meta.getLoadMethod())) {
                        this.execute(this.meta, true);
                    }
                }
                return false;
            }
            if (!this.preview) {
                if (this.first) {
                    this.first = false;
                    this.createControlFile(this.environmentSubstitute(this.meta.getControlFile()), r, this.meta);
                    this.output = new GPBulkDataOutput(this.meta);
                    this.output.open(this, this.psqlProcess);
                }
                this.output.writeLine(this.getInputRowMeta(), r);
            }
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
        }
        catch (KettleException e) {
            this.logError(BaseMessages.getString(PKG, (String)"GPBulkLoader.Log.ErrorInStep", (String[])new String[0]) + e.getMessage());
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GPBulkLoaderMeta)smi;
        this.data = (GPBulkLoaderData)sdi;
        Trans trans = this.getTrans();
        this.preview = trans.isPreview();
        return super.init(smi, sdi);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (GPBulkLoaderMeta)smi;
        this.data = (GPBulkLoaderData)sdi;
        super.dispose(smi, sdi);
        if (!this.preview && this.meta.isEraseFiles()) {
            FileObject fileObject = null;
            String method = this.meta.getLoadMethod();
            if ("AUTO_END".equals(method) && this.meta.getControlFile() != null) {
                try {
                    fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getControlFile()), (VariableSpace)this.getTransMeta());
                    fileObject.delete();
                    fileObject.close();
                }
                catch (Exception ex) {
                    this.logError("Error deleting control file '" + KettleVFS.getFilename((FileObject)fileObject) + "': " + ex.getMessage());
                }
            }
            if ("AUTO_END".equals(method) && this.meta.getDataFile() != null) {
                try {
                    fileObject = KettleVFS.getFileObject((String)this.environmentSubstitute(this.meta.getDataFile()), (VariableSpace)this.getTransMeta());
                    fileObject.delete();
                    fileObject.close();
                }
                catch (Exception ex) {
                    this.logError("Error deleting data file '" + KettleVFS.getFilename((FileObject)fileObject) + "': " + ex.getMessage(), ex);
                }
            }
            if ("MANUAL".equals(method)) {
                this.logBasic("Deletion of files is not compatible with 'manual load method'");
            }
        }
    }

    private final class StreamLogger
    extends Thread {
        private InputStream input;
        private String type;

        StreamLogger(InputStream is, String type) {
            this.input = is;
            this.type = type + ">";
        }

        public void run() {
            try {
                String line;
                BufferedReader br = new BufferedReader(new InputStreamReader(this.input));
                while ((line = br.readLine()) != null) {
                    if (!GPBulkLoader.this.log.isBasic()) continue;
                    GPBulkLoader.this.logBasic(this.type + line);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

