/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.janino;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.codehaus.janino.ExpressionEvaluator;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.janino.JaninoData;
import org.pentaho.di.trans.steps.janino.JaninoMeta;
import org.pentaho.di.trans.steps.janino.JaninoMetaFunction;

public class Janino
extends BaseStep
implements StepInterface {
    private JaninoMeta meta;
    private JaninoData data;

    public Janino(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (JaninoMeta)smi;
        this.data = (JaninoData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.replaceIndex = new int[this.meta.getFormula().length];
            for (int i = 0; i < this.meta.getFormula().length; ++i) {
                JaninoMetaFunction fn = this.meta.getFormula()[i];
                if (!Const.isEmpty((String)fn.getReplaceField())) {
                    this.data.replaceIndex[i] = this.getInputRowMeta().indexOfValue(fn.getReplaceField());
                    if (this.data.replaceIndex[i] >= 0) continue;
                    throw new KettleException("Unknown field specified to replace with a formula result: [" + fn.getReplaceField() + "]");
                }
                this.data.replaceIndex[i] = -1;
            }
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel("Read row #" + this.getLinesRead() + " : " + this.getInputRowMeta().getString(r));
        }
        try {
            Object[] outputRowData = this.calcFields(this.getInputRowMeta(), r);
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (this.log.isRowLevel()) {
                this.logRowlevel("Wrote row #" + this.getLinesWritten() + " : " + this.data.outputRowMeta.getString(outputRowData));
            }
        }
        catch (Exception e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                this.putError(this.getInputRowMeta(), r, 1L, e.toString(), null, "UJE001");
            }
            throw new KettleException((Throwable)e);
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private Object[] calcFields(RowMetaInterface rowMeta, Object[] r) throws KettleValueException {
        try {
            int i;
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)this.data.outputRowMeta.size());
            int tempIndex = rowMeta.size();
            if (this.data.expressionEvaluators == null) {
                List<Object> argIndexes;
                this.data.expressionEvaluators = new ExpressionEvaluator[this.meta.getFormula().length];
                this.data.argumentIndexes = new ArrayList<List<Integer>>();
                for (i = 0; i < this.meta.getFormula().length; ++i) {
                    argIndexes = new ArrayList();
                    this.data.argumentIndexes.add(argIndexes);
                }
                for (int m = 0; m < this.meta.getFormula().length; ++m) {
                    argIndexes = this.data.argumentIndexes.get(m);
                    ArrayList<String> parameterNames = new ArrayList<String>();
                    ArrayList<Class<String>> parameterTypes = new ArrayList<Class<String>>();
                    for (int i2 = 0; i2 < this.data.outputRowMeta.size(); ++i2) {
                        Class parameterType;
                        ValueMetaInterface valueMeta = this.data.outputRowMeta.getValueMeta(i2);
                        if (!this.meta.getFormula()[m].getFormula().contains(valueMeta.getName())) continue;
                        argIndexes.add(i2);
                        switch (valueMeta.getType()) {
                            case 2: {
                                parameterType = String.class;
                                break;
                            }
                            case 1: {
                                parameterType = Double.class;
                                break;
                            }
                            case 5: {
                                parameterType = Long.class;
                                break;
                            }
                            case 3: {
                                parameterType = Date.class;
                                break;
                            }
                            case 6: {
                                parameterType = BigDecimal.class;
                                break;
                            }
                            case 4: {
                                parameterType = Boolean.class;
                                break;
                            }
                            case 8: {
                                parameterType = byte[].class;
                                break;
                            }
                            default: {
                                parameterType = String.class;
                            }
                        }
                        parameterTypes.add(parameterType);
                        parameterNames.add(valueMeta.getName());
                    }
                    JaninoMetaFunction fn = this.meta.getFormula()[m];
                    if (Const.isEmpty((String)fn.getFieldName())) {
                        throw new KettleException("Unable to find field name for formula [" + Const.NVL((String)fn.getFormula(), (String)"") + "]");
                    }
                    this.data.expressionEvaluators[m] = new ExpressionEvaluator();
                    this.data.expressionEvaluators[m].setParameters(parameterNames.toArray(new String[parameterNames.size()]), parameterTypes.toArray(new Class[parameterTypes.size()]));
                    this.data.expressionEvaluators[m].setReturnType(Object.class);
                    this.data.expressionEvaluators[m].setThrownExceptions(new Class[]{Exception.class});
                    this.data.expressionEvaluators[m].cook(fn.getFormula());
                }
            }
            for (i = 0; i < this.meta.getFormula().length; ++i) {
                Object value;
                JaninoMetaFunction fn = this.meta.getFormula()[i];
                List<Integer> argumentIndexes = this.data.argumentIndexes.get(i);
                Object[] argumentData = new Object[argumentIndexes.size()];
                for (int x = 0; x < argumentIndexes.size(); ++x) {
                    int index = argumentIndexes.get(x);
                    ValueMetaInterface outputValueMeta = this.data.outputRowMeta.getValueMeta(index);
                    argumentData[x] = outputValueMeta.convertToNormalStorageType(outputRowData[index]);
                }
                Object formulaResult = this.data.expressionEvaluators[i].evaluate(argumentData);
                if (this.data.returnType[i] < 0) {
                    if (formulaResult instanceof String) {
                        this.data.returnType[i] = 0;
                        if (fn.getValueType() != 2) {
                            throw new KettleValueException("Please specify a String type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Integer) {
                        this.data.returnType[i] = 2;
                        if (fn.getValueType() != 5) {
                            throw new KettleValueException("Please specify an Integer type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Long) {
                        this.data.returnType[i] = 3;
                        if (fn.getValueType() != 5) {
                            throw new KettleValueException("Please specify an Integer type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof BigDecimal) {
                        this.data.returnType[i] = 5;
                        if (fn.getValueType() != 6) {
                            throw new KettleValueException("Please specify a BigNumber type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Number) {
                        this.data.returnType[i] = 1;
                        if (fn.getValueType() != 1) {
                            throw new KettleValueException("Please specify a Number type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Date) {
                        this.data.returnType[i] = 4;
                        if (fn.getValueType() != 3) {
                            throw new KettleValueException("Please specify a Date type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof byte[]) {
                        this.data.returnType[i] = 6;
                        if (fn.getValueType() != 8) {
                            throw new KettleValueException("Please specify a Binary type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Boolean) {
                        this.data.returnType[i] = 7;
                        if (fn.getValueType() != 4) {
                            throw new KettleValueException("Please specify a Boolean type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    }
                }
                if (formulaResult == null) {
                    value = null;
                } else {
                    switch (this.data.returnType[i]) {
                        case 0: {
                            value = formulaResult.toString();
                            break;
                        }
                        case 1: {
                            value = new Double(((Number)formulaResult).doubleValue());
                            break;
                        }
                        case 2: {
                            value = new Long(((Integer)formulaResult).intValue());
                            break;
                        }
                        case 3: {
                            value = (Long)formulaResult;
                            break;
                        }
                        case 4: {
                            value = (Date)formulaResult;
                            break;
                        }
                        case 5: {
                            value = (BigDecimal)formulaResult;
                            break;
                        }
                        case 6: {
                            value = (byte[])formulaResult;
                            break;
                        }
                        case 7: {
                            value = (Boolean)formulaResult;
                            break;
                        }
                        default: {
                            value = null;
                        }
                    }
                }
                if (this.data.replaceIndex[i] < 0) {
                    outputRowData[tempIndex++] = value;
                    continue;
                }
                outputRowData[this.data.replaceIndex[i]] = value;
            }
            return outputRowData;
        }
        catch (Exception e) {
            throw new KettleValueException((Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JaninoMeta)smi;
        this.data = (JaninoData)sdi;
        if (super.init(smi, sdi)) {
            this.data.returnType = new int[this.meta.getFormula().length];
            for (int i = 0; i < this.meta.getFormula().length; ++i) {
                this.data.returnType[i] = -1;
            }
            return true;
        }
        return false;
    }
}

