/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.javafilter;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepIOMeta;
import org.pentaho.di.trans.step.StepIOMetaInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.Stream;
import org.pentaho.di.trans.step.errorhandling.StreamIcon;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.javafilter.JavaFilter;
import org.pentaho.di.trans.steps.javafilter.JavaFilterData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaFilterMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = JavaFilterMeta.class;
    private String condition;

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void allocate(int nrCalcs) {
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
        targetStreams.get(0).setSubject(XMLHandler.getTagValue((Node)stepnode, (String)"send_true_to"));
        targetStreams.get(1).setSubject(XMLHandler.getTagValue((Node)stepnode, (String)"send_false_to"));
        this.condition = XMLHandler.getTagValue((Node)stepnode, (String)"condition");
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
        retval.append(XMLHandler.addTagValue((String)"send_true_to", (String)targetStreams.get(0).getStepname()));
        retval.append(XMLHandler.addTagValue((String)"send_false_to", (String)targetStreams.get(1).getStepname()));
        retval.append(XMLHandler.addTagValue((String)"condition", (String)this.condition));
        return retval.toString();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            JavaFilterMeta m = (JavaFilterMeta)obj;
            return this.getXML() == m.getXML();
        }
        return false;
    }

    @Override
    public Object clone() {
        JavaFilterMeta retval = (JavaFilterMeta)super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
        this.condition = "true";
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
        targetStreams.get(0).setSubject(rep.getStepAttributeString(id_step, "send_true_to"));
        targetStreams.get(1).setSubject(rep.getStepAttributeString(id_step, "send_false_to"));
        this.condition = rep.getStepAttributeString(id_step, "condition");
    }

    @Override
    public void searchInfoAndTargetSteps(List<StepMeta> steps) {
        for (StreamInterface stream : this.getStepIOMeta().getTargetStreams()) {
            stream.setStepMeta(StepMeta.findStep(steps, (String)stream.getSubject()));
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
        rep.saveStepAttribute(id_transformation, id_step, "send_true_to", targetStreams.get(0).getStepname());
        rep.saveStepAttribute(id_transformation, id_step, "send_false_to", targetStreams.get(1).getStepname());
        rep.saveStepAttribute(id_transformation, id_step, "condition", this.condition);
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        int falseTargetIdx;
        int trueTargetIdx;
        CheckResult cr;
        String error_message = "";
        List<StreamInterface> targetStreams = this.getStepIOMeta().getTargetStreams();
        if (targetStreams.get(0).getStepname() != null && targetStreams.get(1).getStepname() != null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.BothTrueAndFalseStepSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else if (targetStreams.get(0).getStepname() == null && targetStreams.get(1).getStepname() == null) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.NeitherTrueAndFalseStepSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.PlsSpecifyBothTrueAndFalseStep", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (targetStreams.get(0).getStepname() != null && (trueTargetIdx = Const.indexOfString((String)targetStreams.get(0).getStepname(), (String[])output)) < 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.TargetStepInvalid", (String[])new String[]{"true", targetStreams.get(0).getStepname()}), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (targetStreams.get(1).getStepname() != null && (falseTargetIdx = Const.indexOfString((String)targetStreams.get(1).getStepname(), (String[])output)) < 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.TargetStepInvalid", (String[])new String[]{"false", targetStreams.get(1).getStepname()}), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        cr = Const.isEmpty((String)this.condition) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.NoConditionSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepinfo) : new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.ConditionSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
        remarks.add((CheckResultInterface)cr);
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.StepReceivingFields", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            error_message = BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.CouldNotReadFieldsFromPreviousStep", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JavaFilterMeta.CheckResult.NoInputReceivedFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new JavaFilter(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new JavaFilterData();
    }

    @Override
    public StepIOMetaInterface getStepIOMeta() {
        if (this.ioMeta == null) {
            this.ioMeta = new StepIOMeta(true, true, false, false, false, false);
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"JavaFilterMeta.InfoStream.True.Description", (String[])new String[0]), StreamIcon.TRUE, null));
            this.ioMeta.addStream(new Stream(StreamInterface.StreamType.TARGET, null, BaseMessages.getString(PKG, (String)"JavaFilterMeta.InfoStream.False.Description", (String[])new String[0]), StreamIcon.FALSE, null));
        }
        return this.ioMeta;
    }

    @Override
    public void resetStepIoMeta() {
    }

    @Override
    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }
}

