/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.ldapinput.store;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.ldapinput.store.KettleTrustManager;
import org.pentaho.di.trans.steps.ldapinput.store.TrustAlwaysManager;

public class CustomSocketFactory
extends SSLSocketFactory {
    private static Class<?> PKG = CustomSocketFactory.class;
    private static boolean configured;
    private static TrustManager[] trustManagers;
    private static final TrustManager[] ALWAYS_TRUST_MANAGER;
    private SSLSocketFactory factory;

    public CustomSocketFactory() {
    }

    protected CustomSocketFactory(SSLSocketFactory factory) {
        this.factory = factory;
    }

    public static synchronized SocketFactory getDefault() {
        SSLContext ctx;
        if (!configured) {
            throw new IllegalStateException();
        }
        try {
            ctx = SSLContext.getInstance("TLS");
            ctx.init(null, trustManagers, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return new CustomSocketFactory(ctx.getSocketFactory());
    }

    public static synchronized void configure(String path, String password) throws KettleException {
        KeyStore keyStore;
        try {
            keyStore = !Const.isEmpty((String)path) && path.endsWith(".p12") ? KeyStore.getInstance("PKCS12") : KeyStore.getInstance("JKS");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"KettleTrustManager.Exception.CouldNotCreateCertStore", (String[])new String[0]), (Throwable)e);
        }
        trustManagers = new KettleTrustManager[]{new KettleTrustManager(keyStore, path, password)};
        configured = true;
    }

    public static synchronized void configure() {
        trustManagers = ALWAYS_TRUST_MANAGER;
        configured = true;
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port);
    }

    public Socket createSocket(String host, int port, InetAddress client_host, int client_port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port, client_host, client_port);
    }

    public Socket createSocket(InetAddress host, int port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port);
    }

    public Socket createSocket(InetAddress host, int port, InetAddress client_host, int client_port) throws IOException, UnknownHostException {
        return this.factory.createSocket(host, port, client_host, client_port);
    }

    public Socket createSocket(Socket socket, String host, int port, boolean autoclose) throws IOException, UnknownHostException {
        return this.factory.createSocket(socket, host, port, autoclose);
    }

    public String[] getDefaultCipherSuites() {
        return this.factory.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return this.factory.getSupportedCipherSuites();
    }

    static {
        trustManagers = null;
        ALWAYS_TRUST_MANAGER = new TrustManager[]{new TrustAlwaysManager()};
    }
}

