/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.loadfileinput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInput;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputData;
import org.pentaho.di.trans.steps.loadfileinput.LoadFileInputField;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadFileInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = LoadFileInputMeta.class;
    public static final String[] RequiredFilesDesc = new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])};
    public static final String[] RequiredFilesCode = new String[]{"N", "Y"};
    private static final String NO = "N";
    private static final String YES = "Y";
    private String[] fileName;
    private String[] fileMask;
    private String[] excludeFileMask;
    private boolean includeFilename;
    private String filenameField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private long rowLimit;
    private LoadFileInputField[] inputFields;
    private String encoding;
    private String DynamicFilenameField;
    private boolean fileinfield;
    private boolean addresultfile;
    private String[] fileRequired;
    private boolean IsIgnoreEmptyFile;
    private String[] includeSubFolders;
    private String shortFileFieldName;
    private String pathFieldName;
    private String hiddenFieldName;
    private String lastModificationTimeFieldName;
    private String uriNameFieldName;
    private String rootUriNameFieldName;
    private String extensionFieldName;

    public String getShortFileNameField() {
        return this.shortFileFieldName;
    }

    public void setShortFileNameField(String field) {
        this.shortFileFieldName = field;
    }

    public String getPathField() {
        return this.pathFieldName;
    }

    public void setPathField(String field) {
        this.pathFieldName = field;
    }

    public String isHiddenField() {
        return this.hiddenFieldName;
    }

    public void setIsHiddenField(String field) {
        this.hiddenFieldName = field;
    }

    public String getLastModificationDateField() {
        return this.lastModificationTimeFieldName;
    }

    public void setLastModificationDateField(String field) {
        this.lastModificationTimeFieldName = field;
    }

    public String getUriField() {
        return this.uriNameFieldName;
    }

    public void setUriField(String field) {
        this.uriNameFieldName = field;
    }

    public String getRootUriField() {
        return this.rootUriNameFieldName;
    }

    public void setRootUriField(String field) {
        this.rootUriNameFieldName = field;
    }

    public String getExtensionField() {
        return this.extensionFieldName;
    }

    public void setExtensionField(String field) {
        this.extensionFieldName = field;
    }

    public String[] getFileRequired() {
        return this.fileRequired;
    }

    public void setFileRequired(String[] fileRequired) {
        this.fileRequired = fileRequired;
    }

    public String[] getExludeFileMask() {
        return this.excludeFileMask;
    }

    public void setExcludeFileMask(String[] excludeFileMask) {
        this.excludeFileMask = excludeFileMask;
    }

    public boolean addResultFile() {
        return this.addresultfile;
    }

    public boolean isIgnoreEmptyFile() {
        return this.IsIgnoreEmptyFile;
    }

    public void setIgnoreEmptyFile(boolean IsIgnoreEmptyFile) {
        this.IsIgnoreEmptyFile = IsIgnoreEmptyFile;
    }

    public void setAddResultFile(boolean addresultfile) {
        this.addresultfile = addresultfile;
    }

    public LoadFileInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(LoadFileInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getDynamicFilenameField() {
        return this.DynamicFilenameField;
    }

    public void setDynamicFilenameField(String DynamicFilenameField) {
        this.DynamicFilenameField = DynamicFilenameField;
    }

    public boolean getIsInFields() {
        return this.fileinfield;
    }

    public void setIsInFields(boolean IsInFields) {
        this.fileinfield = IsInFields;
    }

    public String[] getFileMask() {
        return this.fileMask;
    }

    public void setFileMask(String[] fileMask) {
        this.fileMask = fileMask;
    }

    public String[] getFileName() {
        return this.fileName;
    }

    public String[] getIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setIncludeSubFolders(String[] includeSubFoldersin) {
        for (int i = 0; i < includeSubFoldersin.length; ++i) {
            this.includeSubFolders[i] = this.getRequiredFilesCode(includeSubFoldersin[i]);
        }
    }

    public String getRequiredFilesCode(String tt) {
        if (tt == null) {
            return RequiredFilesCode[0];
        }
        if (tt.equals(RequiredFilesDesc[1])) {
            return RequiredFilesCode[1];
        }
        return RequiredFilesCode[0];
    }

    public String getRequiredFilesDesc(String tt) {
        if (tt == null) {
            return RequiredFilesDesc[0];
        }
        if (tt.equals(RequiredFilesCode[1])) {
            return RequiredFilesDesc[1];
        }
        return RequiredFilesDesc[0];
    }

    public void setFileName(String[] fileName) {
        this.fileName = fileName;
    }

    public String getFilenameField() {
        return this.filenameField;
    }

    public void setFilenameField(String filenameField) {
        this.filenameField = filenameField;
    }

    public boolean includeFilename() {
        return this.includeFilename;
    }

    public void setIncludeFilename(boolean includeFilename) {
        this.includeFilename = includeFilename;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public long getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(long rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        int i;
        LoadFileInputMeta retval = (LoadFileInputMeta)super.clone();
        int nrFiles = this.fileName.length;
        int nrFields = this.inputFields.length;
        retval.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            retval.fileName[i] = this.fileName[i];
            retval.fileMask[i] = this.fileMask[i];
            retval.excludeFileMask[i] = this.excludeFileMask[i];
            retval.fileRequired[i] = this.fileRequired[i];
            retval.includeSubFolders[i] = this.includeSubFolders[i];
        }
        for (i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (LoadFileInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"include", (boolean)this.includeFilename));
        retval.append("    " + XMLHandler.addTagValue((String)"include_field", (String)this.filenameField));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum", (boolean)this.includeRowNumber));
        retval.append("    " + XMLHandler.addTagValue((String)"addresultfile", (boolean)this.addresultfile));
        retval.append("    " + XMLHandler.addTagValue((String)"IsIgnoreEmptyFile", (boolean)this.IsIgnoreEmptyFile));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    " + XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    <file>" + Const.CR);
        for (i = 0; i < this.fileName.length; ++i) {
            retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fileName[i]));
            retval.append("      " + XMLHandler.addTagValue((String)"filemask", (String)this.fileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"exclude_filemask", (String)this.excludeFileMask[i]));
            retval.append("      ").append(XMLHandler.addTagValue((String)"file_required", (String)this.fileRequired[i]));
            retval.append("      " + XMLHandler.addTagValue((String)"include_subfolders", (String)this.includeSubFolders[i]));
        }
        retval.append("      </file>" + Const.CR);
        retval.append("    <fields>" + Const.CR);
        for (i = 0; i < this.inputFields.length; ++i) {
            LoadFileInputField field = this.inputFields[i];
            retval.append(field.getXML());
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"limit", (long)this.rowLimit));
        retval.append("    " + XMLHandler.addTagValue((String)"IsInFields", (boolean)this.fileinfield));
        retval.append("    " + XMLHandler.addTagValue((String)"DynamicFilenameField", (String)this.DynamicFilenameField));
        retval.append("    ").append(XMLHandler.addTagValue((String)"shortFileFieldName", (String)this.shortFileFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"pathFieldName", (String)this.pathFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"hiddenFieldName", (String)this.hiddenFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"lastModificationTimeFieldName", (String)this.lastModificationTimeFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"uriNameFieldName", (String)this.uriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"rootUriNameFieldName", (String)this.rootUriNameFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"extensionFieldName", (String)this.extensionFieldName));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            int i;
            this.includeFilename = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include"));
            this.filenameField = XMLHandler.getTagValue((Node)stepnode, (String)"include_field");
            this.addresultfile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"addresultfile"));
            this.IsIgnoreEmptyFile = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsIgnoreEmptyFile"));
            this.includeRowNumber = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"rownum"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            Node filenode = XMLHandler.getSubNode((Node)stepnode, (String)"file");
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFiles = XMLHandler.countNodes((Node)filenode, (String)"name");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                Node filenamenode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"name", (int)i);
                Node filemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"filemask", (int)i);
                Node excludefilemasknode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"exclude_filemask", (int)i);
                Node fileRequirednode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"file_required", (int)i);
                Node includeSubFoldersnode = XMLHandler.getSubNodeByNr((Node)filenode, (String)"include_subfolders", (int)i);
                this.fileName[i] = XMLHandler.getNodeValue((Node)filenamenode);
                this.fileMask[i] = XMLHandler.getNodeValue((Node)filemasknode);
                this.excludeFileMask[i] = XMLHandler.getNodeValue((Node)excludefilemasknode);
                this.fileRequired[i] = XMLHandler.getNodeValue((Node)fileRequirednode);
                this.includeSubFolders[i] = XMLHandler.getNodeValue((Node)includeSubFoldersnode);
            }
            for (i = 0; i < nrFields; ++i) {
                LoadFileInputField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new LoadFileInputField(fnode);
            }
            this.rowLimit = Const.toLong((String)XMLHandler.getTagValue((Node)stepnode, (String)"limit"), (long)0L);
            this.fileinfield = YES.equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"IsInFields"));
            this.DynamicFilenameField = XMLHandler.getTagValue((Node)stepnode, (String)"DynamicFilenameField");
            this.shortFileFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"shortFileFieldName");
            this.pathFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"pathFieldName");
            this.hiddenFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"hiddenFieldName");
            this.lastModificationTimeFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"lastModificationTimeFieldName");
            this.uriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"uriNameFieldName");
            this.rootUriNameFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"rootUriNameFieldName");
            this.extensionFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"extensionFieldName");
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"LoadFileInputMeta.Exception.ErrorLoadingXML", (String[])new String[]{e.toString()}));
        }
    }

    public void allocate(int nrfiles, int nrfields) {
        this.fileName = new String[nrfiles];
        this.fileMask = new String[nrfiles];
        this.excludeFileMask = new String[nrfiles];
        this.fileRequired = new String[nrfiles];
        this.includeSubFolders = new String[nrfiles];
        this.inputFields = new LoadFileInputField[nrfields];
    }

    @Override
    public void setDefault() {
        int i;
        this.shortFileFieldName = null;
        this.pathFieldName = null;
        this.hiddenFieldName = null;
        this.lastModificationTimeFieldName = null;
        this.uriNameFieldName = null;
        this.rootUriNameFieldName = null;
        this.extensionFieldName = null;
        this.encoding = "";
        this.IsIgnoreEmptyFile = false;
        this.includeFilename = false;
        this.filenameField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.addresultfile = true;
        int nrFiles = 0;
        int nrFields = 0;
        this.allocate(nrFiles, nrFields);
        for (i = 0; i < nrFiles; ++i) {
            this.fileName[i] = "filename" + (i + 1);
            this.fileMask[i] = "";
            this.excludeFileMask[i] = "";
            this.fileRequired[i] = RequiredFilesCode[0];
            this.includeSubFolders[i] = RequiredFilesCode[0];
        }
        for (i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new LoadFileInputField("field" + (i + 1));
        }
        this.rowLimit = 0L;
        this.fileinfield = false;
        this.DynamicFilenameField = null;
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        ValueMeta v;
        if (!this.getIsInFields()) {
            r.clear();
        }
        for (int i = 0; i < this.inputFields.length; ++i) {
            LoadFileInputField field = this.inputFields[i];
            int type = field.getType();
            switch (field.getElementType()) {
                case 0: {
                    if (type != 0) break;
                    type = 2;
                    break;
                }
                case 1: {
                    if (type != 0) break;
                    type = 5;
                    break;
                }
            }
            ValueMeta v2 = new ValueMeta(space.environmentSubstitute(field.getName()), type);
            v2.setLength(field.getLength());
            v2.setPrecision(field.getPrecision());
            v2.setConversionMask(field.getFormat());
            v2.setCurrencySymbol(field.getCurrencySymbol());
            v2.setDecimalSymbol(field.getDecimalSymbol());
            v2.setGroupingSymbol(field.getGroupSymbol());
            v2.setTrimType(field.getTrimType());
            v2.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v2);
        }
        if (this.includeFilename) {
            v = new ValueMeta(space.environmentSubstitute(this.filenameField), 2);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber) {
            v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getShortFileNameField() != null && this.getShortFileNameField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getShortFileNameField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getExtensionField() != null && this.getExtensionField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getExtensionField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getPathField() != null && this.getPathField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getPathField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.isHiddenField() != null && this.isHiddenField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.isHiddenField()), 4);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getLastModificationDateField() != null && this.getLastModificationDateField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getLastModificationDateField()), 3);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getUriField() != null && this.getUriField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getUriField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.getRootUriField() != null && this.getRootUriField().length() > 0) {
            v = new ValueMeta(space.environmentSubstitute(this.getRootUriField()), 2);
            v.setLength(100, -1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int i;
            this.includeFilename = rep.getStepAttributeBoolean(id_step, "include");
            this.filenameField = rep.getStepAttributeString(id_step, "include_field");
            this.addresultfile = rep.getStepAttributeBoolean(id_step, "addresultfile");
            this.IsIgnoreEmptyFile = rep.getStepAttributeBoolean(id_step, "IsIgnoreEmptyFile");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "rownum");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.rowLimit = rep.getStepAttributeInteger(id_step, "limit");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            int nrFiles = rep.countNrStepAttributes(id_step, "file_name");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFiles, nrFields);
            for (i = 0; i < nrFiles; ++i) {
                this.fileName[i] = rep.getStepAttributeString(id_step, i, "file_name");
                this.fileMask[i] = rep.getStepAttributeString(id_step, i, "file_mask");
                this.excludeFileMask[i] = rep.getStepAttributeString(id_step, i, "exclude_file_mask");
                this.fileRequired[i] = rep.getStepAttributeString(id_step, i, "file_required");
                if (!YES.equalsIgnoreCase(this.fileRequired[i])) {
                    this.fileRequired[i] = NO;
                }
                this.includeSubFolders[i] = rep.getStepAttributeString(id_step, i, "include_subfolders");
                if (YES.equalsIgnoreCase(this.includeSubFolders[i])) continue;
                this.includeSubFolders[i] = NO;
            }
            for (i = 0; i < nrFields; ++i) {
                LoadFileInputField field = new LoadFileInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setElementType(LoadFileInputField.getElementTypeByCode(rep.getStepAttributeString(id_step, i, "element_type")));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(LoadFileInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
            this.fileinfield = rep.getStepAttributeBoolean(id_step, "IsInFields");
            this.DynamicFilenameField = rep.getStepAttributeString(id_step, "DynamicFilenameField");
            this.DynamicFilenameField = rep.getStepAttributeString(id_step, "DynamicFilenameField");
            this.shortFileFieldName = rep.getStepAttributeString(id_step, "shortFileFieldName");
            this.pathFieldName = rep.getStepAttributeString(id_step, "pathFieldName");
            this.hiddenFieldName = rep.getStepAttributeString(id_step, "hiddenFieldName");
            this.lastModificationTimeFieldName = rep.getStepAttributeString(id_step, "lastModificationTimeFieldName");
            this.rootUriNameFieldName = rep.getStepAttributeString(id_step, "rootUriNameFieldName");
            this.extensionFieldName = rep.getStepAttributeString(id_step, "extensionFieldName");
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LoadFileInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "include", this.includeFilename);
            rep.saveStepAttribute(id_transformation, id_step, "include_field", this.filenameField);
            rep.saveStepAttribute(id_transformation, id_step, "addresultfile", this.addresultfile);
            rep.saveStepAttribute(id_transformation, id_step, "IsIgnoreEmptyFile", this.IsIgnoreEmptyFile);
            rep.saveStepAttribute(id_transformation, id_step, "rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            for (i = 0; i < this.fileName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "file_name", this.fileName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_mask", this.fileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "excludefile_mask", this.excludeFileMask[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "file_required", this.fileRequired[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "include_subfolders", this.includeSubFolders[i]);
            }
            for (i = 0; i < this.inputFields.length; ++i) {
                LoadFileInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "element_type", field.getElementTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
            rep.saveStepAttribute(id_transformation, id_step, "IsInFields", this.fileinfield);
            rep.saveStepAttribute(id_transformation, id_step, "DynamicFilenameField", this.DynamicFilenameField);
            rep.saveStepAttribute(id_transformation, id_step, "shortFileFieldName", this.shortFileFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "pathFieldName", this.pathFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "hiddenFieldName", this.hiddenFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "lastModificationTimeFieldName", this.lastModificationTimeFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "uriNameFieldName", this.uriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "rootUriNameFieldName", this.rootUriNameFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "extensionFieldName", this.extensionFieldName);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"LoadFileInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    public FileInputList getFiles(VariableSpace space) {
        return FileInputList.createFileList((VariableSpace)space, (String[])this.fileName, (String[])this.fileMask, (String[])this.excludeFileMask, (String[])this.fileRequired, (boolean[])this.includeSubFolderBoolean());
    }

    private boolean[] includeSubFolderBoolean() {
        int len = this.fileName.length;
        boolean[] includeSubFolderBoolean = new boolean[len];
        for (int i = 0; i < len; ++i) {
            includeSubFolderBoolean[i] = YES.equalsIgnoreCase(this.includeSubFolders[i]);
        }
        return includeSubFolderBoolean;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepinfo, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (input.length <= 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.getIsInFields()) {
            if (Const.isEmpty((String)this.getDynamicFilenameField())) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoField", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.FieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        } else {
            FileInputList fileInputList = this.getFiles(transMeta);
            if (fileInputList == null || fileInputList.getFiles().size() == 0) {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.NoFiles", (String[])new String[0]), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"LoadFileInputMeta.CheckResult.FilesOk", (String[])new String[]{"" + fileInputList.getFiles().size()}), (CheckResultSourceInterface)stepinfo);
                remarks.add((CheckResultInterface)cr);
            }
        }
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            if (!this.fileinfield) {
                for (int i = 0; i < this.fileName.length; ++i) {
                    FileObject fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName[i]), (VariableSpace)space);
                    this.fileName[i] = resourceNamingInterface.nameResource(fileObject, space, Const.isEmpty((String)this.fileMask[i]));
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new LoadFileInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new LoadFileInputData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

