/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mailinput;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.getpop.MailConnection;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mailinput.MailInputData;
import org.pentaho.di.trans.steps.mailinput.MailInputMeta;

public class MailInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MailInputMeta.class;
    private MailInputMeta meta;
    private MailInputData data;

    public MailInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MailInputMeta)smi;
        this.data = (MailInputData)sdi;
        Object[] outputRowData = this.getOneRow();
        if (outputRowData == null) {
            this.setOutputDone();
            return false;
        }
        if (this.isRowLevel()) {
            this.log.logRowlevel(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"MailInput.Log.OutputRow", (String[])new String[]{this.data.outputRowMeta.getString(outputRowData)})});
        }
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.data.rowlimit > 0 && this.data.rownr >= (long)this.data.rowlimit) {
            this.setOutputDone();
            return false;
        }
        return true;
    }

    public String[] getFolders(String realIMAPFolder) throws KettleException {
        this.data.folderenr = 0;
        this.data.messagesCount = 0;
        this.data.rownr = 0L;
        String[] folderslist = null;
        if (this.meta.isIncludeSubFolders()) {
            String[] folderslist0 = this.data.mailConn.returnAllFolders(realIMAPFolder);
            if (folderslist0 == null || folderslist0.length == 0) {
                folderslist = new String[]{Const.NVL((String)realIMAPFolder, (String)"INBOX")};
            } else {
                folderslist = new String[folderslist0.length + 1];
                folderslist[0] = Const.NVL((String)realIMAPFolder, (String)"INBOX");
                for (int i = 0; i < folderslist0.length; ++i) {
                    folderslist[i + 1] = folderslist0[i];
                }
            }
        } else {
            folderslist = new String[]{Const.NVL((String)realIMAPFolder, (String)"INBOX")};
        }
        return folderslist;
    }

    private void applySearch(Date beginDate, Date endDate) {
        String realSearchSubject;
        String realSearchReceipient;
        String realSearchSender = this.environmentSubstitute(this.meta.getSenderSearchTerm());
        if (!Const.isEmpty((String)realSearchSender)) {
            this.data.mailConn.setSenderTerm(realSearchSender, this.meta.isNotTermSenderSearch());
        }
        if (!Const.isEmpty((String)(realSearchReceipient = this.environmentSubstitute(this.meta.getRecipientSearch())))) {
            this.data.mailConn.setReceipientTerm(realSearchReceipient);
        }
        if (!Const.isEmpty((String)(realSearchSubject = this.environmentSubstitute(this.meta.getSubjectSearch())))) {
            this.data.mailConn.setSubjectTerm(realSearchSubject, this.meta.isNotTermSubjectSearch());
        }
        switch (this.meta.getConditionOnReceivedDate()) {
            case 1: {
                this.data.mailConn.setReceivedDateTermEQ(beginDate);
                break;
            }
            case 3: {
                this.data.mailConn.setReceivedDateTermGT(beginDate);
                break;
            }
            case 2: {
                this.data.mailConn.setReceivedDateTermLT(beginDate);
                break;
            }
            case 4: {
                this.data.mailConn.setReceivedDateTermBetween(beginDate, endDate);
                break;
            }
        }
        if (this.data.usePOP) {
            if (this.meta.getRetrievemails() == 1) {
                this.data.mailConn.setFlagTermNew();
            }
        } else {
            switch (this.meta.getValueImapList()) {
                case 1: {
                    this.data.mailConn.setFlagTermNew();
                    break;
                }
                case 2: {
                    this.data.mailConn.setFlagTermOld();
                    break;
                }
                case 3: {
                    this.data.mailConn.setFlagTermRead();
                    break;
                }
                case 4: {
                    this.data.mailConn.setFlagTermUnread();
                    break;
                }
                case 5: {
                    this.data.mailConn.setFlagTermFlagged();
                    break;
                }
                case 6: {
                    this.data.mailConn.setFlagTermNotFlagged();
                    break;
                }
                case 7: {
                    this.data.mailConn.setFlagTermDraft();
                    break;
                }
                case 8: {
                    this.data.mailConn.setFlagTermNotDraft();
                    break;
                }
            }
        }
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    private Object[] getOneRow() throws KettleException {
        while (this.data.rownr >= (long)this.data.messagesCount || this.data.folder == null) {
            if (this.openNextFolder()) continue;
            return null;
        }
        Object[] r = this.buildEmptyRow();
        if (this.meta.isDynamicFolder()) {
            System.arraycopy(this.data.readrow, 0, r, 0, this.data.readrow.length);
        }
        try {
            this.data.mailConn.fetchNext();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.FetchingMessage", (Object[])new Object[]{this.data.mailConn.getMessage().getMessageNumber()}));
            }
            block24: for (int i = 0; i < this.data.nrFields; ++i) {
                int index = this.data.totalpreviousfields + i;
                switch (this.meta.getInputFields()[i].getColumn()) {
                    case 0: {
                        r[index] = new Long(this.data.mailConn.getMessage().getMessageNumber());
                        continue block24;
                    }
                    case 1: {
                        r[index] = this.data.mailConn.getMessage().getSubject();
                        continue block24;
                    }
                    case 2: {
                        String From = null;
                        if (this.data.mailConn.getMessage().getFrom() != null) {
                            for (int f = 0; f < this.data.mailConn.getMessage().getFrom().length; ++f) {
                                From = From == null ? this.data.mailConn.getMessage().getFrom()[f].toString() : From + ";" + this.data.mailConn.getMessage().getFrom()[f].toString();
                            }
                        }
                        r[index] = From;
                        continue block24;
                    }
                    case 3: {
                        String replyto = null;
                        if (this.data.mailConn.getMessage().getReplyTo() != null) {
                            for (int f = 0; f < this.data.mailConn.getMessage().getReplyTo().length; ++f) {
                                replyto = replyto == null ? this.data.mailConn.getMessage().getReplyTo()[f].toString() : replyto + ";" + this.data.mailConn.getMessage().getReplyTo()[f].toString();
                            }
                        }
                        r[index] = replyto;
                        continue block24;
                    }
                    case 4: {
                        String Recipients = null;
                        for (int f = 0; f < this.data.mailConn.getMessage().getAllRecipients().length; ++f) {
                            Recipients = Recipients == null ? this.data.mailConn.getMessage().getAllRecipients()[f].toString() : Recipients + ";" + this.data.mailConn.getMessage().getAllRecipients()[f].toString();
                        }
                        r[index] = Recipients;
                        continue block24;
                    }
                    case 5: {
                        r[index] = this.data.mailConn.getMessage().getDescription();
                        continue block24;
                    }
                    case 6: {
                        r[index] = this.data.mailConn.getMessageBody();
                        continue block24;
                    }
                    case 7: {
                        Date receivedDate = this.data.mailConn.getMessage().getReceivedDate();
                        if (receivedDate != null) {
                            r[index] = new Date(receivedDate.getTime());
                            continue block24;
                        }
                        r[index] = null;
                        continue block24;
                    }
                    case 8: {
                        r[index] = new Date(this.data.mailConn.getMessage().getSentDate().getTime());
                        continue block24;
                    }
                    case 9: {
                        r[index] = this.data.mailConn.getMessage().getContentType();
                        continue block24;
                    }
                    case 10: {
                        r[index] = this.data.mailConn.getFolderName();
                        continue block24;
                    }
                    case 11: {
                        r[index] = new Long(this.data.mailConn.getMessage().getSize());
                        continue block24;
                    }
                    case 15: {
                        r[index] = new Boolean(this.data.mailConn.isMessageDraft());
                        continue block24;
                    }
                    case 14: {
                        r[index] = new Boolean(this.data.mailConn.isMessageFlagged());
                        continue block24;
                    }
                    case 12: {
                        r[index] = new Boolean(this.data.mailConn.isMessageNew());
                        continue block24;
                    }
                    case 13: {
                        r[index] = new Boolean(this.data.mailConn.isMessageRead());
                        continue block24;
                    }
                    case 16: {
                        r[index] = new Boolean(this.data.mailConn.isMessageDeleted());
                        continue block24;
                    }
                    case 17: {
                        r[index] = new Long(this.data.mailConn.getAttachedFilesCount(null));
                        continue block24;
                    }
                    case 18: {
                        String name = this.meta.getInputFields()[i].getName();
                        String[] headerValues = this.data.mailConn.getMessage().getHeader(name);
                        StringBuffer sb = new StringBuffer();
                        if (headerValues == null || headerValues.length <= 0) continue block24;
                        for (int h = 0; h < headerValues.length; ++h) {
                            if (h > 0) {
                                sb.append(";");
                            }
                            sb.append(headerValues[h]);
                        }
                        r[index] = new String(sb.toString());
                    }
                }
            }
            this.incrementLinesInput();
            ++this.data.rownr;
        }
        catch (Exception e) {
            throw new KettleException("Error adding values to row!", (Throwable)e);
        }
        return r;
    }

    private boolean openNextFolder() {
        try {
            if (!this.meta.isDynamicFolder()) {
                if (this.data.folderenr >= this.data.folders.length) {
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                    }
                    return false;
                }
            } else {
                String foldername;
                if (this.first) {
                    this.first = false;
                    this.data.readrow = this.getRow();
                    if (this.data.readrow == null) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                        }
                        return false;
                    }
                    this.data.inputRowMeta = this.getInputRowMeta();
                    this.data.outputRowMeta = this.data.inputRowMeta.clone();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.totalpreviousfields = this.data.inputRowMeta.size();
                    if (Const.isEmpty((String)this.meta.getFolderField())) {
                        this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.DynamicFolderFieldMissing", (String[])new String[0]));
                        this.stopAll();
                        this.setErrors(1L);
                        return false;
                    }
                    this.data.indexOfFolderField = this.data.inputRowMeta.indexOfValue(this.meta.getFolderField());
                    if (this.data.indexOfFolderField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.DynamicFolderUnreachable", (String[])new String[]{this.meta.getFolderField()}));
                        this.stopAll();
                        this.setErrors(1L);
                        return false;
                    }
                    foldername = this.data.inputRowMeta.getString(this.data.readrow, this.data.indexOfFolderField);
                    if (this.isDebug()) {
                        this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.FoldernameInStream", (String[])new String[]{this.meta.getFolderField(), foldername}));
                    }
                    this.data.folders = this.getFolders(foldername);
                }
                if (this.data.folderenr >= this.data.folders.length) {
                    this.data.readrow = this.getRow();
                    if (this.data.readrow == null) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"MailInput.Log.FinishedProcessing", (String[])new String[0]));
                        }
                        return false;
                    }
                    foldername = this.data.inputRowMeta.getString(this.data.readrow, this.data.indexOfFolderField);
                    this.data.folders = this.getFolders(foldername);
                }
            }
            this.data.folder = this.data.folders[this.data.folderenr];
            ++this.data.folderenr;
            if (!this.data.usePOP && !Const.isEmpty((String)this.data.folder)) {
                this.data.mailConn.openFolder(this.data.folder, false);
            } else {
                this.data.mailConn.openFolder(false);
            }
            this.data.mailConn.retrieveMessages();
            this.data.messagesCount = this.data.mailConn.getMessagesCount();
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"MailInput.Log.MessagesInFolder", (Object[])new Object[]{this.data.folder, this.data.messagesCount}));
            }
        }
        catch (Exception e) {
            this.logError("Error opening folder " + this.data.folderenr + " " + this.data.folder + ": " + e.toString());
            this.logError(Const.getStackTracker((Throwable)e));
            this.stopAll();
            this.setErrors(1L);
            return false;
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailInputMeta)smi;
        this.data = (MailInputData)sdi;
        if (super.init(smi, sdi)) {
            if (!this.meta.isDynamicFolder()) {
                try {
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"MailInput.ErrorInit", (String[])new String[]{e.toString()}));
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            this.data.usePOP = this.meta.getProtocol().equals("POP3");
            String realserver = this.environmentSubstitute(this.meta.getServerName());
            String realusername = this.environmentSubstitute(this.meta.getUserName());
            String realpassword = this.environmentSubstitute(this.meta.getPassword());
            int realport = Const.toInt((String)this.environmentSubstitute(this.meta.getPort()), (int)-1);
            String realProxyUsername = this.environmentSubstitute(this.meta.getProxyUsername());
            if (!this.meta.isDynamicFolder()) {
                String reallimitrow = this.environmentSubstitute(this.meta.getRowLimit());
                this.data.rowlimit = Const.toInt((String)reallimitrow, (int)0);
            }
            Date beginDate = null;
            Date endDate = null;
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                switch (this.meta.getConditionOnReceivedDate()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        String realBeginDate = this.environmentSubstitute(this.meta.getReceivedDate1());
                        if (Const.isEmpty((String)realBeginDate)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDateSearchTermEmpty", (String[])new String[0]));
                        }
                        beginDate = df.parse(realBeginDate);
                        break;
                    }
                    case 4: {
                        String realBeginDate = this.environmentSubstitute(this.meta.getReceivedDate1());
                        if (Const.isEmpty((String)realBeginDate)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                        }
                        beginDate = df.parse(realBeginDate);
                        String realEndDate = this.environmentSubstitute(this.meta.getReceivedDate2());
                        if (Const.isEmpty((String)realEndDate)) {
                            throw new KettleException(BaseMessages.getString(PKG, (String)"MailInput.Error.ReceivedDatesSearchTermEmpty", (String[])new String[0]));
                        }
                        endDate = df.parse(realEndDate);
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.SettingSearchTerms", (String[])new String[]{e.getMessage()}));
                this.setErrors(1L);
                this.stopAll();
            }
            try {
                this.data.mailConn = new MailConnection(this.log, this.data.usePOP ? 0 : 1, realserver, realport, realusername, realpassword, this.meta.isUseSSL(), this.meta.isUseProxy(), realProxyUsername);
                this.data.mailConn.connect();
                this.applySearch(beginDate, endDate);
                if (!this.meta.isDynamicFolder()) {
                    String realIMAPFolder = this.environmentSubstitute(this.meta.getIMAPFolder());
                    this.data.folders = this.getFolders(realIMAPFolder);
                }
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"MailInput.Error.OpeningConnection", (String[])new String[]{e.getMessage()}));
                this.setErrors(1L);
                this.stopAll();
            }
            this.data.nrFields = this.meta.getInputFields() != null ? this.meta.getInputFields().length : 0;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MailInputMeta)smi;
        this.data = (MailInputData)sdi;
        if (this.data.mailConn != null) {
            try {
                this.data.mailConn.disconnect();
                this.data.mailConn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        super.dispose(smi, sdi);
    }
}

