/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mergejoin;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.mergejoin.MergeJoinData;
import org.pentaho.di.trans.steps.mergejoin.MergeJoinMeta;

public class MergeJoin
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MergeJoinMeta.class;
    private MergeJoinMeta meta;
    private MergeJoinData data;

    public MergeJoin(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        int cmp;
        this.meta = (MergeJoinMeta)smi;
        this.data = (MergeJoinData)sdi;
        if (this.first) {
            int i;
            this.first = false;
            List<StreamInterface> infoStreams = this.meta.getStepIOMeta().getInfoStreams();
            this.data.oneRowSet = this.findInputRowSet(infoStreams.get(0).getStepname());
            if (this.data.oneRowSet == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MergeJoin.Exception.UnableToFindSpecifiedStep", (String[])new String[]{infoStreams.get(0).getStepname()}));
            }
            this.data.twoRowSet = this.findInputRowSet(infoStreams.get(1).getStepname());
            if (this.data.twoRowSet == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MergeJoin.Exception.UnableToFindSpecifiedStep", (String[])new String[]{infoStreams.get(1).getStepname()}));
            }
            this.data.one = this.getRowFrom(this.data.oneRowSet);
            if (this.data.one != null) {
                this.data.oneMeta = this.data.oneRowSet.getRowMeta();
            } else {
                this.data.one = null;
                this.data.oneMeta = this.getTransMeta().getStepFields(infoStreams.get(0).getStepname());
            }
            this.data.two = this.getRowFrom(this.data.twoRowSet);
            if (this.data.two != null) {
                this.data.twoMeta = this.data.twoRowSet.getRowMeta();
            } else {
                this.data.two = null;
                this.data.twoMeta = this.getTransMeta().getStepFields(infoStreams.get(1).getStepname());
            }
            this.data.outputRowMeta = new RowMeta();
            this.data.outputRowMeta.mergeRowMeta(this.data.oneMeta.clone());
            this.data.outputRowMeta.mergeRowMeta(this.data.twoMeta.clone());
            if (this.data.one != null) {
                this.data.keyNrs1 = new int[this.meta.getKeyFields1().length];
                for (i = 0; i < this.data.keyNrs1.length; ++i) {
                    this.data.keyNrs1[i] = this.data.oneMeta.indexOfValue(this.meta.getKeyFields1()[i]);
                    if (this.data.keyNrs1[i] >= 0) continue;
                    String message = BaseMessages.getString(PKG, (String)"MergeJoin.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{this.meta.getKeyFields1()[i]});
                    this.logError(message);
                    throw new KettleStepException(message);
                }
            }
            if (this.data.two != null) {
                this.data.keyNrs2 = new int[this.meta.getKeyFields2().length];
                for (i = 0; i < this.data.keyNrs2.length; ++i) {
                    this.data.keyNrs2[i] = this.data.twoMeta.indexOfValue(this.meta.getKeyFields2()[i]);
                    if (this.data.keyNrs2[i] >= 0) continue;
                    String message = BaseMessages.getString(PKG, (String)"MergeJoin.Exception.UnableToFindFieldInReferenceStream", (String[])new String[]{this.meta.getKeyFields2()[i]});
                    this.logError(message);
                    throw new KettleStepException(message);
                }
            }
            this.data.one_dummy = RowDataUtil.allocateRowData((int)(this.data.oneMeta.size() + this.data.twoMeta.size()));
            this.data.two_dummy = new Object[this.data.twoMeta.size()];
        }
        if (this.log.isRowLevel()) {
            this.logRowlevel(BaseMessages.getString(PKG, (String)"MergeJoin.Log.DataInfo", (String[])new String[]{this.data.oneMeta.getString(this.data.one) + ""}) + this.data.twoMeta.getString(this.data.two));
        }
        if (this.data.one == null && this.data.two == null || this.data.one == null && !this.data.one_optional || this.data.two == null && !this.data.two_optional) {
            while (this.data.one != null && !this.isStopped()) {
                this.data.one = this.getRowFrom(this.data.oneRowSet);
            }
            while (this.data.two != null && !this.isStopped()) {
                this.data.two = this.getRowFrom(this.data.twoRowSet);
            }
            this.setOutputDone();
            return false;
        }
        int compare = this.data.one == null ? -1 : (this.data.two == null ? 1 : ((cmp = this.data.oneMeta.compare(this.data.one, this.data.twoMeta, this.data.two, this.data.keyNrs1, this.data.keyNrs2)) > 0 ? 1 : (cmp < 0 ? -1 : 0)));
        switch (compare) {
            case 0: {
                int compare2;
                this.data.one_next = this.getRowFrom(this.data.oneRowSet);
                this.data.two_next = this.getRowFrom(this.data.twoRowSet);
                int compare1 = this.data.one_next == null ? -1 : this.data.oneMeta.compare(this.data.one, this.data.one_next, this.data.keyNrs1, this.data.keyNrs1);
                int n = compare2 = this.data.two_next == null ? -1 : this.data.twoMeta.compare(this.data.two, this.data.two_next, this.data.keyNrs2, this.data.keyNrs2);
                if (compare1 == 0 || compare2 == 0) {
                    if (this.data.ones == null) {
                        this.data.ones = new ArrayList<Object[]>();
                    } else {
                        this.data.ones.clear();
                    }
                    if (this.data.twos == null) {
                        this.data.twos = new ArrayList<Object[]>();
                    } else {
                        this.data.twos.clear();
                    }
                    this.data.ones.add(this.data.one);
                    if (compare1 == 0) {
                        this.data.ones.add(this.data.one_next);
                        while (!this.isStopped()) {
                            this.data.one_next = this.getRowFrom(this.data.oneRowSet);
                            if (0 != (this.data.one_next == null ? -1 : this.data.oneMeta.compare(this.data.one, this.data.one_next, this.data.keyNrs1, this.data.keyNrs1))) break;
                            this.data.ones.add(this.data.one_next);
                        }
                        if (this.isStopped()) {
                            return false;
                        }
                    }
                    this.data.twos.add(this.data.two);
                    if (compare2 == 0) {
                        this.data.twos.add(this.data.two_next);
                        while (!this.isStopped()) {
                            this.data.two_next = this.getRowFrom(this.data.twoRowSet);
                            if (0 != (this.data.two_next == null ? -1 : this.data.twoMeta.compare(this.data.two, this.data.two_next, this.data.keyNrs2, this.data.keyNrs2))) break;
                            this.data.twos.add(this.data.two_next);
                        }
                        if (this.isStopped()) {
                            return false;
                        }
                    }
                    Iterator<Object[]> oneIter = this.data.ones.iterator();
                    while (oneIter.hasNext() && !this.isStopped()) {
                        Object[] one = oneIter.next();
                        Iterator<Object[]> twoIter = this.data.twos.iterator();
                        while (twoIter.hasNext() && !this.isStopped()) {
                            Object[] two = twoIter.next();
                            Object[] oneBig = RowDataUtil.createResizedCopy((Object[])one, (int)(this.data.oneMeta.size() + this.data.twoMeta.size()));
                            Object[] combi = RowDataUtil.addRowData((Object[])oneBig, (int)this.data.oneMeta.size(), (Object[])two);
                            this.putRow(this.data.outputRowMeta, combi);
                        }
                        oneIter.remove();
                    }
                    this.data.twos.clear();
                } else {
                    Object[] outputRowData = RowDataUtil.addRowData((Object[])this.data.one, (int)this.data.oneMeta.size(), (Object[])this.data.two);
                    this.putRow(this.data.outputRowMeta, outputRowData);
                }
                this.data.one = this.data.one_next;
                this.data.two = this.data.two_next;
                break;
            }
            case 1: {
                if (this.data.one_optional) {
                    if (this.data.two != null) {
                        Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])this.data.one_dummy, (int)this.data.outputRowMeta.size());
                        outputRowData = RowDataUtil.addRowData((Object[])outputRowData, (int)this.data.oneMeta.size(), (Object[])this.data.two);
                        this.putRow(this.data.outputRowMeta, outputRowData);
                        this.data.two = this.getRowFrom(this.data.twoRowSet);
                        break;
                    }
                    if (!this.data.two_optional) {
                        while (this.data.one != null && !this.isStopped()) {
                            this.data.one = this.getRowFrom(this.data.oneRowSet);
                        }
                        while (this.data.two != null && !this.isStopped()) {
                            this.data.two = this.getRowFrom(this.data.twoRowSet);
                        }
                        this.setOutputDone();
                        return false;
                    }
                    Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])this.data.one, (int)this.data.outputRowMeta.size());
                    outputRowData = RowDataUtil.addRowData((Object[])outputRowData, (int)this.data.oneMeta.size(), (Object[])this.data.two_dummy);
                    this.putRow(this.data.outputRowMeta, outputRowData);
                    this.data.one = this.getRowFrom(this.data.oneRowSet);
                    break;
                }
                if (this.data.two == null && this.data.two_optional) {
                    Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])this.data.one, (int)this.data.outputRowMeta.size());
                    outputRowData = RowDataUtil.addRowData((Object[])outputRowData, (int)this.data.oneMeta.size(), (Object[])this.data.two_dummy);
                    this.putRow(this.data.outputRowMeta, outputRowData);
                    this.data.one = this.getRowFrom(this.data.oneRowSet);
                    break;
                }
                if (this.data.two == null) break;
                this.data.two = this.getRowFrom(this.data.twoRowSet);
                break;
            }
            case -1: {
                if (this.data.two_optional) {
                    if (this.data.one != null) {
                        Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])this.data.one, (int)this.data.outputRowMeta.size());
                        outputRowData = RowDataUtil.addRowData((Object[])outputRowData, (int)this.data.oneMeta.size(), (Object[])this.data.two_dummy);
                        this.putRow(this.data.outputRowMeta, outputRowData);
                        this.data.one = this.getRowFrom(this.data.oneRowSet);
                        break;
                    }
                    if (!this.data.one_optional) {
                        while (this.data.one != null && !this.isStopped()) {
                            this.data.one = this.getRowFrom(this.data.oneRowSet);
                        }
                        while (this.data.two != null && !this.isStopped()) {
                            this.data.two = this.getRowFrom(this.data.twoRowSet);
                        }
                        this.setOutputDone();
                        return false;
                    }
                    Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])this.data.one_dummy, (int)this.data.outputRowMeta.size());
                    outputRowData = RowDataUtil.addRowData((Object[])outputRowData, (int)this.data.oneMeta.size(), (Object[])this.data.two);
                    this.putRow(this.data.outputRowMeta, outputRowData);
                    this.data.two = this.getRowFrom(this.data.twoRowSet);
                    break;
                }
                if (this.data.one == null && this.data.one_optional) {
                    Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])this.data.one_dummy, (int)this.data.outputRowMeta.size());
                    outputRowData = RowDataUtil.addRowData((Object[])outputRowData, (int)this.data.oneMeta.size(), (Object[])this.data.two);
                    this.putRow(this.data.outputRowMeta, outputRowData);
                    this.data.two = this.getRowFrom(this.data.twoRowSet);
                    break;
                }
                if (this.data.one == null) break;
                this.data.one = this.getRowFrom(this.data.oneRowSet);
                break;
            }
            default: {
                this.logDebug("We shouldn't be here!!");
                this.data.one = this.getRowFrom(this.data.oneRowSet);
                this.data.two = this.getRowFrom(this.data.twoRowSet);
            }
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic(BaseMessages.getString(PKG, (String)"MergeJoin.LineNumber", (String[])new String[0]) + this.getLinesRead());
        }
        return true;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MergeJoinMeta)smi;
        this.data = (MergeJoinData)sdi;
        if (super.init(smi, sdi)) {
            List<StreamInterface> infoStreams = this.meta.getStepIOMeta().getInfoStreams();
            if (infoStreams.get(0).getStepMeta() == null || infoStreams.get(1).getStepMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"MergeJoin.Log.BothTrueAndFalseNeeded", (String[])new String[0]));
                return false;
            }
            String joinType = this.meta.getJoinType();
            for (int i = 0; i < MergeJoinMeta.join_types.length; ++i) {
                if (!joinType.equalsIgnoreCase(MergeJoinMeta.join_types[i])) continue;
                this.data.one_optional = MergeJoinMeta.one_optionals[i];
                this.data.two_optional = MergeJoinMeta.two_optionals[i];
                return true;
            }
            this.logError(BaseMessages.getString(PKG, (String)"MergeJoin.Log.InvalidJoinType", (String[])new String[]{this.meta.getJoinType()}));
            return false;
        }
        return true;
    }

    protected boolean isInputLayoutValid(RowMetaInterface row1, RowMetaInterface row2) {
        if (row1 != null && row2 != null) {
            String[] keyFields2;
            int nrKeyFields2;
            String[] keyFields1 = this.meta.getKeyFields1();
            int nrKeyFields1 = keyFields1.length;
            if (nrKeyFields1 != (nrKeyFields2 = (keyFields2 = this.meta.getKeyFields2()).length)) {
                this.logError("Number of keys do not match " + nrKeyFields1 + " vs " + nrKeyFields2);
                return false;
            }
            for (int i = 0; i < nrKeyFields1; ++i) {
                ValueMetaInterface v1 = row1.searchValueMeta(keyFields1[i]);
                if (v1 == null) {
                    return false;
                }
                ValueMetaInterface v2 = row2.searchValueMeta(keyFields2[i]);
                if (v2 == null) {
                    return false;
                }
                if (v1.getType() == v2.getType()) continue;
                return false;
            }
        }
        return true;
    }
}

