/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.metainject;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.StringObjectId;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.metainject.MetaInject;
import org.pentaho.di.trans.steps.metainject.MetaInjectData;
import org.pentaho.di.trans.steps.metainject.SourceStepField;
import org.pentaho.di.trans.steps.metainject.TargetStepAttribute;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInjectMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = MetaInjectMeta.class;
    private String transName;
    private String fileName;
    private String directoryPath;
    private ObjectId transObjectId;
    private ObjectLocationSpecificationMethod specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
    private String sourceStepName;
    private Map<TargetStepAttribute, SourceStepField> targetSourceMapping = new HashMap<TargetStepAttribute, SourceStepField>();

    @Override
    public Object clone() {
        Object retval = super.clone();
        return retval;
    }

    @Override
    public void setDefault() {
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_object_id", this.transObjectId == null ? null : this.transObjectId.toString()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"trans_name", (String)this.transName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"filename", (String)this.fileName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"directory_path", (String)this.directoryPath));
        retval.append("    ").append(XMLHandler.addTagValue((String)"source_step", (String)this.sourceStepName));
        retval.append("    ").append(XMLHandler.openTag((String)"mappings"));
        for (TargetStepAttribute target : this.targetSourceMapping.keySet()) {
            retval.append("      ").append(XMLHandler.openTag((String)"mapping"));
            SourceStepField source = this.targetSourceMapping.get(target);
            retval.append("        ").append(XMLHandler.addTagValue((String)"target_step_name", (String)target.getStepname()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"target_attribute_key", (String)target.getAttributeKey()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"target_detail", (boolean)target.isDetail()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"source_step", (String)source.getStepname()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"source_field", (String)source.getField()));
            retval.append("      ").append(XMLHandler.closeTag((String)"mapping"));
        }
        retval.append("    ").append(XMLHandler.closeTag((String)"mappings"));
        return retval.toString();
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        try {
            String method = XMLHandler.getTagValue((Node)stepnode, (String)"specification_method");
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String transId = XMLHandler.getTagValue((Node)stepnode, (String)"trans_object_id");
            this.transObjectId = Const.isEmpty((String)transId) ? null : new StringObjectId(transId);
            this.transName = XMLHandler.getTagValue((Node)stepnode, (String)"trans_name");
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"filename");
            this.directoryPath = XMLHandler.getTagValue((Node)stepnode, (String)"directory_path");
            this.sourceStepName = XMLHandler.getTagValue((Node)stepnode, (String)"source_step");
            Node mappingsNode = XMLHandler.getSubNode((Node)stepnode, (String)"mappings");
            int nrMappings = XMLHandler.countNodes((Node)mappingsNode, (String)"mapping");
            for (int i = 0; i < nrMappings; ++i) {
                Node mappingNode = XMLHandler.getSubNodeByNr((Node)mappingsNode, (String)"mapping", (int)i);
                String targetStepname = XMLHandler.getTagValue((Node)mappingNode, (String)"target_step_name");
                String targetAttributeKey = XMLHandler.getTagValue((Node)mappingNode, (String)"target_attribute_key");
                boolean targetDetail = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)mappingNode, (String)"target_detail"));
                String sourceStepname = XMLHandler.getTagValue((Node)mappingNode, (String)"source_step");
                String sourceField = XMLHandler.getTagValue((Node)mappingNode, (String)"source_field");
                TargetStepAttribute target = new TargetStepAttribute(targetStepname, targetAttributeKey, targetDetail);
                SourceStepField source = new SourceStepField(sourceStepname, sourceField);
                this.targetSourceMapping.put(target, source);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            String method = rep.getStepAttributeString(id_step, "specification_method");
            this.specificationMethod = ObjectLocationSpecificationMethod.getSpecificationMethodByCode((String)method);
            String transId = rep.getStepAttributeString(id_step, "trans_object_id");
            this.transObjectId = Const.isEmpty((String)transId) ? null : new StringObjectId(transId);
            this.transName = rep.getStepAttributeString(id_step, "trans_name");
            this.fileName = rep.getStepAttributeString(id_step, "filename");
            this.directoryPath = rep.getStepAttributeString(id_step, "directory_path");
            this.sourceStepName = rep.getStepAttributeString(id_step, "source_step");
            int nrMappings = rep.countNrStepAttributes(id_step, "mapping_target_step_name");
            for (int i = 0; i < nrMappings; ++i) {
                String targetStepname = rep.getStepAttributeString(id_step, i, "mapping_target_step_name");
                String targetAttributeKey = rep.getStepAttributeString(id_step, i, "mapping_target_attribute_key");
                boolean targetDetail = rep.getStepAttributeBoolean(id_step, i, "mapping_target_detail");
                String sourceStepname = rep.getStepAttributeString(id_step, i, "mapping_source_step");
                String sourceField = rep.getStepAttributeString(id_step, i, "mapping_source_field");
                TargetStepAttribute target = new TargetStepAttribute(targetStepname, targetAttributeKey, targetDetail);
                SourceStepField source = new SourceStepField(sourceStepname, sourceField);
                this.targetSourceMapping.put(target, source);
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "specification_method", this.specificationMethod == null ? null : this.specificationMethod.getCode());
            rep.saveStepAttribute(id_transformation, id_step, "trans_object_id", this.transObjectId == null ? null : this.transObjectId.toString());
            rep.saveStepAttribute(id_transformation, id_step, "filename", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "trans_name", this.transName);
            rep.saveStepAttribute(id_transformation, id_step, "directory_path", this.directoryPath);
            rep.saveStepAttribute(id_transformation, id_step, "source_step", this.sourceStepName);
            ArrayList<TargetStepAttribute> keySet = new ArrayList<TargetStepAttribute>(this.targetSourceMapping.keySet());
            for (int i = 0; i < keySet.size(); ++i) {
                TargetStepAttribute target = (TargetStepAttribute)keySet.get(i);
                SourceStepField source = this.targetSourceMapping.get(target);
                rep.saveStepAttribute(id_transformation, id_step, i, "mapping_target_step_name", target.getStepname());
                rep.saveStepAttribute(id_transformation, id_step, i, "mapping_target_attribute_key", target.getAttributeKey());
                rep.saveStepAttribute(id_transformation, id_step, i, "mapping_target_detail", target.isDetail());
                rep.saveStepAttribute(id_transformation, id_step, i, "mapping_source_step", source.getStepname());
                rep.saveStepAttribute(id_transformation, id_step, i, "mapping_source_field", source.getField());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        rowMeta.clear();
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MetaInject(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MetaInjectData();
    }

    public Map<TargetStepAttribute, SourceStepField> getTargetSourceMapping() {
        return this.targetSourceMapping;
    }

    public void setTargetSourceMapping(Map<TargetStepAttribute, SourceStepField> targetSourceMapping) {
        this.targetSourceMapping = targetSourceMapping;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
    }

    public String getTransName() {
        return this.transName;
    }

    public void setTransName(String transName) {
        this.transName = transName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    public ObjectId getTransObjectId() {
        return this.transObjectId;
    }

    public void setTransObjectId(ObjectId transObjectId) {
        this.transObjectId = transObjectId;
    }

    public ObjectLocationSpecificationMethod getSpecificationMethod() {
        return this.specificationMethod;
    }

    public void setSpecificationMethod(ObjectLocationSpecificationMethod specificationMethod) {
        this.specificationMethod = specificationMethod;
    }

    public static final synchronized TransMeta loadTransformationMeta(MetaInjectMeta mappingMeta, Repository rep, VariableSpace space) throws KettleException {
        TransMeta mappingTransMeta = null;
        switch (mappingMeta.getSpecificationMethod()) {
            case FILENAME: {
                String realFilename = space.environmentSubstitute(mappingMeta.getFileName());
                try {
                    mappingTransMeta = new TransMeta(realFilename, false);
                    mappingTransMeta.getLogChannel().logDetailed("Loading Mapping from repository", new Object[]{"Mapping transformation was loaded from XML file [" + realFilename + "]"});
                    break;
                }
                catch (Exception e) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MetaInjectMeta.Exception.UnableToLoadTransformationFromFile", (String[])new String[]{realFilename}), (Throwable)e);
                }
            }
            case REPOSITORY_BY_NAME: {
                String realTransname = space.environmentSubstitute(mappingMeta.getTransName());
                String realDirectory = space.environmentSubstitute(mappingMeta.getDirectoryPath());
                if (Const.isEmpty((String)realTransname) || Const.isEmpty((String)realDirectory) || rep == null) break;
                RepositoryDirectoryInterface repdir = rep.findDirectory(realDirectory);
                if (repdir != null) {
                    try {
                        mappingTransMeta = rep.loadTransformation(realTransname, repdir, null, true, null);
                        mappingTransMeta.getLogChannel().logDetailed("Loading Mapping from repository", new Object[]{"Mapping transformation [" + realTransname + "] was loaded from the repository"});
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleException("Unable to load transformation [" + realTransname + "]", (Throwable)e);
                    }
                }
                throw new KettleException(BaseMessages.getString(PKG, (String)"MetaInjectMeta.Exception.UnableToLoadTransformationFromRepository", (String[])new String[]{realTransname, realDirectory}));
            }
            case REPOSITORY_BY_REFERENCE: {
                mappingTransMeta = rep.loadTransformation(mappingMeta.getTransObjectId(), null);
            }
        }
        mappingTransMeta.copyVariablesFrom(space);
        mappingTransMeta.setRepository(rep);
        mappingTransMeta.setFilename(mappingTransMeta.getFilename());
        return mappingTransMeta;
    }

    @Override
    public boolean excludeFromCopyDistributeVerification() {
        return true;
    }

    @Override
    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public String getSourceStepName() {
        return this.sourceStepName;
    }

    public void setSourceStepName(String sourceStepName) {
        this.sourceStepName = sourceStepName;
    }
}

