/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mysqlbulkloader;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.math.BigDecimal;
import java.util.Date;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.DBCache;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StreamLogger;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.mysqlbulkloader.MySQLBulkLoaderData;
import org.pentaho.di.trans.steps.mysqlbulkloader.MySQLBulkLoaderMeta;

public class MySQLBulkLoader
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = MySQLBulkLoaderMeta.class;
    private MySQLBulkLoaderMeta meta;
    private MySQLBulkLoaderData data;

    public MySQLBulkLoader(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(MySQLBulkLoaderMeta meta) throws KettleException {
        Runtime rt = Runtime.getRuntime();
        try {
            this.data.fifoFilename = this.environmentSubstitute(meta.getFifoFileName());
            File fifoFile = new File(this.data.fifoFilename);
            if (!fifoFile.exists()) {
                String mkFifoCmd = "mkfifo " + this.data.fifoFilename;
                this.logBasic("Creating FIFO file using this command : " + mkFifoCmd);
                Process mkFifoProcess = rt.exec(mkFifoCmd);
                StreamLogger errorLogger = new StreamLogger(this.log, mkFifoProcess.getErrorStream(), "mkFifoError");
                StreamLogger outputLogger = new StreamLogger(this.log, mkFifoProcess.getInputStream(), "mkFifoOuptut");
                new Thread((Runnable)errorLogger).start();
                new Thread((Runnable)outputLogger).start();
                int result = mkFifoProcess.waitFor();
                if (result != 0) {
                    throw new Exception("Return code " + result + " received from statement : " + mkFifoCmd);
                }
                String chmodCmd = "chmod 666 " + this.data.fifoFilename;
                this.logBasic("Setting FIFO file permissings using this command : " + chmodCmd);
                Process chmodProcess = rt.exec(chmodCmd);
                errorLogger = new StreamLogger(this.log, chmodProcess.getErrorStream(), "chmodError");
                outputLogger = new StreamLogger(this.log, chmodProcess.getInputStream(), "chmodOuptut");
                new Thread((Runnable)errorLogger).start();
                new Thread((Runnable)outputLogger).start();
                result = chmodProcess.waitFor();
                if (result != 0) {
                    throw new Exception("Return code " + result + " received from statement : " + chmodCmd);
                }
            }
            DBCache.getInstance().clear(meta.getDatabaseMeta().getName());
            if (meta.getDatabaseMeta() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"MySQLBulkLoader.Init.ConnectionMissing", (String[])new String[]{this.getStepname()}));
                return false;
            }
            this.data.db = new Database((LoggingObjectInterface)this, meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            if (this.getTransMeta().isUsingUniqueConnections()) {
                Trans trans = this.getTrans();
                synchronized (trans) {
                    this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                }
            } else {
                this.data.db.connect(this.getPartitionID());
            }
            this.logBasic("Connected to MySQL");
            this.executeLoadCommand();
        }
        catch (Exception ex) {
            throw new KettleException((Throwable)ex);
        }
        return true;
    }

    private void executeLoadCommand() throws Exception {
        String delStr;
        String loadCommand = "";
        loadCommand = loadCommand + "LOAD DATA " + (this.meta.isLocalFile() ? "LOCAL" : "") + " INFILE '" + this.environmentSubstitute(this.meta.getFifoFileName()) + "' ";
        if (this.meta.isReplacingData()) {
            loadCommand = loadCommand + "REPLACE ";
        } else if (this.meta.isIgnoringErrors()) {
            loadCommand = loadCommand + "IGNORE ";
        }
        loadCommand = loadCommand + "INTO TABLE `" + this.data.schemaTable + "` ";
        if (!Const.isEmpty((String)this.meta.getEncoding())) {
            loadCommand = loadCommand + "CHARACTER SET " + this.meta.getEncoding() + " ";
        }
        if ("\t".equals(delStr = this.meta.getDelimiter())) {
            delStr = "\\t";
        }
        loadCommand = loadCommand + "FIELDS TERMINATED BY '" + delStr + "' ";
        if (!Const.isEmpty((String)this.meta.getEnclosure())) {
            loadCommand = loadCommand + "OPTIONALLY ENCLOSED BY '" + this.meta.getEnclosure() + "' ";
        }
        loadCommand = loadCommand + "ESCAPED BY '" + this.meta.getEscapeChar() + ("\\".equals(this.meta.getEscapeChar()) ? this.meta.getEscapeChar() : "") + "' ";
        loadCommand = loadCommand + "(";
        for (int cnt = 0; cnt < this.meta.getFieldTable().length; ++cnt) {
            loadCommand = loadCommand + "`" + this.meta.getFieldTable()[cnt] + "`";
            if (cnt >= this.meta.getFieldTable().length - 1) continue;
            loadCommand = loadCommand + ",";
        }
        loadCommand = loadCommand + ");" + Const.CR;
        this.logBasic("Starting the MySQL bulk Load in a separate thread : " + loadCommand);
        this.data.sqlRunner = new SqlRunner(this.data, loadCommand);
        this.data.sqlRunner.start();
        this.logBasic("Opening fifo " + this.data.fifoFilename + " for writing.");
        OpenFifo openFifo = new OpenFifo(this.data.fifoFilename, 1000);
        openFifo.start();
        while (true) {
            openFifo.join(200L);
            if (openFifo.getState() == Thread.State.TERMINATED) break;
            try {
                this.data.sqlRunner.checkExcn();
            }
            catch (Exception e) {
                new BufferedInputStream(new FileInputStream(this.data.fifoFilename)).close();
                openFifo.join();
                this.logError("Make sure user has been granted the FILE privilege.");
                this.logError("");
                throw e;
            }
            openFifo.checkExcn();
        }
        this.data.fifoStream = openFifo.getFifoStream();
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (MySQLBulkLoaderMeta)smi;
        this.data = (MySQLBulkLoaderData)sdi;
        try {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                this.closeOutput();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.keynrs = new int[this.meta.getFieldStream().length];
                for (i = 0; i < this.data.keynrs.length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getFieldStream()[i]);
                }
                this.data.bulkFormatMeta = new ValueMetaInterface[this.data.keynrs.length];
                for (i = 0; i < this.data.keynrs.length; ++i) {
                    ValueMetaInterface sourceMeta = this.getInputRowMeta().getValueMeta(this.data.keynrs[i]);
                    if (sourceMeta.isDate()) {
                        if (this.meta.getFieldFormatType()[i] == 1) {
                            this.data.bulkFormatMeta[i] = this.data.bulkDateMeta.clone();
                        } else if (this.meta.getFieldFormatType()[i] == 2) {
                            this.data.bulkFormatMeta[i] = this.data.bulkTimestampMeta.clone();
                        }
                    } else if (sourceMeta.isNumeric() && this.meta.getFieldFormatType()[i] == 3) {
                        this.data.bulkFormatMeta[i] = this.data.bulkNumberMeta.clone();
                    }
                    if (this.data.bulkFormatMeta[i] != null || sourceMeta.isStorageBinaryString()) continue;
                    this.data.bulkFormatMeta[i] = sourceMeta.clone();
                }
                this.execute(this.meta);
            }
            if (this.data.bulkSize > 0L && this.getLinesOutput() > 0L && this.getLinesOutput() % this.data.bulkSize == 0L) {
                this.closeOutput();
                this.executeLoadCommand();
            }
            this.writeRowToBulk(this.getInputRowMeta(), r);
            this.putRow(this.getInputRowMeta(), r);
            this.incrementLinesOutput();
            return true;
        }
        catch (Exception e) {
            this.logError(BaseMessages.getString(PKG, (String)"MySQLBulkLoader.Log.ErrorInStep", (String[])new String[0]), e);
            this.setErrors(1L);
            this.stopAll();
            this.setOutputDone();
            return false;
        }
    }

    private void closeOutput() throws Exception {
        if (this.data.fifoStream != null) {
            this.data.fifoStream.close();
            this.data.fifoStream = null;
        }
        if (this.data.sqlRunner != null) {
            this.data.sqlRunner.join();
            SqlRunner sqlRunner = this.data.sqlRunner;
            this.data.sqlRunner = null;
            sqlRunner.checkExcn();
        }
    }

    private void writeRowToBulk(RowMetaInterface rowMeta, Object[] r) throws KettleException {
        try {
            block12: for (int i = 0; i < this.data.keynrs.length; ++i) {
                if (i > 0) {
                    this.data.fifoStream.write(this.data.separator);
                }
                int index = this.data.keynrs[i];
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(index);
                Object valueData = r[index];
                if (valueData == null) {
                    this.data.fifoStream.write("NULL".getBytes());
                    continue;
                }
                switch (valueMeta.getType()) {
                    case 2: {
                        this.data.fifoStream.write(this.data.quote);
                        if (valueMeta.isStorageBinaryString() && this.meta.getFieldFormatType()[i] == 0) {
                            this.data.fifoStream.write((byte[])valueData);
                        } else {
                            String string = valueMeta.getString(valueData);
                            if (string != null) {
                                if (this.meta.getFieldFormatType()[i] == 4) {
                                    string = Const.replace((String)string, (String)this.meta.getEnclosure(), (String)(this.meta.getEscapeChar() + this.meta.getEnclosure()));
                                }
                                this.data.fifoStream.write(string.getBytes());
                            }
                        }
                        this.data.fifoStream.write(this.data.quote);
                        continue block12;
                    }
                    case 5: {
                        if (valueMeta.isStorageBinaryString() && this.data.bulkFormatMeta[i] == null) {
                            this.data.fifoStream.write(valueMeta.getBinaryString(valueData));
                            continue block12;
                        }
                        Long integer = valueMeta.getInteger(valueData);
                        if (integer == null) continue block12;
                        this.data.fifoStream.write(this.data.bulkFormatMeta[i].getString((Object)integer).getBytes());
                        continue block12;
                    }
                    case 3: {
                        if (valueMeta.isStorageBinaryString() && this.data.bulkFormatMeta[i] == null) {
                            this.data.fifoStream.write(valueMeta.getBinaryString(valueData));
                            continue block12;
                        }
                        Date date = valueMeta.getDate(valueData);
                        if (date == null) continue block12;
                        this.data.fifoStream.write(this.data.bulkFormatMeta[i].getString((Object)date).getBytes());
                        continue block12;
                    }
                    case 4: {
                        if (valueMeta.isStorageBinaryString() && this.data.bulkFormatMeta[i] == null) {
                            this.data.fifoStream.write(valueMeta.getBinaryString(valueData));
                            continue block12;
                        }
                        Boolean b = valueMeta.getBoolean(valueData);
                        if (b == null) continue block12;
                        this.data.fifoStream.write(this.data.bulkFormatMeta[i].getString((Object)b).getBytes());
                        continue block12;
                    }
                    case 1: {
                        if (valueMeta.isStorageBinaryString() && this.data.bulkFormatMeta[i] == null) {
                            this.data.fifoStream.write((byte[])valueData);
                            continue block12;
                        }
                        Double d = valueMeta.getNumber(valueData);
                        if (d == null) continue block12;
                        this.data.fifoStream.write(this.data.bulkFormatMeta[i].getString((Object)d).getBytes());
                        continue block12;
                    }
                    case 6: {
                        if (valueMeta.isStorageBinaryString() && this.data.bulkFormatMeta[i] == null) {
                            this.data.fifoStream.write((byte[])valueData);
                            continue block12;
                        }
                        BigDecimal bn = valueMeta.getBigNumber(valueData);
                        if (bn == null) continue block12;
                        this.data.fifoStream.write(this.data.bulkFormatMeta[i].getString((Object)bn).getBytes());
                    }
                }
            }
            this.data.fifoStream.write(this.data.newline);
            if (this.getLinesOutput() % 5000L == 0L) {
                this.data.fifoStream.flush();
            }
        }
        catch (Exception e) {
            try {
                this.data.sqlRunner.checkExcn();
            }
            catch (Exception loadEx) {
                throw new KettleException("Error serializing rows of data to the fifo file", (Throwable)loadEx);
            }
            throw new KettleException("Error serializing rows of data to the fifo file", (Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MySQLBulkLoaderMeta)smi;
        this.data = (MySQLBulkLoaderData)sdi;
        if (super.init(smi, sdi)) {
            this.data.quote = Const.isEmpty((String)this.meta.getEnclosure()) ? new byte[0] : this.meta.getEnclosure().getBytes();
            this.data.separator = Const.isEmpty((String)this.meta.getDelimiter()) ? "\t".getBytes() : this.meta.getDelimiter().getBytes();
            this.data.newline = Const.CR.getBytes();
            this.data.bulkTimestampMeta = new ValueMeta("timestampMeta", 3);
            this.data.bulkTimestampMeta.setConversionMask("yyyy-MM-dd HH:mm:ss");
            this.data.bulkTimestampMeta.setStringEncoding(this.meta.getEncoding());
            this.data.bulkDateMeta = new ValueMeta("dateMeta", 3);
            this.data.bulkDateMeta.setConversionMask("yyyy-MM-dd");
            this.data.bulkDateMeta.setStringEncoding(this.meta.getEncoding());
            this.data.bulkNumberMeta = new ValueMeta("numberMeta", 1);
            this.data.bulkNumberMeta.setConversionMask("#.#");
            this.data.bulkNumberMeta.setGroupingSymbol(",");
            this.data.bulkNumberMeta.setDecimalSymbol(".");
            this.data.bulkNumberMeta.setStringEncoding(this.meta.getEncoding());
            this.data.bulkSize = Const.toLong((String)this.environmentSubstitute(this.meta.getBulkSize()), (long)-1L);
            this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (MySQLBulkLoaderMeta)smi;
        this.data = (MySQLBulkLoaderData)sdi;
        try {
            if (this.data.fifoStream != null) {
                this.data.fifoStream.close();
            }
            if (this.data.sqlRunner != null) {
                this.data.sqlRunner.join();
                this.data.sqlRunner = null;
            }
            if (this.data.db != null) {
                this.data.db.disconnect();
                this.data.db = null;
            }
            try {
                if (this.data.fifoFilename != null) {
                    new File(this.data.fifoFilename).delete();
                }
            }
            catch (Exception e) {
                this.logError("Unable to delete FIFO file : " + this.data.fifoFilename, e);
            }
        }
        catch (Exception e) {
            this.setErrors(1L);
            this.logError("Unexpected error encountered while closing the client connection", e);
        }
        super.dispose(smi, sdi);
    }

    static class SqlRunner
    extends Thread {
        private MySQLBulkLoaderData data;
        private String loadCommand;
        private Exception ex;

        SqlRunner(MySQLBulkLoaderData data, String loadCommand) {
            this.data = data;
            this.loadCommand = loadCommand;
        }

        public void run() {
            try {
                this.data.db.execStatement(this.loadCommand);
            }
            catch (Exception ex) {
                this.ex = ex;
            }
        }

        void checkExcn() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
        }
    }

    static class OpenFifo
    extends Thread {
        private BufferedOutputStream fifoStream = null;
        private Exception ex;
        private String fifoName;
        private int size;

        OpenFifo(String fifoName, int size) {
            this.fifoName = fifoName;
            this.size = size;
        }

        public void run() {
            try {
                this.fifoStream = new BufferedOutputStream(new FileOutputStream(this.fifoName), this.size);
            }
            catch (Exception ex) {
                this.ex = ex;
            }
        }

        void checkExcn() throws Exception {
            if (this.ex != null) {
                throw this.ex;
            }
        }

        BufferedOutputStream getFifoStream() {
            return this.fifoStream;
        }
    }
}

