/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.propertyoutput;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.FileObject;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceDefinition;
import org.pentaho.di.resource.ResourceNamingInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.propertyoutput.PropertyOutput;
import org.pentaho.di.trans.steps.propertyoutput.PropertyOutputData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyOutputMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = PropertyOutputMeta.class;
    private String keyfield;
    private String valuefield;
    private boolean addToResult;
    private String fileName;
    private boolean fileNameInField;
    private String fileNameField;
    private String extension;
    private boolean stepNrInFilename;
    private boolean partNrInFilename;
    private boolean dateInFilename;
    private boolean timeInFilename;
    private boolean createparentfolder;
    private String comment;
    private boolean append;

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        PropertyOutputMeta retval = (PropertyOutputMeta)super.clone();
        return retval;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean isFileNameInField() {
        return this.fileNameInField;
    }

    public void setFileNameInField(boolean fileNameInField) {
        this.fileNameInField = fileNameInField;
    }

    public String getFileNameField() {
        return this.fileNameField;
    }

    public void setFileNameField(String fileNameField) {
        this.fileNameField = fileNameField;
    }

    public boolean isStepNrInFilename() {
        return this.stepNrInFilename;
    }

    public void setStepNrInFilename(boolean stepNrInFilename) {
        this.stepNrInFilename = stepNrInFilename;
    }

    public boolean isTimeInFilename() {
        return this.timeInFilename;
    }

    public boolean isDateInFilename() {
        return this.dateInFilename;
    }

    public void setDateInFilename(boolean dateInFilename) {
        this.dateInFilename = dateInFilename;
    }

    public void setTimeInFilename(boolean timeInFilename) {
        this.timeInFilename = timeInFilename;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public boolean addToResult() {
        return this.addToResult;
    }

    public void setAddToResult(boolean addToResult) {
        this.addToResult = addToResult;
    }

    public boolean isCreateParentFolder() {
        return this.createparentfolder;
    }

    public void setCreateParentFolder(boolean createparentfolder) {
        this.createparentfolder = createparentfolder;
    }

    public boolean isAppend() {
        return this.append;
    }

    public void setAppend(boolean append) {
        this.append = append;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String commentin) {
        this.comment = commentin;
    }

    public String[] getFiles(VariableSpace space) {
        int nr;
        int copies = 1;
        int parts = 1;
        if (this.stepNrInFilename) {
            copies = 3;
        }
        if (this.partNrInFilename) {
            parts = 3;
        }
        if ((nr = copies * parts) > 1) {
            ++nr;
        }
        String[] retval = new String[nr];
        int i = 0;
        for (int copy = 0; copy < copies; ++copy) {
            for (int part = 0; part < parts; ++part) {
                retval[i] = this.buildFilename(space, copy);
                ++i;
            }
        }
        if (i < nr) {
            retval[i] = "...";
        }
        return retval;
    }

    public String buildFilename(VariableSpace space, int stepnr) {
        SimpleDateFormat daf = new SimpleDateFormat();
        String retval = space.environmentSubstitute(this.fileName);
        Date now = new Date();
        if (this.dateInFilename) {
            daf.applyPattern("yyyMMdd");
            String d = daf.format(now);
            retval = retval + "_" + d;
        }
        if (this.timeInFilename) {
            daf.applyPattern("HHmmss");
            String t = daf.format(now);
            retval = retval + "_" + t;
        }
        if (this.stepNrInFilename) {
            retval = retval + "_" + stepnr;
        }
        if (this.extension != null && this.extension.length() != 0) {
            retval = retval + "." + this.extension;
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.keyfield = XMLHandler.getTagValue((Node)stepnode, (String)"keyfield");
            this.valuefield = XMLHandler.getTagValue((Node)stepnode, (String)"valuefield");
            this.comment = XMLHandler.getTagValue((Node)stepnode, (String)"comment");
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.createparentfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"create_parent_folder"));
            this.extension = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"extention");
            this.stepNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"split"));
            this.partNrInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"haspartno"));
            this.dateInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_date"));
            this.timeInFilename = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"add_time"));
            this.addToResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"AddToResult"));
            this.append = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"append"));
            this.fileName = XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"name");
            this.fileNameInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"fileNameInField"));
            this.fileNameField = XMLHandler.getTagValue((Node)stepnode, (String)"fileNameField");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.append = false;
        this.createparentfolder = false;
        this.keyfield = null;
        this.valuefield = null;
        this.comment = null;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"keyfield", (String)this.keyfield));
        retval.append("    " + XMLHandler.addTagValue((String)"valuefield", (String)this.valuefield));
        retval.append("    " + XMLHandler.addTagValue((String)"comment", (String)this.comment));
        retval.append("    " + XMLHandler.addTagValue((String)"fileNameInField", (boolean)this.fileNameInField));
        retval.append("    " + XMLHandler.addTagValue((String)"fileNameField", (String)this.fileNameField));
        retval.append("    <file>" + Const.CR);
        retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fileName));
        retval.append("      " + XMLHandler.addTagValue((String)"extention", (String)this.extension));
        retval.append("      " + XMLHandler.addTagValue((String)"split", (boolean)this.stepNrInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"haspartno", (boolean)this.partNrInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"add_date", (boolean)this.dateInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"add_time", (boolean)this.timeInFilename));
        retval.append("      " + XMLHandler.addTagValue((String)"create_parent_folder", (boolean)this.createparentfolder));
        retval.append("    " + XMLHandler.addTagValue((String)"addtoresult", (boolean)this.addToResult));
        retval.append("    " + XMLHandler.addTagValue((String)"append", (boolean)this.append));
        retval.append("      </file>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.keyfield = rep.getStepAttributeString(id_step, "keyfield");
            this.valuefield = rep.getStepAttributeString(id_step, "valuefield");
            this.comment = rep.getStepAttributeString(id_step, "comment");
            this.fileName = rep.getStepAttributeString(id_step, "file_name");
            this.extension = rep.getStepAttributeString(id_step, "file_extention");
            this.stepNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_stepnr");
            this.partNrInFilename = rep.getStepAttributeBoolean(id_step, "file_add_partnr");
            this.dateInFilename = rep.getStepAttributeBoolean(id_step, "file_add_date");
            this.timeInFilename = rep.getStepAttributeBoolean(id_step, "file_add_time");
            this.createparentfolder = rep.getStepAttributeBoolean(id_step, "create_parent_folder");
            this.addToResult = rep.getStepAttributeBoolean(id_step, "addtoresult");
            this.append = rep.getStepAttributeBoolean(id_step, "append");
            this.fileNameInField = rep.getStepAttributeBoolean(id_step, "fileNameInField");
            this.fileNameField = rep.getStepAttributeString(id_step, "fileNameField");
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "keyfield", this.keyfield);
            rep.saveStepAttribute(id_transformation, id_step, "valuefield", this.valuefield);
            rep.saveStepAttribute(id_transformation, id_step, "comment", this.comment);
            rep.saveStepAttribute(id_transformation, id_step, "file_name", this.fileName);
            rep.saveStepAttribute(id_transformation, id_step, "file_extention", this.extension);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_stepnr", this.stepNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_partnr", this.partNrInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_date", this.dateInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "file_add_time", this.timeInFilename);
            rep.saveStepAttribute(id_transformation, id_step, "create_parent_folder", this.createparentfolder);
            rep.saveStepAttribute(id_transformation, id_step, "addtoresult", this.addToResult);
            rep.saveStepAttribute(id_transformation, id_step, "append", this.append);
            rep.saveStepAttribute(id_transformation, id_step, "fileNameInField", this.fileNameInField);
            rep.saveStepAttribute(id_transformation, id_step, "fileNameField", this.fileNameField);
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (!Const.isEmpty((String)this.fileName)) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.FilenameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.FilenameError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        ValueMetaInterface v = prev.searchValueMeta(this.keyfield);
        if (v == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.KeyFieldMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.KeyFieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        v = prev.searchValueMeta(this.valuefield);
        if (v == null) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.ValueFieldMissing", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"PropertyOutputMeta.CheckResult.ValueFieldOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepDataInterface getStepData() {
        return new PropertyOutputData();
    }

    public String getKeyField() {
        return this.keyfield;
    }

    public String getValueField() {
        return this.valuefield;
    }

    public void setKeyField(String KeyField) {
        this.keyfield = KeyField;
    }

    public void setValueField(String valuefield) {
        this.valuefield = valuefield;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new PropertyOutput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String exportResources(VariableSpace space, Map<String, ResourceDefinition> definitions, ResourceNamingInterface resourceNamingInterface, Repository repository) throws KettleException {
        try {
            FileObject fileObject;
            if (!this.fileNameInField && (fileObject = KettleVFS.getFileObject((String)space.environmentSubstitute(this.fileName), (VariableSpace)space)).exists()) {
                this.fileName = resourceNamingInterface.nameResource(fileObject, space, true);
                return this.fileName;
            }
            return null;
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

