/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.randomvalue;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.randomvalue.RandomValue;
import org.pentaho.di.trans.steps.randomvalue.RandomValueData;
import org.pentaho.di.trans.steps.randomvalue.RandomValueMetaFunction;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RandomValueMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = RandomValueMeta.class;
    public static final int TYPE_RANDOM_NONE = 0;
    public static final int TYPE_RANDOM_NUMBER = 1;
    public static final int TYPE_RANDOM_INTEGER = 2;
    public static final int TYPE_RANDOM_STRING = 3;
    public static final int TYPE_RANDOM_UUID = 4;
    public static final int TYPE_RANDOM_UUID4 = 5;
    public static final int TYPE_RANDOM_MAC_HMACMD5 = 6;
    public static final int TYPE_RANDOM_MAC_HMACSHA1 = 7;
    public static final RandomValueMetaFunction[] functions = new RandomValueMetaFunction[]{null, new RandomValueMetaFunction(1, "random number", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomNumber", (String[])new String[0])), new RandomValueMetaFunction(2, "random integer", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomInteger", (String[])new String[0])), new RandomValueMetaFunction(3, "random string", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomString", (String[])new String[0])), new RandomValueMetaFunction(4, "random uuid", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomUUID", (String[])new String[0])), new RandomValueMetaFunction(5, "random uuid4", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomUUID4", (String[])new String[0])), new RandomValueMetaFunction(6, "random machmacmd5", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACMD5", (String[])new String[0])), new RandomValueMetaFunction(7, "random machmacsha1", BaseMessages.getString(PKG, (String)"RandomValueMeta.TypeDesc.RandomHMACSHA1", (String[])new String[0]))};
    private String[] fieldName;
    private int[] fieldType;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.fieldType = new int[count];
    }

    @Override
    public Object clone() {
        RandomValueMeta retval = (RandomValueMeta)super.clone();
        int count = this.fieldName.length;
        retval.allocate(count);
        for (int i = 0; i < count; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldType[i] = this.fieldType[i];
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int count = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                String type = XMLHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldType[i] = RandomValueMeta.getType(type);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to read step information from XML", (Throwable)e);
        }
    }

    public static final int getType(String type) {
        for (int i = 1; i < functions.length; ++i) {
            if (functions[i].getCode().equalsIgnoreCase(type)) {
                return i;
            }
            if (!functions[i].getDescription().equalsIgnoreCase(type)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int t) {
        if (functions == null || functions.length == 0) {
            return null;
        }
        if (t < 0 || t >= functions.length || functions[t] == null) {
            return null;
        }
        return functions[t].getDescription();
    }

    @Override
    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.fieldType[i] = 1;
        }
    }

    @Override
    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        for (int i = 0; i < this.fieldName.length; ++i) {
            ValueMeta v;
            switch (this.fieldType[i]) {
                case 1: {
                    v = new ValueMeta(this.fieldName[i], 1, 10, 5);
                    break;
                }
                case 2: {
                    v = new ValueMeta(this.fieldName[i], 5, 10, 0);
                    break;
                }
                case 3: {
                    v = new ValueMeta(this.fieldName[i], 2, 13, 0);
                    break;
                }
                case 4: {
                    v = new ValueMeta(this.fieldName[i], 2, 36, 0);
                    break;
                }
                case 5: {
                    v = new ValueMeta(this.fieldName[i], 2, 36, 0);
                    break;
                }
                case 6: {
                    v = new ValueMeta(this.fieldName[i], 2, 100, 0);
                    break;
                }
                case 7: {
                    v = new ValueMeta(this.fieldName[i], 2, 100, 0);
                    break;
                }
                default: {
                    v = new ValueMeta(this.fieldName[i], 0);
                }
            }
            v.setOrigin(name);
            row.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)(functions[this.fieldType[i]] != null ? functions[this.fieldType[i]].getCode() : "")));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>" + Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = RandomValueMeta.getType(rep.getStepAttributeString(id_step, i, "field_type"));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            for (int i = 0; i < this.fieldName.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", functions[this.fieldType[i]] != null ? functions[this.fieldType[i]].getCode() : "");
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        int nrRemarks = remarks.size();
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldType[i] > 0) continue;
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RandomValueMeta.CheckResult.FieldHasNoType", (String[])new String[]{this.fieldName[i]}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (remarks.size() == nrRemarks) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RandomValueMeta.CheckResult.AllTypesSpecified", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new RandomValue(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new RandomValueData();
    }
}

