/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.regexeval;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.regexeval.RegexEval;
import org.pentaho.di.trans.steps.regexeval.RegexEvalData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexEvalMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = RegexEvalMeta.class;
    private String script;
    private String matcher;
    private String resultfieldname;
    private boolean usevar;
    private boolean allowcapturegroups;
    private boolean replacefields;
    private boolean canoneq;
    private boolean caseinsensitive;
    private boolean comment;
    private boolean dotall;
    private boolean multiline;
    private boolean unicode;
    private boolean unix;
    private String[] fieldName;
    private int[] fieldType;
    private String[] fieldFormat;
    private String[] fieldGroup;
    private String[] fieldDecimal;
    private String[] fieldCurrency;
    private int[] fieldLength;
    private int[] fieldPrecision;
    private String[] fieldNullIf;
    private String[] fieldIfNull;
    private int[] fieldTrimType;

    @Override
    public Object clone() {
        RegexEvalMeta retval = (RegexEvalMeta)super.clone();
        int nrfields = this.fieldName.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.fieldName[i] = this.fieldName[i];
            retval.fieldType[i] = this.fieldType[i];
            retval.fieldLength[i] = this.fieldLength[i];
            retval.fieldPrecision[i] = this.fieldPrecision[i];
            retval.fieldFormat[i] = this.fieldFormat[i];
            retval.fieldGroup[i] = this.fieldGroup[i];
            retval.fieldDecimal[i] = this.fieldDecimal[i];
            retval.fieldCurrency[i] = this.fieldCurrency[i];
            retval.fieldNullIf[i] = this.fieldNullIf[i];
            retval.fieldIfNull[i] = this.fieldIfNull[i];
            retval.fieldTrimType[i] = this.fieldTrimType[i];
        }
        return retval;
    }

    public void allocate(int nrfields) {
        this.fieldName = new String[nrfields];
        this.fieldType = new int[nrfields];
        this.fieldFormat = new String[nrfields];
        this.fieldGroup = new String[nrfields];
        this.fieldDecimal = new String[nrfields];
        this.fieldCurrency = new String[nrfields];
        this.fieldLength = new int[nrfields];
        this.fieldPrecision = new int[nrfields];
        this.fieldNullIf = new String[nrfields];
        this.fieldIfNull = new String[nrfields];
        this.fieldTrimType = new int[nrfields];
    }

    public String getScript() {
        return this.script;
    }

    public String getRegexOptions() {
        StringBuilder options = new StringBuilder();
        if (this.isCaseInsensitiveFlagSet()) {
            options.append("(?i)");
        }
        if (this.isCommentFlagSet()) {
            options.append("(?x)");
        }
        if (this.isDotAllFlagSet()) {
            options.append("(?s)");
        }
        if (this.isMultilineFlagSet()) {
            options.append("(?m)");
        }
        if (this.isUnicodeFlagSet()) {
            options.append("(?u)");
        }
        if (this.isUnixLineEndingsFlagSet()) {
            options.append("(?d)");
        }
        return options.toString();
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getMatcher() {
        return this.matcher;
    }

    public void setMatcher(String matcher) {
        this.matcher = matcher;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public boolean isUseVariableInterpolationFlagSet() {
        return this.usevar;
    }

    public void setUseVariableInterpolationFlag(boolean usevar) {
        this.usevar = usevar;
    }

    public boolean isAllowCaptureGroupsFlagSet() {
        return this.allowcapturegroups;
    }

    public void setAllowCaptureGroupsFlag(boolean allowcapturegroups) {
        this.allowcapturegroups = allowcapturegroups;
    }

    public boolean isReplacefields() {
        return this.replacefields;
    }

    public void setReplacefields(boolean replacefields) {
        this.replacefields = replacefields;
    }

    public boolean isCanonicalEqualityFlagSet() {
        return this.canoneq;
    }

    public void setCanonicalEqualityFlag(boolean canoneq) {
        this.canoneq = canoneq;
    }

    public boolean isCaseInsensitiveFlagSet() {
        return this.caseinsensitive;
    }

    public void setCaseInsensitiveFlag(boolean caseinsensitive) {
        this.caseinsensitive = caseinsensitive;
    }

    public boolean isCommentFlagSet() {
        return this.comment;
    }

    public void setCommentFlag(boolean comment) {
        this.comment = comment;
    }

    public boolean isDotAllFlagSet() {
        return this.dotall;
    }

    public void setDotAllFlag(boolean dotall) {
        this.dotall = dotall;
    }

    public boolean isMultilineFlagSet() {
        return this.multiline;
    }

    public void setMultilineFlag(boolean multiline) {
        this.multiline = multiline;
    }

    public boolean isUnicodeFlagSet() {
        return this.unicode;
    }

    public void setUnicodeFlag(boolean unicode) {
        this.unicode = unicode;
    }

    public boolean isUnixLineEndingsFlagSet() {
        return this.unix;
    }

    public void setUnixLineEndingsFlag(boolean unix) {
        this.unix = unix;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String[] getFieldGroup() {
        return this.fieldGroup;
    }

    public void setFieldGroup(String[] fieldGroup) {
        this.fieldGroup = fieldGroup;
    }

    public String[] getFieldDecimal() {
        return this.fieldDecimal;
    }

    public void setFieldDecimal(String[] fieldDecimal) {
        this.fieldDecimal = fieldDecimal;
    }

    public String[] getFieldCurrency() {
        return this.fieldCurrency;
    }

    public void setFieldCurrency(String[] fieldCurrency) {
        this.fieldCurrency = fieldCurrency;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getFieldNullIf() {
        return this.fieldNullIf;
    }

    public void setFieldNullIf(String[] fieldNullIf) {
        this.fieldNullIf = fieldNullIf;
    }

    public String[] getFieldIfNull() {
        return this.fieldIfNull;
    }

    public void setFieldIfNull(String[] fieldIfNull) {
        this.fieldIfNull = fieldIfNull;
    }

    public int[] getFieldTrimType() {
        return this.fieldTrimType;
    }

    public void setFieldTrimType(int[] fieldTrimType) {
        this.fieldTrimType = fieldTrimType;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.script = XMLHandler.getTagValue((Node)stepnode, (String)"script");
            this.matcher = XMLHandler.getTagValue((Node)stepnode, (String)"matcher");
            this.resultfieldname = XMLHandler.getTagValue((Node)stepnode, (String)"resultfieldname");
            this.usevar = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"usevar"));
            this.allowcapturegroups = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"allowcapturegroups"));
            this.replacefields = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"replacefields"));
            this.canoneq = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"canoneq"));
            this.caseinsensitive = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"caseinsensitive"));
            this.comment = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"comment"));
            this.dotall = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"dotall"));
            this.multiline = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"multiline"));
            this.unicode = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"unicode"));
            this.unix = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"unix"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XMLHandler.getTagValue((Node)fnode, (String)"name");
                String stype = XMLHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldFormat[i] = XMLHandler.getTagValue((Node)fnode, (String)"format");
                this.fieldGroup[i] = XMLHandler.getTagValue((Node)fnode, (String)"group");
                this.fieldDecimal[i] = XMLHandler.getTagValue((Node)fnode, (String)"decimal");
                this.fieldCurrency[i] = XMLHandler.getTagValue((Node)fnode, (String)"currency");
                String slen = XMLHandler.getTagValue((Node)fnode, (String)"length");
                String sprc = XMLHandler.getTagValue((Node)fnode, (String)"precision");
                this.fieldNullIf[i] = XMLHandler.getTagValue((Node)fnode, (String)"nullif");
                this.fieldIfNull[i] = XMLHandler.getTagValue((Node)fnode, (String)"ifnull");
                String trim = XMLHandler.getTagValue((Node)fnode, (String)"trimtype");
                this.fieldType[i] = ValueMeta.getType((String)stype);
                this.fieldLength[i] = Const.toInt((String)slen, (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)sprc, (int)-1);
                this.fieldTrimType[i] = ValueMeta.getTrimTypeByCode((String)trim);
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"RegexEvalMeta.Exception.UnableToLoadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.script = "";
        this.matcher = "";
        this.resultfieldname = "result";
        this.usevar = false;
        this.allowcapturegroups = false;
        this.replacefields = true;
        this.canoneq = false;
        this.caseinsensitive = false;
        this.comment = false;
        this.dotall = false;
        this.multiline = false;
        this.unicode = false;
        this.unix = false;
        this.allocate(0);
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (!Const.isEmpty((String)this.resultfieldname)) {
            ValueMetaInterface v = null;
            if (this.replacefields) {
                v = inputRowMeta.searchValueMeta(this.resultfieldname);
            }
            if (v != null) {
                v.setOrigin(name);
                v.setType(4);
            } else {
                v = new ValueMeta(space.environmentSubstitute(this.resultfieldname), 4);
                v.setOrigin(name);
                inputRowMeta.addValueMeta(v);
            }
        }
        if (this.allowcapturegroups) {
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
                ValueMetaInterface v = null;
                if (this.replacefields) {
                    v = inputRowMeta.searchValueMeta(this.fieldName[i]);
                }
                if (v != null) {
                    this.setValueMeta(v, i, name);
                    continue;
                }
                v = new ValueMeta(this.fieldName[i]);
                this.setValueMeta(v, i, name);
                inputRowMeta.addValueMeta(v);
            }
        }
    }

    private void setValueMeta(ValueMetaInterface v, int i, String name) {
        int type = this.fieldType[i];
        if (type == 0) {
            type = 2;
        }
        v.setType(type);
        v.setLength(this.fieldLength[i]);
        v.setPrecision(this.fieldPrecision[i]);
        v.setOrigin(name);
        v.setConversionMask(this.fieldFormat[i]);
        v.setDecimalSymbol(this.fieldDecimal[i]);
        v.setGroupingSymbol(this.fieldGroup[i]);
        v.setCurrencySymbol(this.fieldCurrency[i]);
        v.setTrimType(this.fieldTrimType[i]);
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    @Override
    public String getXML() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XMLHandler.openTag((String)"script") + XMLHandler.buildCDATA((String)this.script) + XMLHandler.closeTag((String)"script"));
        retval.append("    " + XMLHandler.addTagValue((String)"matcher", (String)this.matcher));
        retval.append("    " + XMLHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    " + XMLHandler.addTagValue((String)"usevar", (boolean)this.usevar));
        retval.append("    " + XMLHandler.addTagValue((String)"allowcapturegroups", (boolean)this.allowcapturegroups));
        retval.append("    " + XMLHandler.addTagValue((String)"replacefields", (boolean)this.replacefields));
        retval.append("    " + XMLHandler.addTagValue((String)"canoneq", (boolean)this.canoneq));
        retval.append("    " + XMLHandler.addTagValue((String)"caseinsensitive", (boolean)this.caseinsensitive));
        retval.append("    " + XMLHandler.addTagValue((String)"comment", (boolean)this.comment));
        retval.append("    " + XMLHandler.addTagValue((String)"dotall", (boolean)this.dotall));
        retval.append("    " + XMLHandler.addTagValue((String)"multiline", (boolean)this.multiline));
        retval.append("    " + XMLHandler.addTagValue((String)"unicode", (boolean)this.unicode));
        retval.append("    " + XMLHandler.addTagValue((String)"unix", (boolean)this.unix));
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)ValueMeta.getTypeDesc((int)this.fieldType[i])));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)this.fieldFormat[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)this.fieldGroup[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)this.fieldDecimal[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)this.fieldLength[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)this.fieldPrecision[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullif", (String)this.fieldNullIf[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"ifnull", (String)this.fieldIfNull[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"trimtype", (String)ValueMeta.getTrimTypeCode((int)this.fieldTrimType[i])));
            retval.append("      </field>").append(Const.CR);
        }
        retval.append("    </fields>").append(Const.CR);
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.script = rep.getStepAttributeString(id_step, "script");
            this.matcher = rep.getStepAttributeString(id_step, "matcher");
            this.resultfieldname = rep.getStepAttributeString(id_step, "resultfieldname");
            this.usevar = rep.getStepAttributeBoolean(id_step, "usevar");
            this.allowcapturegroups = rep.getStepAttributeBoolean(id_step, "allowcapturegroups");
            this.replacefields = rep.getStepAttributeBoolean(id_step, "replacefields");
            this.canoneq = rep.getStepAttributeBoolean(id_step, "canoneq");
            this.caseinsensitive = rep.getStepAttributeBoolean(id_step, "caseinsensitive");
            this.comment = rep.getStepAttributeBoolean(id_step, "comment");
            this.multiline = rep.getStepAttributeBoolean(id_step, "multiline");
            this.dotall = rep.getStepAttributeBoolean(id_step, "dotall");
            this.unicode = rep.getStepAttributeBoolean(id_step, "unicode");
            this.unix = rep.getStepAttributeBoolean(id_step, "unix");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.fieldName[i] = rep.getStepAttributeString(id_step, i, "field_name");
                this.fieldType[i] = ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type"));
                this.fieldFormat[i] = rep.getStepAttributeString(id_step, i, "field_format");
                this.fieldGroup[i] = rep.getStepAttributeString(id_step, i, "field_group");
                this.fieldDecimal[i] = rep.getStepAttributeString(id_step, i, "field_decimal");
                this.fieldLength[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_length");
                this.fieldPrecision[i] = (int)rep.getStepAttributeInteger(id_step, i, "field_precision");
                this.fieldNullIf[i] = rep.getStepAttributeString(id_step, i, "field_nullif");
                this.fieldIfNull[i] = rep.getStepAttributeString(id_step, i, "field_ifnull");
                this.fieldTrimType[i] = ValueMeta.getTrimTypeByCode((String)rep.getStepAttributeString(id_step, i, "field_trimtype"));
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RegexEvalMeta.Exception.UnexpectedErrorInReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "script", this.script);
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (this.fieldName[i] == null || this.fieldName[i].length() == 0) continue;
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldName[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", ValueMeta.getTypeDesc((int)this.fieldType[i]));
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", this.fieldFormat[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", this.fieldGroup[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", this.fieldDecimal[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", this.fieldLength[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", this.fieldPrecision[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", this.fieldNullIf[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_ifnull", this.fieldIfNull[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trimtype", ValueMeta.getTrimTypeCode((int)this.fieldTrimType[i]));
            }
            rep.saveStepAttribute(id_transformation, id_step, "resultfieldname", this.resultfieldname);
            rep.saveStepAttribute(id_transformation, id_step, "usevar", this.usevar);
            rep.saveStepAttribute(id_transformation, id_step, "allowcapturegroups", this.allowcapturegroups);
            rep.saveStepAttribute(id_transformation, id_step, "replacefields", this.replacefields);
            rep.saveStepAttribute(id_transformation, id_step, "canoneq", this.canoneq);
            rep.saveStepAttribute(id_transformation, id_step, "caseinsensitive", this.caseinsensitive);
            rep.saveStepAttribute(id_transformation, id_step, "comment", this.comment);
            rep.saveStepAttribute(id_transformation, id_step, "dotall", this.dotall);
            rep.saveStepAttribute(id_transformation, id_step, "multiline", this.multiline);
            rep.saveStepAttribute(id_transformation, id_step, "unicode", this.unicode);
            rep.saveStepAttribute(id_transformation, id_step, "unix", this.unix);
            rep.saveStepAttribute(id_transformation, id_step, "matcher", this.matcher);
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"RegexEvalMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.ConnectedStepOK", (String[])new String[]{String.valueOf(prev.size())}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.NoInputReceived", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (!Const.isEmpty((String)this.matcher)) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.MatcherOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.NoMatcher", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (!Const.isEmpty((String)this.resultfieldname)) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.ResultFieldnameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"RegexEvalMeta.CheckResult.NoResultFieldname", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new RegexEval(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new RegexEvalData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

