/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rssinput;

import it.sauronsoftware.feed4j.FeedParser;
import it.sauronsoftware.feed4j.FeedXMLParseException;
import it.sauronsoftware.feed4j.UnsupportedFeedException;
import it.sauronsoftware.feed4j.bean.FeedItem;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.dom4j.DocumentException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rssinput.RssInputData;
import org.pentaho.di.trans.steps.rssinput.RssInputField;
import org.pentaho.di.trans.steps.rssinput.RssInputMeta;
import org.xml.sax.SAXParseException;

public class RssInput
extends BaseStep
implements StepInterface {
    private static Class<?> PKG = RssInput.class;
    private RssInputMeta meta;
    private RssInputData data;
    private int errors = 0;

    public RssInput(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readNextUrl() throws Exception {
        this.data.feed = null;
        this.data.itemssize = 0;
        if (this.meta.urlInField()) {
            this.data.readrow = this.getRow();
            if (this.data.readrow == null) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"RssInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.inputRowMeta = this.getInputRowMeta();
                this.data.outputRowMeta = this.data.inputRowMeta.clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.totalpreviousfields = this.data.inputRowMeta.size();
                this.data.convertRowMeta = this.data.outputRowMeta.clone();
                for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                    this.data.convertRowMeta.getValueMeta(i).setType(2);
                }
                this.data.convertRowMeta = this.data.outputRowMeta.clone();
                for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                    this.data.convertRowMeta.getValueMeta(i).setType(2);
                }
                if (Const.isEmpty((String)this.meta.getUrlFieldname())) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssInput.Log.UrlFieldNameMissing", (String[])new String[0]));
                    throw new KettleException(BaseMessages.getString(PKG, (String)"RssInput.Log.UrlFieldNameMissing", (String[])new String[0]));
                }
                if (this.data.indexOfUrlField < 0) {
                    this.data.indexOfUrlField = this.data.inputRowMeta.indexOfValue(this.meta.getUrlFieldname());
                    if (this.data.indexOfUrlField < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"RssInput.Log.ErrorFindingField", (String[])new String[0]) + "[" + this.meta.getUrlFieldname() + "]");
                        throw new KettleException(BaseMessages.getString(PKG, (String)"RssInput.Exception.ErrorFindingField", (String[])new String[]{this.meta.getUrlFieldname()}));
                    }
                }
            }
            this.data.currenturl = this.data.inputRowMeta.getString(this.data.readrow, this.data.indexOfUrlField);
        } else {
            if (this.data.last_url) {
                return false;
            }
            if (this.data.urlnr >= this.data.urlsize) {
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"RssInput.Log.FinishedProcessing", (String[])new String[0]));
                }
                return false;
            }
            this.data.last_url = this.data.urlnr == this.data.urlsize - 1;
            this.data.currenturl = this.environmentSubstitute(this.meta.getUrl()[this.data.urlnr]);
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"RssInput.Log.ReadingUrl", (String[])new String[]{this.data.currenturl}));
        }
        try {
            URL rss = new URL(this.data.currenturl);
            this.data.feed = FeedParser.parse((URL)rss);
            this.data.itemssize = this.data.feed.getItemCount();
            Object var3_3 = null;
            ++this.data.urlnr;
            this.data.itemsnr = 0;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ++this.data.urlnr;
            this.data.itemsnr = 0;
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"RssInput.Log.UrlReadFailed", (String[])new String[]{this.data.currenturl}));
            }
            throw throwable;
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"RssInput.Log.UrlReadFailed", (String[])new String[]{this.data.currenturl}));
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"RssInput.Log.UrlReaded", (Object[])new Object[]{this.data.currenturl, this.data.itemssize}));
        }
        return true;
    }

    private Object[] getOneRow() throws Exception {
        if (this.meta.urlInField()) {
            while (this.data.itemsnr >= this.data.itemssize) {
                if (this.readNextUrl()) continue;
                return null;
            }
        } else {
            while (this.data.itemsnr >= this.data.itemssize || this.data.feed == null) {
                if (this.readNextUrl()) continue;
                return null;
            }
        }
        Object[] outputRowData = this.buildEmptyRow();
        if (this.data.readrow != null) {
            System.arraycopy(this.data.readrow, 0, outputRowData, 0, this.data.readrow.length);
        }
        FeedItem item = this.data.feed.getItem(this.data.itemsnr);
        if (Const.isEmpty((String)this.meta.getRealReadFrom()) || !Const.isEmpty((String)this.meta.getRealReadFrom()) && item.getPubDate().compareTo(this.data.readfromdatevalide) > 0) {
            RowMetaInterface irow;
            for (int j = 0; j < this.meta.getInputFields().length; ++j) {
                RssInputField RSSInputField = this.meta.getInputFields()[j];
                String valueString = null;
                switch (RSSInputField.getColumn()) {
                    case 0: {
                        valueString = item.getTitle();
                        break;
                    }
                    case 1: {
                        valueString = item.getLink() == null ? "" : item.getLink().toString();
                        break;
                    }
                    case 2: {
                        valueString = item.getDescriptionAsText();
                        break;
                    }
                    case 3: {
                        valueString = item.getDescriptionAsHTML();
                        break;
                    }
                    case 4: {
                        valueString = item.getComments() == null ? "" : item.getComments().toString();
                        break;
                    }
                    case 5: {
                        valueString = item.getGUID();
                        break;
                    }
                    case 6: {
                        valueString = item.getPubDate() == null ? "" : DateFormat.getInstance().format(item.getPubDate());
                        break;
                    }
                }
                switch (RSSInputField.getTrimType()) {
                    case 1: {
                        valueString = Const.ltrim((String)valueString);
                        break;
                    }
                    case 2: {
                        valueString = Const.rtrim((String)valueString);
                        break;
                    }
                    case 3: {
                        valueString = Const.trim((String)valueString);
                        break;
                    }
                }
                ValueMetaInterface targetValueMeta = this.data.outputRowMeta.getValueMeta(this.data.totalpreviousfields + j);
                ValueMetaInterface sourceValueMeta = this.data.convertRowMeta.getValueMeta(this.data.totalpreviousfields + j);
                outputRowData[this.data.totalpreviousfields + j] = targetValueMeta.convertData(sourceValueMeta, (Object)valueString);
                if (!this.meta.getInputFields()[j].isRepeated() || this.data.previousRow == null || !Const.isEmpty((String)valueString)) continue;
                outputRowData[this.data.totalpreviousfields + j] = this.data.previousRow[this.data.totalpreviousfields + j];
            }
            int rowIndex = this.data.nrInputFields;
            if (this.meta.includeUrl()) {
                outputRowData[this.data.totalpreviousfields + rowIndex++] = this.data.currenturl;
            }
            if (this.meta.includeRowNumber()) {
                outputRowData[this.data.totalpreviousfields + rowIndex++] = new Long(this.data.rownr);
            }
            this.data.previousRow = (irow = this.getInputRowMeta()) == null ? outputRowData : irow.cloneRow(outputRowData);
            ++this.data.rownr;
            this.putRow(this.data.outputRowMeta, outputRowData);
            if (this.meta.getRowLimit() > 0L && this.data.rownr > this.meta.getRowLimit()) {
                return null;
            }
        }
        ++this.data.itemsnr;
        return outputRowData;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] outputRowData = null;
        try {
            outputRowData = this.getOneRow();
            if (outputRowData == null) {
                this.setOutputDone();
                return false;
            }
        }
        catch (Exception e) {
            if (this.getStepMeta().isDoingErrorHandling()) {
                RowMeta errorMeta = new RowMeta();
                Object[] errorData = new Object[]{};
                if (this.data.readrow != null) {
                    errorMeta.addRowMeta(this.getInputRowMeta());
                    errorData = this.data.readrow;
                }
                String errorCode = "UnknownError";
                if (e instanceof FeedXMLParseException) {
                    if (e.getCause() instanceof DocumentException) {
                        if (((DocumentException)e.getCause()).getNestedException() instanceof SAXParseException) {
                            errorCode = "XMLError";
                        } else if (((DocumentException)e.getCause()).getNestedException() instanceof FileNotFoundException) {
                            errorCode = "FileNotFound";
                        } else if (((DocumentException)e.getCause()).getNestedException() instanceof IOException) {
                            errorCode = ((DocumentException)e.getCause()).getNestedException() instanceof UnknownHostException ? "UnknownHost" : "TransferError";
                        }
                    }
                } else if (e instanceof MalformedURLException) {
                    errorCode = "BadURL";
                } else if (e instanceof UnsupportedFeedException) {
                    errorCode = "BadRSSFormat";
                }
                this.putError((RowMetaInterface)errorMeta, errorData, 1L, e.toString(), this.data.currenturl, errorCode);
                ++this.errors;
                this.logError(BaseMessages.getString(PKG, (String)"RssInput.ErrorProcessing.Run", (String[])new String[]{e.toString()}));
                ByteArrayOutputStream byteOS = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(byteOS));
                this.logDebug(byteOS.toString());
            }
            this.logError(BaseMessages.getString(PKG, (String)"RssInput.Exception.Run", (String[])new String[]{e.toString()}));
            this.logError(Const.getStackTracker((Throwable)e));
            this.setErrors(1L);
            throw new KettleException((Throwable)e);
        }
        return true;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)this.data.outputRowMeta.size());
        return rowData;
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RssInputMeta)smi;
        this.data = (RssInputData)sdi;
        if (super.init(smi, sdi)) {
            if (this.meta.includeRowNumber() && Const.isEmpty((String)this.meta.getRowNumberField())) {
                this.logError(BaseMessages.getString(PKG, (String)"RssInput.Error.RowNumberFieldMissing", (String[])new String[0]));
                return false;
            }
            if (this.meta.includeUrl() && Const.isEmpty((String)this.meta.geturlField())) {
                this.logError(BaseMessages.getString(PKG, (String)"RssInput.Error.UrlFieldMissing", (String[])new String[0]));
                return false;
            }
            if (!Const.isEmpty((String)this.meta.getReadFrom())) {
                try {
                    SimpleDateFormat fdrss = new SimpleDateFormat("yyyy-MM-dd");
                    fdrss.setLenient(false);
                    this.data.readfromdatevalide = fdrss.parse(this.meta.getRealReadFrom());
                }
                catch (Exception e) {
                    this.logError("can not validate ''Read From date'' : " + this.environmentSubstitute(this.meta.getReadFrom()));
                    return false;
                }
            }
            if (this.meta.urlInField()) {
                if (this.meta.getUrl() == null && this.meta.getUrl().length == 0) {
                    this.logError(BaseMessages.getString(PKG, (String)"RssInput.Log.UrlMissing", (String[])new String[0]));
                    return false;
                }
            } else {
                this.data.urlsize = this.meta.getUrl().length;
                try {
                    int i;
                    this.data.outputRowMeta = new RowMeta();
                    this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                    this.data.convertRowMeta = this.data.outputRowMeta.clone();
                    for (i = 0; i < this.data.convertRowMeta.size(); ++i) {
                        this.data.convertRowMeta.getValueMeta(i).setType(2);
                    }
                }
                catch (Exception e) {
                    this.logError("Error initializing step: " + e.toString());
                    this.logError(Const.getStackTracker((Throwable)e));
                    return false;
                }
            }
            this.data.rownr = 1L;
            this.data.urlnr = 0;
            this.data.nrInputFields = this.meta.getInputFields().length;
            return true;
        }
        return false;
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (RssInputMeta)smi;
        this.data = (RssInputData)sdi;
        if (this.data.feed != null) {
            this.data.feed = null;
        }
        super.dispose(smi, sdi);
    }
}

