/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rules.Rules;
import org.pentaho.di.trans.steps.rules.RulesData;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RulesMeta
extends BaseStepMeta
implements StepMetaInterface {
    private List<ValueMetaInterface> ruleResultColumns = new ArrayList<ValueMetaInterface>();
    private String ruleFile;
    private String ruleDefinition;
    private boolean keepInputFields = true;

    public List<ValueMetaInterface> getRuleResultColumns() {
        return this.ruleResultColumns;
    }

    public void setRuleResultColumns(List<ValueMetaInterface> ruleResultColumns) {
        this.ruleResultColumns = ruleResultColumns;
    }

    public void setRuleFile(String ruleFile) {
        this.ruleFile = ruleFile;
    }

    public String getRuleFile() {
        return this.ruleFile;
    }

    public void setRuleDefinition(String ruleDefinition) {
        this.ruleDefinition = ruleDefinition;
    }

    public String getRuleDefinition() {
        return this.ruleDefinition;
    }

    public boolean isKeepInputFields() {
        return this.keepInputFields;
    }

    public void setKeepInputFields(boolean keepInputFields) {
        this.keepInputFields = keepInputFields;
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        return new Rules(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new RulesData();
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        try {
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)StorageKeys.NODE_FIELDS.toString());
            int nrfields = XMLHandler.countNodes((Node)fields, (String)StorageKeys.SUBNODE_FIELD.toString());
            ValueMeta vm = null;
            for (int i = 0; i < nrfields; ++i) {
                vm = new ValueMeta();
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)StorageKeys.SUBNODE_FIELD.toString(), (int)i);
                vm.setName(XMLHandler.getTagValue((Node)fnode, (String)StorageKeys.COLUMN_NAME.toString()));
                vm.setType(ValueMeta.getType((String)XMLHandler.getTagValue((Node)fnode, (String)StorageKeys.COLUMN_TYPE.toString())));
                this.getRuleResultColumns().add((ValueMetaInterface)vm);
            }
            this.setRuleFile(XMLHandler.getTagValue((Node)stepnode, (String)StorageKeys.RULE_FILE.toString()));
            this.setRuleDefinition(XMLHandler.getTagValue((Node)stepnode, (String)StorageKeys.RULE_DEFINITION.toString()));
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    <" + (Object)((Object)StorageKeys.NODE_FIELDS) + ">").append(Const.CR);
        for (int i = 0; i < this.ruleResultColumns.size(); ++i) {
            retval.append("      <" + (Object)((Object)StorageKeys.SUBNODE_FIELD) + ">").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)StorageKeys.COLUMN_NAME.toString(), (String)this.ruleResultColumns.get(i).getName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)StorageKeys.COLUMN_TYPE.toString(), (String)this.ruleResultColumns.get(i).getTypeDesc()));
            retval.append("      </" + (Object)((Object)StorageKeys.SUBNODE_FIELD) + ">").append(Const.CR);
        }
        retval.append("    </" + (Object)((Object)StorageKeys.NODE_FIELDS) + ">").append(Const.CR);
        retval.append("    ").append(XMLHandler.addTagValue((String)StorageKeys.RULE_FILE.toString(), (String)this.getRuleFile()));
        retval.append("    ").append(XMLHandler.addTagValue((String)StorageKeys.RULE_DEFINITION.toString(), (String)this.getRuleDefinition()));
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, ObjectId idStep, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        int nrfields = rep.countNrStepAttributes(idStep, StorageKeys.COLUMN_NAME.toString());
        ValueMeta vm = null;
        for (int i = 0; i < nrfields; ++i) {
            vm = new ValueMeta();
            vm.setName(rep.getStepAttributeString(idStep, i, StorageKeys.COLUMN_NAME.toString()));
            vm.setType(ValueMeta.getType((String)rep.getStepAttributeString(idStep, i, StorageKeys.COLUMN_TYPE.toString())));
            this.getRuleResultColumns().add((ValueMetaInterface)vm);
        }
        this.setRuleFile(rep.getStepAttributeString(idStep, StorageKeys.RULE_FILE.toString()));
        this.setRuleDefinition(rep.getStepAttributeString(idStep, StorageKeys.RULE_DEFINITION.toString()));
    }

    @Override
    public void saveRep(Repository rep, ObjectId idTransformation, ObjectId idStep) throws KettleException {
        for (int i = 0; i < this.ruleResultColumns.size(); ++i) {
            rep.saveStepAttribute(idTransformation, idStep, i, StorageKeys.COLUMN_NAME.toString(), this.ruleResultColumns.get(i).getName());
            rep.saveStepAttribute(idTransformation, idStep, i, StorageKeys.COLUMN_TYPE.toString(), this.ruleResultColumns.get(i).getTypeDesc());
        }
        rep.saveStepAttribute(idTransformation, idStep, StorageKeys.RULE_FILE.toString(), this.getRuleFile());
        rep.saveStepAttribute(idTransformation, idStep, StorageKeys.RULE_DEFINITION.toString(), this.getRuleDefinition());
    }

    @Override
    public void setDefault() {
    }

    @Override
    public void getFields(RowMetaInterface row, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (!this.keepInputFields) {
            row.clear();
        }
        if (this.ruleResultColumns != null) {
            for (int i = 0; i < this.ruleResultColumns.size(); ++i) {
                row.addValueMeta(this.ruleResultColumns.get(i));
            }
        }
    }

    public String[] getExpectedResultList() {
        String[] result = new String[this.ruleResultColumns.size()];
        for (int i = 0; i < this.ruleResultColumns.size(); ++i) {
            result[i] = this.ruleResultColumns.get(i).getName();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum StorageKeys {
        NODE_FIELDS("fields"),
        SUBNODE_FIELD("field"),
        COLUMN_NAME("column-name"),
        COLUMN_TYPE("column-type"),
        RULE_FILE("rule-file"),
        RULE_DEFINITION("rule-definition");

        private final String storageKey;

        private StorageKeys(String name) {
            this.storageKey = name;
        }

        public String toString() {
            return this.storageKey;
        }
    }
}

